/*
 * Decompiled with CFR 0.152.
 */
package com.phison.gti;

import com.phison.gti.Gti2Common;
import com.phison.gti.Gti2Exception;
import com.phison.gti.Gti2Stream;
import com.phison.gti.Utils;

public class Gti2Assd {
    private Gti2Stream m_gtiStream = new Gti2Stream();
    private byte m_byStatus = 1;
    public byte[] byResponse = new byte[65536];
    String m_strSDCardPath = "";

    private void vTransmitAndGetResponse(byte[] byCmd, int dwCmdlen, byte[] byResp, int[] dwBuflen, int dwTimeOutMode, int dwCmdtype) throws Gti2Exception {
        if (byCmd == null || byResp == null || dwBuflen == null) {
            throw new Gti2Exception(512, 778, "vTransmitAndGetResponse-argu invalid.");
        }
        if (dwTimeOutMode == 0) {
            throw new Gti2Exception(514, 514, "vTransmitAndGetResponse-dwTimeOutMode invalid.");
        }
        this.m_gtiStream.vWriteCmd(byCmd, dwCmdlen, dwCmdtype);
        this.m_gtiStream.vReadResponse(byResp, dwBuflen, dwTimeOutMode);
        if (dwBuflen[0] == 0) {
            throw new Gti2Exception(518, 777, "vTransmitAndGetResponse-Response len invalid.");
        }
    }

    private void CheckICStatus(byte[] byStatus, int[] dwLen) throws Gti2Exception {
        byte[] byCmd = new byte[5];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        int dwCount = 0;
        System.arraycopy(Gti2Common.byTCMD, 5, byCmd, 0, 5);
        while (true) {
            this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[dwBuflens[0] - 2] == -112 || this.byResponse[dwBuflens[0] - 1] == 0) break;
            if (dwCount >= 10) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "byGetStatus failed. ");
            }
            ++dwCount;
        }
    }

    private void CheckFWVersion() throws Gti2Exception {
        byte[] byCmd = new byte[34];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 0, byCmd, 0, 5);
            byCmd[4] = 4;
            byCmd[5] = 0;
            byCmd[6] = 0;
            byCmd[7] = 0;
            byCmd[8] = 0;
            this.vTransmitAndGetResponse(byCmd, 9, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetFwInformation failed. ");
            }
            int dwControllerID = 0;
            dwControllerID = Integer.parseInt(String.valueOf(Integer.toString(this.byResponse[6] - 48)) + Integer.toString(this.byResponse[7] - 48) + Integer.toString(this.byResponse[8] - 48) + Integer.toString(this.byResponse[9] - 48));
            System.arraycopy(Gti2Common.byTCMD, 0, byCmd, 0, 5);
            byCmd[4] = 4;
            if (dwControllerID == 7000) {
                byCmd[5] = 0;
                byCmd[6] = 1;
                byCmd[7] = 0;
                byCmd[8] = 2;
            } else {
                byCmd[5] = 0;
                byCmd[6] = 0;
                byCmd[7] = 0;
                byCmd[8] = 0;
            }
            this.vTransmitAndGetResponse(byCmd, 9, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[dwBuflens[0] - 2] == 100 && this.byResponse[dwBuflens[0] - 1] == 57) {
                throw new Gti2Exception(526, 526, "ASSD_GetFwInformation failed. ");
            }
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetFwInformation failed. ");
            }
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
    }

    private boolean bCheckConnStatus() {
        return this.m_byStatus == 0;
    }

    public final void ASSD_DetectAssdDevices(String strSDCardPath) throws Gti2Exception {
        this.m_strSDCardPath = strSDCardPath;
        try {
            this.m_gtiStream.vOpen(strSDCardPath);
        }
        catch (Gti2Exception ex2) {
            throw new Gti2Exception(521, ex2.getGtiLastError(), "ASSD_DetectAssdDevices failed. ");
        }
        catch (Exception ex) {
            throw new Gti2Exception(521, 521, "ASSD_DetectAssdDevices failed. ");
        }
        try {
            try {
                this.CheckFWVersion();
            }
            catch (Gti2Exception ex2) {
                throw new Gti2Exception(521, ex2.getGtiLastError(), "ASSD_DetectAssdDevices failed. ");
            }
            catch (Exception ex) {
                throw new Gti2Exception(521, 521, "ASSD_DetectAssdDevices failed. ");
            }
        }
        finally {
            this.m_gtiStream.vClose();
            this.m_byStatus = 1;
        }
    }

    public final void ASSD_Connect() throws Gti2Exception {
        try {
            this.m_gtiStream.vOpen(this.m_strSDCardPath);
            this.m_byStatus = 0;
        }
        catch (Gti2Exception ex) {
            this.m_byStatus = 1;
            this.m_gtiStream.vClose();
            throw new Gti2Exception(256, ex.getGtiLastError(), "ASSD_Connect failed, " + ex.getMessage());
        }
    }

    public final void ASSD_Disconnect() throws Gti2Exception {
        try {
            try {
                this.m_gtiStream.vClose();
            }
            catch (Gti2Exception ex) {
                throw new Gti2Exception(257, ex.getGtiLastError(), "ASSD_Disconnect failed, " + ex.getMessage());
            }
        }
        finally {
            this.m_byStatus = 1;
        }
    }

    public final void ASSD_SendAndReceiveAPDU(byte[] byCAPDU, int dwCLen, byte[] byRAPDU, int[] dwRLen, int dwTimeout) throws Gti2Exception {
        if (byCAPDU == null || byRAPDU == null || dwRLen == null) {
            throw new Gti2Exception(512, 512, "ASSD_SendAndReceiveAPDU-argu invalid.");
        }
        if (dwTimeout == 0) {
            throw new Gti2Exception(514, 514, "ASSD_SendAndReceiveAPDU-dwTimeOutMode invalid.");
        }
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_SendAndReceiveAPDU-Card is disconnected.");
        }
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            this.m_gtiStream.vWriteCmd(byCAPDU, dwCLen, 0);
            this.m_gtiStream.vReadResponse(this.byResponse, dwBuflens, dwTimeout);
            if (dwRLen[0] == 0) {
                throw new Gti2Exception(518, 777, "ASSD_SendAndReceiveAPDU-Response len invalid.");
            }
            System.arraycopy(this.byResponse, 0, byRAPDU, 0, dwBuflens[0]);
            dwRLen[0] = dwBuflens[0];
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
    }

    public final void ASSD_Abort() throws Gti2Exception {
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        byte[] byCmd = new byte[8];
        if (this.bCheckConnStatus()) {
            try {
                System.arraycopy(Gti2Common.byTCMD, 50, byCmd, 0, 5);
                this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
                if (this.byResponse[dwBuflens[0] - 2] == 100 && this.byResponse[dwBuflens[0] - 1] == 68) {
                    this.byResponse[dwBuflens[0] - 2] = -112;
                    this.byResponse[dwBuflens[0] - 1] = 0;
                }
                if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                    throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_Abort failed. ");
                }
            }
            catch (Gti2Exception ex) {
                throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
            }
        }
        this.m_gtiStream.vClose();
        this.m_byStatus = 1;
    }

    public final String ASSD_GetLibVersion() throws Gti2Exception {
        return "1.1.0.4";
    }

    public final byte[] ASSD_GetFwInformation() throws Gti2Exception {
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_GetFwInformation-Card is disconnected.");
        }
        byte[] byCmd = new byte[34];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 0, byCmd, 0, 5);
            byCmd[4] = 4;
            byCmd[5] = 0;
            byCmd[6] = 0;
            byCmd[7] = 0;
            byCmd[8] = 0;
            this.vTransmitAndGetResponse(byCmd, 9, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetFwInformation failed. ");
            }
            System.arraycopy(this.byResponse, 0, byCmd, 0, dwBuflens[0] - 2);
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
        return byCmd;
    }

    public final byte[] ASSD_GetATR() throws Gti2Exception {
        byte[] byATR;
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_GetATR-Card is disconnected.");
        }
        byte[] byCmd = new byte[5];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            try {
                System.arraycopy(Gti2Common.byTCMD, 40, byCmd, 0, 5);
                this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
                if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                    throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetATR failed. ");
                }
                byATR = new byte[dwBuflens[0] - 2];
                System.arraycopy(this.byResponse, 0, byATR, 0, dwBuflens[0] - 2);
            }
            catch (Gti2Exception ex) {
                throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
            }
        }
        finally {
            byCmd = null;
            dwBuflens = null;
        }
        return byATR;
    }

    public final void ASSD_ResetICC(boolean bIsColdReset) throws Gti2Exception {
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_ResetICC-Card is disconnected.");
        }
        byte[] byCmd = new byte[5];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            if (bIsColdReset) {
                System.arraycopy(Gti2Common.byTCMD, 30, byCmd, 0, 5);
            } else {
                System.arraycopy(Gti2Common.byTCMD, 35, byCmd, 0, 5);
            }
            this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[0] != -112 && this.byResponse[1] != 0) {
                throw new Gti2Exception(517, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[0], this.byResponse[1]), "ASSD_ResetICC failed. ");
            }
            byCmd = null;
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
    }

    public final void ASSD_AdjustHwSettings(short wFrequency, byte byFiDi) throws Gti2Exception {
        if (wFrequency < 10 || wFrequency > 200) {
            throw new Gti2Exception(512, 512, "wFrequency is invalid.");
        }
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_AdjustHwSettings-Card is disconnected.");
        }
        byte[] byCmd = new byte[8];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 55, byCmd, 0, 5);
            byCmd[3] = 0;
            byCmd[4] = 3;
            byCmd[5] = (byte)wFrequency;
            byCmd[6] = byFiDi;
            byCmd[7] = 2;
            this.vTransmitAndGetResponse(byCmd, 8, this.byResponse, dwBuflens, 5, 1);
            byCmd = null;
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_AdjustHwSettings failed.");
            }
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
    }

    public final void ASSD_ModifyInterfaceParameters(byte byBWI, byte byCWI) throws Gti2Exception {
        if (byBWI < 0 || byBWI > 9) {
            throw new Gti2Exception(512, 512, "byBWI is invalid.");
        }
        if (byCWI < 0 || byCWI > 15) {
            throw new Gti2Exception(512, 512, "byCWI is invalid.");
        }
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_ModifyInterfaceParameters-Card is disconnected.");
        }
        byte[] byCmd = new byte[8];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 55, byCmd, 0, 5);
            byCmd[3] = 2;
            byCmd[4] = 2;
            byCmd[5] = (byte)(byBWI << 4 | byCWI & 0xF);
            byCmd[6] = -2;
            this.vTransmitAndGetResponse(byCmd, 7, this.byResponse, dwBuflens, 5, 1);
            byCmd = null;
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_AdjustHwSettings failed.");
            }
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
    }

    public final short[] ASSD_GetHwSettings() throws Gti2Exception {
        short[] wResp;
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_GetHwSettings-Card is disconnected.");
        }
        byte[] byCmd = new byte[5];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 60, byCmd, 0, 5);
            byCmd[3] = 0;
            byCmd[4] = 0;
            this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
            byCmd = null;
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetHwSettings failed.");
            }
            wResp = new short[]{this.byResponse[0], this.byResponse[1]};
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
        return wResp;
    }

    public final byte[] ASSD_GetInterfaceParameters() throws Gti2Exception {
        if (!this.bCheckConnStatus()) {
            throw new Gti2Exception(520, 520, "ASSD_GetInterfaceParameters-Card is disconnected.");
        }
        byte[] byCmd = new byte[8];
        int[] nArray = new int[2];
        nArray[0] = 25088;
        int[] dwBuflens = nArray;
        try {
            System.arraycopy(Gti2Common.byTCMD, 60, byCmd, 0, 5);
            byCmd[3] = 2;
            byCmd[4] = 0;
            this.vTransmitAndGetResponse(byCmd, 5, this.byResponse, dwBuflens, 5, 1);
            if (this.byResponse[dwBuflens[0] - 2] != -112 && this.byResponse[dwBuflens[0] - 1] != 0) {
                throw new Gti2Exception(518, Utils.four_bytes_to_int((byte)0, (byte)0, this.byResponse[dwBuflens[0] - 2], this.byResponse[dwBuflens[0] - 1]), "ASSD_GetHwSettings failed.");
            }
            byCmd[0] = (byte)(this.byResponse[0] >> 4 & 0xF);
            byCmd[1] = (byte)(this.byResponse[0] & 0xF);
            byCmd[2] = 0;
            byCmd[3] = 0;
            byCmd[4] = 0;
        }
        catch (Gti2Exception ex) {
            throw new Gti2Exception(518, ex.getGtiLastError(), "vTransmitAndGetResponse failed, " + ex.getMessage());
        }
        return byCmd;
    }
}

