/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.BitString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.ocsp.ResponseData;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Certificate;
import java.util.Vector;

public class BasicOCSPResponse
extends Sequence {
    private ResponseData tbsResponseData = new ResponseData("default_tbsResponseData");
    private AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier("default_signatureAlgorithm");
    private BitString signature = new BitString("default_signature");
    private SequenceOf certs = new SequenceOf("certs", new Certificate("defaultCert"));

    public BasicOCSPResponse() {
        super("default_BasicOCSPResponse");
        this.setUpElements();
    }

    public BasicOCSPResponse(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.tbsResponseData);
        super.addElement(this.signatureAlgorithm);
        super.addElement(this.signature);
        super.addElement(this.certs);
        this.certs.setOptional(true);
        this.certs.setTaggingMethod(2);
        this.certs.setTagClass((byte)-128);
        this.certs.setTagNumber(0);
    }

    public void setTbsResponseData(ResponseData value) {
        this.tbsResponseData = value;
    }

    public ResponseData getTbsResponseData() {
        return this.tbsResponseData;
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier value) {
        this.signatureAlgorithm = value;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignature(BitString value) {
        this.signature = value;
    }

    public BitString getSignature() {
        return this.signature;
    }

    public void setCerts(Vector certsVec) {
        this.certs.setValue(certsVec);
    }

    public Vector getCerts() {
        return (Vector)this.certs.getValue();
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

