/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableMessageMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private final Matcher<String> fMatcher;

    public ThrowableMessageMatcher(Matcher<String> matcher) {
        this.fMatcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("exception with message ");
        description.appendDescriptionOf(this.fMatcher);
    }

    protected boolean matchesSafely(T item) {
        return this.fMatcher.matches((Object)((Throwable)item).getMessage());
    }

    protected void describeMismatchSafely(T item, Description description) {
        description.appendText("message ");
        this.fMatcher.describeMismatch((Object)((Throwable)item).getMessage(), description);
    }

    @Factory
    public static <T extends Throwable> Matcher<T> hasMessage(Matcher<String> matcher) {
        return new ThrowableMessageMatcher<T>(matcher);
    }
}

