/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;
import java.math.BigInteger;

public class CRLNumber
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.20";
    private String crlNumberValStr;

    public CRLNumber(String name, boolean critical, int crlNumber) {
        this.crlNumberValStr = Integer.toString(crlNumber);
        ObjectID extObjId = new ObjectID("CRLNumberObjectId");
        extObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        ASN1Integer crlNumberAsn = new ASN1Integer("crlNumber", Integer.toString(crlNumber));
        byte[] crlNumberBytes = crlNumberAsn.getEncoded();
        OctetString crlNumberOcts = new OctetString("crlNumberOcts", crlNumberBytes);
        this.setextnValue(crlNumberOcts);
        this.commitElementUpdate();
    }

    public CRLNumber(String name, boolean critical, String crlNumberStr) {
        this.crlNumberValStr = crlNumberStr;
        ObjectID extObjId = new ObjectID("CRLNumberObjectId");
        extObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        ASN1Integer crlNumberAsn = new ASN1Integer("crlNumber", crlNumberStr);
        byte[] crlNumberBytes = crlNumberAsn.getEncoded();
        OctetString crlNumberOcts = new OctetString("crlNumberOcts", crlNumberBytes);
        this.setextnValue(crlNumberOcts);
        this.commitElementUpdate();
    }

    public CRLNumber() {
        super("defaultCRLNo");
        this.crlNumberValStr = null;
        ObjectID crlNoObjId = new ObjectID("crlNoId");
        crlNoObjId.setValue(EXT_OBJ_ID);
        this.setextnID(crlNoObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        try {
            ASN1Integer crlNumberAsn = new ASN1Integer("crlNumber");
            crlNumberAsn.decode(extValBytes);
            BigInteger crlNoBigInt = (BigInteger)crlNumberAsn.getValue();
            this.crlNumberValStr = crlNoBigInt.toString(10);
            OctetString octs = new OctetString("octs");
            octs.setValue(extValBytes);
            this.setextnValue(octs);
            this.commitElementUpdate();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public String getExtensionTitle() {
        return "CRL Number";
    }

    public String getTurkishExtensionTitle() {
        return "S\u0130L Seri Numaras\u0131";
    }

    public String getExplanation() throws DecodeException {
        return this.crlNumberValStr;
    }

    public String getTurkishExplanation() throws DecodeException {
        return this.crlNumberValStr;
    }
}

