/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class ASN1Boolean
extends BaseASN1Object {
    private boolean value = false;
    private boolean defaultValue = false;

    public ASN1Boolean(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(1);
        this.setTagNumber(1);
    }

    public ASN1Boolean(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(1);
        this.setTagNumber(1);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof Boolean) {
            this.value = (Boolean)value;
        }
        if (value instanceof String) {
            this.value = Boolean.valueOf((String)value);
        }
    }

    public Object getValue() {
        return new Boolean(this.value);
    }

    public void setDefaultValue(Object value) {
        if (value instanceof Boolean) {
            this.defaultValue = (Boolean)value;
        }
        if (value instanceof String) {
            this.defaultValue = Boolean.valueOf((String)value);
        }
    }

    public Object getDefaultValue() {
        return new Boolean(this.defaultValue);
    }

    public boolean isDefaultValue() {
        return this.value == this.defaultValue;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        if (data[tagInfo.contentIndex] == 0) {
            this.value = false;
        } else if (data[tagInfo.contentIndex] == -1) {
            this.value = true;
        } else {
            throw new DecodeException();
        }
    }

    protected byte[] getContentEncoding() {
        byte[] x = new byte[]{this.value ? (byte)-1 : 0};
        return x;
    }

    public String toString() {
        return new String(super.toString() + " " + this.value);
    }

    public static void main(String[] args) {
        ASN1Boolean i = new ASN1Boolean("boolean", Boolean.valueOf("true"));
        System.out.println(i.toString());
        byte[] a = i.getEncoded();
        for (int z = 0; z < a.length; ++z) {
            System.out.println(Integer.toString(a[z] & 0xFF, 16));
        }
    }
}

