/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.ecdsa;

import gnu.crypto.key.ecdsa.ECDSAKey;
import gnu.crypto.key.ecdsa.ECDSAKeyPairX509Codec;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECDomainParameter;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

public class ECDSAPublicKey
extends ECDSAKey
implements PublicKey {
    private final ECGNUPoint c;

    public static ECDSAPublicKey fromECPublicKey(ECPublicKey pubKey) {
        ECDSAKeyPairX509Codec eCDSAKeyPairX509Codec = new ECDSAKeyPairX509Codec();
        return (ECDSAPublicKey)eCDSAKeyPairX509Codec.decodePublicKey(pubKey.getEncoded());
    }

    public ECDSAPublicKey(ECDomainParameter aParameters, ECGNUPoint aQ) {
        super(aParameters);
        this.c = aQ;
    }

    public ECGNUPoint getMQ() {
        return this.c;
    }

    public ECPoint getW() {
        return this.c;
    }

    @Override
    public byte[] getEncoded() {
        return new ECDSAKeyPairX509Codec().encodePublicKey(this);
    }
}

