/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.ECCParams;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeader;
import tubitak.akis.cif.functions.Conversions;

public class ECCKey {
    public SDOHeader header;
    protected byte[] private_ecc;
    protected ECCParams eccParams;

    public ECCKey() {
        this.header = new SDOHeader();
        this.private_ecc = null;
        this.eccParams = new ECCParams();
    }

    public ECCKey(SDOHeader header, byte[] private_ecc, ECCParams eccParams) {
        this.header = header;
        if (private_ecc.length % 2 != 0) {
            this.private_ecc = new byte[private_ecc.length + 1];
            this.private_ecc[0] = 0;
            System.arraycopy(private_ecc, 0, this.private_ecc, 1, private_ecc.length);
        } else {
            this.private_ecc = private_ecc;
        }
        this.eccParams = new ECCParams(eccParams.getCharacteristic(), eccParams.getModulus(), eccParams.getCoefficientA(), eccParams.getCoefficientB(), eccParams.getBasepointX(), eccParams.getBasepointY(), eccParams.getBasepointOrder());
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i = 0;
        int index = 0;
        int len = 0;
        byte[] headerList = new byte[256];
        if (this.header.access == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (keyType != KeyType.PRIVATE_ECC) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = -65;
        headerList[i++] = -111;
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        if (this.header.maxUsageCount != -1) {
            headerList[i++] = -100;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.maxUsageCount >> 8);
                headerList[i++] = (byte)this.header.maxUsageCount;
            }
        }
        if (keyType == KeyType.PRIVATE_ECC) {
            if (this.header.nonRepFlag == -1) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i++] = -98;
            headerList[i++] = 1;
            if (op) {
                headerList[i++] = (byte)this.header.nonRepFlag;
            }
        }
        if (this.header.len != -1) {
            headerList[i++] = -128;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.len >> 8);
                headerList[i++] = (byte)this.header.len;
            }
        }
        headerList[i++] = -95;
        if (op) {
            len = this.header.access.toByteArray().length;
            headerList[i++] = (byte)len;
            System.arraycopy(this.header.access.toByteArray(), 0, headerList, i, len);
            i += len;
        } else if (this.header.access.toByteArray().length == 5) {
            headerList[i++] = 2;
            headerList[i++] = this.header.access.toByteArray()[0];
            headerList[i++] = 3;
        } else {
            headerList[i++] = 4;
            headerList[i++] = -53;
            headerList[i++] = 3;
            headerList[i++] = -52;
            headerList[i++] = 3;
        }
        if (this.header.info != null) {
            headerList[i++] = -123;
            headerList[i++] = (byte)this.header.info.length;
            if (op) {
                System.arraycopy(this.header.info, 0, headerList, i, this.header.info.length);
                i += this.header.info.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (keyType == KeyType.PRIVATE_ECC && !op) {
            if (this.private_ecc == null || this.eccParams == null || this.eccParams.getCharacteristic() != 0 && this.eccParams.getCharacteristic() != 1 || this.eccParams.getModulus() == null || this.eccParams.getCoefficientA() == null || this.eccParams.getCoefficientB() == null || this.eccParams.getBasepointX() == null || this.eccParams.getBasepointY() == null || this.eccParams.getBasepointOrder() == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            byte characteristic = this.eccParams.getCharacteristic();
            byte[] modulus = this.eccParams.getModulus();
            byte[] coefficientA = this.eccParams.getCoefficientA();
            byte[] coefficientB = this.eccParams.getCoefficientB();
            byte[] basepointX = this.eccParams.getBasepointX();
            byte[] basepointY = this.eccParams.getBasepointY();
            byte[] basepointOrder = this.eccParams.getBasepointOrder();
            headerList[i++] = 127;
            headerList[i++] = 72;
            index = i;
            headerList[i++] = 0;
            headerList[i++] = -110;
            byte[] temp = Conversions.GetBerLen(this.private_ecc.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -57;
            headerList[i++] = 1;
            headerList[i++] = -109;
            temp = Conversions.GetBerLen(modulus.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -108;
            temp = Conversions.GetBerLen(coefficientA.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -107;
            temp = Conversions.GetBerLen(coefficientB.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -61;
            temp = Conversions.GetBerLen(basepointX.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -60;
            temp = Conversions.GetBerLen(basepointY.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -105;
            temp = Conversions.GetBerLen(basepointOrder.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            headerList[index] = (byte)((i += temp.length) - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(KeyType keyType, int tag) {
        byte[] temp;
        int i = 0;
        byte[] data = new byte[512];
        byte[] sdo = new byte[512];
        byte characteristic = this.eccParams.getCharacteristic();
        byte[] modulus = this.eccParams.getModulus();
        byte[] coefficientA = this.eccParams.getCoefficientA();
        byte[] coefficientB = this.eccParams.getCoefficientB();
        byte[] basepointX = this.eccParams.getBasepointX();
        byte[] basepointY = this.eccParams.getBasepointY();
        byte[] basepointOrder = this.eccParams.getBasepointOrder();
        sdo[0] = -65;
        sdo[2] = this.header.keyID;
        if (keyType == KeyType.PRIVATE_ECC) {
            sdo[1] = -111;
            data[i++] = 127;
            data[i++] = 72;
            if (tag == 146) {
                temp = Conversions.GetBerLen(this.private_ecc.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -110;
                temp = Conversions.GetBerLen(this.private_ecc.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.private_ecc, 0, data, i += temp.length, this.private_ecc.length);
                i += this.private_ecc.length;
            } else if (tag == 199) {
                data[i++] = 3;
                data[i++] = -57;
                data[i++] = 1;
                data[i++] = characteristic;
            } else if (tag == 147) {
                temp = Conversions.GetBerLen(modulus.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -109;
                temp = Conversions.GetBerLen(modulus.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(modulus, 0, data, i += temp.length, modulus.length);
                i += modulus.length;
            } else if (tag == 148) {
                temp = Conversions.GetBerLen(coefficientA.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -108;
                temp = Conversions.GetBerLen(coefficientA.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(coefficientA, 0, data, i += temp.length, coefficientA.length);
                i += coefficientA.length;
            } else if (tag == 149) {
                temp = Conversions.GetBerLen(coefficientB.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -107;
                temp = Conversions.GetBerLen(coefficientB.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(coefficientB, 0, data, i += temp.length, coefficientB.length);
                i += coefficientB.length;
            } else if (tag == 195) {
                temp = Conversions.GetBerLen(basepointX.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -61;
                temp = Conversions.GetBerLen(basepointX.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(basepointX, 0, data, i += temp.length, basepointX.length);
                i += basepointX.length;
            } else if (tag == 196) {
                temp = Conversions.GetBerLen(basepointY.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -60;
                temp = Conversions.GetBerLen(basepointY.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(basepointY, 0, data, i += temp.length, basepointY.length);
                i += basepointY.length;
            } else if (tag == 151) {
                temp = Conversions.GetBerLen(basepointOrder.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -105;
                temp = Conversions.GetBerLen(basepointOrder.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(basepointOrder, 0, data, i += temp.length, basepointOrder.length);
                i += basepointOrder.length;
            }
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int dataLen = i;
        temp = Conversions.GetBerLen(dataLen);
        System.arraycopy(temp, 0, sdo, 3, temp.length);
        i = temp.length + 3;
        System.arraycopy(data, 0, sdo, i, dataLen);
        byte[] resizedData = new byte[dataLen + i];
        System.arraycopy(sdo, 0, resizedData, 0, dataLen + i);
        return resizedData;
    }
}

