/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;
import sune.security.x509.DNSName;
import sune.security.x509.EDIPartyName;
import sune.security.x509.GeneralNameInterface;
import sune.security.x509.IPAddressName;
import sune.security.x509.OIDName;
import sune.security.x509.OtherName;
import sune.security.x509.RFC822Name;
import sune.security.x509.URIName;
import sune.security.x509.X500Name;

public class GeneralName {
    protected static Logger logger = LoggerFactory.getLogger(GeneralName.class);
    private GeneralNameInterface name = null;

    public GeneralName(GeneralNameInterface name) {
        if (name == null) {
            throw new NullPointerException("GeneralName must not be null");
        }
        this.name = name;
    }

    public GeneralName(DerValue encName) throws IOException {
        this(encName, false);
    }

    public GeneralName(DerValue encName, boolean nameConstraint) throws IOException {
        short tag = (byte)(encName.tag & 0x1F);
        switch (tag) {
            case 0: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new OtherName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new RFC822Name(encName);
                    break;
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new DNSName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = nameConstraint ? URIName.nameConstraint(encName) : new URIName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    this.name = new IPAddressName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)6);
                    this.name = new OIDName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    this.name = new X500Name(encName.getData());
                    break;
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new EDIPartyName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                throw new IOException("Unrecognized GeneralName tag, (" + tag + ")");
            }
        }
    }

    public int getType() {
        return this.name.getType();
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneralName)) {
            return false;
        }
        GeneralNameInterface otherGNI = ((GeneralName)other).name;
        try {
            return this.name.constrains(otherGNI) == 0;
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Warning in GeneralName", (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.name.encode(tmp);
        int nameType = this.name.getType();
        if (nameType == 0 || nameType == 3 || nameType == 5) {
            out.writeImplicit(DerValue.createTag((byte)-128, true, (byte)nameType), tmp);
        } else if (nameType == 4) {
            out.write(DerValue.createTag((byte)-128, true, (byte)nameType), tmp);
        } else {
            out.writeImplicit(DerValue.createTag((byte)-128, false, (byte)nameType), tmp);
        }
    }
}

