/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.UTF8String;
import com.turktrust.cms.EncapsulatedContentInfo;
import com.turktrust.cms.SignedAttributes;
import com.turktrust.cms.SignedData;
import com.turktrust.cms.SignerIdentifier;
import com.turktrust.cms.SignerInfo;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.pkcs7.IssuerAndSerialNumber;
import com.turktrust.smyy.utils.Base64;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.smyy.utils.PKCS5Fabrikasi;
import com.turktrust.smyy.utils.SertifikaFabrikasi;
import com.turktrust.timestamp.Accuracy;
import com.turktrust.timestamp.MessageImprint;
import com.turktrust.timestamp.PKIFailureInfo;
import com.turktrust.timestamp.PKIFreeText;
import com.turktrust.timestamp.PKIStatus;
import com.turktrust.timestamp.PKIStatusInfo;
import com.turktrust.timestamp.TBTKReqEx;
import com.turktrust.timestamp.TSTInfo;
import com.turktrust.timestamp.TimeStampReq;
import com.turktrust.timestamp.TimeStampResp;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.Name;
import com.turktrust.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TimestampFabrikasi {
    public static final int DOGRULAMA_ISLEMINDE_HATA = -1;
    public static final int TST_GECERLI = 0;
    public static final int TST_GECERSIZ = 1;
    public static final int SERTIFIKA_BULUNAMADI = 2;
    public static final int DOGRULAMA_ISLEMINDE_TST_VERI_YAPISI_HATALI = 3;
    public static final int DOGRULAMA_ISLEMINDE_BILINMEYEN_IMZA_ALGORITMASI = 4;
    public static final int TS_AUTH_METHOD_TURKTRUST = 1;
    public static final int TS_AUTH_METHOD_HTTP_AUTHENTICATION = 2;
    public static final int TS_AUTH_METHOD_TUBITAK = 3;
    private static final int TUBITAK_ITERATION_COUNT = 100;
    private static final int TUBITAK_SALT_LENGTH = 16;
    private static final String TUBITAK_HTTP_PROPERTY_NAME = "identity";

    public static MessageImprint formMessageImprint(byte[] messageBytes, String hashAlgorithmOid) {
        try {
            if (!HashFabrikasi.algoritmaDesteklenmeKontrolu(hashAlgorithmOid)) {
                return null;
            }
            byte[] hashBytes = HashFabrikasi.hashAl(messageBytes, hashAlgorithmOid);
            ObjectID hash_objId = new ObjectID("HashObjId");
            hash_objId.setValue(hashAlgorithmOid);
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("HashAlgId");
            algId.setalgorithm(hash_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            MessageImprint mesimp = new MessageImprint("mesimp");
            mesimp.setHashAlgorithm(algId);
            OctetString hashOcts = new OctetString("hashOcts", hashBytes);
            mesimp.setHashedMessage(hashOcts);
            mesimp.commitElementUpdate();
            return mesimp;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static MessageImprint formMessageImprintFromFile(String inputFilename, String hashAlgorithmOid) {
        try {
            byte[] buffer;
            int readCount;
            if (!HashFabrikasi.algoritmaDesteklenmeKontrolu(hashAlgorithmOid)) {
                return null;
            }
            MessageDigest dig = HashFabrikasi.messageDigestNesnesiAl(hashAlgorithmOid);
            int blockSize = 1024000;
            FileInputStream fis = new FileInputStream(inputFilename);
            while ((readCount = fis.read(buffer = new byte[blockSize])) != -1) {
                byte[] hashInput = null;
                if (readCount < blockSize) {
                    hashInput = new byte[readCount];
                    System.arraycopy(buffer, 0, hashInput, 0, readCount);
                } else {
                    hashInput = buffer;
                }
                dig.update(hashInput);
            }
            fis.close();
            byte[] hashBytes = dig.digest();
            ObjectID hash_objId = new ObjectID("HashObjId");
            hash_objId.setValue(hashAlgorithmOid);
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("HashAlgId");
            algId.setalgorithm(hash_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            MessageImprint mesimp = new MessageImprint("mesimp");
            mesimp.setHashAlgorithm(algId);
            OctetString hashOcts = new OctetString("hashOcts", hashBytes);
            mesimp.setHashedMessage(hashOcts);
            mesimp.commitElementUpdate();
            return mesimp;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static MessageImprint formMessageImprintUseSHA1Result(byte[] hashBytes) {
        try {
            ObjectID hash_objId = new ObjectID("HashAlg");
            hash_objId.setValue("1.3.14.3.2.26");
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1");
            algId.setalgorithm(hash_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            MessageImprint mesimp = new MessageImprint("mesimp");
            mesimp.setHashAlgorithm(algId);
            OctetString hashOcts = new OctetString("hashOcts", hashBytes);
            mesimp.setHashedMessage(hashOcts);
            mesimp.commitElementUpdate();
            return mesimp;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static MessageImprint formMessageImprintUseHashResult(String hashAlgorithmOid, byte[] hashResultBytes) {
        try {
            ObjectID hash_objId = new ObjectID("HashAlg");
            hash_objId.setValue(hashAlgorithmOid);
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("algId");
            algId.setalgorithm(hash_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            MessageImprint mesimp = new MessageImprint("mesimp");
            mesimp.setHashAlgorithm(algId);
            OctetString hashOcts = new OctetString("hashOcts", hashResultBytes);
            mesimp.setHashedMessage(hashOcts);
            mesimp.commitElementUpdate();
            return mesimp;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static TimeStampReq formTimeStampReq(MessageImprint mesimp, String tsaPolicyIdStr, BigInteger nonce, boolean certRequired) {
        try {
            TimeStampReq tsr = new TimeStampReq("tsr");
            ASN1Integer version = new ASN1Integer("version", "1");
            tsr.setVersion(version);
            tsr.setMessageImprint(mesimp);
            if (tsaPolicyIdStr != null) {
                ObjectID policyId = new ObjectID("policyId", tsaPolicyIdStr);
                tsr.setReqPolicy(policyId);
            }
            if (nonce != null) {
                ASN1Integer nonceASN = new ASN1Integer("nonceASN", nonce);
                tsr.setNonce(nonceASN);
            }
            if (certRequired) {
                ASN1Boolean certreq = new ASN1Boolean("certreq", new Boolean(true));
                tsr.setCertReq(certreq);
            }
            tsr.commitElementUpdate();
            return tsr;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static PKIStatusInfo formPKIStatusInfo(int statusCode, String[] statusFreeTextArr, int[] failureCodesArr) {
        try {
            int i;
            PKIStatusInfo psi = new PKIStatusInfo("psi");
            PKIStatus pkiStatus = new PKIStatus("pkiStatus", statusCode);
            psi.setStatus(pkiStatus);
            if (statusFreeTextArr != null && statusFreeTextArr.length > 0) {
                PKIFreeText pft = new PKIFreeText("pft");
                for (i = 0; i < statusFreeTextArr.length; ++i) {
                    UTF8String ftTemp = new UTF8String("ftTemp");
                    ftTemp.setValue(statusFreeTextArr[i]);
                    pft.addElement(ftTemp);
                }
                psi.setPKIFreeText(pft);
            }
            if (failureCodesArr != null && failureCodesArr.length > 0) {
                PKIFailureInfo pfi = new PKIFailureInfo("pfi");
                for (i = 0; i < failureCodesArr.length; ++i) {
                    pfi.setFailingReason(failureCodesArr[i]);
                }
                psi.setFailInfo(pfi);
            }
            psi.commitElementUpdate();
            return psi;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static TSTInfo formTSTInfo(String policyIdStr, MessageImprint mesimp, BigInteger serialNo, Date generatedAt, int accuracyInSeconds, String tsAuthorityURL, BigInteger nonceVal) {
        try {
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            ASN1Integer version = new ASN1Integer("version", "1");
            tstinfo.setVersion(version);
            ObjectID policyId = new ObjectID("policyId", policyIdStr);
            tstinfo.setPolicyId(policyId);
            tstinfo.setMessageImprint(mesimp);
            ASN1Integer serial = new ASN1Integer("serial", serialNo);
            tstinfo.setSerialNumber(serial);
            GeneralizedTime genTime = new GeneralizedTime("genTime", generatedAt);
            tstinfo.setGenTime(genTime);
            if (accuracyInSeconds != -1) {
                Accuracy acc = new Accuracy("acc");
                ASN1Integer accSeconds = new ASN1Integer("accSeconds", Integer.toString(accuracyInSeconds));
                acc.setSeconds(accSeconds);
                acc.commitElementUpdate();
                tstinfo.setAccuracy(acc);
            }
            if (tsAuthorityURL != null && tsAuthorityURL.length() > 0) {
                GeneralName tsAuthGenName = new GeneralName("tsAuthGenName");
                tsAuthGenName.setURI(tsAuthorityURL);
                tstinfo.setTSAuthority(tsAuthGenName);
            }
            ASN1Integer nonce = new ASN1Integer("nonce", nonceVal);
            tstinfo.setNonce(nonce);
            tstinfo.commitElementUpdate();
            return tstinfo;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Vector verifyTimeStampToken(SignedData sd) {
        try {
            Vector<Serializable> resultVec = new Vector<Serializable>();
            if (((BigInteger)sd.getCMSVersion().getValue()).intValue() != 1 && ((BigInteger)sd.getCMSVersion().getValue()).intValue() != 3) {
                resultVec.addElement(new Integer(3));
                return resultVec;
            }
            Vector algIdSet = (Vector)sd.getDigestAlgorithms().getValue();
            for (int i = 0; i < algIdSet.size(); ++i) {
                if (HashFabrikasi.algoritmaDesteklenmeKontrolu((String)((AlgorithmIdentifier)algIdSet.elementAt(i)).getalgorithm().getValue())) continue;
                resultVec.addElement(new Integer(4));
                return resultVec;
            }
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            if (!eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.9.16.1.4")) {
                resultVec.addElement(new Integer(3));
                return resultVec;
            }
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                resultVec.addElement(new Integer(2));
                return resultVec;
            }
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            int sinfoVer = ((BigInteger)sinfo.getCMSVersion().getValue()).intValue();
            if (sinfoVer != 1 && sinfoVer != 3) {
                resultVec.addElement(new Integer(3));
                return resultVec;
            }
            SignerIdentifier signid = sinfo.getSignerIdentifier();
            Certificate signerCert = null;
            IssuerAndSerialNumber iasn = null;
            OctetString keyHash = null;
            try {
                iasn = (IssuerAndSerialNumber)signid.getValue();
            }
            catch (ClassCastException cce) {
                keyHash = (OctetString)signid.getValue();
            }
            if (iasn != null) {
                Name signerCertIssuerName = iasn.getissuer();
                ASN1Integer serialAsnInt = new ASN1Integer("serialAsnInt");
                serialAsnInt.decode((byte[])iasn.getserialNumber().getValue());
                BigInteger signerCertSerialNo = (BigInteger)serialAsnInt.getValue();
                for (Certificate tempCert : certsvec) {
                    BigInteger tempSerialNo;
                    Name tempIssuer = tempCert.gettbsCertificate().getissuer();
                    if (!signerCertIssuerName.isEqualTo(tempIssuer) || !signerCertSerialNo.equals(tempSerialNo = (BigInteger)tempCert.gettbsCertificate().getserialNumber().getValue())) continue;
                    signerCert = tempCert;
                }
            } else if (keyHash != null) {
                byte[] subjectKeyIdBytes = (byte[])keyHash.getValue();
                for (Certificate tempCert : certsvec) {
                    SubjectPublicKeyInfo spki = tempCert.gettbsCertificate().getsubjectPublicKeyInfo();
                    byte[] subjectPubKeyBytes = (byte[])spki.getsubjectPublicKey().getValue();
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    byte[] tempPubKeyHash = sha.digest(subjectPubKeyBytes);
                    if (subjectKeyIdBytes.length != tempPubKeyHash.length) continue;
                    boolean match = true;
                    for (int i = 0; i < subjectKeyIdBytes.length; ++i) {
                        if (subjectKeyIdBytes[i] == tempPubKeyHash[i]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    signerCert = tempCert;
                }
            }
            if (signerCert == null) {
                resultVec.addElement(new Integer(2));
                return resultVec;
            }
            if (!ImzaFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getSignatureAlgorithm().getalgorithm().getValue()) && !sinfo.getSignatureAlgorithm().getalgorithm().getValue().equals("1.2.840.113549.1.1.1")) {
                resultVec.addElement(new Integer(3));
                return resultVec;
            }
            byte[] signerSpkiBytes = signerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(signerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey signerPubKey = keyFac.generatePublic(xspec);
            byte[] sigBytes = (byte[])sinfo.getSignature().getValue();
            SignedAttributes signedAtts = sinfo.getSignedAttributes();
            byte[] signedAttsBytes = signedAtts.getEncoded();
            byte[] toBeVerifiedBytes = new byte[signedAttsBytes.length];
            System.arraycopy(signedAttsBytes, 0, toBeVerifiedBytes, 0, signedAttsBytes.length);
            toBeVerifiedBytes[0] = 49;
            if (ImzaFabrikasi.verifyPKCS1Signature(sigBytes, signerPubKey, toBeVerifiedBytes)) {
                byte[] origDataHash = null;
                byte[] origVerifBytes = (byte[])eci.getEncapsulatedContent().getValue();
                if (!HashFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getDigestAlgorithm().getalgorithm().getValue())) {
                    resultVec.addElement(new Integer(4));
                    resultVec.addElement(signerCert);
                    return resultVec;
                }
                origDataHash = HashFabrikasi.hashAl(origVerifBytes, (String)sinfo.getDigestAlgorithm().getalgorithm().getValue());
                Vector sVec = (Vector)signedAtts.getValue();
                for (int i = 0; i < sVec.size(); ++i) {
                    Attribute at = (Attribute)sVec.elementAt(i);
                    if (!((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.4")) continue;
                    Vector vVec = (Vector)at.getvalues().getValue();
                    Any ocsAny = (Any)vVec.get(0);
                    OctetString ocs = new OctetString("ocs");
                    ocs.decode((byte[])ocsAny.getValue());
                    byte[] imzalananDataninHashi = (byte[])ocs.getValue();
                    boolean vfSonuc = TimestampFabrikasi.areByteArraysEqual(imzalananDataninHashi, origDataHash);
                    if (vfSonuc) {
                        Date tsTime = TimestampFabrikasi.getGenerationTimeOfTimestamp(sd);
                        if (SertifikaFabrikasi.isCertificateValidAtGivenDate(signerCert, tsTime)) {
                            resultVec.addElement(new Integer(0));
                            resultVec.addElement(signerCert);
                            continue;
                        }
                        resultVec.addElement(new Integer(1));
                        continue;
                    }
                    resultVec.addElement(new Integer(1));
                }
                return resultVec;
            }
            resultVec.addElement(new Integer(1));
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Vector<Integer> resultVec = new Vector<Integer>();
            resultVec.addElement(new Integer(-1));
            return resultVec;
        }
    }

    public static Date getGenerationTimeOfTimestamp(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            return (Date)tstinfo.getGenTime().getValue();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getPolicyIdOfTimestamp(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            return (String)tstinfo.getPolicyId().getValue();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getSerialNumberOfTimestamp(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            return ((BigInteger)tstinfo.getSerialNumber().getValue()).toString();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static MessageImprint getMessageImprintInTimestamp(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            return tstinfo.getMessageImprint();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getAuthorityURLOfTimestamp(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            return tstinfo.getTSAuthority().getURI();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getSignatureAlgorithmOfTimestamp(SignedData sd) {
        try {
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            return (String)sinfo.getSignatureAlgorithm().getalgorithm().getValue();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String getHashAlgorithmOfTimestamp(SignedData sd) {
        try {
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            return (String)sinfo.getDigestAlgorithm().getalgorithm().getValue();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static Certificate extractSignerCertFromTimeStampToken(SignedData sd) {
        try {
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] tstInfoBytes = (byte[])eci.getEncapsulatedContent().getValue();
            TSTInfo tstinfo = new TSTInfo("tstinfo");
            tstinfo.decode(tstInfoBytes);
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                return null;
            }
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            SignerIdentifier signid = sinfo.getSignerIdentifier();
            Certificate signerCert = null;
            IssuerAndSerialNumber iasn = null;
            OctetString keyHash = null;
            try {
                iasn = (IssuerAndSerialNumber)signid.getValue();
            }
            catch (ClassCastException cce) {
                keyHash = (OctetString)signid.getValue();
            }
            if (iasn != null) {
                Name signerCertIssuerName = iasn.getissuer();
                ASN1Integer serialAsnInt = new ASN1Integer("serialAsnInt");
                serialAsnInt.decode((byte[])iasn.getserialNumber().getValue());
                BigInteger signerCertSerialNo = (BigInteger)serialAsnInt.getValue();
                for (Certificate tempCert : certsvec) {
                    BigInteger tempSerialNo;
                    Name tempIssuer = tempCert.gettbsCertificate().getissuer();
                    if (!signerCertIssuerName.isEqualTo(tempIssuer) || !signerCertSerialNo.equals(tempSerialNo = (BigInteger)tempCert.gettbsCertificate().getserialNumber().getValue())) continue;
                    signerCert = tempCert;
                }
            } else if (keyHash != null) {
                byte[] subjectKeyIdBytes = (byte[])keyHash.getValue();
                for (Certificate tempCert : certsvec) {
                    SubjectPublicKeyInfo spki = tempCert.gettbsCertificate().getsubjectPublicKeyInfo();
                    byte[] subjectPubKeyBytes = (byte[])spki.getsubjectPublicKey().getValue();
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    byte[] tempPubKeyHash = sha.digest(subjectPubKeyBytes);
                    if (subjectKeyIdBytes.length != tempPubKeyHash.length) continue;
                    boolean match = true;
                    for (int i = 0; i < subjectKeyIdBytes.length; ++i) {
                        if (subjectKeyIdBytes[i] == tempPubKeyHash[i]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    signerCert = tempCert;
                }
            }
            return signerCert;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static TimeStampResp formTimeStampResp(PKIStatusInfo pkiStatusInfo, ContentInfo timeStampToken) {
        TimeStampResp tsr = new TimeStampResp("tsr");
        tsr.setStatus(pkiStatusInfo);
        if (timeStampToken != null) {
            tsr.setTimeStampToken(timeStampToken);
        } else {
            ContentInfo emptyToken = new ContentInfo("emptyToken");
            emptyToken.setDefaulting(true);
            tsr.setTimeStampToken(emptyToken);
        }
        tsr.commitElementUpdate();
        return tsr;
    }

    private static byte[] formDirectTCPMessage(int header, byte[] content) {
        int len = content.length;
        byte[] mes = new byte[len + 5];
        mes[0] = (byte)((len & 0xFF000000) >> 24);
        mes[1] = (byte)((len & 0xFF0000) >> 16);
        mes[2] = (byte)((len & 0xFF00) >> 8);
        mes[3] = (byte)(len & 0xFF);
        mes[4] = (byte)header;
        System.arraycopy(content, 0, mes, 5, len);
        return mes;
    }

    public static byte[] getTSARespViaDirectTCP(byte[] tsaReqBytes, String hostAddress, int port, int timeOutSeconds) {
        try {
            Socket sock = new Socket(hostAddress, port);
            if (timeOutSeconds != -1) {
                sock.setSoTimeout(timeOutSeconds * 1000);
            }
            InputStream is = sock.getInputStream();
            OutputStream os = sock.getOutputStream();
            byte[] tsaMsg = TimestampFabrikasi.formDirectTCPMessage(0, tsaReqBytes);
            os.write(tsaMsg);
            int nextByte = 0;
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            while ((nextByte = is.read()) != -1) {
                baos1.write(nextByte);
            }
            byte[] resp1 = baos1.toByteArray();
            byte flag = resp1[4];
            while (flag != 3 && flag != 5 && flag != 6) {
                if (flag == 1 || flag == 4) {
                    byte[] pollReference = new byte[4];
                    System.arraycopy(resp1, 5, pollReference, 0, 4);
                    int timeToCheckBack = 0;
                    timeToCheckBack = resp1[9] << 24;
                    timeToCheckBack |= resp1[10] << 16;
                    timeToCheckBack |= resp1[11] << 8;
                    System.out.println((timeToCheckBack |= resp1[12]) + " saniye bekleniyor");
                    Thread.sleep(timeToCheckBack * 1000);
                    byte[] pollReq = TimestampFabrikasi.formDirectTCPMessage(2, pollReference);
                    os.write(pollReq);
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    while ((nextByte = is.read()) != -1) {
                        baos2.write(nextByte);
                    }
                    resp1 = baos2.toByteArray();
                    flag = resp1[4];
                    continue;
                }
                if (flag <= 6) continue;
                System.out.println("Bilinmeyen flag : " + flag);
                if (!sock.isClosed()) {
                    sock.close();
                }
                return null;
            }
            if (flag == 3) {
                System.out.println("Negatif flag");
                if (!sock.isClosed()) {
                    sock.close();
                }
                return null;
            }
            if (flag == 5) {
                byte[] finalRes = new byte[resp1.length - 5];
                System.arraycopy(resp1, 5, finalRes, 0, finalRes.length);
                if (!sock.isClosed()) {
                    sock.close();
                }
                return finalRes;
            }
            if (flag == 6) {
                byte[] errorRes = new byte[resp1.length - 4];
                System.arraycopy(resp1, 4, errorRes, 0, errorRes.length);
                if (!sock.isClosed()) {
                    sock.close();
                }
                return errorRes;
            }
            System.out.println("Bilinmeyen flag : " + flag);
            if (!sock.isClosed()) {
                sock.close();
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static byte[] getTSARespViaHTTP(byte[] tsaReqBytes, String timeStampServerURL, boolean useSSL, int timeOutSeconds) {
        try {
            int oneChar;
            if (useSSL) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            URL u = new URL(timeStampServerURL);
            URLConnection uc = u.openConnection();
            if (u == null) {
                byte[] err = new byte[]{-1};
                return err;
            }
            if (timeOutSeconds != -1) {
                uc.setConnectTimeout(timeOutSeconds * 1000);
                uc.setReadTimeout(timeOutSeconds * 1000);
            }
            HttpURLConnection connection = (HttpURLConnection)uc;
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(tsaReqBytes.length));
            connection.setRequestProperty("Content-Type", "application/timestamp-query");
            OutputStream out = connection.getOutputStream();
            out.write(tsaReqBytes);
            out.close();
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            while ((oneChar = is.read()) != -1) {
                baos.write(oneChar);
                ++count;
            }
            is.close();
            connection.disconnect();
            byte[] tsrespBytes = baos.toByteArray();
            return tsrespBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] err = new byte[]{-1};
            return err;
        }
    }

    public static byte[] getTSARespViaHTTP(byte[] tsaReqBytes, String timeStampServerURL, boolean useSSL, String tsUsername, String tsPassword, int authMethod, int timeOutSeconds) {
        try {
            int oneChar;
            if (authMethod != 1 && authMethod != 2 && authMethod != 3) {
                return null;
            }
            if (useSSL) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            URL u = new URL(timeStampServerURL);
            URLConnection uc = u.openConnection();
            if (u == null) {
                byte[] err = new byte[]{-1};
                return err;
            }
            if (timeOutSeconds != -1) {
                uc.setConnectTimeout(timeOutSeconds * 1000);
                uc.setReadTimeout(timeOutSeconds * 1000);
            }
            HttpURLConnection connection = (HttpURLConnection)uc;
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(tsaReqBytes.length));
            connection.setRequestProperty("Content-Type", "application/timestamp-query");
            if (authMethod == 1) {
                connection.addRequestProperty("t_username", tsUsername);
                connection.addRequestProperty("t_password", tsPassword);
                connection.addRequestProperty("t_c", "t");
            } else if (authMethod == 2) {
                String userConcatPass = tsUsername + ":" + tsPassword;
                Base64 b64 = new Base64();
                String ucpB64 = b64.encodeToString(userConcatPass.getBytes("ASCII"), false);
                String authHeaderContent = "Basic " + ucpB64;
                connection.addRequestProperty("Authorization", authHeaderContent);
            } else if (authMethod == 3) {
                TimeStampReq tsareq = new TimeStampReq("tsareq");
                tsareq.decode(tsaReqBytes);
                MessageImprint mesimp = tsareq.getMessageImprint();
                byte[] mesHashBytes = (byte[])mesimp.getHashedMessage().getValue();
                byte[] passBytes = tsPassword.getBytes("UTF-8");
                SecureRandom sr = new SecureRandom();
                byte[] saltBytes = new byte[16];
                sr.nextBytes(saltBytes);
                byte[] aesKeyAndIV = PKCS5Fabrikasi.generateKeyUsingHMAC((int)32, (byte[])passBytes, (int)100, (byte[])saltBytes);
                byte[] aesKey = new byte[16];
                System.arraycopy(aesKeyAndIV, 0, aesKey, 0, 16);
                byte[] aesIV = new byte[16];
                System.arraycopy(aesKeyAndIV, 16, aesIV, 0, 16);
                SecretKeySpec skeySpec = new SecretKeySpec(aesKey, "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(aesIV);
                Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                aesCipher.init(1, (Key)skeySpec, ivSpec);
                byte[] encMesImp = aesCipher.doFinal(mesHashBytes);
                TBTKReqEx tbtkreqex = new TBTKReqEx();
                ASN1Integer userIdInt = new ASN1Integer("userIdInt", tsUsername);
                OctetString saltOcts = new OctetString("saltOcts", saltBytes);
                ASN1Integer iterationInt = new ASN1Integer("iterationInt", Integer.toString(100));
                OctetString encMesImpOcts = new OctetString("encMesImpOcts", encMesImp);
                tbtkreqex.setUserId(userIdInt);
                tbtkreqex.setSalt(saltOcts);
                tbtkreqex.setIterationCount(iterationInt);
                tbtkreqex.setEncryptedMessageImprint(encMesImpOcts);
                tbtkreqex.commitElementUpdate();
                byte[] tbtkReqExBytes = tbtkreqex.getEncoded();
                Base64 b64 = new Base64();
                String tbtkReqExStr = b64.encodeToString(tbtkReqExBytes, false);
                connection.addRequestProperty(TUBITAK_HTTP_PROPERTY_NAME, tbtkReqExStr);
            }
            OutputStream out = connection.getOutputStream();
            out.write(tsaReqBytes);
            out.close();
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            while ((oneChar = is.read()) != -1) {
                baos.write(oneChar);
                ++count;
            }
            is.close();
            connection.disconnect();
            byte[] tsrespBytes = baos.toByteArray();
            return tsrespBytes;
        }
        catch (Exception e) {
            byte[] err = new byte[]{-1};
            return err;
        }
    }

    public static byte[] getTSARespViaHTTP_EncParams(byte[] tsaReqBytes, String timeStampServerURL, boolean useSSL, String tsUserId, String tsPassword) {
        try {
            int oneChar;
            if (useSSL) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            System.out.println("Sifreleme islemleri basliyor");
            TimeStampReq tsareq = new TimeStampReq("tsareq");
            tsareq.decode(tsaReqBytes);
            MessageImprint mesimp = tsareq.getMessageImprint();
            byte[] mesHashBytes = (byte[])mesimp.getHashedMessage().getValue();
            Base64 bb64 = new Base64();
            String mesimpStr = bb64.encodeToString(mesHashBytes, false);
            System.out.println("Mes hash = " + mesimpStr);
            byte[] passBytes = tsPassword.getBytes("UTF-8");
            byte[] saltBytes = new byte[]{125, 25, 54, -25, 121, -128, 126, -59};
            byte[] aesKeyAndIV = PKCS5Fabrikasi.generateKeyUsingHMAC((int)32, (byte[])passBytes, (int)100, (byte[])saltBytes);
            byte[] aesKey = new byte[16];
            System.arraycopy(aesKeyAndIV, 0, aesKey, 0, 16);
            byte[] aesIV = new byte[16];
            System.arraycopy(aesKeyAndIV, 16, aesIV, 0, 16);
            SecretKeySpec skeySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(aesIV);
            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            aesCipher.init(1, (Key)skeySpec, ivSpec);
            byte[] encMesImp = aesCipher.doFinal(mesHashBytes);
            TBTKReqEx tbtkreqex = new TBTKReqEx();
            ASN1Integer userIdInt = new ASN1Integer("userIdInt", tsUserId);
            OctetString saltOcts = new OctetString("saltOcts", saltBytes);
            ASN1Integer iterationInt = new ASN1Integer("iterationInt", Integer.toString(100));
            OctetString encMesImpOcts = new OctetString("encMesImpOcts", encMesImp);
            tbtkreqex.setUserId(userIdInt);
            tbtkreqex.setSalt(saltOcts);
            tbtkreqex.setIterationCount(iterationInt);
            tbtkreqex.setEncryptedMessageImprint(encMesImpOcts);
            tbtkreqex.commitElementUpdate();
            byte[] tbtkReqExBytes = tbtkreqex.getEncoded();
            Base64 b64 = new Base64();
            String tbtkReqExStr = b64.encodeToString(tbtkReqExBytes, false);
            System.out.println("ASN yapisi olusturuldu");
            System.out.println(tbtkReqExStr);
            FileOutputStream fos2 = new FileOutputStream("d:\\ct\\tubitak\\bizim_identity.bin");
            fos2.write(tbtkReqExBytes);
            fos2.close();
            URL u = new URL(timeStampServerURL);
            URLConnection uc = u.openConnection();
            if (u == null) {
                byte[] err = new byte[]{-1};
                return err;
            }
            System.out.println("URL baglanti kuruldu");
            HttpURLConnection connection = (HttpURLConnection)uc;
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(tsaReqBytes.length));
            connection.setRequestProperty("Content-Type", "application/timestamp-query");
            connection.addRequestProperty(TUBITAK_HTTP_PROPERTY_NAME, tbtkReqExStr);
            OutputStream out = connection.getOutputStream();
            out.write(tsaReqBytes);
            out.close();
            System.out.println("Gonderildi");
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            while ((oneChar = is.read()) != -1) {
                baos.write(oneChar);
                ++count;
            }
            is.close();
            connection.disconnect();
            byte[] tsrespBytes = baos.toByteArray();
            return tsrespBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] err = new byte[]{-1};
            return err;
        }
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

