/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

public class PinModify {
    private byte[] a = new byte[24];
    private byte[] b;

    public PinModify() {
    }

    public PinModify(int timeOut, int timeOut2, int formatString, int pinBlockString, int pinLengthFormat, int insertionOffsetOld, int insertionOffsetNew, int pinMaxExtraDigit, int confirmPin, int entryValidationCondition, int numberMessage, int langId, int msgIndex1, int msgIndex2, int msgIndex3, int teoPrologue0, int teoPrologue1, int teoPrologue2, byte[] data, int dataLength) {
        this.setTimeOut(timeOut);
        this.setTimeOut2(timeOut2);
        this.setFormatString(formatString);
        this.setPinBlockString(pinBlockString);
        this.setPinLengthFormat(pinLengthFormat);
        this.setInsertionOffsetOld(insertionOffsetOld);
        this.setInsertionOffsetNew(insertionOffsetNew);
        this.setPinMaxExtraDigit(pinMaxExtraDigit);
        this.setConfirmPin(confirmPin);
        this.setEntryValidationCondition(entryValidationCondition);
        this.setNumberMessage(numberMessage);
        this.setLangId(langId);
        this.setMsgIndex1(msgIndex1);
        this.setMsgIndex2(msgIndex2);
        this.setMsgIndex3(msgIndex3);
        this.setTeoPrologue(0, teoPrologue0);
        this.setTeoPrologue(1, teoPrologue1);
        this.setTeoPrologue(2, teoPrologue2);
        this.setData(data, dataLength);
    }

    public int getTimeOut() {
        return this.a[0] & 0xFF;
    }

    public void setTimeOut(int timeOut) {
        this.a[0] = (byte)timeOut;
    }

    public int getTimeOut2() {
        return this.a[1] & 0xFF;
    }

    public void setTimeOut2(int timeOut2) {
        this.a[1] = (byte)timeOut2;
    }

    public int getFormatString() {
        return this.a[2] & 0xFF;
    }

    public void setFormatString(int formatString) {
        this.a[2] = (byte)formatString;
    }

    public int getPinBlockString() {
        return this.a[3] & 0xFF;
    }

    public void setPinBlockString(int pinBlockString) {
        this.a[3] = (byte)pinBlockString;
    }

    public int getPinLengthFormat() {
        return this.a[4] & 0xFF;
    }

    public void setPinLengthFormat(int pinLengthFormat) {
        this.a[4] = (byte)pinLengthFormat;
    }

    public int getInsertionOffsetOld() {
        return this.a[5] & 0xFF;
    }

    public void setInsertionOffsetOld(int insertionOffsetOld) {
        this.a[5] = (byte)insertionOffsetOld;
    }

    public int getInsertionOffsetNew() {
        return this.a[6] & 0xFF;
    }

    public void setInsertionOffsetNew(int insertionOffsetNew) {
        this.a[6] = (byte)insertionOffsetNew;
    }

    public int getPinMaxExtraDigit() {
        return this.a[7] & 0xFF | (this.a[8] & 0xFF) << 8;
    }

    public void setPinMaxExtraDigit(int pinMaxExtraDigit) {
        this.a[7] = (byte)pinMaxExtraDigit;
        this.a[8] = (byte)(pinMaxExtraDigit >> 8);
    }

    public int getConfirmPin() {
        return this.a[9] & 0xFF;
    }

    public void setConfirmPin(int confirmPin) {
        this.a[9] = (byte)confirmPin;
    }

    public int getEntryValidationCondition() {
        return this.a[10] & 0xFF;
    }

    public void setEntryValidationCondition(int entryValidationCondition) {
        this.a[10] = (byte)entryValidationCondition;
    }

    public int getNumberMessage() {
        return this.a[11] & 0xFF;
    }

    public void setNumberMessage(int numberMessage) {
        this.a[11] = (byte)numberMessage;
    }

    public int getLangId() {
        return this.a[12] & 0xFF | (this.a[13] & 0xFF) << 8;
    }

    public void setLangId(int langId) {
        this.a[12] = (byte)langId;
        this.a[13] = (byte)(langId >> 8);
    }

    public int getMsgIndex1() {
        return this.a[14] & 0xFF;
    }

    public void setMsgIndex1(int msgIndex1) {
        this.a[14] = (byte)msgIndex1;
    }

    public int getMsgIndex2() {
        return this.a[15] & 0xFF;
    }

    public void setMsgIndex2(int msgIndex2) {
        this.a[15] = (byte)msgIndex2;
    }

    public int getMsgIndex3() {
        return this.a[16] & 0xFF;
    }

    public void setMsgIndex3(int msgIndex3) {
        this.a[16] = (byte)msgIndex3;
    }

    public int getTeoPrologue(int index) {
        if (index < 0 || index >= 3) {
            throw new IllegalArgumentException("The index is invalid.");
        }
        return this.a[index + 17] & 0xFF;
    }

    public void setTeoPrologue(int index, int teoPrologue) {
        if (index < 0 || index >= 3) {
            throw new IllegalArgumentException("The index is invalid.");
        }
        this.a[index + 17] = (byte)teoPrologue;
    }

    public byte[] getData() {
        return this.b;
    }

    public void setData(byte[] data, int dataLength) {
        if (data == null) {
            throw new IllegalArgumentException("The data is null.");
        }
        if (dataLength <= 0) {
            throw new IllegalArgumentException("The data length is less than or equal to zero.");
        }
        if (dataLength > data.length) {
            throw new IllegalArgumentException("The data length is greater than the data size.");
        }
        this.b = new byte[dataLength];
        System.arraycopy(data, 0, this.b, 0, dataLength);
        this.a[20] = (byte)this.b.length;
        this.a[21] = (byte)(this.b.length >> 8);
        this.a[22] = (byte)(this.b.length >> 16);
        this.a[23] = (byte)(this.b.length >>> 24);
    }

    public byte[] toByteArray() {
        byte[] byArray;
        if (this.b != null) {
            byArray = new byte[this.a.length + this.b.length];
            System.arraycopy(this.a, 0, byArray, 0, this.a.length);
            System.arraycopy(this.b, 0, byArray, this.a.length, this.b.length);
        } else {
            byArray = new byte[this.a.length];
            System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        }
        return byArray;
    }
}

