/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecoder;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerDecoder;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1TagMatchFailedException;
import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Diag;
import com.objsys.asn1j.runtime.IntHolder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;

public abstract class Asn1Type
implements Asn1TypeIF,
Serializable,
Cloneable {
    public static final short EOC = 0;
    public static final short BOOLEAN = 1;
    public static final short INTEGER = 2;
    public static final short BIT_STRING = 3;
    public static final short OCTET_STRING = 4;
    public static final short NULL = 5;
    public static final short OBJECT_IDENTIFIER = 6;
    public static final short ObjectDescriptor = 7;
    public static final short EXTERNAL = 8;
    public static final short REAL = 9;
    public static final short ENUMERATED = 10;
    public static final short UTF8String = 12;
    public static final short RelativeOID = 13;
    public static final short TIME = 14;
    public static final short SEQUENCE = 16;
    public static final short SET = 17;
    public static final short NumericString = 18;
    public static final short PrintableString = 19;
    public static final short TeletexString = 20;
    public static final short T61String = 20;
    public static final short VideotexString = 21;
    public static final short IA5String = 22;
    public static final short UTCTime = 23;
    public static final short GeneralTime = 24;
    public static final short GraphicString = 25;
    public static final short VisibleString = 26;
    public static final short GeneralString = 27;
    public static final short UniversalString = 28;
    public static final short BMPString = 30;
    public static final short DATE = 31;
    public static final short TIME_OF_DAY = 32;
    public static final short DATE_TIME = 33;
    public static final short DURATION = 34;
    public static final short OID_IRI = 35;
    public static final short RELATIVE_OID_IRI = 36;
    public static final short OpenType = 99;
    private boolean a = false;
    private transient Asn1Tag b = null;
    private transient IntHolder c = null;
    private static final long serialVersionUID = -257475726651236891L;
    public static int z;

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class BER decode method.");
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer) throws Asn1Exception, IOException {
        this.decode(asn1BerDecodeBuffer, true, 0);
    }

    public static Asn1Type decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, Object object, boolean bl, int n2) throws Asn1Exception, IOException {
        try {
            if (object instanceof Asn1BerDecoder) {
                Asn1BerDecoder asn1BerDecoder = (Asn1BerDecoder)object;
                return asn1BerDecoder.decode(asn1BerDecodeBuffer, bl, n2);
            }
            Class clazz = (Class)object;
            Object t2 = clazz.newInstance();
            Asn1Type asn1Type = (Asn1Type)t2;
            asn1Type.decode(asn1BerDecodeBuffer, bl, n2);
            return asn1Type;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Asn1Exception(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Asn1Exception(instantiationException.toString());
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        throw new Asn1Exception("Attempt to invoke base class BER encode method.");
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer) throws Asn1Exception {
        return this.encode(asn1BerEncodeBuffer, true);
    }

    public static Asn1Type decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Object object) throws Asn1Exception, IOException {
        try {
            if (object instanceof Asn1PerDecoder) {
                Asn1PerDecoder asn1PerDecoder = (Asn1PerDecoder)object;
                return asn1PerDecoder.decode(asn1PerDecodeBuffer);
            }
            Class clazz = (Class)object;
            Object t2 = clazz.newInstance();
            Asn1Type asn1Type = (Asn1Type)t2;
            asn1Type.decode(asn1PerDecodeBuffer);
            return asn1Type;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Asn1Exception(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Asn1Exception(instantiationException.toString());
        }
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class PER decode method.");
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class PER encode method.");
    }

    public void encode(Asn1XerEncoder asn1XerEncoder) throws Asn1Exception, IOException {
        this.encode(asn1XerEncoder, null);
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class XER encode method.");
    }

    public void decode(Object object, String string) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class XER decode method.");
    }

    public void decode(Object object, InputStream inputStream) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class XER decode method.");
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        throw new Asn1Exception("Attempt to invoke base class decodeXML method.");
    }

    public void setOpenType() {
        this.a = true;
    }

    public boolean isOpenType() {
        return this.a;
    }

    public int getLength() throws Asn1InvalidLengthException {
        throw new Asn1InvalidLengthException();
    }

    public static void setKey(byte[] byArray) {
        h.a().setKey(byArray);
    }

    protected static int matchTag(Asn1BerDecodeBuffer asn1BerDecodeBuffer, short s2, short s3, int n2) throws Asn1Exception, IOException {
        Asn1Tag asn1Tag = new Asn1Tag();
        IntHolder intHolder = new IntHolder();
        if (asn1BerDecodeBuffer.matchTag(s2, s3, n2, asn1Tag, intHolder)) {
            return intHolder.value;
        }
        throw new Asn1TagMatchFailedException(asn1BerDecodeBuffer, new Asn1Tag(s2, s3, n2), asn1Tag);
    }

    protected static int matchTag(Asn1BerDecodeBuffer asn1BerDecodeBuffer, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        return Asn1Type.matchTag(asn1BerDecodeBuffer, asn1Tag.mClass, asn1Tag.mForm, asn1Tag.mIDCode);
    }

    public void indent(PrintStream printStream, int n2) {
        boolean bl = Asn1Exception.z;
        int n3 = n2 * 3;
        for (int i2 = 0; i2 < n3; ++i2) {
            printStream.print(" ");
            if (!bl) continue;
        }
    }

    public void pdiag(String string) {
        Diag.instance().println(string);
    }

    public void print(PrintStream printStream, String string, int n2) {
        this.indent(printStream, n2);
        printStream.println(string + " = " + this.toString());
    }

    public static String getTypeName(short s2) {
        switch (s2) {
            case 0: {
                return "EOC";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 7: {
                return "ObjectDescriptor";
            }
            case 8: {
                return "EXTERNAL";
            }
            case 9: {
                return "REAL";
            }
            case 10: {
                return "ENUMERATED";
            }
            case 12: {
                return "UTF8String";
            }
            case 16: {
                return "SEQUENCE";
            }
            case 17: {
                return "SET";
            }
            case 18: {
                return "NumericString";
            }
            case 19: {
                return "PrintableString";
            }
            case 20: {
                return "T61String";
            }
            case 21: {
                return "VideotexString";
            }
            case 22: {
                return "IA5String";
            }
            case 23: {
                return "UTCTime";
            }
            case 24: {
                return "GeneralTime";
            }
            case 25: {
                return "GraphicString";
            }
            case 26: {
                return "VisibleString";
            }
            case 27: {
                return "GeneralString";
            }
            case 28: {
                return "UniversalString";
            }
            case 30: {
                return "BMPString";
            }
            case 99: {
                return "ANY";
            }
        }
        return "?";
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class BER stream encode method.");
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        throw new Asn1Exception("Attempt to invoke base class PER encode method.");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Asn1Type asn1Type) {
        return this.equals((Object)asn1Type);
    }

    public int hashCode() {
        return 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        IntHolder intHolder = new IntHolder();
        Asn1Tag asn1Tag = new Asn1Tag();
        objectOutputStream.writeObject(asn1Tag);
        objectOutputStream.writeInt(intHolder.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.b = (Asn1Tag)objectInputStream.readObject();
        this.c = new IntHolder(objectInputStream.readInt());
    }
}

