/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.PrintableString;
import com.turktrust.asn1.Sequence;
import java.math.BigInteger;

public class MonetaryValue
extends Sequence {
    private PrintableString currencyCode = new PrintableString("currencyCode");
    private ASN1Integer amount = new ASN1Integer("amount");
    private ASN1Integer exponent = new ASN1Integer("exponent");

    public MonetaryValue() {
        super("default_monetary_value");
        this.setUpElements();
    }

    public MonetaryValue(String name, String currencyCodeStr, int given_amount, int given_exponent) {
        super(name);
        this.currencyCode.setValue(currencyCodeStr);
        this.amount.setValue(Integer.toString(given_amount));
        this.exponent.setValue(Integer.toString(given_exponent));
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.currencyCode);
        super.addElement(this.amount);
        super.addElement(this.exponent);
    }

    public PrintableString getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(PrintableString given_currency_code) {
        this.currencyCode = given_currency_code;
    }

    public ASN1Integer getAmount() {
        return this.amount;
    }

    public void setAmount(ASN1Integer given_amount) {
        this.amount = given_amount;
    }

    public ASN1Integer getExponent() {
        return this.exponent;
    }

    public void setExponent(ASN1Integer given_exponent) {
        this.exponent = given_exponent;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] input) throws DecodeException {
        super.decode(input);
        this.setCurrencyCode((PrintableString)super.getElement(0));
        this.setAmount((ASN1Integer)super.getElement(1));
        this.setExponent((ASN1Integer)super.getElement(2));
        this.commitElementUpdate();
    }

    public String getExplanation() {
        String exp = "Parasal De\u011fer S\u0131n\u0131rlamas\u0131 :\n";
        exp = exp + "     Para Birimi = " + (String)this.currencyCode.getValue() + "\n";
        exp = exp + "     Miktar = " + ((BigInteger)this.amount.getValue()).toString() + "\n";
        exp = exp + "     \u00dcs = " + ((BigInteger)this.exponent.getValue()).toString();
        return exp;
    }

    public String getTurkishExplanation() {
        return this.getExplanation();
    }
}

