/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import java.util.ArrayList;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseArchiveTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampCertificateChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampMessageDigestChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampSignatureChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampTimeChecker;

public class ArchiveTimeStampAttrChecker
extends BaseArchiveTimeStampAttrChecker {
    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        boolean bl;
        block15: {
            block14: {
                aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.ARCHIVE_TIMESTAMP_ATTRIBUTE_CHECKER, new String[0]), ArchiveTimeStampAttrChecker.class);
                List<EAttribute> list = null;
                int n = CheckerResult.h;
                try {
                    list = aSigner.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                    if (list.isEmpty()) {
                        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NO_ARCHIVE_TSA_IN_SIGNEDDATA, new String[0])));
                        aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
                        return false;
                    }
                }
                catch (Exception exception) {
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ARCHIVE_TSA_DECODE_ERROR, new String[0]), exception));
                    return false;
                }
                bl = true;
                for (EAttribute eAttribute : list) {
                    block13: {
                        boolean bl2;
                        block12: {
                            boolean bl3 = this.checkOneTimeStampAttr(eAttribute, aSigner, aCheckerResult);
                            if (!bl || !bl3) break block12;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = bl = false;
                    }
                    if (n == 0) continue;
                }
                if (bl) break block14;
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ARCHIVE_TSA_CHECK_UNSUCCESSFUL, new String[0])));
                if (n == 0) break block15;
            }
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ARCHIVE_TSA_CHECK_SUCCESSFUL, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        }
        return bl;
    }

    @Override
    public boolean checkOneTimeStampAttr(EAttribute attr, Signer aSigner, CheckerResult aCheckerResult) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ESignedData eSignedData = null;
        int n = CheckerResult.h;
        try {
            object = new EContentInfo(attr.getValue(0));
            eSignedData = new ESignedData(object.getContent());
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ARCHIVE_TSA_CHECK_UNSUCCESSFUL, new String[0]), exception));
            return false;
        }
        object = new TimeStampSignatureChecker(eSignedData);
        TimeStampTimeChecker timeStampTimeChecker = new TimeStampTimeChecker(Types.TS_Type.ESA, eSignedData);
        TimeStampMessageDigestChecker timeStampMessageDigestChecker = new TimeStampMessageDigestChecker(Types.TS_Type.ESA, eSignedData);
        TimeStampCertificateChecker timeStampCertificateChecker = new TimeStampCertificateChecker(eSignedData);
        arrayList.add(object);
        arrayList.add(timeStampTimeChecker);
        arrayList.add(timeStampMessageDigestChecker);
        arrayList.add(timeStampCertificateChecker);
        boolean bl = true;
        for (Checker checker : arrayList) {
            boolean bl2;
            CheckerResult checkerResult;
            block8: {
                block7: {
                    checkerResult = new CheckerResult();
                    checker.setParameters(this.getParameters());
                    boolean bl3 = checker.check(aSigner, checkerResult);
                    if (!bl || !bl3) break block7;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            bl = bl2;
            aCheckerResult.addCheckerResult(checkerResult);
            if (n == 0) continue;
        }
        return bl;
    }
}

