/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.LogotypeImageResolution;

public class LogotypeImageInfo
extends Sequence {
    private ASN1Integer type = new ASN1Integer("type");
    private ASN1Integer fileSize = new ASN1Integer("fileSize");
    private ASN1Integer xSize = new ASN1Integer("xSize");
    private ASN1Integer ySize = new ASN1Integer("ySize");
    private LogotypeImageResolution resolution = new LogotypeImageResolution("resolution");
    private IA5String language = new IA5String("language");

    public LogotypeImageInfo() {
        this("defaultLogotypeImageInfo");
    }

    public LogotypeImageInfo(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        this.setForcedTagMethod(1);
        super.addElement(this.type);
        this.type.setTaggingMethod(1);
        this.type.setTagClass((byte)-128);
        this.type.setTagNumber(0);
        this.type.setDefaultValue("1");
        super.addElement(this.fileSize);
        super.addElement(this.xSize);
        super.addElement(this.ySize);
        super.addElement(this.resolution);
        this.resolution.setOptional(true);
        super.addElement(this.language);
        this.language.setTaggingMethod(1);
        this.language.setTagClass((byte)-128);
        this.language.setTagNumber(4);
        this.language.setOptional(true);
    }

    public ASN1Integer getFileSize() {
        return this.fileSize;
    }

    public IA5String getLanguage() {
        return this.language;
    }

    public LogotypeImageResolution getResolution() {
        return this.resolution;
    }

    public ASN1Integer getImageInfoType() {
        return this.type;
    }

    public ASN1Integer getxSize() {
        return this.xSize;
    }

    public ASN1Integer getySize() {
        return this.ySize;
    }

    public void setFileSize(ASN1Integer fileSize) {
        this.fileSize = fileSize;
    }

    public void setLanguage(IA5String language) {
        this.language = language;
    }

    public void setResolution(LogotypeImageResolution resolution) {
        this.resolution = resolution;
    }

    public void setImageInfoType(ASN1Integer type) {
        this.type = type;
    }

    public void setxSize(ASN1Integer xSize) {
        this.xSize = xSize;
    }

    public void setySize(ASN1Integer ySize) {
        this.ySize = ySize;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] input) throws DecodeException {
        super.decode(input);
        this.setImageInfoType((ASN1Integer)super.getElement(0));
        this.setFileSize((ASN1Integer)super.getElement(1));
        this.setxSize((ASN1Integer)super.getElement(2));
        this.setySize((ASN1Integer)super.getElement(3));
        this.setResolution((LogotypeImageResolution)super.getElement(4));
        this.setLanguage((IA5String)super.getElement(5));
        this.commitElementUpdate();
    }
}

