/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.CertID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Request;
import tr.gov.tubitak.uekae.esya.asn.ocsp.TBSRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Version;
import tr.gov.tubitak.uekae.esya.asn.ocsp._SeqOfRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp._ocspValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extension;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;

public class OCSPClient {
    protected static Logger logger;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGED = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_AA_COMPROMISE = 10;
    public static final int STATUS_RESPONSE_HAS_INVALID_SIGNATURE = 1;
    public static final int STATUS_RESPONSE_CANT_BE_RECEIVED = 2;
    public static final int STATUS_RESPONCE_INVALID_NONCE = 3;
    private static final String a;
    private static final String b;
    private static final String c;
    private static final String d;
    private static final String e;
    public static final Asn1ObjectIdentifier NONCE_OID;
    private int f;
    protected HashMultiMap<BigInteger, ESingleResponse> singleResponses;
    protected ECertificate signingCertificate;
    protected EBasicOCSPResponse mBasicResponse;
    protected EOCSPResponse mOCSPResponce;
    private static final Logger g;
    private String h;
    private HttpURLConnection i;
    private URL j;
    private byte[] k;
    private int l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    public static DigestAlg digestAlgForOcspRequest;
    public static int q;
    private static final String[] r;
    private static final String[] s;

    protected OCSPClient() {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    int n = q;
                    this.h = null;
                    this.i = null;
                    this.j = null;
                    this.k = null;
                    this.l = 0;
                    this.m = true;
                    this.n = true;
                    this.o = true;
                    this.p = false;
                    this.singleResponses = new HashMultiMap();
                    try {
                        LV.getInstance().checkLD(LV.Urunler.ORTAK);
                    }
                    catch (LE lE) {
                        throw new ESYARuntimeException(OCSPClient.a(7616, 30250) + lE.getMessage());
                    }
                    if (n == 0) break block6;
                    if (!AbstractConfigElement.b) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            AbstractConfigElement.b = bl;
        }
    }

    public OCSPClient(String aConnectionAddress) throws ESYAException {
        this();
        try {
            this.j = new URL(aConnectionAddress);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ESYAException((Throwable)malformedURLException);
        }
        this.h = aConnectionAddress;
    }

    public void setCheckSignature(boolean aCheckSignature) {
        this.m = aCheckSignature;
    }

    public void setCheckNonce(boolean aCheckNonce) {
        this.n = aCheckNonce;
    }

    public void setCheckResponseStatus(boolean aCheckResponseStatus) {
        this.o = aCheckResponseStatus;
    }

    public void setCheckDate(boolean aCheckDate) {
        this.p = aCheckDate;
    }

    public void openConnection() throws ESYAException {
        this.openConnection(null);
    }

    public void closeConnection() throws ESYAException {
        this.i.disconnect();
    }

    public void openConnection(String aTimeOut) throws ESYAException {
        int n = q;
        try {
            this.i = (HttpURLConnection)this.j.openConnection();
            if (aTimeOut != null) {
                this.i.setConnectTimeout(Integer.parseInt(aTimeOut));
                this.i.setReadTimeout(Integer.parseInt(aTimeOut));
            }
            this.i.setRequestProperty(OCSPClient.a(7647, -23482), OCSPClient.a(7578, -1191));
            this.i.setRequestProperty(OCSPClient.a(7658, 27358), OCSPClient.a(7673, 30095));
            this.i.setRequestMethod(OCSPClient.a(7665, -16861));
            this.i.setDoOutput(true);
            this.i.setUseCaches(false);
            this.i.connect();
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(7659, -19546) + this.h, (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(7624, 15735) + this.h, (Throwable)iOException);
        }
        if (AbstractConfigElement.b) {
            q = ++n;
        }
    }

    public Calendar getProducedAt() {
        return this.mBasicResponse.getProducedAt();
    }

    public void queryCertificate(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        this.queryCertificate(new ECertificate[]{aCertificateToQuery}, new ECertificate[]{aIssuerCertificate});
    }

    public EOCSPResponse queryCertificate(ECertificate[] aCertificatesToQuery, ECertificate[] aIssuerCertificates) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(7675, 18513));
            throw new ESYAException(OCSPClient.a(7641, -10484));
        }
        byte[] byArray = this.a(aCertificatesToQuery, aIssuerCertificates);
        this.a(byArray);
        g.debug(OCSPClient.a(7676, 24260));
        return this.mOCSPResponce;
    }

    public EOCSPResponse queryCertificate(BigInteger aSertifikaSeriNo, byte[] aSMSubjectHashDegeri, byte[] aSMAcikAnahtarHashDegeri) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(7625, -2852));
            throw new ESYAException(OCSPClient.a(7617, -22730));
        }
        byte[] byArray = this.a(aSertifikaSeriNo, aSMSubjectHashDegeri, aSMAcikAnahtarHashDegeri);
        this.a(byArray);
        g.debug(OCSPClient.a(7649, -6560));
        return this.mOCSPResponce;
    }

    public int getStatus() {
        return this.l;
    }

    private EOCSPResponse a(byte[] byArray) throws ESYAException {
        block10: {
            block11: {
                int n = q;
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.i.getOutputStream());
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    g.error(OCSPClient.a(7668, 3858), (Throwable)iOException);
                    throw new ESYAException(OCSPClient.a(7678, 7889), (Throwable)iOException);
                }
                try {
                    g.debug(OCSPClient.a(7670, 22621));
                    this.mOCSPResponce = this.b();
                    g.debug(OCSPClient.a(7636, 11661));
                }
                catch (Exception exception) {
                    this.l = 2;
                    g.error(OCSPClient.a(7667, 20938), (Throwable)exception);
                    throw new ESYAException(OCSPClient.a(7664, -28108), (Throwable)exception);
                }
                if (!this.o) break block10;
                if (!this.checkResponseStatus()) break block11;
                this.a(this.mOCSPResponce);
                if (n == 0) break block10;
            }
            this.mOCSPResponce = null;
            g.error(OCSPClient.a(7630, 17406));
            throw new ESYAException(OCSPClient.a(7583, -13740));
        }
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(ECertificate[] eCertificateArray, ECertificate[] eCertificateArray2) throws ESYAException {
        g.debug(OCSPClient.a(7679, -25856));
        int n = q;
        if (eCertificateArray == null || eCertificateArray.length == 0) {
            g.error(OCSPClient.a(7672, -18416));
            throw new ESYAException(OCSPClient.a(7652, -17080));
        }
        int n2 = eCertificateArray.length;
        Request[] requestArray = new Request[n2];
        for (int i = 0; i < n2; ++i) {
            ECertificate eCertificate = eCertificateArray[i];
            ECertificate eCertificate2 = eCertificateArray2[i];
            try {
                requestArray[i] = this.a(eCertificate, eCertificate2);
                continue;
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(7671, -19284), (Throwable)exception);
                throw new ESYAException(OCSPClient.a(7646, 28939), (Throwable)exception);
            }
        }
        return this.a(requestArray);
    }

    private byte[] a(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        Request[] requestArray = new Request[1];
        try {
            requestArray[0] = this.b(bigInteger, byArray, byArray2);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(7643, 24357), (Throwable)exception);
            return null;
        }
        return this.a(requestArray);
    }

    private byte[] a(Request[] requestArray) throws ESYAException {
        Extension extension;
        OCSPRequest oCSPRequest = new OCSPRequest();
        TBSRequest tBSRequest = new TBSRequest();
        try {
            extension = this.a();
        }
        catch (Exception exception) {
            g.warn(OCSPClient.a(7677, -31893), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(7654, -1748));
        }
        tBSRequest.requestList = new _SeqOfRequest(requestArray);
        tBSRequest.requestExtensions = new Extensions(new Extension[]{extension});
        tBSRequest.version = new Version(0L);
        oCSPRequest.tbsRequest = tBSRequest;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            oCSPRequest.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(7642, -32007), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(7639, -12648));
        }
        byte[] byArray = asn1DerEncodeBuffer.getMsgCopy();
        g.debug(OCSPClient.a(7645, -25216));
        return byArray;
    }

    private Extension a() throws ESYAException {
        try {
            Extension extension = new Extension();
            extension.extnID = NONCE_OID;
            this.k = new byte[16];
            SecureRandom.getInstance(OCSPClient.a(7618, 17031)).nextBytes(this.k);
            Asn1OctetString asn1OctetString = new Asn1OctetString(this.k);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            extension.extnValue = new Asn1OctetString(asn1DerEncodeBuffer.getMsgCopy());
            return extension;
        }
        catch (Exception exception) {
            throw new ESYAException((Throwable)exception);
        }
    }

    private EOCSPResponse b() throws ESYAException {
        OCSPResponse oCSPResponse = new OCSPResponse();
        InputStream inputStream = null;
        try {
            inputStream = this.i.getInputStream();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(inputStream);
            oCSPResponse.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            g.debug(OCSPClient.a(7580, 2356));
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(7621, -24599), (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(7674, 18242), (Throwable)iOException);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(7626, -3625), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(7626, -3625), (Throwable)exception);
        }
        return new EOCSPResponse(oCSPResponse);
    }

    private Request a(ECertificate eCertificate, ECertificate eCertificate2) throws Exception {
        BigInteger bigInteger = eCertificate.getSerialNumber();
        byte[] byArray = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubject().getEncoded());
        byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey());
        return this.b(bigInteger, byArray, byArray2);
    }

    private Request b(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        CertID certID = new CertID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgForOcspRequest.getOID());
        Asn1OctetString asn1OctetString = new Asn1OctetString(byArray);
        Asn1OctetString asn1OctetString2 = new Asn1OctetString(byArray2);
        Asn1BigInteger asn1BigInteger = new Asn1BigInteger(bigInteger);
        certID.hashAlgorithm = algorithmIdentifier;
        certID.issuerNameHash = asn1OctetString;
        certID.issuerKeyHash = asn1OctetString2;
        certID.serialNumber = asn1BigInteger;
        return new Request(certID);
    }

    public int getResponseStatus() {
        return this.f;
    }

    public ESingleResponse getSingleResponse(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        List<ESingleResponse> list = this.singleResponses.get(aCertificateToQuery.getSerialNumber());
        int n = q;
        if (list == null) {
            throw new ESYAException(OCSPClient.a(7620, 15832));
        }
        for (ESingleResponse eSingleResponse : list) {
            ECertID eCertID = eSingleResponse.getCertID();
            if (OCSPClient.isEqual(eCertID, aCertificateToQuery, aIssuerCertificate)) {
                return eSingleResponse;
            }
            if (n == 0) continue;
        }
        throw new ESYAException(OCSPClient.a(7619, -4502));
    }

    public static boolean isEqual(ECertID certID, ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) {
        block5: {
            if (certID.getSerialNumber().equals(aCertificateToQuery.getSerialNumber())) {
                try {
                    byte[] byArray = aIssuerCertificate.getSubject().getEncoded();
                    byte[] byArray2 = aIssuerCertificate.getSubjectPublicKeyInfo().getSubjectPublicKey();
                    DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)certID.getHashAlgorithm());
                    byte[] byArray3 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
                    byte[] byArray4 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                    if (!Arrays.equals(certID.getIssuerNameHash(), byArray3) || !Arrays.equals(certID.getIssuerKeyHash(), byArray4)) break block5;
                    return true;
                }
                catch (CryptoException cryptoException) {
                    logger.warn(OCSPClient.a(7640, 26316), (Throwable)cryptoException);
                    return false;
                }
            }
        }
        return false;
    }

    public EBasicOCSPResponse getBasicResponse() {
        return this.mBasicResponse;
    }

    public EOCSPResponse getOCSPResponse() {
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkResponseStatus() {
        int n;
        this.f = n = this.mOCSPResponce.getResponseStatus();
        g.debug(OCSPClient.a(7662, -24447) + n);
        switch (n) {
            case 0: {
                g.debug(OCSPClient.a(7622, 29940));
                return true;
            }
            case 1: {
                g.debug(OCSPClient.a(7632, -26055));
                return false;
            }
            case 2: {
                g.debug(OCSPClient.a(7653, 8077));
                return false;
            }
            case 3: {
                g.debug(OCSPClient.a(7623, -32243));
                return false;
            }
            case 5: {
                g.debug(OCSPClient.a(7663, 3156));
                return false;
            }
            case 6: {
                g.debug(OCSPClient.a(7644, -3550));
                return false;
            }
        }
        return false;
    }

    public void checkResponse() throws ESYAException {
        this.a(this.mOCSPResponce);
    }

    private void a(EOCSPResponse eOCSPResponse) throws ESYAException {
        int n;
        block17: {
            block18: {
                block15: {
                    block16: {
                        n = q;
                        try {
                            this.mBasicResponse = eOCSPResponse.getBasicOCSPResponse();
                        }
                        catch (Exception exception) {
                            g.error(OCSPClient.a(7576, -16339), (Throwable)exception);
                            throw new ESYAException(OCSPClient.a(7626, -3625), (Throwable)exception);
                        }
                        if (!this.n) break block15;
                        if (this.checkNonce()) break block16;
                        this.mOCSPResponce = null;
                        this.l = 3;
                        g.error(OCSPClient.a(7637, 12996));
                        throw new ESYAException(OCSPClient.a(7656, 27911));
                    }
                    g.debug(OCSPClient.a(7631, -16101));
                }
                if (!this.m) break block17;
                if (this.checkSignature()) break block18;
                this.mOCSPResponce = null;
                this.l = 1;
                g.error(OCSPClient.a(7627, 23325));
                throw new ESYAException(OCSPClient.a(7638, -19400));
            }
            g.debug(OCSPClient.a(7655, 2056));
        }
        EResponseData eResponseData = this.mBasicResponse.getTbsResponseData();
        int n2 = eResponseData.getSingleResponseCount();
        for (int i = 0; i < n2; ++i) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i);
            if (this.p) {
                Calendar calendar = Calendar.getInstance();
                if (!this.checkDate(eSingleResponse, calendar)) {
                    g.error(OCSPClient.a(7660, -8526));
                    throw new ESYAException(OCSPClient.a(7579, -7133));
                }
            }
            this.singleResponses.put(eSingleResponse.getCertID().getSerialNumber(), eSingleResponse);
            if (n == 0) continue;
        }
    }

    public boolean checkDate(ESingleResponse aResponse, Calendar aDate) {
        block7: {
            if (aDate.before(aResponse.getThisUpdate())) {
                g.warn(OCSPClient.a(7629, 26632));
                return false;
            }
            if (aResponse.getNextUpdate() == null || !aDate.after(aResponse.getNextUpdate())) break block7;
            g.warn(OCSPClient.a(7635, -31450));
            return false;
        }
        return true;
    }

    public byte[] getNonce() {
        return this.k;
    }

    public boolean checkNonce() {
        EExtensions eExtensions = this.mBasicResponse.getResponseExtensions();
        int n = q;
        if (eExtensions == null) {
            g.error(OCSPClient.a(7582, 11884));
            return false;
        }
        for (int i = 0; i < eExtensions.getExtensionCount(); ++i) {
            EExtension eExtension = eExtensions.getExtension(i);
            if (!eExtension.getIdentifier().equals((Asn1Type)NONCE_OID)) continue;
            byte[] byArray = eExtension.getValue();
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            try {
                asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(7657, -31722), (Throwable)exception);
                return false;
            }
            if (Arrays.equals(asn1OctetString.value, this.k)) {
                return true;
            }
            return false;
        }
        g.error(OCSPClient.a(7633, 1820));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSignature() {
        byte[] byArray = null;
        int n = q;
        byArray = this.mBasicResponse.getTbsResponseData().getEncoded();
        byte[] byArray2 = this.mBasicResponse.getSignature();
        if (this.mBasicResponse.getObject() == null || ((BasicOCSPResponse)this.mBasicResponse.getObject()).certs == null) {
            g.error(OCSPClient.a(7650, -21019));
            return false;
        }
        for (int i = 0; i < this.mBasicResponse.getCertificateCount(); ++i) {
            ECertificate eCertificate = this.mBasicResponse.getCertificate(i);
            try {
                Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)this.mBasicResponse.getSignatureAlgorithm());
                PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                if (SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey)) {
                    return true;
                }
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = byArray2.length - 1;
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray3[j] = byArray2[n2 - j];
                    if (n == 0) continue;
                }
                if (!SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) continue;
                return true;
            }
            catch (CryptoException cryptoException) {
                g.error(OCSPClient.a(7669, -15159), (Throwable)cryptoException);
                return false;
            }
        }
        g.debug(OCSPClient.a(7648, -572));
        return false;
    }

    public ECertificate getSigningCertificate() throws ESYAException {
        if (this.mBasicResponse == null) {
            throw new ESYAException(OCSPClient.a(7577, -12277));
        }
        if (this.signingCertificate != null) {
            return this.signingCertificate;
        }
        if (this.checkSignature()) {
            return this.signingCertificate;
        }
        return null;
    }

    public void setDigestAlgForOcspRequest(DigestAlg digestAlg) {
        digestAlgForOcspRequest = digestAlg;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[71];
                var3_1 = 0;
                var2_2 = "N\u00ae\u00b7\u009e\u00cdE\u00989\u008f=(\u00ee\u00e1\u00185\u0090\t%(I\u0084\u001a\u00db\u00a0\u00c3\u0098\u008d\u00cb\u0083-\u00a2\u00fd\u009f\u00d1\u00c0\u008a\u00d0\u0000\bjS\u00a9d\u00b9\u0014\u0170n\u00c7\u0085K\u00fcvv\u00dd\u01fb$\u009c\u00a9K\u00c47\u009f\u00fau\u0186\u0015]\u00aa\u00efF\u008a\u00a0\u00046\u0086\u0007\u0084.RF\u0090V\u00af\u00b8S\u0098\u00a1\u0015;K\u00a9\u00b5\u00d1\u00d3\u00f1\u00bdO\u0016{*\u009dWaEp:\u00a5\u00a3\u00ab\u0018\u00d7\u001eKZ\u00fb\u00f2<\u00ba\u0002\u00b6\u00a7\u0017\u00c9\u00d5\u0096\u00f0\u0018\u00cb\u008d\roH!\u001c\f\u00a4MZo\u00af\u00dc>\u00b4\u008d\u00ec/\u008c\u001a\u00e9\u00f8\u00eb\u0087\u00978\u0089\u00f6\u00a9\u00db=\u00d0\u00e3Q\u00d5\u0084\u008bvj\u00d8\u00ae\u00ad\u00daxJ|!\u009b\u00cd\r\u00f2\u009a\u00c8r\u0088\u00d2\u017f\u00ca\u0011\u00da\u0011\u018b\u00ea<\u0111\u00e0\u00fc]\u00ffm<j\u011bG\u00d4\u00c1\u00d0\u00e3\u0095\u00ca\u0003\u001c\u008f\u00f339\u00f1Yu\u001025\u009e\u00ea\u0090\u0000 \u00e4\u00a9\u0080\u00f3\u0011\u00d5\u001f\u0083\u00bd\u000b\u00fe\u00ab\u0118\u00fb(\u00a9\u00b8\u01ca\u00d1\u00b08\u001a\u00f2\u00cf\u009cL\u00e6\u00f3U\u00a6\"\u00f2I\u0003^\u008f\u00f6\u0096\u001b\u001eE\u00e5~$%L\u00dfxc\nd\u00ea\u00c8\u0016\u00a8c2w\u00ea\u0093\u00c4\u008a\u00d8A\u00a6c\u00cd \u00b0]-CS\u0016!\u00f9\u00b8\b\u00cfM\u00a8\u01e59g\u0092`\u00c3\u00a7\u008e\u001e\u00f3\u00fe6\u00da\u008bD\u00ffq4\u009d\u00f6\u0082$\u0000\u000b\u00d4\u0001/\u00e9{\u0090p\u00aa\u0083\u0015\u0187)B\u00a56\u00ff\u00fdc\u0088\u00b4]\u00d5\u00f6\u008b:\u00b4N\u0005f\u0097\u00c3\u001e0\u00c3\u00f7\u00d5\u0085\u00f0\u00e3\u00b9H\u0083\u00fc\u0081\u00bc\u00d0\u0190\u00970\u0105y\u01a4\u00ed\u0018\u00d6Okp\u00ff\u00b7\u00bc\u0012\u0012\u00a3\u00a5\u00b5\u0089\u0081\u009ez\u0019\u009a\u00ad'k\r\u00a1\u00b4\f\u0097v$Vn\u0002\u00a4\u00a9\u010c1\u00c2\u0196*\u00ceS\u00a7!\u00cf\u00b8\u00ce\u00cf\u0095\u00ba\u00eff\u0019\t*\u00b2\u00eaaU\u00c2\u0011\u0018\u0000\u00a7\u0092\u009d\u009f3\u0083\u0017\u00ab\u00ac\u00961\u00e1\u01f6\u00f4\u0093\u01d2\u001f\u01d9\u00f2.\u001dP\u00ddA\u0080\u00b4'N\u00a8\u008aH`\u00ed\u00c9\u00b4\u00aa9b%\u00a8Y\u0012\u00a4.lKh\u00bf(>\u001d\u00d8\u00d8\u00d6\u0084\u00b01\u008c:i\u00c0\u0013N\u0014\u00ed\u00da)\u00f1X@@3\u0094QJf\n\u0091p\u00d6\u00cb\u00d3\u00ea\u00d5j\u00b5\u00a1\u00fe4.+\u00be/\u0084B\u00a4\u00fcan\u000f-\u01e6(\u00fe\u01f2\u00a0\u015a\u00d6\u001b\u00d3\u00fe\u0004\u0094\u00bb\u001e@\rSs\u0090\u00e4\u00ab\u00c5\u0091\u016d\u0098\u0000\u00be\u01d9n\u00ec\u00a5: \u0119s\u001c\u00f4\u00bd^8\u00b0h\u00c8\u00b0\u00d2\u00d8\u015b\u0018S\u00fa\u00f2\u0129\u000fi\u0092\u00fc\u008an\u0003\u00c6\u00fd\u0186\u0185\u009f\u0014\u00a3\u00af\u00a2m\u00bee\u00bdH\u0122\u00ae\u00b2\u018b\u00a3\u0121\u0014\u00b3H\u01b1\u008b\u0003)\t\u00c8_R\u00d0\u00d6-\u0002\u00e9\u0003`Q\u00e8\u00ef\u0014n-\u00fa\u00ad\u00b1\u000ev\u00e3j\u00ee$\u0010\u0004r\u00f1\u0095pQ\u00aa\u0019\u0185\u00eb\u00fd\u0131\u00cd\u01a5\nt\u00fe\u009f\u00805\u00c8?\u00b4\u00e6\u00a04\u0014\u001f\u00fc\u00a8\u00a4\u0089\u00a3\u00e98~Z\u00e7\u00a2\u0019\u00e3\u00d6\u009aqn\u0017\u0093\u0099;\u00f9\u01a0\u00b1?\u00e0Z\u01e3\u008d\u0095\u00b3\u00be\u0083[\u00b2\u00de#\u00a1\u00ed\u00ec5\u00bb\u00ab*\u0087\u00ab\u00f5$\u0098\u001d\b\u00be\u000f$\u00a1\u009f\u00d4\u0091d<)\u00c6[\u0093P\u00ff=\u0011\u00fa\u00db\u007f\u00a8\u008c^\u009dd\u00b5M}\u007f\u0092\u0099\u0014!\u00f9glX\u00bf\u00cc\u0018x`\u00e7\u00c6q\u0093\u00dd\u00dcp\u00b59j~\u0093c}\u0000\u00fc\u00daS\n\u00e1\"\u00d6\u008b\t\u0085[F\u001b\u00a1\u00bf\t\u00e2p\u00c7\u00fb/\u00d0\u0006\u00dc3\u00ab@#-V\u00d0\u00b5\u0093\u00af\u00f7^X\u009cC#6o\u00af-x\u00d26\u0001\u00a6\u00e1y2F\u008c[yh\u001e\u00b1\u00cd7\u00e3\u00c1\u00f5\u00e6\u00c4\u00b5\u00fb\u00efdXh\u0084v\u00ff\u0010B\u00c9\u0086\u0138\u00d3?\u0083\u007f\u0106\u00be\u008c\u00a4@L\u00f9\u00db4\u00e7\u01d8\u000e\u00adlc\u0015\u0086j\u00ba\u00a9\u01c2\u0092\u00ae\u010c \u01d1\u0016\u00e2\u001c\u008a\u001b\u00bb\u00ab\f\u0084\u0019\u0095+\u0019!h\u008c\u00bf\u0099\u00b7&\u00e2\u009au<4\u00c4\u00f8\u00d3$\u00f7\u00b3\u0010+\u00fbE\u00ac\u00cb\u00deut\u00a8O\u00de?\u00e6\u0091\u009a (GV\\\u00f8L\u00f0h}\u00e5e1\u00e7\u00d5Rqd\u0019Pz\u00d4\u00e3\u0095\u0010\u00e1\u00d8\u00f0J\u0095*X\u008a\u00d8\u00a5aB'\u00ac=\u00eb\u00ecF\u0001\u00ff\u00f8\u00b3\\+\u00ba\u0081\u00929\u00c1\u0088A\u001e\u000e\u0090(\u00d2\u001dE\u00d8e\u0084\u00c61B:\u00b0\u00c0(Ns\u00ed6'n\n\u00b3\nM\u00dd\u009ec\u009f/\u00ae\u00d41_/xJvF\u00e8\u009b\u00f4\u00b3\u0086i\u00ab\u00e0\u00eav\u00fcT\u0083r\u00f7p\u00a8x1W\u001c\u00fa\u00a2\u009f\u00db\u0088\u0014\u00cf?2)\u0147&\u00d0=\u0082\u01d1\u0001vS\u001f\u00b2\u0012\u0004I\u001d\u0177\u0199\u00a1\u001e\u008aa\u0096\u00ea!m\u0002\u00ae \u001e\u0094e\u0016X\u00cf\u008b\u009b4\u0010L\u00c9}A\t\u00d9&\u00b8\u0086\u00fd\t\u0011\u008c\u00e5\u00ae \u0090\u00e8\u00c6\u00db\u00c9\u008b\u0010J\u00ef}\u00d8a-\u001f\u01e9\u00ba\u00f4\u001f-\u00af\u00b2\u0086W\u0017\u001cZ\u0086m\\\u00da/2\u00af\nH\u00a5\u00fc\u0013ubC\u00cd\u0177\u00f2\u00a4\u0019;\u00ab\u0019>\u0018Q\"\u00bb\u00d8\u0119\u008b\u00dd\u00ff\u0085\u00a9\u01ea\u0011\u00ac\u0088\u009e7\u00c8\u0080\u00beD#\u00bf.\u0089\u008e\n^a{\u0080\t\u00b1\u00ee\u00f9\\_\u00d6%\u019b\u00aa\u0010\u015f\u00e6t`\u007f\u0017\u000f\u0003l)'\u00b4I\u001a\u01cd\u001e)wG?\fm[P2\u0093\u00e2\u00ea3Y\u00edm\u00fa\u00d5\u008a\u01a1\u0088T}\u00af\u00cfm\u00d0\u00f7\u001f\u0166\f,\u0087K6\u008d\u00f7z\u00d1\u0005@>\u0019*\u00a0Rj\u0001v\u00ac\u00f9[d\u00b9v\u00b86\u00e7\n\u00d8\u008bR\u00fb'dZ \u01bc\u00bb\u0193\u0003x\u0098\u0083q\u008bI\u00c5s\u00c3\u00a8\u00bb\u00d2\u01ebP\u00ca\u001e+\u001e\u001b\u0088X\u009d<}\u00dc}a \u00d4\u00f4V\u00ba\u0000\u001e\u008a\u00aeJk\u00e5\u019a\u0003\u0007\u000b\u00bad\u01cf\u0003\t\u00c3Q\u000eDx^\u0097!:M\u00ae\u0131\u00d1`\u00d8\u0085\t\u0014\u012d1ln>\u0081\u00d8\u00d9\b\u010e\u009e\"\u00fe\u009c.\u00cd\u00c2\u00a5\u00de\u016d\u001f\u01ba\u009b\u009e;`+\u001b\u0016b\u0005\u00ba\u0018R%\u00c6\u00d3|\u0013\u00c5.\u0005!U\u0083@p\u00e5\u008f\u01a3\u00ba>\u001eMu8?0k;\u013bse\u000e4\u00eb\u018c\r\tsy\u00a5A\u0087\u00988B\u0015\"\u00f0\u018c\u0010\u00b4\n3\u00few\u0080(\u00c8\u009c\u00b4\u0092\u00a0',T\u00fb\u00c1D\u00b4\u00bfX\u00ac\u00d9o\u00b1Ton\u0138g\u00aaA\u018c\u0091\u0116E5\u00c1\u00ect j\u00f1\u00ea\u00d4]w*\u01f1\u000et1*F\u00d3\u00b61\u00ed\u00ba\u008a\u008f\u001d\u00b2\u00feg;)n\u00b6b\u00e1D\u00d23\u001aD\u00e7\u001a\u0095\u008e2\u00a17\u00ef\u00a8\u001e\u00b1\u00f0\u01e6\u00d6\u0091\u0196_\u0151\u00fa3\u00e09blw\u0011\u00d9\u00faw\u000e\u01a2\u00ed\u008f\b}\u0090\u0004\u00e4j\u00bep\u009f\u000b\u00be~Y6\u00e0ul\u009fw\u00a3a\u00a0J\u00b1I\u00a0`V\u00b2\u00c7\u00f2\u00d3\u00eayt\u00f5\u008b\u00fa\u0013-\u000b\u00ed\u00fd\u0010\u00f3\u00b4\u009e\u000b\u00f0\u0099Q\u009b\f\u00ae\u00ebf\u00c4\u000f\u0019\f\u0085W(\u0000\u00cd{H\u00f7\f\u00f6*\u009a\u000e\u00fchn+\u0001\u00a9\u00ea\u00a2\u0010\u00fej/d\u00fb\u00f24e\u001a\u009b\u009b?0\u00ba=\u00b3\u00bd{:A\"\u0087\u00cc\f\\\u0017EZ\u00ae\u00ba\u008b\u00f6\u0006\u00f5\u00ec\u00b3sh989g{\u0088\u0012\u00f5\u00b7\u0019P\u017d\u0018F\u00dc~\u00b9\u00fa\u0010\f\u00d8A\u00052//:\u00b5\u00dc\r\u00a7n\u001c\u0007\u0018\u00ac5\u001f\u0099\u0012\u00a2\u00d3/\u00f3\u000b\u00fb\u00b0\u00d9\t.\u00c5\u00dc\u00a4*\u0083X\u0093\u008b\"\u00ff\u00f16\u00a0k\u000b\u00d5\u00ec\u00fa2\u0011WN\u00d5U\u00ffF+\u000et1\u00a7\u001d\u0019\u0097\u0006<\u00f60f\u00ea]\u00cc\u009c\u0015\u00a4\u01f4\u00dc\u009b\u000bM\u00c8\u0092\u001e\u0090:~\u0001\u0005\u0017J\u00bb\u0097\u00db\u00fd\u001f\u00ecd]\u00c4\u00b6\u00cf\u0017H\bbz\u0082=O^d\u00e1+\u00a8\u013bb#\u00a5T\u00ca\u00c1b\u00b7lF!\u00ae\u0085\u001a\u007f\u00c2\u008f\u0005?\u01e1\u00e9_\u0137\u000fy]\u00de\u00b0;\u00f7\u00ea\u00b7\u00f7gS`\u018e\"\u00a14VW.`\u001f\u00f1\u00ba\u00a7\u00f3l\u0011\u0089\u00a9w~\u009b\u008c\u00bc0\u00d5zpq\u0082\u00ca\u00c3TM\u00a9\u00d1?\u0001(\u0014\u007f\u00fc\u00a4\u00a4\b\u00a3\u00d98xZ>\u00af\u0002\u00fc\u00d30M\tEi\u00a8\u00dc\u00b8\u00e0]O\f\u00dd5NW\u00ea\n\u015a\u00cci\u016eM\u01c9\u0017\u00c9t\u0015_\u00c13\u00f3\u0092\u0006\u00f49\u0099\u00f9mD\u00f4Ht\u00d8zWG\u00be\u001b\u00b4\u0003@\u00f8\u00e2\u00d7'\u000b|d\u0087'\u00b4\u00af#[\u00df\u009dQ\u00b1\u0001X\u00cc\u00136\u0013-\u0018\u00b2j\u00e0o)\u00cav\u0083\u000en\u00dbB\u0012\u0097\u0012i\u00f9\u0011\u00f0\u00ca\u00d4\u00c2\u00d6n/\u00aa\u0002+\u000b^\u00fd\u00fcg\u00d3\u00af'\u00ce\u0000\u00c3\r\u00f5\u008f\u00db^\u00f37\u00bbp\u00b9\u00b61'xEx\u0083#}\u008a\u00b1\u0006\u0003\u00de\u0000\u0087d\u008dhD\u00aa.\u010b.\u00b3+\b.:Yp\u00f3B=\u0015\u0096F\u0017\u00c1q\u0097\u0019\u00f0\u00c7\u00e3\u00ff\u00f3\u0093\u0086\u00fc5I\u0083\u00e0h\u0003v\u00adQ\u00df\u008bam\u00d4*\u00a4\u0013\u00e2F\u0004\u0010\u008a\t}\u00fc\u00ca\u00cbP\u00e5\u00e2v#U\u00b3\u00cc&\u00bb'\u001c\u00b9\u00fd|\u0084\u0013\u00a7\u00ba\u00b8\u0006\u015b\u00ec\u00b0(\u009a\u0094\u00f8d\u00f5\u0085\u0094\u00acd\u008a\u0006\u00b9\u0017k\u00e1H\u00e6{PE\u00c6\u00c7\u0010\u00d7\u014e";
                var4_3 = "N\u00ae\u00b7\u009e\u00cdE\u00989\u008f=(\u00ee\u00e1\u00185\u0090\t%(I\u0084\u001a\u00db\u00a0\u00c3\u0098\u008d\u00cb\u0083-\u00a2\u00fd\u009f\u00d1\u00c0\u008a\u00d0\u0000\bjS\u00a9d\u00b9\u0014\u0170n\u00c7\u0085K\u00fcvv\u00dd\u01fb$\u009c\u00a9K\u00c47\u009f\u00fau\u0186\u0015]\u00aa\u00efF\u008a\u00a0\u00046\u0086\u0007\u0084.RF\u0090V\u00af\u00b8S\u0098\u00a1\u0015;K\u00a9\u00b5\u00d1\u00d3\u00f1\u00bdO\u0016{*\u009dWaEp:\u00a5\u00a3\u00ab\u0018\u00d7\u001eKZ\u00fb\u00f2<\u00ba\u0002\u00b6\u00a7\u0017\u00c9\u00d5\u0096\u00f0\u0018\u00cb\u008d\roH!\u001c\f\u00a4MZo\u00af\u00dc>\u00b4\u008d\u00ec/\u008c\u001a\u00e9\u00f8\u00eb\u0087\u00978\u0089\u00f6\u00a9\u00db=\u00d0\u00e3Q\u00d5\u0084\u008bvj\u00d8\u00ae\u00ad\u00daxJ|!\u009b\u00cd\r\u00f2\u009a\u00c8r\u0088\u00d2\u017f\u00ca\u0011\u00da\u0011\u018b\u00ea<\u0111\u00e0\u00fc]\u00ffm<j\u011bG\u00d4\u00c1\u00d0\u00e3\u0095\u00ca\u0003\u001c\u008f\u00f339\u00f1Yu\u001025\u009e\u00ea\u0090\u0000 \u00e4\u00a9\u0080\u00f3\u0011\u00d5\u001f\u0083\u00bd\u000b\u00fe\u00ab\u0118\u00fb(\u00a9\u00b8\u01ca\u00d1\u00b08\u001a\u00f2\u00cf\u009cL\u00e6\u00f3U\u00a6\"\u00f2I\u0003^\u008f\u00f6\u0096\u001b\u001eE\u00e5~$%L\u00dfxc\nd\u00ea\u00c8\u0016\u00a8c2w\u00ea\u0093\u00c4\u008a\u00d8A\u00a6c\u00cd \u00b0]-CS\u0016!\u00f9\u00b8\b\u00cfM\u00a8\u01e59g\u0092`\u00c3\u00a7\u008e\u001e\u00f3\u00fe6\u00da\u008bD\u00ffq4\u009d\u00f6\u0082$\u0000\u000b\u00d4\u0001/\u00e9{\u0090p\u00aa\u0083\u0015\u0187)B\u00a56\u00ff\u00fdc\u0088\u00b4]\u00d5\u00f6\u008b:\u00b4N\u0005f\u0097\u00c3\u001e0\u00c3\u00f7\u00d5\u0085\u00f0\u00e3\u00b9H\u0083\u00fc\u0081\u00bc\u00d0\u0190\u00970\u0105y\u01a4\u00ed\u0018\u00d6Okp\u00ff\u00b7\u00bc\u0012\u0012\u00a3\u00a5\u00b5\u0089\u0081\u009ez\u0019\u009a\u00ad'k\r\u00a1\u00b4\f\u0097v$Vn\u0002\u00a4\u00a9\u010c1\u00c2\u0196*\u00ceS\u00a7!\u00cf\u00b8\u00ce\u00cf\u0095\u00ba\u00eff\u0019\t*\u00b2\u00eaaU\u00c2\u0011\u0018\u0000\u00a7\u0092\u009d\u009f3\u0083\u0017\u00ab\u00ac\u00961\u00e1\u01f6\u00f4\u0093\u01d2\u001f\u01d9\u00f2.\u001dP\u00ddA\u0080\u00b4'N\u00a8\u008aH`\u00ed\u00c9\u00b4\u00aa9b%\u00a8Y\u0012\u00a4.lKh\u00bf(>\u001d\u00d8\u00d8\u00d6\u0084\u00b01\u008c:i\u00c0\u0013N\u0014\u00ed\u00da)\u00f1X@@3\u0094QJf\n\u0091p\u00d6\u00cb\u00d3\u00ea\u00d5j\u00b5\u00a1\u00fe4.+\u00be/\u0084B\u00a4\u00fcan\u000f-\u01e6(\u00fe\u01f2\u00a0\u015a\u00d6\u001b\u00d3\u00fe\u0004\u0094\u00bb\u001e@\rSs\u0090\u00e4\u00ab\u00c5\u0091\u016d\u0098\u0000\u00be\u01d9n\u00ec\u00a5: \u0119s\u001c\u00f4\u00bd^8\u00b0h\u00c8\u00b0\u00d2\u00d8\u015b\u0018S\u00fa\u00f2\u0129\u000fi\u0092\u00fc\u008an\u0003\u00c6\u00fd\u0186\u0185\u009f\u0014\u00a3\u00af\u00a2m\u00bee\u00bdH\u0122\u00ae\u00b2\u018b\u00a3\u0121\u0014\u00b3H\u01b1\u008b\u0003)\t\u00c8_R\u00d0\u00d6-\u0002\u00e9\u0003`Q\u00e8\u00ef\u0014n-\u00fa\u00ad\u00b1\u000ev\u00e3j\u00ee$\u0010\u0004r\u00f1\u0095pQ\u00aa\u0019\u0185\u00eb\u00fd\u0131\u00cd\u01a5\nt\u00fe\u009f\u00805\u00c8?\u00b4\u00e6\u00a04\u0014\u001f\u00fc\u00a8\u00a4\u0089\u00a3\u00e98~Z\u00e7\u00a2\u0019\u00e3\u00d6\u009aqn\u0017\u0093\u0099;\u00f9\u01a0\u00b1?\u00e0Z\u01e3\u008d\u0095\u00b3\u00be\u0083[\u00b2\u00de#\u00a1\u00ed\u00ec5\u00bb\u00ab*\u0087\u00ab\u00f5$\u0098\u001d\b\u00be\u000f$\u00a1\u009f\u00d4\u0091d<)\u00c6[\u0093P\u00ff=\u0011\u00fa\u00db\u007f\u00a8\u008c^\u009dd\u00b5M}\u007f\u0092\u0099\u0014!\u00f9glX\u00bf\u00cc\u0018x`\u00e7\u00c6q\u0093\u00dd\u00dcp\u00b59j~\u0093c}\u0000\u00fc\u00daS\n\u00e1\"\u00d6\u008b\t\u0085[F\u001b\u00a1\u00bf\t\u00e2p\u00c7\u00fb/\u00d0\u0006\u00dc3\u00ab@#-V\u00d0\u00b5\u0093\u00af\u00f7^X\u009cC#6o\u00af-x\u00d26\u0001\u00a6\u00e1y2F\u008c[yh\u001e\u00b1\u00cd7\u00e3\u00c1\u00f5\u00e6\u00c4\u00b5\u00fb\u00efdXh\u0084v\u00ff\u0010B\u00c9\u0086\u0138\u00d3?\u0083\u007f\u0106\u00be\u008c\u00a4@L\u00f9\u00db4\u00e7\u01d8\u000e\u00adlc\u0015\u0086j\u00ba\u00a9\u01c2\u0092\u00ae\u010c \u01d1\u0016\u00e2\u001c\u008a\u001b\u00bb\u00ab\f\u0084\u0019\u0095+\u0019!h\u008c\u00bf\u0099\u00b7&\u00e2\u009au<4\u00c4\u00f8\u00d3$\u00f7\u00b3\u0010+\u00fbE\u00ac\u00cb\u00deut\u00a8O\u00de?\u00e6\u0091\u009a (GV\\\u00f8L\u00f0h}\u00e5e1\u00e7\u00d5Rqd\u0019Pz\u00d4\u00e3\u0095\u0010\u00e1\u00d8\u00f0J\u0095*X\u008a\u00d8\u00a5aB'\u00ac=\u00eb\u00ecF\u0001\u00ff\u00f8\u00b3\\+\u00ba\u0081\u00929\u00c1\u0088A\u001e\u000e\u0090(\u00d2\u001dE\u00d8e\u0084\u00c61B:\u00b0\u00c0(Ns\u00ed6'n\n\u00b3\nM\u00dd\u009ec\u009f/\u00ae\u00d41_/xJvF\u00e8\u009b\u00f4\u00b3\u0086i\u00ab\u00e0\u00eav\u00fcT\u0083r\u00f7p\u00a8x1W\u001c\u00fa\u00a2\u009f\u00db\u0088\u0014\u00cf?2)\u0147&\u00d0=\u0082\u01d1\u0001vS\u001f\u00b2\u0012\u0004I\u001d\u0177\u0199\u00a1\u001e\u008aa\u0096\u00ea!m\u0002\u00ae \u001e\u0094e\u0016X\u00cf\u008b\u009b4\u0010L\u00c9}A\t\u00d9&\u00b8\u0086\u00fd\t\u0011\u008c\u00e5\u00ae \u0090\u00e8\u00c6\u00db\u00c9\u008b\u0010J\u00ef}\u00d8a-\u001f\u01e9\u00ba\u00f4\u001f-\u00af\u00b2\u0086W\u0017\u001cZ\u0086m\\\u00da/2\u00af\nH\u00a5\u00fc\u0013ubC\u00cd\u0177\u00f2\u00a4\u0019;\u00ab\u0019>\u0018Q\"\u00bb\u00d8\u0119\u008b\u00dd\u00ff\u0085\u00a9\u01ea\u0011\u00ac\u0088\u009e7\u00c8\u0080\u00beD#\u00bf.\u0089\u008e\n^a{\u0080\t\u00b1\u00ee\u00f9\\_\u00d6%\u019b\u00aa\u0010\u015f\u00e6t`\u007f\u0017\u000f\u0003l)'\u00b4I\u001a\u01cd\u001e)wG?\fm[P2\u0093\u00e2\u00ea3Y\u00edm\u00fa\u00d5\u008a\u01a1\u0088T}\u00af\u00cfm\u00d0\u00f7\u001f\u0166\f,\u0087K6\u008d\u00f7z\u00d1\u0005@>\u0019*\u00a0Rj\u0001v\u00ac\u00f9[d\u00b9v\u00b86\u00e7\n\u00d8\u008bR\u00fb'dZ \u01bc\u00bb\u0193\u0003x\u0098\u0083q\u008bI\u00c5s\u00c3\u00a8\u00bb\u00d2\u01ebP\u00ca\u001e+\u001e\u001b\u0088X\u009d<}\u00dc}a \u00d4\u00f4V\u00ba\u0000\u001e\u008a\u00aeJk\u00e5\u019a\u0003\u0007\u000b\u00bad\u01cf\u0003\t\u00c3Q\u000eDx^\u0097!:M\u00ae\u0131\u00d1`\u00d8\u0085\t\u0014\u012d1ln>\u0081\u00d8\u00d9\b\u010e\u009e\"\u00fe\u009c.\u00cd\u00c2\u00a5\u00de\u016d\u001f\u01ba\u009b\u009e;`+\u001b\u0016b\u0005\u00ba\u0018R%\u00c6\u00d3|\u0013\u00c5.\u0005!U\u0083@p\u00e5\u008f\u01a3\u00ba>\u001eMu8?0k;\u013bse\u000e4\u00eb\u018c\r\tsy\u00a5A\u0087\u00988B\u0015\"\u00f0\u018c\u0010\u00b4\n3\u00few\u0080(\u00c8\u009c\u00b4\u0092\u00a0',T\u00fb\u00c1D\u00b4\u00bfX\u00ac\u00d9o\u00b1Ton\u0138g\u00aaA\u018c\u0091\u0116E5\u00c1\u00ect j\u00f1\u00ea\u00d4]w*\u01f1\u000et1*F\u00d3\u00b61\u00ed\u00ba\u008a\u008f\u001d\u00b2\u00feg;)n\u00b6b\u00e1D\u00d23\u001aD\u00e7\u001a\u0095\u008e2\u00a17\u00ef\u00a8\u001e\u00b1\u00f0\u01e6\u00d6\u0091\u0196_\u0151\u00fa3\u00e09blw\u0011\u00d9\u00faw\u000e\u01a2\u00ed\u008f\b}\u0090\u0004\u00e4j\u00bep\u009f\u000b\u00be~Y6\u00e0ul\u009fw\u00a3a\u00a0J\u00b1I\u00a0`V\u00b2\u00c7\u00f2\u00d3\u00eayt\u00f5\u008b\u00fa\u0013-\u000b\u00ed\u00fd\u0010\u00f3\u00b4\u009e\u000b\u00f0\u0099Q\u009b\f\u00ae\u00ebf\u00c4\u000f\u0019\f\u0085W(\u0000\u00cd{H\u00f7\f\u00f6*\u009a\u000e\u00fchn+\u0001\u00a9\u00ea\u00a2\u0010\u00fej/d\u00fb\u00f24e\u001a\u009b\u009b?0\u00ba=\u00b3\u00bd{:A\"\u0087\u00cc\f\\\u0017EZ\u00ae\u00ba\u008b\u00f6\u0006\u00f5\u00ec\u00b3sh989g{\u0088\u0012\u00f5\u00b7\u0019P\u017d\u0018F\u00dc~\u00b9\u00fa\u0010\f\u00d8A\u00052//:\u00b5\u00dc\r\u00a7n\u001c\u0007\u0018\u00ac5\u001f\u0099\u0012\u00a2\u00d3/\u00f3\u000b\u00fb\u00b0\u00d9\t.\u00c5\u00dc\u00a4*\u0083X\u0093\u008b\"\u00ff\u00f16\u00a0k\u000b\u00d5\u00ec\u00fa2\u0011WN\u00d5U\u00ffF+\u000et1\u00a7\u001d\u0019\u0097\u0006<\u00f60f\u00ea]\u00cc\u009c\u0015\u00a4\u01f4\u00dc\u009b\u000bM\u00c8\u0092\u001e\u0090:~\u0001\u0005\u0017J\u00bb\u0097\u00db\u00fd\u001f\u00ecd]\u00c4\u00b6\u00cf\u0017H\bbz\u0082=O^d\u00e1+\u00a8\u013bb#\u00a5T\u00ca\u00c1b\u00b7lF!\u00ae\u0085\u001a\u007f\u00c2\u008f\u0005?\u01e1\u00e9_\u0137\u000fy]\u00de\u00b0;\u00f7\u00ea\u00b7\u00f7gS`\u018e\"\u00a14VW.`\u001f\u00f1\u00ba\u00a7\u00f3l\u0011\u0089\u00a9w~\u009b\u008c\u00bc0\u00d5zpq\u0082\u00ca\u00c3TM\u00a9\u00d1?\u0001(\u0014\u007f\u00fc\u00a4\u00a4\b\u00a3\u00d98xZ>\u00af\u0002\u00fc\u00d30M\tEi\u00a8\u00dc\u00b8\u00e0]O\f\u00dd5NW\u00ea\n\u015a\u00cci\u016eM\u01c9\u0017\u00c9t\u0015_\u00c13\u00f3\u0092\u0006\u00f49\u0099\u00f9mD\u00f4Ht\u00d8zWG\u00be\u001b\u00b4\u0003@\u00f8\u00e2\u00d7'\u000b|d\u0087'\u00b4\u00af#[\u00df\u009dQ\u00b1\u0001X\u00cc\u00136\u0013-\u0018\u00b2j\u00e0o)\u00cav\u0083\u000en\u00dbB\u0012\u0097\u0012i\u00f9\u0011\u00f0\u00ca\u00d4\u00c2\u00d6n/\u00aa\u0002+\u000b^\u00fd\u00fcg\u00d3\u00af'\u00ce\u0000\u00c3\r\u00f5\u008f\u00db^\u00f37\u00bbp\u00b9\u00b61'xEx\u0083#}\u008a\u00b1\u0006\u0003\u00de\u0000\u0087d\u008dhD\u00aa.\u010b.\u00b3+\b.:Yp\u00f3B=\u0015\u0096F\u0017\u00c1q\u0097\u0019\u00f0\u00c7\u00e3\u00ff\u00f3\u0093\u0086\u00fc5I\u0083\u00e0h\u0003v\u00adQ\u00df\u008bam\u00d4*\u00a4\u0013\u00e2F\u0004\u0010\u008a\t}\u00fc\u00ca\u00cbP\u00e5\u00e2v#U\u00b3\u00cc&\u00bb'\u001c\u00b9\u00fd|\u0084\u0013\u00a7\u00ba\u00b8\u0006\u015b\u00ec\u00b0(\u009a\u0094\u00f8d\u00f5\u0085\u0094\u00acd\u008a\u0006\u00b9\u0017k\u00e1H\u00e6{PE\u00c6\u00c7\u0010\u00d7\u014e".length();
                var1_4 = 44;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\\\u0086kY=\u009e0\u00b4\u00cd\u00a7\u00d9\u00aa\u0010\u001b*|\u00ba\u00e8\u0011\u00cb\u001f\u000f\u00a5\u00e6\u00c1*\u00b9\u00b6#\u00d5\u00d3\u00c41\u00a3\u00b4C\u0084$l\u0090\u00a8\u0091&\u00ce\f=\u0095\u00c0?Y\u0087\u00e6:g\u00c3\"\u00e9-un>kB\u0093";
                    var4_3 = "\\\u0086kY=\u009e0\u00b4\u00cd\u00a7\u00d9\u00aa\u0010\u001b*|\u00ba\u00e8\u0011\u00cb\u001f\u000f\u00a5\u00e6\u00c1*\u00b9\u00b6#\u00d5\u00d3\u00c41\u00a3\u00b4C\u0084$l\u0090\u00a8\u0091&\u00ce\f=\u0095\u00c0?Y\u0087\u00e6:g\u00c3\"\u00e9-un>kB\u0093".length();
                    var1_4 = 28;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 68;
                            break;
                        }
                        case 1: {
                            v13 = 35;
                            break;
                        }
                        case 2: {
                            v13 = 3;
                            break;
                        }
                        case 3: {
                            v13 = 84;
                            break;
                        }
                        case 4: {
                            v13 = 66;
                            break;
                        }
                        case 5: {
                            v13 = 47;
                            break;
                        }
                        default: {
                            v13 = 62;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        OCSPClient.r = var5;
        OCSPClient.s = new String[71];
        OCSPClient.e = OCSPClient.a(7634, 15988);
        OCSPClient.d = OCSPClient.a(7651, 13651);
        OCSPClient.c = OCSPClient.a(7628, -26031);
        OCSPClient.a = OCSPClient.a(7666, 19114);
        OCSPClient.b = OCSPClient.a(7661, 18717);
        OCSPClient.logger = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.NONCE_OID = new Asn1ObjectIdentifier(_ocspValues.id_pkix_ocsp_nonce);
        OCSPClient.g = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.digestAlgForOcspRequest = DigestAlg.SHA256;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x1DDA) & 0xFFFF;
        if (s[n3] == null) {
            int n4;
            int n5;
            char[] cArray = r[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 26;
                    break;
                }
                case 1: {
                    n5 = 247;
                    break;
                }
                case 2: {
                    n5 = 186;
                    break;
                }
                case 3: {
                    n5 = 96;
                    break;
                }
                case 4: {
                    n5 = 165;
                    break;
                }
                case 5: {
                    n5 = 36;
                    break;
                }
                case 6: {
                    n5 = 239;
                    break;
                }
                case 7: {
                    n5 = 212;
                    break;
                }
                case 8: {
                    n5 = 9;
                    break;
                }
                case 9: {
                    n5 = 137;
                    break;
                }
                case 10: {
                    n5 = 180;
                    break;
                }
                case 11: {
                    n5 = 174;
                    break;
                }
                case 12: {
                    n5 = 171;
                    break;
                }
                case 13: {
                    n5 = 8;
                    break;
                }
                case 14: {
                    n5 = 216;
                    break;
                }
                case 15: {
                    n5 = 32;
                    break;
                }
                case 16: {
                    n5 = 34;
                    break;
                }
                case 17: {
                    n5 = 18;
                    break;
                }
                case 18: {
                    n5 = 145;
                    break;
                }
                case 19: {
                    n5 = 13;
                    break;
                }
                case 20: {
                    n5 = 30;
                    break;
                }
                case 21: {
                    n5 = 2;
                    break;
                }
                case 22: {
                    n5 = 128;
                    break;
                }
                case 23: {
                    n5 = 0;
                    break;
                }
                case 24: {
                    n5 = 10;
                    break;
                }
                case 25: {
                    n5 = 126;
                    break;
                }
                case 26: {
                    n5 = 131;
                    break;
                }
                case 27: {
                    n5 = 11;
                    break;
                }
                case 28: {
                    n5 = 102;
                    break;
                }
                case 29: {
                    n5 = 105;
                    break;
                }
                case 30: {
                    n5 = 225;
                    break;
                }
                case 31: {
                    n5 = 3;
                    break;
                }
                case 32: {
                    n5 = 67;
                    break;
                }
                case 33: {
                    n5 = 17;
                    break;
                }
                case 34: {
                    n5 = 89;
                    break;
                }
                case 35: {
                    n5 = 154;
                    break;
                }
                case 36: {
                    n5 = 226;
                    break;
                }
                case 37: {
                    n5 = 108;
                    break;
                }
                case 38: {
                    n5 = 229;
                    break;
                }
                case 39: {
                    n5 = 231;
                    break;
                }
                case 40: {
                    n5 = 63;
                    break;
                }
                case 41: {
                    n5 = 160;
                    break;
                }
                case 42: {
                    n5 = 221;
                    break;
                }
                case 43: {
                    n5 = 190;
                    break;
                }
                case 44: {
                    n5 = 45;
                    break;
                }
                case 45: {
                    n5 = 46;
                    break;
                }
                case 46: {
                    n5 = 7;
                    break;
                }
                case 47: {
                    n5 = 113;
                    break;
                }
                case 48: {
                    n5 = 236;
                    break;
                }
                case 49: {
                    n5 = 205;
                    break;
                }
                case 50: {
                    n5 = 175;
                    break;
                }
                case 51: {
                    n5 = 37;
                    break;
                }
                case 52: {
                    n5 = 33;
                    break;
                }
                case 53: {
                    n5 = 206;
                    break;
                }
                case 54: {
                    n5 = 118;
                    break;
                }
                case 55: {
                    n5 = 121;
                    break;
                }
                case 56: {
                    n5 = 219;
                    break;
                }
                case 57: {
                    n5 = 228;
                    break;
                }
                case 58: {
                    n5 = 19;
                    break;
                }
                case 59: {
                    n5 = 87;
                    break;
                }
                case 60: {
                    n5 = 148;
                    break;
                }
                case 61: {
                    n5 = 122;
                    break;
                }
                case 62: {
                    n5 = 15;
                    break;
                }
                case 63: {
                    n5 = 215;
                    break;
                }
                case 64: {
                    n5 = 110;
                    break;
                }
                case 65: {
                    n5 = 136;
                    break;
                }
                case 66: {
                    n5 = 189;
                    break;
                }
                case 67: {
                    n5 = 230;
                    break;
                }
                case 68: {
                    n5 = 203;
                    break;
                }
                case 69: {
                    n5 = 58;
                    break;
                }
                case 70: {
                    n5 = 211;
                    break;
                }
                case 71: {
                    n5 = 192;
                    break;
                }
                case 72: {
                    n5 = 73;
                    break;
                }
                case 73: {
                    n5 = 123;
                    break;
                }
                case 74: {
                    n5 = 24;
                    break;
                }
                case 75: {
                    n5 = 151;
                    break;
                }
                case 76: {
                    n5 = 88;
                    break;
                }
                case 77: {
                    n5 = 25;
                    break;
                }
                case 78: {
                    n5 = 80;
                    break;
                }
                case 79: {
                    n5 = 93;
                    break;
                }
                case 80: {
                    n5 = 233;
                    break;
                }
                case 81: {
                    n5 = 98;
                    break;
                }
                case 82: {
                    n5 = 23;
                    break;
                }
                case 83: {
                    n5 = 142;
                    break;
                }
                case 84: {
                    n5 = 114;
                    break;
                }
                case 85: {
                    n5 = 241;
                    break;
                }
                case 86: {
                    n5 = 62;
                    break;
                }
                case 87: {
                    n5 = 223;
                    break;
                }
                case 88: {
                    n5 = 85;
                    break;
                }
                case 89: {
                    n5 = 193;
                    break;
                }
                case 90: {
                    n5 = 99;
                    break;
                }
                case 91: {
                    n5 = 78;
                    break;
                }
                case 92: {
                    n5 = 49;
                    break;
                }
                case 93: {
                    n5 = 234;
                    break;
                }
                case 94: {
                    n5 = 177;
                    break;
                }
                case 95: {
                    n5 = 207;
                    break;
                }
                case 96: {
                    n5 = 69;
                    break;
                }
                case 97: {
                    n5 = 97;
                    break;
                }
                case 98: {
                    n5 = 116;
                    break;
                }
                case 99: {
                    n5 = 51;
                    break;
                }
                case 100: {
                    n5 = 248;
                    break;
                }
                case 101: {
                    n5 = 191;
                    break;
                }
                case 102: {
                    n5 = 199;
                    break;
                }
                case 103: {
                    n5 = 1;
                    break;
                }
                case 104: {
                    n5 = 127;
                    break;
                }
                case 105: {
                    n5 = 83;
                    break;
                }
                case 106: {
                    n5 = 53;
                    break;
                }
                case 107: {
                    n5 = 115;
                    break;
                }
                case 108: {
                    n5 = 246;
                    break;
                }
                case 109: {
                    n5 = 72;
                    break;
                }
                case 110: {
                    n5 = 201;
                    break;
                }
                case 111: {
                    n5 = 20;
                    break;
                }
                case 112: {
                    n5 = 153;
                    break;
                }
                case 113: {
                    n5 = 198;
                    break;
                }
                case 114: {
                    n5 = 161;
                    break;
                }
                case 115: {
                    n5 = 107;
                    break;
                }
                case 116: {
                    n5 = 125;
                    break;
                }
                case 117: {
                    n5 = 135;
                    break;
                }
                case 118: {
                    n5 = 42;
                    break;
                }
                case 119: {
                    n5 = 188;
                    break;
                }
                case 120: {
                    n5 = 146;
                    break;
                }
                case 121: {
                    n5 = 155;
                    break;
                }
                case 122: {
                    n5 = 245;
                    break;
                }
                case 123: {
                    n5 = 47;
                    break;
                }
                case 124: {
                    n5 = 172;
                    break;
                }
                case 125: {
                    n5 = 244;
                    break;
                }
                case 126: {
                    n5 = 75;
                    break;
                }
                case 127: {
                    n5 = 208;
                    break;
                }
                case 128: {
                    n5 = 169;
                    break;
                }
                case 129: {
                    n5 = 71;
                    break;
                }
                case 130: {
                    n5 = 187;
                    break;
                }
                case 131: {
                    n5 = 220;
                    break;
                }
                case 132: {
                    n5 = 254;
                    break;
                }
                case 133: {
                    n5 = 209;
                    break;
                }
                case 134: {
                    n5 = 111;
                    break;
                }
                case 135: {
                    n5 = 176;
                    break;
                }
                case 136: {
                    n5 = 124;
                    break;
                }
                case 137: {
                    n5 = 143;
                    break;
                }
                case 138: {
                    n5 = 255;
                    break;
                }
                case 139: {
                    n5 = 213;
                    break;
                }
                case 140: {
                    n5 = 39;
                    break;
                }
                case 141: {
                    n5 = 133;
                    break;
                }
                case 142: {
                    n5 = 173;
                    break;
                }
                case 143: {
                    n5 = 59;
                    break;
                }
                case 144: {
                    n5 = 144;
                    break;
                }
                case 145: {
                    n5 = 86;
                    break;
                }
                case 146: {
                    n5 = 181;
                    break;
                }
                case 147: {
                    n5 = 41;
                    break;
                }
                case 148: {
                    n5 = 79;
                    break;
                }
                case 149: {
                    n5 = 64;
                    break;
                }
                case 150: {
                    n5 = 170;
                    break;
                }
                case 151: {
                    n5 = 159;
                    break;
                }
                case 152: {
                    n5 = 224;
                    break;
                }
                case 153: {
                    n5 = 14;
                    break;
                }
                case 154: {
                    n5 = 103;
                    break;
                }
                case 155: {
                    n5 = 196;
                    break;
                }
                case 156: {
                    n5 = 101;
                    break;
                }
                case 157: {
                    n5 = 237;
                    break;
                }
                case 158: {
                    n5 = 106;
                    break;
                }
                case 159: {
                    n5 = 150;
                    break;
                }
                case 160: {
                    n5 = 252;
                    break;
                }
                case 161: {
                    n5 = 50;
                    break;
                }
                case 162: {
                    n5 = 200;
                    break;
                }
                case 163: {
                    n5 = 29;
                    break;
                }
                case 164: {
                    n5 = 43;
                    break;
                }
                case 165: {
                    n5 = 235;
                    break;
                }
                case 166: {
                    n5 = 40;
                    break;
                }
                case 167: {
                    n5 = 167;
                    break;
                }
                case 168: {
                    n5 = 60;
                    break;
                }
                case 169: {
                    n5 = 55;
                    break;
                }
                case 170: {
                    n5 = 158;
                    break;
                }
                case 171: {
                    n5 = 184;
                    break;
                }
                case 172: {
                    n5 = 44;
                    break;
                }
                case 173: {
                    n5 = 52;
                    break;
                }
                case 174: {
                    n5 = 22;
                    break;
                }
                case 175: {
                    n5 = 141;
                    break;
                }
                case 176: {
                    n5 = 249;
                    break;
                }
                case 177: {
                    n5 = 195;
                    break;
                }
                case 178: {
                    n5 = 95;
                    break;
                }
                case 179: {
                    n5 = 5;
                    break;
                }
                case 180: {
                    n5 = 21;
                    break;
                }
                case 181: {
                    n5 = 35;
                    break;
                }
                case 182: {
                    n5 = 134;
                    break;
                }
                case 183: {
                    n5 = 182;
                    break;
                }
                case 184: {
                    n5 = 147;
                    break;
                }
                case 185: {
                    n5 = 84;
                    break;
                }
                case 186: {
                    n5 = 157;
                    break;
                }
                case 187: {
                    n5 = 54;
                    break;
                }
                case 188: {
                    n5 = 119;
                    break;
                }
                case 189: {
                    n5 = 61;
                    break;
                }
                case 190: {
                    n5 = 100;
                    break;
                }
                case 191: {
                    n5 = 76;
                    break;
                }
                case 192: {
                    n5 = 238;
                    break;
                }
                case 193: {
                    n5 = 65;
                    break;
                }
                case 194: {
                    n5 = 70;
                    break;
                }
                case 195: {
                    n5 = 243;
                    break;
                }
                case 196: {
                    n5 = 202;
                    break;
                }
                case 197: {
                    n5 = 168;
                    break;
                }
                case 198: {
                    n5 = 6;
                    break;
                }
                case 199: {
                    n5 = 232;
                    break;
                }
                case 200: {
                    n5 = 242;
                    break;
                }
                case 201: {
                    n5 = 179;
                    break;
                }
                case 202: {
                    n5 = 185;
                    break;
                }
                case 203: {
                    n5 = 210;
                    break;
                }
                case 204: {
                    n5 = 38;
                    break;
                }
                case 205: {
                    n5 = 183;
                    break;
                }
                case 206: {
                    n5 = 139;
                    break;
                }
                case 207: {
                    n5 = 227;
                    break;
                }
                case 208: {
                    n5 = 12;
                    break;
                }
                case 209: {
                    n5 = 48;
                    break;
                }
                case 210: {
                    n5 = 251;
                    break;
                }
                case 211: {
                    n5 = 253;
                    break;
                }
                case 212: {
                    n5 = 56;
                    break;
                }
                case 213: {
                    n5 = 120;
                    break;
                }
                case 214: {
                    n5 = 132;
                    break;
                }
                case 215: {
                    n5 = 138;
                    break;
                }
                case 216: {
                    n5 = 27;
                    break;
                }
                case 217: {
                    n5 = 28;
                    break;
                }
                case 218: {
                    n5 = 197;
                    break;
                }
                case 219: {
                    n5 = 162;
                    break;
                }
                case 220: {
                    n5 = 77;
                    break;
                }
                case 221: {
                    n5 = 81;
                    break;
                }
                case 222: {
                    n5 = 104;
                    break;
                }
                case 223: {
                    n5 = 240;
                    break;
                }
                case 224: {
                    n5 = 163;
                    break;
                }
                case 225: {
                    n5 = 178;
                    break;
                }
                case 226: {
                    n5 = 92;
                    break;
                }
                case 227: {
                    n5 = 214;
                    break;
                }
                case 228: {
                    n5 = 31;
                    break;
                }
                case 229: {
                    n5 = 129;
                    break;
                }
                case 230: {
                    n5 = 152;
                    break;
                }
                case 231: {
                    n5 = 90;
                    break;
                }
                case 232: {
                    n5 = 66;
                    break;
                }
                case 233: {
                    n5 = 74;
                    break;
                }
                case 234: {
                    n5 = 109;
                    break;
                }
                case 235: {
                    n5 = 57;
                    break;
                }
                case 236: {
                    n5 = 4;
                    break;
                }
                case 237: {
                    n5 = 217;
                    break;
                }
                case 238: {
                    n5 = 130;
                    break;
                }
                case 239: {
                    n5 = 149;
                    break;
                }
                case 240: {
                    n5 = 218;
                    break;
                }
                case 241: {
                    n5 = 140;
                    break;
                }
                case 242: {
                    n5 = 156;
                    break;
                }
                case 243: {
                    n5 = 250;
                    break;
                }
                case 244: {
                    n5 = 91;
                    break;
                }
                case 245: {
                    n5 = 204;
                    break;
                }
                case 246: {
                    n5 = 194;
                    break;
                }
                case 247: {
                    n5 = 117;
                    break;
                }
                case 248: {
                    n5 = 94;
                    break;
                }
                case 249: {
                    n5 = 82;
                    break;
                }
                case 250: {
                    n5 = 222;
                    break;
                }
                case 251: {
                    n5 = 16;
                    break;
                }
                case 252: {
                    n5 = 112;
                    break;
                }
                case 253: {
                    n5 = 166;
                    break;
                }
                case 254: {
                    n5 = 68;
                    break;
                }
                default: {
                    n5 = 164;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            OCSPClient.s[n3] = new String(cArray).intern();
        }
        return s[n3];
    }
}

