/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Mac
extends MacSpi {
    private static final int S_UNINIT = 1;
    private static final int S_RESET = 2;
    private static final int S_UPDATE = 3;
    private static final int S_DOFINAL = 4;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private final int macLength;
    private P11Key p11Key;
    private Session session;
    private int state;
    private byte[] oneByte;

    P11Mac(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        switch ((int)l) {
            case 529: {
                this.macLength = 16;
                break;
            }
            case 545: {
                this.macLength = 20;
                break;
            }
            case 593: {
                this.macLength = 32;
                break;
            }
            case 609: {
                this.macLength = 48;
                break;
            }
            case 625: {
                this.macLength = 64;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l);
            }
        }
        this.state = 1;
        this.initialize();
    }

    private void ensureInitialized() throws PKCS11Exception {
        this.token.ensureValid();
        if (this.state == 1) {
            this.initialize();
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        try {
            this.token.p11.C_SignFinal(this.session.id());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Cancel failed", pKCS11Exception);
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.state == 2) {
            return;
        }
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        if (this.p11Key != null) {
            this.token.p11.C_SignInit(this.session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
            this.state = 2;
        } else {
            this.state = 1;
        }
    }

    protected int engineGetMacLength() {
        return this.macLength;
    }

    protected void engineReset() {
        if (this.state == 4) {
            this.state = 1;
            return;
        }
        this.cancelOperation();
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("reset() failed, ", pKCS11Exception);
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.cancelOperation();
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.algorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("init() failed", pKCS11Exception);
        }
    }

    protected byte[] engineDoFinal() {
        try {
            this.ensureInitialized();
            byte[] byArray = this.token.p11.C_SignFinal(this.session.id());
            this.state = 4;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.session = this.token.releaseSession(this.session);
        }
    }

    protected void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        try {
            this.ensureInitialized();
            this.token.p11.C_SignUpdate(this.session.id(), 0L, byArray, n, n2);
            this.state = 3;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInitialized();
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (!(byteBuffer instanceof DirectBuffer)) {
                super.engineUpdate(byteBuffer);
                return;
            }
            long l = ((DirectBuffer)((Object)byteBuffer)).address();
            int n2 = byteBuffer.position();
            this.token.p11.C_SignUpdate(this.session.id(), l + (long)n2, null, 0, n);
            byteBuffer.position(n2 + n);
            this.state = 3;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.session != null && this.token.isValid()) {
                this.cancelOperation();
                this.session = this.token.releaseSession(this.session);
            }
        }
        finally {
            super.finalize();
        }
    }
}

