/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.Sequence;
import com.turktrust.ocsp.Signature;
import com.turktrust.ocsp.TBSRequest;

public class OCSPRequest
extends Sequence {
    private TBSRequest tbsRequest = new TBSRequest();
    private Signature signature = new Signature();
    private boolean signatureExists = false;

    public OCSPRequest() {
        super("default_ocspRequest");
        this.setUpElements();
    }

    public OCSPRequest(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.tbsRequest);
        super.addElement(this.signature);
        this.signature.setOptional(true);
        this.signature.setTaggingMethod(2);
        this.signature.setTagClass((byte)-128);
        this.signature.setTagNumber(0);
    }

    public void setTBSRequest(TBSRequest value) {
        this.tbsRequest = value;
    }

    public TBSRequest getTBSRequest() {
        return this.tbsRequest;
    }

    public void setSignature(Signature value) {
        this.signature = value;
        this.signatureExists = true;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void commitElementUpdate() {
        super.clearElements();
        if (this.signatureExists) {
            this.setUpElements();
        } else {
            super.addElement(this.tbsRequest);
        }
    }
}

