/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ESYAPKCS11;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;

public class PKCS11Ops
implements IPKCS11Ops {
    private Logger a = LoggerFactory.getLogger(PKCS11Ops.class);
    private static List<String> b;
    protected PKCS11 mPKCS11;
    private CardType c;
    protected MessageDigest OZET_ALICI;
    protected ESYAPKCS11 mESYAPKCS11 = null;
    public static int d;
    private static final String[] f;
    private static final String[] g;

    public PKCS11Ops(CardType aKartTip) {
        try {
            this.OZET_ALICI = MessageDigest.getInstance(PKCS11Ops.a(8588, -30218));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.error(PKCS11Ops.a(8681, -9643), (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.c = aKartTip;
    }

    @Override
    public void initialize() throws PKCS11Exception, IOException {
        try {
            CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = this.a();
            String string = this.a(this.c.getLibName());
            this.mPKCS11 = PKCS11.getInstance(string, PKCS11Ops.a(8679, -24388), cK_C_INITIALIZE_ARGS, false);
        }
        catch (Exception exception) {
            throw new IOException(PKCS11Ops.a(8602, -31483), exception);
        }
    }

    CK_C_INITIALIZE_ARGS a() {
        return null;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(true);
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        long[] lArray = this.getTokenPresentSlotList();
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        long[] lArray2 = lArray;
        int n = d;
        for (long l : lArray2) {
            String string = "";
            try {
                string = string + " " + new String(this.getSlotInfo((long)l).slotDescription).trim();
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(8677, -19364) + exception.getMessage(), (Throwable)exception);
            }
            try {
                string = string + " " + new String(this.getTokenInfo((long)l).label).trim().split("\u0000")[0];
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(8682, -754) + exception.getMessage(), (Throwable)exception);
            }
            arrayList.add((Pair<Long, String>)new Pair((Object)l, (Object)string));
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(false);
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO = this.mPKCS11.C_GetSlotInfo(aSlotID);
        long l = cK_SLOT_INFO.flags;
        if ((l & 1L) != 0L) {
            return true;
        }
        return false;
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_OpenSession(aSlotID, 6L, null, null);
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_CloseSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mPKCS11.C_Login(aSessionID, 1L, aCardPIN.toCharArray());
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_Logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aSertifika);
        this.mPKCS11.C_CreateObject(aSessionID, list.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAKeyGenParameterSpec rSAKeyGenParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM;
        block12: {
            block11: {
                cK_MECHANISM = new CK_MECHANISM(0L);
                cK_MECHANISM.mechanism = 10L;
                cK_MECHANISM.pParameter = null;
                if (this.c == CardType.AKIS || this.c == CardType.ATIKHSM) break block11;
                if (this.c == CardType.DIRAKHSM) break block11;
                if (this.c == CardType.OPENDNSSOFTHSM) break block11;
                if (this.c != CardType.PROCENNEHSM) break block12;
            }
            cK_MECHANISM.mechanism = 0L;
        }
        int n = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        }
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = iCardTemplate.getRSAPublicKeyCreateTemplate(string, n, bigInteger, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = iCardTemplate.getRSAPrivateKeyCreateTemplate(string, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        this.a(l, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        int n;
        block14: {
            n = d;
            if (aParamSpec instanceof RSAKeyGenParameterSpec) {
                this.a(aSessionID, aKeyLabel, (RSAKeyGenParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
                if (n == 0) return;
            }
            if (!(aParamSpec instanceof ECParameterSpec)) break block14;
            this.a(aSessionID, aKeyLabel, (ECParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
            if (n == 0) return;
        }
        if (!(aParamSpec instanceof ECGenParameterSpec)) throw new SmartCardException(PKCS11Ops.a(8593, 15470));
        ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)aParamSpec;
        ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(eCGenParameterSpec.getName());
        if (eCParameterSpec == null) {
            throw new SmartCardException(PKCS11Ops.a(8586, -10058));
        }
        this.a(aSessionID, aKeyLabel, eCParameterSpec, aIsSign, aIsEncrypt);
        if (n == 0) return;
        throw new SmartCardException(PKCS11Ops.a(8593, 15470));
    }

    private void a(long l, String string, ECParameterSpec eCParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        byte[] byArray = ECParameters.encodeParameters(eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, bl2), new CK_ATTRIBUTE(266L, bl), new CK_ATTRIBUTE(384L, byArray), new CK_ATTRIBUTE(3L, string)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(261L, bl2), new CK_ATTRIBUTE(264L, bl), new CK_ATTRIBUTE(3L, string)};
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray4);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray4[0].pValue;
        byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray5 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray2 = this.objeAra(l, cK_ATTRIBUTEArray5);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray6 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray4)};
        this.mPKCS11.C_SetAttributeValue(l, lArray2[0], cK_ATTRIBUTEArray6);
        this.mPKCS11.C_SetAttributeValue(l, lArray2[1], cK_ATTRIBUTEArray6);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyCreateTemplate(aKey);
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aKey.getGenerationMechanism();
        cK_MECHANISM.pParameter = null;
        this.mPKCS11.C_GenerateKey(aSessionID, cK_MECHANISM, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyImportTemplate(aKey);
        this.mPKCS11.C_CreateObject(aSessionId, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(aKeyTemplate);
        this.mPKCS11.C_CreateObject(aSessionId, aKeyTemplate.getAttributesAsArr());
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception {
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, aKeyID);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(8587, -1642));
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray2;
    }

    private byte[] a(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            cK_ATTRIBUTEArray = list.iterator();
            int n = d;
            while (cK_ATTRIBUTEArray.hasNext()) {
                object = cK_ATTRIBUTEArray.next();
                lArray = this.objeAra(l, object.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(8583, 8723));
        }
        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        object = (byte[])cK_ATTRIBUTEArray[0].pValue;
        return object;
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aData);
        byte[] byArray2 = this.b(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(8605, -30673));
        }
        byte[] byArray3 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.a(aSessionID, byArray, 0, byArray.length, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        return byArray4;
    }

    private int a(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block17: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(8597, -23483))) break block17;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(8581, 8764));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(8638, 3878));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SmartCardException(PKCS11Ops.a(8613, 24008), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(8637, -30516), illegalAccessException);
        }
    }

    private byte[] b(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            cK_ATTRIBUTEArray = list.iterator();
            int n = d;
            while (cK_ATTRIBUTEArray.hasNext()) {
                List<CK_ATTRIBUTE> list2 = cK_ATTRIBUTEArray.next();
                lArray = this.objeAra(l, list2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(8620, 7723));
        }
        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, true);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, false);
    }

    private List<byte[]> a(long l, boolean bl) throws PKCS11Exception, SmartCardException {
        List<byte[]> list = this.getCertificates(l);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = d;
        for (byte[] byArray : list) {
            block15: {
                block17: {
                    Object object;
                    block16: {
                        X509Certificate x509Certificate = null;
                        try {
                            object = new ByteArrayInputStream(byArray);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(PKCS11Ops.a(8625, -7189));
                            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            throw new SmartCardException(PKCS11Ops.a(8622, 22064) + StringUtil.toHexString((byte[])byArray), exception);
                        }
                        object = x509Certificate.getKeyUsage();
                        if (object == null) break block15;
                        if (!bl) break block16;
                        if (object[0] == false) break block15;
                        arrayList.add(byArray);
                        if (n == 0) break block15;
                    }
                    if (object[3] != false) break block17;
                    if (object[2] == false) break block15;
                }
                arrayList.add(byArray);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = d;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        for (long l : lArray) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n == 0) continue;
        }
        return arrayList;
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(264L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(262L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(263L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    public String[] getLabels(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long[] lArray = this.objeAra(aSessionID, aTemplate);
        ArrayList<String> arrayList = new ArrayList<String>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        long[] lArray2 = lArray;
        int n = d;
        for (long l : lArray2) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray);
            String string = new String((char[])cK_ATTRIBUTEArray[0].pValue);
            arrayList.add(string);
            if (n == 0) continue;
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private boolean a(long l, String string, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, l2)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private void a(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, byArray), new CK_ATTRIBUTE(2L, bl)};
        this.mPKCS11.C_CreateObject(l, cK_ATTRIBUTEArray);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, true);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, false);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, long aDataType) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, aIsPrivate, true, aDataType);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIstoken, long aDataType) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, aDataType), new CK_ATTRIBUTE(1L, aIstoken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = lArray.length;
        int n2 = d;
        if (n == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(8631, -23388));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < n; ++i) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, true, 0L);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 0L);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 3L);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 2L);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 1L);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 1L);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(130L, aCertSerialNo)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(8635, -30497));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[0], cK_ATTRIBUTEArray2);
        return (byte[])cK_ATTRIBUTEArray2[0].pValue;
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(8624, 5490));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(8596, 5162));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(8685, -5214));
        }
        return lArray[0];
    }

    private KeySpec a(long l, long l2) throws SmartCardException, PKCS11Exception {
        Long l3;
        block7: {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
            this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
            l3 = (Long)cK_ATTRIBUTEArray[0].pValue;
            if (l3 == 0L) {
                return this.b(l, l2);
            }
            if (l3 != 3L && l3 != 3L) break block7;
            return this._readECPublicKeySpec(l, l2);
        }
        throw new SmartCardException(PKCS11Ops.a(8609, -13838), l3);
    }

    private RSAPublicKeySpec b(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(288L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new RSAPublicKeySpec(bigInteger2, bigInteger);
    }

    protected ECPublicKeySpec _readECPublicKeySpec(long aSessionID, long aKeyId) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L), new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, aKeyId, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        try {
            ECParameterSpec eCParameterSpec = ECParameters.decodeParameters(byArray);
            byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
            ECPoint eCPoint = ECParameters.decodePoint(byArray3, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            return eCPublicKeySpec;
        }
        catch (IOException iOException) {
            throw new SmartCardException(PKCS11Ops.a(8584, -1283), iOException);
        }
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, true);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, false);
    }

    private void b(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(8631, -23388));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, byArray)};
        this.mPKCS11.C_SetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray2);
    }

    protected void _deleteObject(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIsToken) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, aIsToken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = d;
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(8631, -23388));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
            if (n == 0) continue;
        }
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, true, true);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, false, true);
    }

    private void a(long l, String string, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        int n = d;
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(8631, -23388));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(l, lArray[i]);
            if (n == 0) continue;
        }
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, true);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, false);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        byte[] byArray = new byte[aDataLength];
        this.mPKCS11.C_GenerateRandom(aSessionID, byArray);
        return byArray;
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        char[] cArray = this.mPKCS11.C_GetTokenInfo((long)aSlotID).serialNumber;
        String string = new String(cArray);
        return string.trim().getBytes();
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8621, -24422));
            }
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8686, 19703));
            }
        }
        this.mPKCS11.C_SignRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = new byte[1024];
        int n = this.mPKCS11.C_SignRecover(aSessionID, aImzalanacak, 0, aImzalanacak.length, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8621, -24422));
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_VerifyRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n = this.mPKCS11.C_VerifyRecover(aSessionID, aSignature, 0, aSignature.length, byArray2, 0, byArray2.length);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8580, 11895));
            }
        }
        this.mPKCS11.C_VerifyInit(aSessionID, aMechanism, lArray[0]);
        this.mPKCS11.C_Verify(aSessionID, aData, aImza);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aImza, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            byte[] byArray;
            int n2;
            int n3;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
                n3 = d;
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8621, -24422));
                    }
                }
                n2 = 1024;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray = new byte[n2 + 128];
                this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, lArray[0]);
                n = 0;
                if (aData.length >= n2) break block9;
                n = this.b(aSessionID, aData, 0, aData.length, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                if (n3 == 0) break block10;
            }
            int n4 = aData.length;
            int n5 = 0;
            while (n4 > 0) {
                int n6;
                block12: {
                    block11: {
                        n6 = 0;
                        if (n4 <= n2) break block11;
                        n6 = n2;
                        if (n3 == 0) break block12;
                    }
                    n6 = n4;
                }
                n = this.mPKCS11.C_EncryptUpdate(aSessionID, 0L, aData, n5, n6, 0L, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                n4 -= n6;
                n5 += n6;
                if (n3 == 0) continue;
            }
            n = this.mPKCS11.C_EncryptFinal(aSessionID, 0L, byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int b(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException, PKCS11Exception {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block20: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(8578, 15838))) break block20;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(8616, -3133));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(8600, 25418));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PKCS11Exception) {
                throw (PKCS11Exception)invocationTargetException.getTargetException();
            }
            throw new SmartCardException(PKCS11Ops.a(8676, -1087), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(8595, 8671), illegalAccessException);
        }
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            int n3;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
                n3 = d;
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8621, -24422));
                    }
                }
                long l = lArray[0];
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray2 = new byte[1152];
                this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, l);
                byArray = this.a(aData);
                n2 = 1024;
                n = 0;
                if (byArray.length >= n2) break block9;
                n = this.a(aSessionID, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                if (n3 == 0) break block10;
            }
            int n4 = aData.length;
            int n5 = 0;
            while (n4 > 0) {
                int n6;
                block12: {
                    block11: {
                        n6 = 0;
                        if (n4 <= n2) break block11;
                        n6 = n2;
                        if (n3 == 0) break block12;
                    }
                    n6 = n4;
                }
                n = this.mPKCS11.C_DecryptUpdate(aSessionID, 0L, byArray, n5, n6, 0L, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                n4 -= n6;
                n5 += n6;
                if (n3 == 0) continue;
            }
            n = this.mPKCS11.C_DecryptFinal(aSessionID, 0L, byArray2, 0, byArray2.length);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] a(byte[] byArray) {
        int n;
        block3: {
            n = byArray.length % 8;
            if (n != 1 || byArray[0] != 0) break block3;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        if (n == 7) {
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        Object object;
        block14: {
            block15: {
                byte[] byArray;
                boolean bl;
                int n;
                boolean bl2;
                block13: {
                    boolean[] blArray;
                    bl2 = false;
                    n = d;
                    bl = false;
                    if (aCert != null && (blArray = aCert.getKeyUsage()) != null) {
                        bl2 = blArray[0];
                        bl = blArray[2] || blArray[3] || blArray[4];
                    }
                    byArray = aCert.getSubjectX500Principal().getEncoded();
                    if (!(aPrivKey instanceof RSAPrivateCrtKey)) break block13;
                    object = (RSAPrivateCrtKey)aPrivKey;
                    this.a(aSessionID, aKeyLabel, (RSAPrivateCrtKey)object, byArray, bl2, bl);
                    if (n == 0) break block14;
                }
                if (!(aPrivKey instanceof ECPrivateKey)) break block15;
                object = (ECPrivateKey)aPrivKey;
                ECPublicKey eCPublicKey = null;
                try {
                    eCPublicKey = (ECPublicKey)aCert.getPublicKey();
                }
                catch (ClassCastException classCastException) {
                    try {
                        PublicKey publicKey = aCert.getPublicKey();
                        Class<?> clazz = Class.forName(PKCS11Ops.a(8576, 26516));
                        Constructor<?> constructor = clazz.getConstructor(byte[].class);
                        eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{publicKey.getEncoded()});
                    }
                    catch (Exception exception) {
                        this.a.warn(PKCS11Ops.a(8629, 31384), (Throwable)exception);
                        throw classCastException;
                    }
                }
                this.a(aSessionID, aKeyLabel, (ECPrivateKey)object, eCPublicKey, byArray, bl2, bl);
                if (n == 0) break block14;
            }
            throw new SmartCardException(PKCS11Ops.a(8683, -10583));
        }
        object = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aCert);
        this.mPKCS11.C_CreateObject(aSessionID, object.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getRSAPrivateKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        List<CK_ATTRIBUTE> list2 = this.c.getCardTemplate().getRSAPublicKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        if (byArray != null) {
            list.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, list.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, list2.toArray(new CK_ATTRIBUTE[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l, String string, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        Object object;
        byte[] byArray2;
        int n;
        ECParameterSpec eCParameterSpec;
        block18: {
            block17: {
                eCParameterSpec = eCPrivateKey.getParams();
                n = d;
                if (this.c != CardType.AKIS) break block17;
                byArray2 = ECParameters.encodeECParameterSpec(eCParameterSpec);
                if (n == 0) break block18;
            }
            byArray2 = ECParameters.encodeParameters(eCParameterSpec);
        }
        ECPoint eCPoint = eCPublicKey.getW();
        byte[] byArray3 = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
        DerValue derValue = new DerValue(4, byArray3);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 3L));
        arrayList.add(new CK_ATTRIBUTE(384L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(3L, string));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            arrayList.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            arrayList.add(new CK_ATTRIBUTE(266L, bl));
        }
        boolean bl3 = false;
        ECParameterSpec eCParameterSpec2 = eCPublicKey.getParams();
        if (eCParameterSpec2 instanceof NamedCurve) {
            bl3 = true;
            object = NamedCurve.getNameCurves();
            ObjectIdentifier objectIdentifier = ((NamedCurve)eCParameterSpec2).getObjectIdentifier();
            for (NamedCurve namedCurve : object.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(objectIdentifier.toString())) {
                    bl3 = false;
                    if (n == 0) break;
                }
                if (n == 0) continue;
            }
        }
        arrayList.add(new CK_ATTRIBUTE(2L, bl3));
        object = new ArrayList();
        object.add(new CK_ATTRIBUTE(1L, true));
        object.add(new CK_ATTRIBUTE(2L, true));
        object.add(new CK_ATTRIBUTE(0L, 3L));
        object.add(new CK_ATTRIBUTE(256L, 3L));
        object.add(new CK_ATTRIBUTE(3L, string));
        object.add(new CK_ATTRIBUTE(17L, eCPrivateKey.getS()));
        object.add(new CK_ATTRIBUTE(384L, byArray2));
        object.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            object.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            object.add(new CK_ATTRIBUTE(264L, bl));
        }
        if (byArray != null) {
            object.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, arrayList.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, object.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        block13: {
            block14: {
                PublicKey publicKey;
                int n;
                PrivateKey privateKey;
                block12: {
                    privateKey = aKeyPair.getPrivate();
                    n = d;
                    publicKey = aKeyPair.getPublic();
                    if (!(privateKey instanceof RSAPrivateCrtKey) || !(publicKey instanceof RSAPublicKey)) break block12;
                    this.a(aSessionID, aLabel, (RSAPrivateCrtKey)privateKey, aSubject, aIsSign, aIsEncrypt);
                    if (n == 0) break block13;
                }
                if (!(privateKey instanceof ECPrivateKey)) break block14;
                if (!(publicKey instanceof ECPublicKey)) break block14;
                this.a(aSessionID, aLabel, (ECPrivateKey)privateKey, (ECPublicKey)publicKey, aSubject, aIsSign, aIsEncrypt);
                if (n == 0) break block13;
            }
            throw new SmartCardException(PKCS11Ops.a(8619, 30361));
        }
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changePassword(aOldPass, aNewPass, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.formatToken(aSOpin, aNewPIN, aLabel, slotID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.setSOPin(aSOPin, aSOPin.length, aNewSOPin, aNewSOPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changeUserPin(aSOPin, aSOPin.length, aUserPin, aUserPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionID) {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.setContainer(aContainerLabel, aContainerLabel.length, (int)aSessionID, string);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarCifti.length, aAnahtarLen, aScfname, aScfname.length(), aContextName, aContextName.length(), aPbCertData, aSignOrEnc);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        byte[] byArray = null;
        try {
            byArray = aPbCertificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.a.warn(PKCS11Ops.a(8601, -30622), (Throwable)certificateEncodingException);
            return false;
        }
        return this.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, byArray, aSignOrEnc);
    }

    protected void changePUK(byte[] aOldPUK, byte[] aNewPUK, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.ChangePUK(aOldPUK, aOldPUK.length, aNewPUK, aNewPUK.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    protected void unBlockPIN(byte[] aPUK, byte[] aUserPIN, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.UnBlockPIN(aPUK, aPUK.length, aUserPIN, aUserPIN.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long l = 200L;
        this.mPKCS11.C_FindObjectsInit(aSessionID, aTemplate);
        long[] lArray = this.mPKCS11.C_FindObjects(aSessionID, l);
        this.mPKCS11.C_FindObjectsFinal(aSessionID);
        return lArray;
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aOldLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = d;
        if (lArray.length == 0) {
            throw new SmartCardException(aOldLabel + PKCS11Ops.a(8594, -688));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aNewLabel)};
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_SetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            if (n == 0) continue;
        }
    }

    private String a(String string) {
        String string2 = System.getProperty(PKCS11Ops.a(8614, 13514));
        this.a.debug(PKCS11Ops.a(8639, 16199) + string2);
        this.a.debug(PKCS11Ops.a(8672, -21969) + string2);
        int n = d;
        if (new File(string).exists()) {
            this.a.info(string + PKCS11Ops.a(8615, 19200));
            return string;
        }
        String string3 = System.getProperty(PKCS11Ops.a(8598, 24786));
        String string4 = System.getProperty(PKCS11Ops.a(8607, -29261));
        String[] stringArray = string3.split(string4);
        for (String string5 : stringArray) {
            String string6 = string5 + System.getProperty(PKCS11Ops.a(8579, 27564)) + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(8634, -21927) + string6);
            if (!new File(string6).exists()) continue;
            this.a.info(PKCS11Ops.a(8633, 22384) + string6);
            return string6;
        }
        for (String string7 : b) {
            String string8 = string7 + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(8634, -21927) + string8);
            if (new File(string8).exists()) {
                this.a.info(PKCS11Ops.a(8617, -21428) + string8);
                return string8;
            }
            this.a.debug(PKCS11Ops.a(8684, -7099) + string8);
            if (n == 0) continue;
        }
        this.a.info(PKCS11Ops.a(8617, -21428) + System.mapLibraryName(string));
        return System.mapLibraryName(string);
    }

    protected byte[] toByteArray(BigInteger aX) {
        byte[] byArray = aX.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(8589, 6976));
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(8604, -29691));
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.getAttributeValue(aSessionID, aObjID, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private long b(long l, String string, long l2) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l2), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(l, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(string + PKCS11Ops.a(8621, -24422));
            }
        }
        return lArray[0];
    }

    @Override
    public long getObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.b(aSessionID, aLabel, 2L);
    }

    @Override
    public long getObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aLabel + PKCS11Ops.a(8621, -24422));
            }
        }
        return lArray[0];
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, wrapperKeyLabel), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(wrapperKeyLabel + PKCS11Ops.a(8636, -21565));
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(2L, true)};
        long[] lArray2 = this.objeAra(aSessionID, cK_ATTRIBUTEArray2);
        if (lArray2.length == 0) {
            throw new SmartCardException(aKeyLabel + PKCS11Ops.a(8591, -20685));
        }
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, lArray[0], lArray2[0]);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate aToBeExportedKeyTemplate) throws PKCS11Exception {
        this.a(aSessionID, wrapperKeyTemplate, aToBeExportedKeyTemplate);
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyTemplate.getKeyId(), aToBeExportedKeyTemplate.getKeyId());
    }

    private void a(long l, KeyTemplate ... keyTemplateArray) throws PKCS11Exception {
        KeyTemplate[] keyTemplateArray2 = keyTemplateArray;
        int n = keyTemplateArray2.length;
        int n2 = d;
        for (int i = 0; i < n; ++i) {
            KeyTemplate keyTemplate = keyTemplateArray2[i];
            if (keyTemplate.getKeyId() > 0L) continue;
            this.a(l, keyTemplate);
            continue;
        }
    }

    private void a(long l, KeyTemplate keyTemplate) throws PKCS11Exception {
        long[] lArray;
        block7: {
            lArray = this.objeAra(l, keyTemplate.getAttributesAsArr());
            if (lArray != null && lArray.length != 0) break block7;
            return;
        }
        if (lArray.length > 1) {
            this.a.warn(PKCS11Ops.a(8610, 9272) + keyTemplate);
        }
        keyTemplate.setKeyId(lArray[0]);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, String unwrapperKeyLabel, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, unwrapperKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(unwrapperKeyLabel + PKCS11Ops.a(8591, -20685));
            }
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate unwrapperKeyTemplate, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        this.a(aUnwrappedKeyTemplate);
        this.a(aSessionID, new KeyTemplate[]{unwrapperKeyTemplate});
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyTemplate.getKeyId(), byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = unwrapperKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    private void a(KeyTemplate keyTemplate) throws SmartCardException {
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        if (keyTemplate instanceof SecretKeyTemplate) {
            iCardTemplate.applyTemplate((SecretKeyTemplate)keyTemplate);
        }
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, byte[] certSerialNumber, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        byte[] byArray2 = this.b(aSessionID, certSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toString((byte[])certSerialNumber) + PKCS11Ops.a(8592, 21729));
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
    }

    public PKCS11 getmPKCS11() {
        return this.mPKCS11;
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, IOException, SmartCardException {
        if (this.a.isDebugEnabled()) {
            this.a(((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr());
            this.a(((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr());
        }
        if (template instanceof RSAKeyPairTemplate) {
            return this.createKeyPair(aSessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.a(aSessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(PKCS11Ops.a(8612, 1680) + template);
    }

    public KeySpec createKeyPair(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        long[] lArray = this.createKeyPairWithOutRead(aSessionID, template);
        RSAPublicKeySpec rSAPublicKeySpec = this.b(aSessionID, lArray[0]);
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        this.a(aSessionID, string);
        ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(lArray[0]);
        ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(lArray[1]);
        return rSAPublicKeySpec;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 0L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
        if (this.a.isDebugEnabled()) {
            this.a(cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, ECKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = eCPublicKeyTemplate.getAttributesAsArr();
        ECPrivateKeyTemplate eCPrivateKeyTemplate = (ECPrivateKeyTemplate)template.getPrivateKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = eCPrivateKeyTemplate.getAttributesAsArr();
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    private void a(long l, String string) {
        int n = d;
        try {
            long[] lArray;
            block5: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(1L, true)};
                lArray = this.objeAra(l, cK_ATTRIBUTEArray);
                if (lArray != null && lArray.length >= 1) break block5;
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
            this.OZET_ALICI.update(byArray);
            byte[] byArray2 = this.OZET_ALICI.digest();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2)};
            for (long l2 : lArray) {
                this.mPKCS11.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray2);
                if (n == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.a.warn(PKCS11Ops.a(8680, -892), (Throwable)exception);
        }
    }

    private KeySpec a(long l, ECKeyPairTemplate eCKeyPairTemplate) throws SmartCardException, IOException, PKCS11Exception {
        long[] lArray = this.createKeyPairWithOutRead(l, eCKeyPairTemplate);
        long l2 = lArray[0];
        byte[] byArray = this.d(l, l2);
        this.a(l, lArray, byArray);
        return this.a(l, l2);
    }

    private byte[] c(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private void a(long l, long[] lArray, ECPublicKeyTemplate eCPublicKeyTemplate) throws PKCS11Exception {
        byte[] byArray = this.a(eCPublicKeyTemplate);
        this.a(l, lArray, byArray);
    }

    private void a(long l, long[] lArray, byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray)};
        int n = d;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == -1L) continue;
            this.mPKCS11.C_SetAttributeValue(l, lArray[i], cK_ATTRIBUTEArray);
            continue;
        }
    }

    private byte[] a(ECPublicKeyTemplate eCPublicKeyTemplate) {
        ECPoint eCPoint = eCPublicKeyTemplate.getEcPublicKey().getW();
        EllipticCurve ellipticCurve = ((ECParameterSpec)eCPublicKeyTemplate.getSpec()).getCurve();
        byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve, false);
        return this.OZET_ALICI.digest(byArray);
    }

    private byte[] d(long l, long l2) throws IOException, PKCS11Exception {
        byte[] byArray = this.c(l, l2);
        byte[] byArray2 = this.c.getCardTemplate().getPointValue(byArray);
        byte[] byArray3 = this.OZET_ALICI.digest(byArray2);
        return byArray3;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        block9: {
            block10: {
                int n;
                block8: {
                    this.c.getCardTemplate().applyTemplate(template);
                    n = d;
                    if (!(template instanceof RSAKeyPairTemplate)) break block8;
                    this.importKeyPair(sessionID, (RSAKeyPairTemplate)template);
                    if (n == 0) break block9;
                }
                if (!(template instanceof ECKeyPairTemplate)) break block10;
                this.importKeyPair(sessionID, (ECKeyPairTemplate)template);
                if (n == 0) break block9;
            }
            throw new ESYARuntimeException(PKCS11Ops.a(8675, -31565) + template);
        }
    }

    public void importKeyPair(long sessionID, RSAKeyPairTemplate template) throws PKCS11Exception {
        long l;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        if (template.getPublicKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        if (template.getPrivateKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l);
        }
        this.a(sessionID, string);
    }

    public void importKeyPair(long sessionID, ECKeyPairTemplate template) throws PKCS11Exception {
        long l = -1L;
        if (template.getPublicKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        long l2 = -1L;
        if (template.getPrivateKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l2);
        }
        this.a(sessionID, new long[]{l, l2}, (ECPublicKeyTemplate)template.getPublicKeyTemplate());
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = template.getAttributesAsArr();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(template.getGenerationMechanism());
        long l = this.mPKCS11.C_GenerateKey(sessionID, cK_MECHANISM, cK_ATTRIBUTEArray);
        template.setKeyId(l);
    }

    @Override
    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = 0;
        int n2 = d;
        if (lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
                ++n;
                if (n2 == 0) continue;
            }
        }
        return n;
    }

    private void a(CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        block4: {
            block5: {
                if (!this.a.isDebugEnabled()) break block4;
                this.a.debug(PKCS11Ops.a(8692, -12803));
                this.a.debug(PKCS11Ops.a(8603, -32003) + cK_MECHANISM.mechanism);
                this.a.debug(PKCS11Ops.a(8582, 6776));
                if (cK_MECHANISM.pParameter != null) break block5;
                this.a.debug(PKCS11Ops.a(8687, 14157));
            }
            this.a.debug("\n");
            this.a.debug(PKCS11Ops.a(8673, -9226));
            this.a(cK_ATTRIBUTEArray2);
            this.a.debug(PKCS11Ops.a(8628, 4159));
            this.a.debug(PKCS11Ops.a(8674, -9993));
            this.a(cK_ATTRIBUTEArray);
            this.a.debug(PKCS11Ops.a(8678, -9717));
        }
    }

    private void a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        int n = cK_ATTRIBUTEArray2.length;
        int n2 = d;
        for (int i = 0; i < n; ++i) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray2[i];
            this.a.debug(cK_ATTRIBUTE.toString());
            System.out.println(cK_ATTRIBUTE.toString());
            if (n2 == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block26: {
            block25: {
                var5 = new String[81];
                var3_1 = 0;
                var2_2 = "\u00b7o>\r\u00108 zU\u00f8D\u00f5\u00e5n\u00f3n\u00f4\u00ce\u00dc\u00e0\u0011\u0086\u00b0S\u001aW\u00a5\u00be'<\u008f\u00e7l\u0094\u00e8X\u0018\u0081\u00b0.\u00deC\u00ff\u00b9\u0005\u0083\u00b7lv\u009c\u00c4\bK\u0084\u00ec\u00bd>?S\u00ac\u001b\u00b3K\u0006\u00f4h\u00f1\u0098n\u0013\u0092\u00f4]\u00a5T0\u00a8\u001e\u00d4h\u0007\u0081\u0010%\u0084\u0086\\\u00fb\u0007P\u00cd\u00c6\u00dbP4\u00edH\n\u00bfr~3\u001b\u00f8\u00df\u001d\u008dk\u00d8\u00e3a\u00ac/\u0006o\u00ec|\u0010\u00e30\u00d6\u00e1\u00fdc\rwR\u00fe,7I_\u00b9\u001e\u00b1\u00f9\u00e3J\t\u0017\u00c7\u0014S\u0004\u00f2\u00bc\u0001$\u00f0\u008es\u009a\u00d4\u00aeC\u0083DC\u0001g\u00ee\u00e7~2\u00ec?\u00f3\u00bb#1\u00829\u00d0r\u00f2\u0082\u00e0\u00d7~\u00dd)\u00b4Gg%\u001b\u00d3\u00ba5\u00ea\"\u0088RkS\u00c0\u009eOR\u000f\u00f1\u001eR\u009a\u00b5\u00e8\u00b1\u00cbX\u00e7\u00ea\u00ab?\u0086p\u008d\u00dfI-\u0003d*\u001e2P\u0003\u00df\u0082\u00ef\u00a1d\f\u0016\u00fb\u00ef\u009b1O\u00a6mU]\u00c2+ju0\u00d4+c\u00e0\u00e6\u00e0W\u0002\u008e\"D&`\u00c6\u00ac@\u00fe\u0089\u008bN\u00b4H\u001aa7\u001e\u00f1\u001aRn&\u00a2\u00f0\u00ac\u00a1\u0085[\u00c1\u0005\u00b7I\u00e4p\u00bbbp|\u00e7\u00d1\u00b6\u00aa\u00d9\\B4y\u00da_\u00a4\u00fa\u00d8d\u000b\u00e3|\u0016\u0081\u00b8\u00ea\u00ad\u00f0F\u00f0\u00ccn\u000b1\u00b82\fj\u00b8\u0090\u0083Ig\u00b1\u008a\u00ae\u00b0\u0096\u00f3\u0081\u00e8\u008fe\u00a6$#\u00a3\u009em}\u0088\u00f7\u00a8\u00f8\u0003t\u0087\u0016\"\u00edR\u00e8\u00d2\u00d7[\u009a\u00f6;\u00d6\u00ba\u000e&B\u0014\u00a02\u001dx\u009d\u00a6\u00a3\u0018\u0004\u0096f\u009a\u009b\u008c\u0096\u00e1O\u0094\u0086\u001d\u001e3)\f\u00a0\u00c7I\u00c2\u008a\u007fb\u00e6q\u00e6%\u009f\u00d22(\u00d9]\u00de\u00fd\u00c6\u00b8\u0096\u00e2\u001e\u00d2\u000e\u00016\u00dd\u00a50\u00de\u009eg1\u00dbHw\u00fbp3\u00bf\u00dc\"yP\u00de\u0093\u00e3\u00d0\u0006\u0003\u001d\u0087\u0086\u001e\u00fe\u00a0\u00d8\u00d3\u00efJ\tI6\u00a0\u00bb\u00c0\u00e9\u00a4?\u00e2/0.\u0083\u00b4&\u008d\u00c7n\u0095\u00a3\u00f2\u009b\u0006\u00be \u00cd\u00abC\u001b.\u00fcX\u0001\u00ec\u00c1\u00e8\u008bi\u009e\u00b34\u0097\u00f3A\n\u00c7\u00df\u001f\u001a\u0096\u00f0\u00a6\u00f1J\u00d9\u00a8N\u00a6\u00bd;)\u0080\u00c4e+\u00d8\u008a\u0085\u00b6Q\u00a3\u0099\u0000\u00dc\u009e|\u0014;`\u0093mc\u00b0YD\u0083\u00f9V\u0088u\u001e\u000e\u0093\u00f2h}\b\u0005'?]F\u008c \u0082\u00b8<x\u00b3\u00f7\u00c9\u00eeY\u00a7\u00b9\u0017\u009fw\u0080\u00e1_G\u00e7\u00a30\u008a\u001d(O\u00ce\u0083\u0001\u008d\u00ce\u00ae]\u001b\u00e4q\u00f0A*\u00d0\u00fa\n00h\u0089\u00e4#\u00c5C\u00d4o\u00aa\u0004\u000b\u00ca\u00f1V7\u00b3\u009a\u0005}`\u00f2\u0095\u00b0\u0003\u0091\u0005\u00a0\u0003\u00c5\u0091\u0000!\u00cc\u00ee\u00f5\u00b2\u008a\u00ae\u00ee\u00c5\u00b2\u00c98\u00b6\u00ee\u00c4\u0084\u00bf\u00fc\u00f0\u00af\u00f7\u00ab\u00b4\u00e5\u0082\u00afV\u008bS\u001a\u00eeT;\u00ea\u001a=\u0096\u00f3A\u0095C\u00d2\u00f52\u00db\u008c~\u001b|}G)\u00cc\u00f4c*{Y\u00ef:\u00f7-\u00fe\u0096\u00a1d\u00b6\u008a`FlNL4\"\u00ffD\u001a\bw\t\u001c\u0004\u00cdZ#\u009c!\u00e1\u00b9\u00a6\u0007\u0001\u001d\u00a5\u00f5\u00e9\u00b8\u00d5\u00b4\u00b9\u00dcH\u00c6\u0007~d\rBq\u00bc\u0085\u0086\b\u00e5S\u0019\u001c\u00fb\u00a3\u00a9?\u00f9G\u00b7\u00e0\u0090\u00b4\u0093\u00a1\u00b4\u00acs\u00e7\u00f1\u00a4\u00db\u00cdPC\u00a1\u00e9\n[\u00ad\u00bb\u001e|:\u00d4\u001f\u00d9\u00b0n\u001f\u0084>\u0010\u00a5\u008eP~3\u00ca\u00e7\u00bc)o4O\u00ba\u00c9\u0091\\\u00cf\u0096\u0080\u009d\u0093D\u00c5`u\u00d5\u00d0\u001d\u00f8\u00ac\u00f5\u00ff;\u00b9:\r\u00e4\u0086\u00af\u00d9\u00c8\u0001\u0012c4\u00ad\u00f4*\u00c6\u00a0\u008e\t\u00d6o/!k#\u0090\u0091\u0083\u0099\u00df\u008b\u00ce#~\u0014Ud6\u00d5\n\u0085D\u00de\u00fbp$\\\u00f8\u00ff\u0013\u008f\u00ae\u00d8N5!\u00a1j\u00c1\u009b,\u00e7\u00e7\u0097\u0087\u00fe\u00bb\u0013\u0089y\u0004\u00c5\u0085\u0007\u0006-\u00a0\u00cf\u0098\u0007q\u00da\u00af5\u000f\u00d3\u00e4\u00c57<0\u0091\u0085SFSHb\u009c\u0081m.\u0097\u00b0\u009c\u001bA\u00a2D;\u00bc\u009f(\u00e3j\r#.\u008d\u00d7\u00e8\u00ddq\u00bc\u001e~\u009d\u0085#\u00bfm\u008e\u00d1\"5t\u00f2\u001d\u00b5\u00c8\u00d6\u0084\u00b2\u0098\u008b\u00c7\u0000{\u00d0\u0087\u00aa\u00f9k\u0001\u00c40Tv\u001f(\u00abR\u00aa\u00af%h\fb\u0018m\u00ad\u00d7p\u001f\u00b0\u00fe\u00e3En\u00d7\u0019o\u001d\u0010\u00b8\u0011\u00e1\u00cad\u00f5A\u00d3\u001720\u0007\u00d3\u0002n\u00b1T\u000e\u0010\u00bb/\u0093)N\u00a5M5Y\u00ce\u00ab\u00ebe\u0000\u00d6-# \u00ee\u00f8V\u0001\u00aeB@*\u00e0G\u00bcp\u00fc\u008f\u00cb\u008e\u00bcP\u001bb\u0017~\u00f5\u001f\u00c8\u00e8Q\u00aa\u00be\u000b\u00bf\f\u00c0\b\u0012xF*\u0091\u00e8C\u00f7\u0091p\u001ch\u008e\u00b4\u009c\u00b8\u0018\u0081\u00e9j\u00aa\u0007,Y\u0012\u001a\u008c]\u00af\t\u00dbW.r\u000fO\u0081tX\u000e\u00e4\u00c7a\u009b\u00a7\u0019l\u009fo\u00c4\u0083\u0094\u0082\f\u0005\b\u00f5B\u0090TL\u0001\u0082\u00a4E\u009a\u00fe\u0012Z\u00cb|\u0093\u0083\u0086\u00f3+\u008c\u00b2\u00de\u00d1\u0007\u0084y\u00fe\u0081\u00b7\u00d6\u00ec\u009b(Ju\u00dcH\u00c2N\u00e4(\u00b6Kd\u00e0\u0004$K\u00f5O\tV.j\u0095~\u00a8\u00ec\u0010\u00db\u00ee\u008f\u00b1)O_\u00a9P7\u009d\fm\b\u00c9\u00dc(9pP\u00e1 \u00be\u008b\u009f\u00c6g\u0086\u0084\u00bd\u00a7>\u00fe\u00be\u00db\u00e4,\u00aa\f.\u009a\u008e8)\u0018\u0099+\u00997\u00a6\u0001\u00d1UL!1\u00f7J\u0091}\u00ca\u0010ImX\u00c3\u0084\u0091\u0082kw\u0001\u00e9\u0010\u00d4\\\u00d0\u001b\u000ep\u00c7pae\u00a8\u00bb\u00f3\u0017,\u00f0\u0086\u00e8\u00c9\b\u00f5\u00a0(\u00dc\u0011\u00b3\u0019O\fp<\u00a7j\u00d8\u0015\u00a3#\u0090\u00cc\u00e0\u0084\u00a4o\u008f\u00ec\u00ae5\u00d4g\u00a0\u00b4z\u0090&\u001e\u00e3G\u0002\u00ca\n\u00dez\u00aa/i\u00a2\u00a0*)\u0088-\u0083\u00ed\u00a5_\u00a0\u001a\u008d{\u0019\u001coI\u00c4\u00d4\u0001\u00fc\u008c\u00e8t\u00e5\u00b4<\u00f4\bp\u00cdD\u00e3\u0005+rLK\u00c2\u00c2\u00f1\u0083\u00a0Q\u00df^'\u00a3\u0085k[\u00a7B!\u00aa0\u00a4\u009f\u00aci\u00ef\u0000\u0019\u00cc\u001f\u0019g\u00a2\u001c<\u001c\u00b5!\u00d9\u009cG\u0092M`m\"\u009bGX\u0085H\u00fdnE\u00aa\u0093\u00a4S\u0084\f\u00f6\u00e0\u00a5O\u00afX\u00ff\u0085\u00fc\u0082\u00f5\u0003\u001a\u000em\u00e7\u00f8r\u00ee\u00c6~c\u00c7\u0004\u00e3\u00af\u00a97c\u00f3m\u00da\u0082\u00c2\u0081\u00b9]\"9\u00fcyo\u00da\u0083\u00bb\u0084\u00a7\u001a\u0005\t\u00fb$\u009b\u00fe\u00a4+\u0094r\u001b3\u00b7\u00f8J\u00027v\u009bV\u00fe\u00c1\u00a1HK\u00e1\t~\u00b0\u009b\u0085\u0098\u00dbs\u00e6\u0006\u0011\r\u0083\u00cb\u001e\u00ab2\u00e1\u0014@\u00f6\u0004\u00aeB\u00e5\u0013\u00fc|\u0003\u00c8\u00d5\u00a14.\u00bd\u00bf\u00be\u000eRK\u00b6\u00e2\u00c88C\u00965\u00a3\u00f0E\u0017\u0007\u00c57\u00f5\u00e1PV\u0012\u00dbQ\u00e0h\u00ecv\u00dd\u0096\u00c0t\u0017\u00e5\u0099\u00b0x\u00da\u00d1@g\u00e4'\u00f6<#i\u0123-\u00ee\u00fc\b}\u0015^;\u00f3\u00cf\r\u00b5k\u009f\u0090jt\u00e1\u00f9\u00d9\u00c7\u0001xB\u0080\u00a6\u00dc\u009e\u00c1^o\u0019\u00c4&\u00d3o\u00d36\u00e4\u00e7W\u00886y\u00a70 Y\u0090G}\u00dcW$\u00fa\u00e4%\u000eGi}^\u00a0\u0084o\u009c\u00a6_*\u00f0<\u00f2L4Q{\u00c4p\u001c ]\u00f0\u00fe\u0086\u0015\u00d1\u00c2\u00a70\u00fc\u00dbK\n\u00ea\u0091\u00b5\u0093\u00b5l\u00c3T+}8xi}\u00fd(Nm\u00c58X\u00a5\u008f\u00a1\u00ffb\u00be\u00c9^\u000e!\u00cd\u00d0:\u00e1\u00b5\u00eb\u00f9\u00fa\u00e3\u00e1\u00e5R\u0012\"\u00a4^\u00d5~\u0083\u00bf\u00e5\u0011\u00e5e\u0000M*\u00e7\u00f7uv\u0096\u0005\u00a3\u0086\u00c3owM\u00be\u009a\u00cdp\u00bcH[\u0001\u001a\u00f5\u00a1\u00aa\u00c5\u00cc\u0080\u0003jM\u00a9e\t,\u00a5\u0004D\u00e8\u0017/@\u008a\u00b0-\u0017\u0000\u00d0\u00c44\u00ae\u0085\u00fe\u00dd\u009c\u00f6\u00f4$\u00f9\u00bf\u00ce\u00d6\u00c9\u00bc_\u00f6\u0090\u008d\t\u0000+\u008ef\u00e3\u00a6/p\u008b WQd\u00db\u0004\u00d8;\u0013\u000fy\u00ce\u00fa\u001b\tv j+\u00d4\u00b4{\u00fbz\u00ed\u00f7\u00e3\u000e\u0089\u00af\u00d1\u0001\u00ea\b\u0013\u00ef7\u009d\u00da\u00f4\u00b7\u00bd\u000eL\b\u00b8f\u0087\nh\u00fd\u00ef\u0088\u0093\u001d\u0080=-\u00e3E\u0002\u001e\u00c2\u00c5\u00ee\u00af\u00bdsv\u0093e\n\u00a7\u0085\u001e\u0084\u00cbb\\\u0002Q\u00da\u00fd\u001e\u00cd^#\u00fb\u00b1\u0082\u00b3\u0006+\u00c6\u008d{\u00b2%)\u00f9+\u0099\u00e1\u0014t\u00d7z\u009b^n\u00fe\u009fw\u0082\u00c8\u00e7\u00a6\u00f3t.\u00bd\u00df\u0094\u00fe$3\u00dbDH\u00d6\u00d1\u00fb\u008bc\u00b2b/\u0087\u00ff\u00c8\u00e6dv\u0083J\u00c6\u00a5\u00b9\u00c7\u0082./\u00bb\u00bc\u0093\u00fc\u008aW\u00adX@\f\u00f8ce\u00a9I\u008b4\u0084\u001c\u0082\u00e6\u00f4 \u009f\u00b6\u00a6N\u001e\u00c8\u00a3\u0084\u001c\u0098^\u00c7\u00ba{\u0087\u0087Q\u00f34\u000b_2\u001c\u001bT\r\u00f8q\u0098\u00df{\u00f7\u001a\u0090\u00a4\u007fC\t\u0000z\u00b7&E~\u00c1\"+\u00dd\u0177\u0013\u00d0\u007f\u00a2\u0010n\r\u00c3\u00cf\u00fc,\u00b3\u0097\u00e8\u0015\u00fc\u00d7,\u008ejO\u00aa\b \u00b2p\u00b9\u0090\u00d0\u00f3o\u00cd\u0099V\u00ad-T\u00d09n\u00c8S\u00fe\u008b\u00aa\u00c2!\u00b7\u00ba\u0011\u00b6We\u009eC\u0011\u00b4\u00f7\u00c1m\u00a7\u00f2mo_\u0001\u00cf\u00f1\u0003\u00e6{ d#\u00ddp*\u00a5\u00ea\fh\u00d3\u00aa\n\u00cf\u00a7e\u00ad`\u008a\t?RL\u0011\u00db^\u000f\u00c7\u00914\u001b\u001dMK\u00ae' 2.D,\u0016b#9\u00d7S\u0015\u00f98-\u00e4\u00f9h\u00b9\u001e\u00af\u0005d\u00ed\u00b4\u00e0\u00fdCs+&\u0085\u00d45Q\u000b\u00ca~- ;\u00e3\u0086\tcU\u00834\u0097-F\u0016V%+\u00d1\u00d6N5Z<^oj{\u00850\u00b6\u0003]\u009fm\u00e9\u008b\u00f7\u00a6p\u00f3\u0085\u008a\u0002\u00fa4\u00865\u00a4I\n\u00ce\u00a0\u00ac\u00a7\u00e1\u001b\u00a2\u0018ps\u00c6\u008e\u000fH\u00c3t)9\u00cb\u00cd\u0014i\u00cd\u008e3\u00d2$c\u000e\u00f6S]\u001e\u00cd;\u00c7Hq\u0092\u00ef!+R\u00e3./Wy#\"iN\u00c9\u00c3\u00dfb\u00ad\u0084\u00b4J\u00a5B\u00a1T\u00f7\u00a6\u00a5\u00d1P@\u00dd\u00fc\u00bb\u0088\u00fel\u000b\u0013\u00dd\u007f\u00c5\u00d9\u00c5\u00a35\u007f\u00d8\u009fd\u001bz\u00d5\u00db\u00a0y\u001e\u00f0\u00c96\u00a9\u00e3\u00b3k\u00ae\u0090\u0002\u00e6,\u00c8\u0096\u001f\u00acz\u00fb\u00d3\u0097\u00c3\u0093\u00ed^O\u0151\u000b_\u00e6e\u0087$S?b\u008fW\u00de?\u0019\u00b1?#u\u00dc\u00f0k\u00eb\u0003\u009d\u01ccl\u001at\u0013\u00e2\rhY\u00b2;9\u0016IM\u00c0\u00bbAPD\r\u00b8HIC\u00b9g>\u0095\u0004xz\u00fb\u00ba\u0015\u009dD\u00cd\u00a70o\u00c7\u009e=\u00bcZ\u00cc\u0007\u00a7\u00eb\u001c\u0007\u00beM8\u00ff\u0012B\u0089\u00ec \u0097v\u00b1U\u0018b.\u0011d.U\u00d7\u00f6m\u001a:g*;\u00a3\u000f/V\u008cy+F\u0088\u00db\u0088\u0169\u00b9\u0013*\u00da\u00baaX\"e\u00c0";
                var4_3 = "\u00b7o>\r\u00108 zU\u00f8D\u00f5\u00e5n\u00f3n\u00f4\u00ce\u00dc\u00e0\u0011\u0086\u00b0S\u001aW\u00a5\u00be'<\u008f\u00e7l\u0094\u00e8X\u0018\u0081\u00b0.\u00deC\u00ff\u00b9\u0005\u0083\u00b7lv\u009c\u00c4\bK\u0084\u00ec\u00bd>?S\u00ac\u001b\u00b3K\u0006\u00f4h\u00f1\u0098n\u0013\u0092\u00f4]\u00a5T0\u00a8\u001e\u00d4h\u0007\u0081\u0010%\u0084\u0086\\\u00fb\u0007P\u00cd\u00c6\u00dbP4\u00edH\n\u00bfr~3\u001b\u00f8\u00df\u001d\u008dk\u00d8\u00e3a\u00ac/\u0006o\u00ec|\u0010\u00e30\u00d6\u00e1\u00fdc\rwR\u00fe,7I_\u00b9\u001e\u00b1\u00f9\u00e3J\t\u0017\u00c7\u0014S\u0004\u00f2\u00bc\u0001$\u00f0\u008es\u009a\u00d4\u00aeC\u0083DC\u0001g\u00ee\u00e7~2\u00ec?\u00f3\u00bb#1\u00829\u00d0r\u00f2\u0082\u00e0\u00d7~\u00dd)\u00b4Gg%\u001b\u00d3\u00ba5\u00ea\"\u0088RkS\u00c0\u009eOR\u000f\u00f1\u001eR\u009a\u00b5\u00e8\u00b1\u00cbX\u00e7\u00ea\u00ab?\u0086p\u008d\u00dfI-\u0003d*\u001e2P\u0003\u00df\u0082\u00ef\u00a1d\f\u0016\u00fb\u00ef\u009b1O\u00a6mU]\u00c2+ju0\u00d4+c\u00e0\u00e6\u00e0W\u0002\u008e\"D&`\u00c6\u00ac@\u00fe\u0089\u008bN\u00b4H\u001aa7\u001e\u00f1\u001aRn&\u00a2\u00f0\u00ac\u00a1\u0085[\u00c1\u0005\u00b7I\u00e4p\u00bbbp|\u00e7\u00d1\u00b6\u00aa\u00d9\\B4y\u00da_\u00a4\u00fa\u00d8d\u000b\u00e3|\u0016\u0081\u00b8\u00ea\u00ad\u00f0F\u00f0\u00ccn\u000b1\u00b82\fj\u00b8\u0090\u0083Ig\u00b1\u008a\u00ae\u00b0\u0096\u00f3\u0081\u00e8\u008fe\u00a6$#\u00a3\u009em}\u0088\u00f7\u00a8\u00f8\u0003t\u0087\u0016\"\u00edR\u00e8\u00d2\u00d7[\u009a\u00f6;\u00d6\u00ba\u000e&B\u0014\u00a02\u001dx\u009d\u00a6\u00a3\u0018\u0004\u0096f\u009a\u009b\u008c\u0096\u00e1O\u0094\u0086\u001d\u001e3)\f\u00a0\u00c7I\u00c2\u008a\u007fb\u00e6q\u00e6%\u009f\u00d22(\u00d9]\u00de\u00fd\u00c6\u00b8\u0096\u00e2\u001e\u00d2\u000e\u00016\u00dd\u00a50\u00de\u009eg1\u00dbHw\u00fbp3\u00bf\u00dc\"yP\u00de\u0093\u00e3\u00d0\u0006\u0003\u001d\u0087\u0086\u001e\u00fe\u00a0\u00d8\u00d3\u00efJ\tI6\u00a0\u00bb\u00c0\u00e9\u00a4?\u00e2/0.\u0083\u00b4&\u008d\u00c7n\u0095\u00a3\u00f2\u009b\u0006\u00be \u00cd\u00abC\u001b.\u00fcX\u0001\u00ec\u00c1\u00e8\u008bi\u009e\u00b34\u0097\u00f3A\n\u00c7\u00df\u001f\u001a\u0096\u00f0\u00a6\u00f1J\u00d9\u00a8N\u00a6\u00bd;)\u0080\u00c4e+\u00d8\u008a\u0085\u00b6Q\u00a3\u0099\u0000\u00dc\u009e|\u0014;`\u0093mc\u00b0YD\u0083\u00f9V\u0088u\u001e\u000e\u0093\u00f2h}\b\u0005'?]F\u008c \u0082\u00b8<x\u00b3\u00f7\u00c9\u00eeY\u00a7\u00b9\u0017\u009fw\u0080\u00e1_G\u00e7\u00a30\u008a\u001d(O\u00ce\u0083\u0001\u008d\u00ce\u00ae]\u001b\u00e4q\u00f0A*\u00d0\u00fa\n00h\u0089\u00e4#\u00c5C\u00d4o\u00aa\u0004\u000b\u00ca\u00f1V7\u00b3\u009a\u0005}`\u00f2\u0095\u00b0\u0003\u0091\u0005\u00a0\u0003\u00c5\u0091\u0000!\u00cc\u00ee\u00f5\u00b2\u008a\u00ae\u00ee\u00c5\u00b2\u00c98\u00b6\u00ee\u00c4\u0084\u00bf\u00fc\u00f0\u00af\u00f7\u00ab\u00b4\u00e5\u0082\u00afV\u008bS\u001a\u00eeT;\u00ea\u001a=\u0096\u00f3A\u0095C\u00d2\u00f52\u00db\u008c~\u001b|}G)\u00cc\u00f4c*{Y\u00ef:\u00f7-\u00fe\u0096\u00a1d\u00b6\u008a`FlNL4\"\u00ffD\u001a\bw\t\u001c\u0004\u00cdZ#\u009c!\u00e1\u00b9\u00a6\u0007\u0001\u001d\u00a5\u00f5\u00e9\u00b8\u00d5\u00b4\u00b9\u00dcH\u00c6\u0007~d\rBq\u00bc\u0085\u0086\b\u00e5S\u0019\u001c\u00fb\u00a3\u00a9?\u00f9G\u00b7\u00e0\u0090\u00b4\u0093\u00a1\u00b4\u00acs\u00e7\u00f1\u00a4\u00db\u00cdPC\u00a1\u00e9\n[\u00ad\u00bb\u001e|:\u00d4\u001f\u00d9\u00b0n\u001f\u0084>\u0010\u00a5\u008eP~3\u00ca\u00e7\u00bc)o4O\u00ba\u00c9\u0091\\\u00cf\u0096\u0080\u009d\u0093D\u00c5`u\u00d5\u00d0\u001d\u00f8\u00ac\u00f5\u00ff;\u00b9:\r\u00e4\u0086\u00af\u00d9\u00c8\u0001\u0012c4\u00ad\u00f4*\u00c6\u00a0\u008e\t\u00d6o/!k#\u0090\u0091\u0083\u0099\u00df\u008b\u00ce#~\u0014Ud6\u00d5\n\u0085D\u00de\u00fbp$\\\u00f8\u00ff\u0013\u008f\u00ae\u00d8N5!\u00a1j\u00c1\u009b,\u00e7\u00e7\u0097\u0087\u00fe\u00bb\u0013\u0089y\u0004\u00c5\u0085\u0007\u0006-\u00a0\u00cf\u0098\u0007q\u00da\u00af5\u000f\u00d3\u00e4\u00c57<0\u0091\u0085SFSHb\u009c\u0081m.\u0097\u00b0\u009c\u001bA\u00a2D;\u00bc\u009f(\u00e3j\r#.\u008d\u00d7\u00e8\u00ddq\u00bc\u001e~\u009d\u0085#\u00bfm\u008e\u00d1\"5t\u00f2\u001d\u00b5\u00c8\u00d6\u0084\u00b2\u0098\u008b\u00c7\u0000{\u00d0\u0087\u00aa\u00f9k\u0001\u00c40Tv\u001f(\u00abR\u00aa\u00af%h\fb\u0018m\u00ad\u00d7p\u001f\u00b0\u00fe\u00e3En\u00d7\u0019o\u001d\u0010\u00b8\u0011\u00e1\u00cad\u00f5A\u00d3\u001720\u0007\u00d3\u0002n\u00b1T\u000e\u0010\u00bb/\u0093)N\u00a5M5Y\u00ce\u00ab\u00ebe\u0000\u00d6-# \u00ee\u00f8V\u0001\u00aeB@*\u00e0G\u00bcp\u00fc\u008f\u00cb\u008e\u00bcP\u001bb\u0017~\u00f5\u001f\u00c8\u00e8Q\u00aa\u00be\u000b\u00bf\f\u00c0\b\u0012xF*\u0091\u00e8C\u00f7\u0091p\u001ch\u008e\u00b4\u009c\u00b8\u0018\u0081\u00e9j\u00aa\u0007,Y\u0012\u001a\u008c]\u00af\t\u00dbW.r\u000fO\u0081tX\u000e\u00e4\u00c7a\u009b\u00a7\u0019l\u009fo\u00c4\u0083\u0094\u0082\f\u0005\b\u00f5B\u0090TL\u0001\u0082\u00a4E\u009a\u00fe\u0012Z\u00cb|\u0093\u0083\u0086\u00f3+\u008c\u00b2\u00de\u00d1\u0007\u0084y\u00fe\u0081\u00b7\u00d6\u00ec\u009b(Ju\u00dcH\u00c2N\u00e4(\u00b6Kd\u00e0\u0004$K\u00f5O\tV.j\u0095~\u00a8\u00ec\u0010\u00db\u00ee\u008f\u00b1)O_\u00a9P7\u009d\fm\b\u00c9\u00dc(9pP\u00e1 \u00be\u008b\u009f\u00c6g\u0086\u0084\u00bd\u00a7>\u00fe\u00be\u00db\u00e4,\u00aa\f.\u009a\u008e8)\u0018\u0099+\u00997\u00a6\u0001\u00d1UL!1\u00f7J\u0091}\u00ca\u0010ImX\u00c3\u0084\u0091\u0082kw\u0001\u00e9\u0010\u00d4\\\u00d0\u001b\u000ep\u00c7pae\u00a8\u00bb\u00f3\u0017,\u00f0\u0086\u00e8\u00c9\b\u00f5\u00a0(\u00dc\u0011\u00b3\u0019O\fp<\u00a7j\u00d8\u0015\u00a3#\u0090\u00cc\u00e0\u0084\u00a4o\u008f\u00ec\u00ae5\u00d4g\u00a0\u00b4z\u0090&\u001e\u00e3G\u0002\u00ca\n\u00dez\u00aa/i\u00a2\u00a0*)\u0088-\u0083\u00ed\u00a5_\u00a0\u001a\u008d{\u0019\u001coI\u00c4\u00d4\u0001\u00fc\u008c\u00e8t\u00e5\u00b4<\u00f4\bp\u00cdD\u00e3\u0005+rLK\u00c2\u00c2\u00f1\u0083\u00a0Q\u00df^'\u00a3\u0085k[\u00a7B!\u00aa0\u00a4\u009f\u00aci\u00ef\u0000\u0019\u00cc\u001f\u0019g\u00a2\u001c<\u001c\u00b5!\u00d9\u009cG\u0092M`m\"\u009bGX\u0085H\u00fdnE\u00aa\u0093\u00a4S\u0084\f\u00f6\u00e0\u00a5O\u00afX\u00ff\u0085\u00fc\u0082\u00f5\u0003\u001a\u000em\u00e7\u00f8r\u00ee\u00c6~c\u00c7\u0004\u00e3\u00af\u00a97c\u00f3m\u00da\u0082\u00c2\u0081\u00b9]\"9\u00fcyo\u00da\u0083\u00bb\u0084\u00a7\u001a\u0005\t\u00fb$\u009b\u00fe\u00a4+\u0094r\u001b3\u00b7\u00f8J\u00027v\u009bV\u00fe\u00c1\u00a1HK\u00e1\t~\u00b0\u009b\u0085\u0098\u00dbs\u00e6\u0006\u0011\r\u0083\u00cb\u001e\u00ab2\u00e1\u0014@\u00f6\u0004\u00aeB\u00e5\u0013\u00fc|\u0003\u00c8\u00d5\u00a14.\u00bd\u00bf\u00be\u000eRK\u00b6\u00e2\u00c88C\u00965\u00a3\u00f0E\u0017\u0007\u00c57\u00f5\u00e1PV\u0012\u00dbQ\u00e0h\u00ecv\u00dd\u0096\u00c0t\u0017\u00e5\u0099\u00b0x\u00da\u00d1@g\u00e4'\u00f6<#i\u0123-\u00ee\u00fc\b}\u0015^;\u00f3\u00cf\r\u00b5k\u009f\u0090jt\u00e1\u00f9\u00d9\u00c7\u0001xB\u0080\u00a6\u00dc\u009e\u00c1^o\u0019\u00c4&\u00d3o\u00d36\u00e4\u00e7W\u00886y\u00a70 Y\u0090G}\u00dcW$\u00fa\u00e4%\u000eGi}^\u00a0\u0084o\u009c\u00a6_*\u00f0<\u00f2L4Q{\u00c4p\u001c ]\u00f0\u00fe\u0086\u0015\u00d1\u00c2\u00a70\u00fc\u00dbK\n\u00ea\u0091\u00b5\u0093\u00b5l\u00c3T+}8xi}\u00fd(Nm\u00c58X\u00a5\u008f\u00a1\u00ffb\u00be\u00c9^\u000e!\u00cd\u00d0:\u00e1\u00b5\u00eb\u00f9\u00fa\u00e3\u00e1\u00e5R\u0012\"\u00a4^\u00d5~\u0083\u00bf\u00e5\u0011\u00e5e\u0000M*\u00e7\u00f7uv\u0096\u0005\u00a3\u0086\u00c3owM\u00be\u009a\u00cdp\u00bcH[\u0001\u001a\u00f5\u00a1\u00aa\u00c5\u00cc\u0080\u0003jM\u00a9e\t,\u00a5\u0004D\u00e8\u0017/@\u008a\u00b0-\u0017\u0000\u00d0\u00c44\u00ae\u0085\u00fe\u00dd\u009c\u00f6\u00f4$\u00f9\u00bf\u00ce\u00d6\u00c9\u00bc_\u00f6\u0090\u008d\t\u0000+\u008ef\u00e3\u00a6/p\u008b WQd\u00db\u0004\u00d8;\u0013\u000fy\u00ce\u00fa\u001b\tv j+\u00d4\u00b4{\u00fbz\u00ed\u00f7\u00e3\u000e\u0089\u00af\u00d1\u0001\u00ea\b\u0013\u00ef7\u009d\u00da\u00f4\u00b7\u00bd\u000eL\b\u00b8f\u0087\nh\u00fd\u00ef\u0088\u0093\u001d\u0080=-\u00e3E\u0002\u001e\u00c2\u00c5\u00ee\u00af\u00bdsv\u0093e\n\u00a7\u0085\u001e\u0084\u00cbb\\\u0002Q\u00da\u00fd\u001e\u00cd^#\u00fb\u00b1\u0082\u00b3\u0006+\u00c6\u008d{\u00b2%)\u00f9+\u0099\u00e1\u0014t\u00d7z\u009b^n\u00fe\u009fw\u0082\u00c8\u00e7\u00a6\u00f3t.\u00bd\u00df\u0094\u00fe$3\u00dbDH\u00d6\u00d1\u00fb\u008bc\u00b2b/\u0087\u00ff\u00c8\u00e6dv\u0083J\u00c6\u00a5\u00b9\u00c7\u0082./\u00bb\u00bc\u0093\u00fc\u008aW\u00adX@\f\u00f8ce\u00a9I\u008b4\u0084\u001c\u0082\u00e6\u00f4 \u009f\u00b6\u00a6N\u001e\u00c8\u00a3\u0084\u001c\u0098^\u00c7\u00ba{\u0087\u0087Q\u00f34\u000b_2\u001c\u001bT\r\u00f8q\u0098\u00df{\u00f7\u001a\u0090\u00a4\u007fC\t\u0000z\u00b7&E~\u00c1\"+\u00dd\u0177\u0013\u00d0\u007f\u00a2\u0010n\r\u00c3\u00cf\u00fc,\u00b3\u0097\u00e8\u0015\u00fc\u00d7,\u008ejO\u00aa\b \u00b2p\u00b9\u0090\u00d0\u00f3o\u00cd\u0099V\u00ad-T\u00d09n\u00c8S\u00fe\u008b\u00aa\u00c2!\u00b7\u00ba\u0011\u00b6We\u009eC\u0011\u00b4\u00f7\u00c1m\u00a7\u00f2mo_\u0001\u00cf\u00f1\u0003\u00e6{ d#\u00ddp*\u00a5\u00ea\fh\u00d3\u00aa\n\u00cf\u00a7e\u00ad`\u008a\t?RL\u0011\u00db^\u000f\u00c7\u00914\u001b\u001dMK\u00ae' 2.D,\u0016b#9\u00d7S\u0015\u00f98-\u00e4\u00f9h\u00b9\u001e\u00af\u0005d\u00ed\u00b4\u00e0\u00fdCs+&\u0085\u00d45Q\u000b\u00ca~- ;\u00e3\u0086\tcU\u00834\u0097-F\u0016V%+\u00d1\u00d6N5Z<^oj{\u00850\u00b6\u0003]\u009fm\u00e9\u008b\u00f7\u00a6p\u00f3\u0085\u008a\u0002\u00fa4\u00865\u00a4I\n\u00ce\u00a0\u00ac\u00a7\u00e1\u001b\u00a2\u0018ps\u00c6\u008e\u000fH\u00c3t)9\u00cb\u00cd\u0014i\u00cd\u008e3\u00d2$c\u000e\u00f6S]\u001e\u00cd;\u00c7Hq\u0092\u00ef!+R\u00e3./Wy#\"iN\u00c9\u00c3\u00dfb\u00ad\u0084\u00b4J\u00a5B\u00a1T\u00f7\u00a6\u00a5\u00d1P@\u00dd\u00fc\u00bb\u0088\u00fel\u000b\u0013\u00dd\u007f\u00c5\u00d9\u00c5\u00a35\u007f\u00d8\u009fd\u001bz\u00d5\u00db\u00a0y\u001e\u00f0\u00c96\u00a9\u00e3\u00b3k\u00ae\u0090\u0002\u00e6,\u00c8\u0096\u001f\u00acz\u00fb\u00d3\u0097\u00c3\u0093\u00ed^O\u0151\u000b_\u00e6e\u0087$S?b\u008fW\u00de?\u0019\u00b1?#u\u00dc\u00f0k\u00eb\u0003\u009d\u01ccl\u001at\u0013\u00e2\rhY\u00b2;9\u0016IM\u00c0\u00bbAPD\r\u00b8HIC\u00b9g>\u0095\u0004xz\u00fb\u00ba\u0015\u009dD\u00cd\u00a70o\u00c7\u009e=\u00bcZ\u00cc\u0007\u00a7\u00eb\u001c\u0007\u00beM8\u00ff\u0012B\u0089\u00ec \u0097v\u00b1U\u0018b.\u0011d.U\u00d7\u00f6m\u001a:g*;\u00a3\u000f/V\u008cy+F\u0088\u00db\u0088\u0169\u00b9\u0013*\u00da\u00baaX\"e\u00c0".length();
                var1_4 = 24;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block25;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00be\u00a3\u0002\u0096T#\u0013\\\u00e4\u00ee9\u00c0\u001e\u008eX\u00b7\u00fb\u008d?\u00e9\u009c\u00a4\u0094%\u00fd\u00beO\u0080\u00a3\u00e77/\u0007Vy\u00bf\u00afu\u009c\u00ceH\u00f8Q*-D0\u00db\u0092t,\u0089\u0084\u00a4\u00c3\u0000w~\u00e9\u00ce\u00a2\u00d0\u00caM\u0017\u00d5\u008a] ?B\u00f0[r\u000f\u00f4\u00b8n0\u00e2\u0007\u0080\u00da\u00909\u009d\u00deh[\u00b7)\u001c\u0002\u00af\n`\u0012\u0098Mm\u00ae\u00ac@\u00c6\u009c\u00d7\u00ed\u00fd\u00bc*\u00c4\u00d1\u0097";
                    var4_3 = "\u00be\u00a3\u0002\u0096T#\u0013\\\u00e4\u00ee9\u00c0\u001e\u008eX\u00b7\u00fb\u008d?\u00e9\u009c\u00a4\u0094%\u00fd\u00beO\u0080\u00a3\u00e77/\u0007Vy\u00bf\u00afu\u009c\u00ceH\u00f8Q*-D0\u00db\u0092t,\u0089\u0084\u00a4\u00c3\u0000w~\u00e9\u00ce\u00a2\u00d0\u00caM\u0017\u00d5\u008a] ?B\u00f0[r\u000f\u00f4\u00b8n0\u00e2\u0007\u0080\u00da\u00909\u009d\u00deh[\u00b7)\u001c\u0002\u00af\n`\u0012\u0098Mm\u00ae\u00ac@\u00c6\u009c\u00d7\u00ed\u00fd\u00bc*\u00c4\u00d1\u0097".length();
                    var1_4 = 40;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block25;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block26;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 82;
                            break;
                        }
                        case 1: {
                            v13 = 33;
                            break;
                        }
                        case 2: {
                            v13 = 113;
                            break;
                        }
                        case 3: {
                            v13 = 102;
                            break;
                        }
                        case 4: {
                            v13 = 106;
                            break;
                        }
                        case 5: {
                            v13 = 28;
                            break;
                        }
                        default: {
                            v13 = 91;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        PKCS11Ops.f = var5;
        PKCS11Ops.g = new String[81];
        PKCS11Ops.b = new ArrayList<String>();
        var7_7 = System.getProperty(PKCS11Ops.a(8577, -25181)).toLowerCase();
        if (var7_7.indexOf(PKCS11Ops.a(8608, 23628)) >= 0) {
            var8_8 = System.getenv(PKCS11Ops.a(8585, 21521)) + System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8606, -11956) + System.getProperty(PKCS11Ops.a(8618, -22433));
            PKCS11Ops.b.add(var8_8);
        } else if (var7_7.indexOf(PKCS11Ops.a(8623, -18372)) >= 0) {
            var8_9 = System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8611, -9306) + System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8630, -26046) + System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8599, 18593) + System.getProperty(PKCS11Ops.a(8618, -22433));
            PKCS11Ops.b.add(var8_9);
            var9_11 = System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8626, -14554) + System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8627, 7230) + System.getProperty(PKCS11Ops.a(8618, -22433));
            PKCS11Ops.b.add(var9_11);
            if (!MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) ** GOTO lbl113
            System.setProperty(PKCS11Ops.a(8590, -12658), PKCS11Ops.a(8632, -17397));
        } else {
            var8_10 = System.getProperty(PKCS11Ops.a(8618, -22433)) + PKCS11Ops.a(8627, 7230) + System.getProperty(PKCS11Ops.a(8618, -22433));
            PKCS11Ops.b.add(var8_10);
        }
lbl113:
        // 4 sources

    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x21A4) & 0xFFFF;
        if (g[n3] == null) {
            int n4;
            int n5;
            char[] cArray = f[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 122;
                    break;
                }
                case 1: {
                    n5 = 25;
                    break;
                }
                case 2: {
                    n5 = 215;
                    break;
                }
                case 3: {
                    n5 = 197;
                    break;
                }
                case 4: {
                    n5 = 196;
                    break;
                }
                case 5: {
                    n5 = 130;
                    break;
                }
                case 6: {
                    n5 = 65;
                    break;
                }
                case 7: {
                    n5 = 234;
                    break;
                }
                case 8: {
                    n5 = 226;
                    break;
                }
                case 9: {
                    n5 = 242;
                    break;
                }
                case 10: {
                    n5 = 182;
                    break;
                }
                case 11: {
                    n5 = 37;
                    break;
                }
                case 12: {
                    n5 = 227;
                    break;
                }
                case 13: {
                    n5 = 162;
                    break;
                }
                case 14: {
                    n5 = 201;
                    break;
                }
                case 15: {
                    n5 = 147;
                    break;
                }
                case 16: {
                    n5 = 0;
                    break;
                }
                case 17: {
                    n5 = 77;
                    break;
                }
                case 18: {
                    n5 = 34;
                    break;
                }
                case 19: {
                    n5 = 68;
                    break;
                }
                case 20: {
                    n5 = 190;
                    break;
                }
                case 21: {
                    n5 = 86;
                    break;
                }
                case 22: {
                    n5 = 187;
                    break;
                }
                case 23: {
                    n5 = 141;
                    break;
                }
                case 24: {
                    n5 = 148;
                    break;
                }
                case 25: {
                    n5 = 94;
                    break;
                }
                case 26: {
                    n5 = 83;
                    break;
                }
                case 27: {
                    n5 = 124;
                    break;
                }
                case 28: {
                    n5 = 107;
                    break;
                }
                case 29: {
                    n5 = 158;
                    break;
                }
                case 30: {
                    n5 = 69;
                    break;
                }
                case 31: {
                    n5 = 111;
                    break;
                }
                case 32: {
                    n5 = 186;
                    break;
                }
                case 33: {
                    n5 = 167;
                    break;
                }
                case 34: {
                    n5 = 71;
                    break;
                }
                case 35: {
                    n5 = 204;
                    break;
                }
                case 36: {
                    n5 = 123;
                    break;
                }
                case 37: {
                    n5 = 129;
                    break;
                }
                case 38: {
                    n5 = 241;
                    break;
                }
                case 39: {
                    n5 = 100;
                    break;
                }
                case 40: {
                    n5 = 181;
                    break;
                }
                case 41: {
                    n5 = 61;
                    break;
                }
                case 42: {
                    n5 = 9;
                    break;
                }
                case 43: {
                    n5 = 184;
                    break;
                }
                case 44: {
                    n5 = 214;
                    break;
                }
                case 45: {
                    n5 = 192;
                    break;
                }
                case 46: {
                    n5 = 153;
                    break;
                }
                case 47: {
                    n5 = 116;
                    break;
                }
                case 48: {
                    n5 = 85;
                    break;
                }
                case 49: {
                    n5 = 80;
                    break;
                }
                case 50: {
                    n5 = 109;
                    break;
                }
                case 51: {
                    n5 = 164;
                    break;
                }
                case 52: {
                    n5 = 127;
                    break;
                }
                case 53: {
                    n5 = 189;
                    break;
                }
                case 54: {
                    n5 = 99;
                    break;
                }
                case 55: {
                    n5 = 233;
                    break;
                }
                case 56: {
                    n5 = 101;
                    break;
                }
                case 57: {
                    n5 = 195;
                    break;
                }
                case 58: {
                    n5 = 185;
                    break;
                }
                case 59: {
                    n5 = 6;
                    break;
                }
                case 60: {
                    n5 = 13;
                    break;
                }
                case 61: {
                    n5 = 169;
                    break;
                }
                case 62: {
                    n5 = 172;
                    break;
                }
                case 63: {
                    n5 = 89;
                    break;
                }
                case 64: {
                    n5 = 66;
                    break;
                }
                case 65: {
                    n5 = 26;
                    break;
                }
                case 66: {
                    n5 = 144;
                    break;
                }
                case 67: {
                    n5 = 191;
                    break;
                }
                case 68: {
                    n5 = 84;
                    break;
                }
                case 69: {
                    n5 = 113;
                    break;
                }
                case 70: {
                    n5 = 152;
                    break;
                }
                case 71: {
                    n5 = 224;
                    break;
                }
                case 72: {
                    n5 = 244;
                    break;
                }
                case 73: {
                    n5 = 87;
                    break;
                }
                case 74: {
                    n5 = 209;
                    break;
                }
                case 75: {
                    n5 = 155;
                    break;
                }
                case 76: {
                    n5 = 49;
                    break;
                }
                case 77: {
                    n5 = 36;
                    break;
                }
                case 78: {
                    n5 = 17;
                    break;
                }
                case 79: {
                    n5 = 228;
                    break;
                }
                case 80: {
                    n5 = 11;
                    break;
                }
                case 81: {
                    n5 = 118;
                    break;
                }
                case 82: {
                    n5 = 73;
                    break;
                }
                case 83: {
                    n5 = 42;
                    break;
                }
                case 84: {
                    n5 = 79;
                    break;
                }
                case 85: {
                    n5 = 183;
                    break;
                }
                case 86: {
                    n5 = 110;
                    break;
                }
                case 87: {
                    n5 = 179;
                    break;
                }
                case 88: {
                    n5 = 217;
                    break;
                }
                case 89: {
                    n5 = 92;
                    break;
                }
                case 90: {
                    n5 = 237;
                    break;
                }
                case 91: {
                    n5 = 103;
                    break;
                }
                case 92: {
                    n5 = 221;
                    break;
                }
                case 93: {
                    n5 = 128;
                    break;
                }
                case 94: {
                    n5 = 8;
                    break;
                }
                case 95: {
                    n5 = 157;
                    break;
                }
                case 96: {
                    n5 = 31;
                    break;
                }
                case 97: {
                    n5 = 212;
                    break;
                }
                case 98: {
                    n5 = 223;
                    break;
                }
                case 99: {
                    n5 = 240;
                    break;
                }
                case 100: {
                    n5 = 231;
                    break;
                }
                case 101: {
                    n5 = 45;
                    break;
                }
                case 102: {
                    n5 = 91;
                    break;
                }
                case 103: {
                    n5 = 24;
                    break;
                }
                case 104: {
                    n5 = 211;
                    break;
                }
                case 105: {
                    n5 = 90;
                    break;
                }
                case 106: {
                    n5 = 202;
                    break;
                }
                case 107: {
                    n5 = 159;
                    break;
                }
                case 108: {
                    n5 = 2;
                    break;
                }
                case 109: {
                    n5 = 72;
                    break;
                }
                case 110: {
                    n5 = 16;
                    break;
                }
                case 111: {
                    n5 = 160;
                    break;
                }
                case 112: {
                    n5 = 125;
                    break;
                }
                case 113: {
                    n5 = 75;
                    break;
                }
                case 114: {
                    n5 = 193;
                    break;
                }
                case 115: {
                    n5 = 175;
                    break;
                }
                case 116: {
                    n5 = 251;
                    break;
                }
                case 117: {
                    n5 = 41;
                    break;
                }
                case 118: {
                    n5 = 213;
                    break;
                }
                case 119: {
                    n5 = 131;
                    break;
                }
                case 120: {
                    n5 = 134;
                    break;
                }
                case 121: {
                    n5 = 156;
                    break;
                }
                case 122: {
                    n5 = 27;
                    break;
                }
                case 123: {
                    n5 = 121;
                    break;
                }
                case 124: {
                    n5 = 133;
                    break;
                }
                case 125: {
                    n5 = 165;
                    break;
                }
                case 126: {
                    n5 = 146;
                    break;
                }
                case 127: {
                    n5 = 114;
                    break;
                }
                case 128: {
                    n5 = 82;
                    break;
                }
                case 129: {
                    n5 = 104;
                    break;
                }
                case 130: {
                    n5 = 254;
                    break;
                }
                case 131: {
                    n5 = 38;
                    break;
                }
                case 132: {
                    n5 = 194;
                    break;
                }
                case 133: {
                    n5 = 253;
                    break;
                }
                case 134: {
                    n5 = 232;
                    break;
                }
                case 135: {
                    n5 = 117;
                    break;
                }
                case 136: {
                    n5 = 206;
                    break;
                }
                case 137: {
                    n5 = 20;
                    break;
                }
                case 138: {
                    n5 = 177;
                    break;
                }
                case 139: {
                    n5 = 210;
                    break;
                }
                case 140: {
                    n5 = 50;
                    break;
                }
                case 141: {
                    n5 = 57;
                    break;
                }
                case 142: {
                    n5 = 200;
                    break;
                }
                case 143: {
                    n5 = 108;
                    break;
                }
                case 144: {
                    n5 = 35;
                    break;
                }
                case 145: {
                    n5 = 176;
                    break;
                }
                case 146: {
                    n5 = 21;
                    break;
                }
                case 147: {
                    n5 = 58;
                    break;
                }
                case 148: {
                    n5 = 255;
                    break;
                }
                case 149: {
                    n5 = 245;
                    break;
                }
                case 150: {
                    n5 = 252;
                    break;
                }
                case 151: {
                    n5 = 67;
                    break;
                }
                case 152: {
                    n5 = 166;
                    break;
                }
                case 153: {
                    n5 = 198;
                    break;
                }
                case 154: {
                    n5 = 171;
                    break;
                }
                case 155: {
                    n5 = 119;
                    break;
                }
                case 156: {
                    n5 = 238;
                    break;
                }
                case 157: {
                    n5 = 18;
                    break;
                }
                case 158: {
                    n5 = 5;
                    break;
                }
                case 159: {
                    n5 = 105;
                    break;
                }
                case 160: {
                    n5 = 247;
                    break;
                }
                case 161: {
                    n5 = 46;
                    break;
                }
                case 162: {
                    n5 = 22;
                    break;
                }
                case 163: {
                    n5 = 76;
                    break;
                }
                case 164: {
                    n5 = 246;
                    break;
                }
                case 165: {
                    n5 = 29;
                    break;
                }
                case 166: {
                    n5 = 230;
                    break;
                }
                case 167: {
                    n5 = 170;
                    break;
                }
                case 168: {
                    n5 = 12;
                    break;
                }
                case 169: {
                    n5 = 56;
                    break;
                }
                case 170: {
                    n5 = 115;
                    break;
                }
                case 171: {
                    n5 = 135;
                    break;
                }
                case 172: {
                    n5 = 55;
                    break;
                }
                case 173: {
                    n5 = 178;
                    break;
                }
                case 174: {
                    n5 = 188;
                    break;
                }
                case 175: {
                    n5 = 138;
                    break;
                }
                case 176: {
                    n5 = 54;
                    break;
                }
                case 177: {
                    n5 = 88;
                    break;
                }
                case 178: {
                    n5 = 149;
                    break;
                }
                case 179: {
                    n5 = 60;
                    break;
                }
                case 180: {
                    n5 = 28;
                    break;
                }
                case 181: {
                    n5 = 225;
                    break;
                }
                case 182: {
                    n5 = 220;
                    break;
                }
                case 183: {
                    n5 = 53;
                    break;
                }
                case 184: {
                    n5 = 81;
                    break;
                }
                case 185: {
                    n5 = 1;
                    break;
                }
                case 186: {
                    n5 = 126;
                    break;
                }
                case 187: {
                    n5 = 44;
                    break;
                }
                case 188: {
                    n5 = 132;
                    break;
                }
                case 189: {
                    n5 = 64;
                    break;
                }
                case 190: {
                    n5 = 97;
                    break;
                }
                case 191: {
                    n5 = 199;
                    break;
                }
                case 192: {
                    n5 = 14;
                    break;
                }
                case 193: {
                    n5 = 140;
                    break;
                }
                case 194: {
                    n5 = 203;
                    break;
                }
                case 195: {
                    n5 = 112;
                    break;
                }
                case 196: {
                    n5 = 154;
                    break;
                }
                case 197: {
                    n5 = 168;
                    break;
                }
                case 198: {
                    n5 = 10;
                    break;
                }
                case 199: {
                    n5 = 216;
                    break;
                }
                case 200: {
                    n5 = 102;
                    break;
                }
                case 201: {
                    n5 = 33;
                    break;
                }
                case 202: {
                    n5 = 219;
                    break;
                }
                case 203: {
                    n5 = 48;
                    break;
                }
                case 204: {
                    n5 = 43;
                    break;
                }
                case 205: {
                    n5 = 51;
                    break;
                }
                case 206: {
                    n5 = 249;
                    break;
                }
                case 207: {
                    n5 = 248;
                    break;
                }
                case 208: {
                    n5 = 180;
                    break;
                }
                case 209: {
                    n5 = 47;
                    break;
                }
                case 210: {
                    n5 = 208;
                    break;
                }
                case 211: {
                    n5 = 30;
                    break;
                }
                case 212: {
                    n5 = 93;
                    break;
                }
                case 213: {
                    n5 = 150;
                    break;
                }
                case 214: {
                    n5 = 143;
                    break;
                }
                case 215: {
                    n5 = 173;
                    break;
                }
                case 216: {
                    n5 = 74;
                    break;
                }
                case 217: {
                    n5 = 32;
                    break;
                }
                case 218: {
                    n5 = 163;
                    break;
                }
                case 219: {
                    n5 = 52;
                    break;
                }
                case 220: {
                    n5 = 106;
                    break;
                }
                case 221: {
                    n5 = 136;
                    break;
                }
                case 222: {
                    n5 = 161;
                    break;
                }
                case 223: {
                    n5 = 120;
                    break;
                }
                case 224: {
                    n5 = 59;
                    break;
                }
                case 225: {
                    n5 = 63;
                    break;
                }
                case 226: {
                    n5 = 62;
                    break;
                }
                case 227: {
                    n5 = 174;
                    break;
                }
                case 228: {
                    n5 = 3;
                    break;
                }
                case 229: {
                    n5 = 229;
                    break;
                }
                case 230: {
                    n5 = 23;
                    break;
                }
                case 231: {
                    n5 = 207;
                    break;
                }
                case 232: {
                    n5 = 15;
                    break;
                }
                case 233: {
                    n5 = 70;
                    break;
                }
                case 234: {
                    n5 = 7;
                    break;
                }
                case 235: {
                    n5 = 95;
                    break;
                }
                case 236: {
                    n5 = 239;
                    break;
                }
                case 237: {
                    n5 = 222;
                    break;
                }
                case 238: {
                    n5 = 40;
                    break;
                }
                case 239: {
                    n5 = 78;
                    break;
                }
                case 240: {
                    n5 = 4;
                    break;
                }
                case 241: {
                    n5 = 137;
                    break;
                }
                case 242: {
                    n5 = 236;
                    break;
                }
                case 243: {
                    n5 = 139;
                    break;
                }
                case 244: {
                    n5 = 235;
                    break;
                }
                case 245: {
                    n5 = 243;
                    break;
                }
                case 246: {
                    n5 = 205;
                    break;
                }
                case 247: {
                    n5 = 218;
                    break;
                }
                case 248: {
                    n5 = 151;
                    break;
                }
                case 249: {
                    n5 = 19;
                    break;
                }
                case 250: {
                    n5 = 96;
                    break;
                }
                case 251: {
                    n5 = 98;
                    break;
                }
                case 252: {
                    n5 = 145;
                    break;
                }
                case 253: {
                    n5 = 39;
                    break;
                }
                case 254: {
                    n5 = 142;
                    break;
                }
                default: {
                    n5 = 250;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            PKCS11Ops.g[n3] = new String(cArray).intern();
        }
        return g[n3];
    }
}

