/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.PathValidationRecord;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ATSHashIndexCollector;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignedDataValidation;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampV2AttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampV3AttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CAdES_C_TimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CertificateChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CertificateRefsValuesMatchChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckAllChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ContentTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ContentTypeAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CryptoChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.MessageDigestAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.RevocationRefsValuesMatchChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SignaturePolicyChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SignatureTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SigningCertificateAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampedCertsCrlsRefsAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ValidationState;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.signature.certval.CertificateSearchCriteria;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;

public class SignatureValidator {
    private static Logger a;
    private List<Checker> b = new ArrayList<Checker>();
    private List<ECertificate> c = new ArrayList<ECertificate>();
    private List<ECRL> d = new ArrayList<ECRL>();
    private List<EBasicOCSPResponse> e = new ArrayList<EBasicOCSPResponse>();
    BaseSignedData f = null;
    private byte[] g = null;
    private static final String[] h;
    private static final String[] i;

    public SignatureValidator(byte[] aContentInfo) throws CMSSignatureException {
        this.g = aContentInfo;
        this.f = new BaseSignedData(aContentInfo);
    }

    private ArrayList<Checker> a(ESignatureType eSignatureType) throws CMSSignatureException {
        ArrayList<Checker> arrayList = new ArrayList<Checker>();
        arrayList.add(new CryptoChecker());
        arrayList.add(new MessageDigestAttrChecker());
        arrayList.add(new SigningCertificateAttrChecker());
        arrayList.add(new CertificateChecker());
        if (eSignatureType == ESignatureType.TYPE_BES) {
            return arrayList;
        }
        ArrayList<Checker> arrayList2 = new ArrayList<Checker>();
        arrayList2.addAll(arrayList);
        if (eSignatureType == ESignatureType.TYPE_EPES) {
            return arrayList2;
        }
        ArrayList<Checker> arrayList3 = new ArrayList<Checker>();
        arrayList3.addAll(arrayList);
        arrayList3.add(new SignatureTimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_EST) {
            return arrayList3;
        }
        ArrayList<Checker> arrayList4 = new ArrayList<Checker>();
        arrayList4.addAll(arrayList3);
        if (eSignatureType == ESignatureType.TYPE_ESC) {
            return arrayList4;
        }
        ArrayList<Checker> arrayList5 = new ArrayList<Checker>();
        arrayList5.addAll(arrayList4);
        arrayList5.add(new CAdES_C_TimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESX_Type1) {
            return arrayList5;
        }
        ArrayList<Checker> arrayList6 = new ArrayList<Checker>();
        arrayList6.addAll(arrayList4);
        arrayList6.add(new TimeStampedCertsCrlsRefsAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESX_Type2) {
            return arrayList6;
        }
        ArrayList<Checker> arrayList7 = new ArrayList<Checker>();
        arrayList7.addAll(arrayList4);
        arrayList7.add(new RevocationRefsValuesMatchChecker());
        arrayList7.add(new CertificateRefsValuesMatchChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong) {
            return arrayList7;
        }
        ArrayList<Checker> arrayList8 = new ArrayList<Checker>();
        arrayList8.addAll(arrayList7);
        arrayList8.add(new CAdES_C_TimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong_Type1) {
            return arrayList8;
        }
        ArrayList<Checker> arrayList9 = new ArrayList<Checker>();
        arrayList9.addAll(arrayList7);
        arrayList9.add(new TimeStampedCertsCrlsRefsAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong_Type2) {
            return arrayList9;
        }
        ArrayList<Checker> arrayList10 = new ArrayList<Checker>();
        arrayList10.addAll(arrayList);
        ArrayList<Checker> arrayList11 = new ArrayList<Checker>();
        arrayList11.add(new CAdES_C_TimeStampAttrChecker());
        arrayList11.add(new TimeStampedCertsCrlsRefsAttrChecker());
        arrayList10.add(new CheckAllChecker(arrayList11, false));
        ArrayList<Checker> arrayList12 = new ArrayList<Checker>();
        arrayList12.add(new ArchiveTimeStampAttrChecker());
        arrayList12.add(new ArchiveTimeStampV2AttrChecker());
        arrayList12.add(new ArchiveTimeStampV3AttrChecker());
        arrayList10.add(new CheckAllChecker(arrayList12, true));
        if (eSignatureType == ESignatureType.TYPE_ESA) {
            return arrayList10;
        }
        throw new CMSSignatureException(SignatureValidator.a(29580, -31406));
    }

    public void setCertificates(List<ECertificate> aCerts) {
        this.c = aCerts;
    }

    public void setCRLs(List<ECRL> aCRLs) {
        this.d = aCRLs;
    }

    public void setOCSPs(List<EBasicOCSPResponse> aOCSPs) {
        this.e = aOCSPs;
    }

    List<Checker> a(Signer signer, boolean bl, ESignatureType eSignatureType, Map<String, Object> map) throws CMSSignatureException {
        ArrayList<Checker> arrayList;
        block35: {
            block31: {
                block34: {
                    boolean bl2;
                    block33: {
                        block32: {
                            arrayList = this.a(eSignatureType);
                            bl2 = Types.b;
                            if (!bl) {
                                arrayList.add(new ContentTypeAttrChecker());
                            }
                            if (signer.getType() != ESignatureType.TYPE_ESA) break block31;
                            if (!signer._checkIfSignerIsESAV2()) break block32;
                            arrayList.add(new SignatureTimeStampAttrChecker());
                            arrayList.add(new RevocationRefsValuesMatchChecker());
                            arrayList.add(new CertificateRefsValuesMatchChecker());
                            if (!bl2) break block31;
                        }
                        if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_signatureTimeStampToken).size() <= 0) break block33;
                        arrayList.add(new SignatureTimeStampAttrChecker());
                    }
                    if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certValues).size() <= 0 || signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationValues).size() <= 0) break block34;
                    arrayList.add(new RevocationRefsValuesMatchChecker());
                    arrayList.add(new CertificateRefsValuesMatchChecker());
                    if (!bl2) break block31;
                }
                if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certificateRefs).size() != 0) break block31;
                if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationRefs).size() != 0) break block31;
                map.put(SignatureValidator.a(29624, 2502), true);
            }
            if (signer.getSignedAttribute(AttributeOIDs.id_aa_ets_sigPolicyId).size() > 0) {
                arrayList.add(new SignaturePolicyChecker());
            }
            if (!signer.isTurkishProfile() || Boolean.TRUE.equals(map.get(SignatureValidator.a(29607, 22489)))) break block35;
            arrayList.add(new TurkishProfileAttributesChecker());
        }
        if (signer.getSignedAttribute(AttributeOIDs.id_aa_ets_contentTimestamp).size() > 0) {
            arrayList.add(new ContentTimeStampAttrChecker());
        }
        return arrayList;
    }

    public void verify(SignatureValidationResult aSVR, Signer aSigner, boolean aIsCounterSigner, Map<String, Object> aParams) throws CMSSignatureException {
        List<EBasicOCSPResponse> list;
        HashMap<String, Object> hashMap;
        boolean bl;
        block28: {
            List<ECRL> list2;
            block31: {
                boolean bl2;
                block29: {
                    block30: {
                        Object object;
                        block27: {
                            Object object2;
                            ESignatureType eSignatureType = aSigner.getType();
                            List<Checker> list3 = this.a(aSigner, aIsCounterSigner, eSignatureType, aParams);
                            bl = Types.b;
                            ECertificate eCertificate = this.a(this.c, aSigner.getSignerInfo().getSignerIdentifier(), aParams);
                            if (eCertificate == null) {
                                throw new CMSSignatureException(SignatureValidator.a(29569, -13727));
                            }
                            this.a(eCertificate);
                            hashMap = new HashMap<String, Object>();
                            hashMap.put(SignatureValidator.a(29578, 8798), eCertificate);
                            hashMap.put(SignatureValidator.a(29618, 22011), this.f.getSignedData());
                            hashMap.put(SignatureValidator.a(29605, 24801), this.c);
                            hashMap.put(SignatureValidator.a(29620, 2424), this.d);
                            hashMap.put(SignatureValidator.a(29627, 18179), this.e);
                            hashMap.put(SignatureValidator.a(29629, -20600), this.g);
                            if (aParams != null) {
                                hashMap.putAll(aParams);
                            }
                            this.a(hashMap);
                            aSVR.setSignerCertificate((ECertificate)hashMap.get(SignatureValidator.a(29578, 8798)));
                            if (eSignatureType == ESignatureType.TYPE_ESA) {
                                SignedDataValidation signedDataValidation = new SignedDataValidation();
                                signedDataValidation._fillCertRevocationLists(this.f.getSignedData(), aSigner, aParams);
                                hashMap.put(SignatureValidator.a(29617, 80), signedDataValidation.mCerts);
                                hashMap.put(SignatureValidator.a(29616, 4149), signedDataValidation.mCRLs);
                                hashMap.put(SignatureValidator.a(29623, -11255), signedDataValidation.mOCSPs);
                                if (aSigner._checkIfSignerIsESAV3()) {
                                    object2 = new ATSHashIndexCollector();
                                    ((ATSHashIndexCollector)object2).checkATSHashIndex(aSigner);
                                    object = signedDataValidation.mCerts;
                                    list2 = signedDataValidation.mCRLs;
                                    list = signedDataValidation.mOCSPs;
                                    object.removeAll(((ATSHashIndexCollector)object2).a);
                                    list2.removeAll(((ATSHashIndexCollector)object2).b);
                                    list.removeAll(((ATSHashIndexCollector)object2).c);
                                    hashMap.put(SignatureValidator.a(29617, 80), object);
                                    hashMap.put(SignatureValidator.a(29616, 4149), list2);
                                    hashMap.put(SignatureValidator.a(29623, -11255), list);
                                }
                            }
                            bl2 = true;
                            object2 = new ArrayList<Checker>();
                            object2.addAll(this.b);
                            object2.addAll(list3);
                            object = object2.iterator();
                            while (object.hasNext()) {
                                list2 = (Checker)object.next();
                                list2.setParameters(hashMap);
                                list = new CheckerResult();
                                boolean bl3 = list2.check(aSigner, (CheckerResult)((Object)list));
                                aSVR.addCheckResult((CheckerResult)((Object)list));
                                if (bl2) {
                                    bl2 = bl3;
                                }
                                if (!bl) continue;
                                int n = BaseChecker.d;
                                BaseChecker.d = ++n;
                                break;
                            }
                            object = aSVR.getSignatureStatus();
                            list2 = aSVR;
                            if (object != Types.Signature_Status.INVALID) break block27;
                            ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                            ((SignatureValidationResult)((Object)list2)).setDescription(SignatureValidator.a(29577, -3747));
                            ((SignatureValidationResult)((Object)list2)).getCheckerResults().add(this.a(Types.CheckerResult_Status.UNSUCCESS));
                            if (!bl) break block28;
                        }
                        if (object != Types.Signature_Status.INCOMPLETE) break block29;
                        ((SignatureValidationResult)((Object)list2)).getCheckerResults().add(this.a(Types.CheckerResult_Status.UNSUCCESS));
                        if (bl2) break block30;
                        ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                        this.a((SignatureValidationResult)((Object)list2));
                        if (!bl) break block28;
                    }
                    ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INCOMPLETE);
                    ((SignatureValidationResult)((Object)list2)).setDescription(SignatureValidator.a(29577, -3747));
                    if (!bl) break block28;
                }
                if (bl2) break block31;
                ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                this.a((SignatureValidationResult)((Object)list2));
                if (!bl) break block28;
            }
            this.b((SignatureValidationResult)((Object)list2));
            ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.VALID);
        }
        list = aSigner.getCounterSigners();
        for (Signer signer : list) {
            this.a(aSigner, signer, aSVR, hashMap);
            if (!bl) continue;
        }
    }

    private CheckerResult a(Types.CheckerResult_Status checkerResult_Status) {
        CheckerResult checkerResult;
        block5: {
            block4: {
                checkerResult = new CheckerResult();
                boolean bl = Types.b;
                checkerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_CHECKER, new String[0]), c.class);
                checkerResult.setResultStatus(checkerResult_Status);
                if (checkerResult_Status != Types.CheckerResult_Status.SUCCESS) break block4;
                checkerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_VALID, new String[0])));
                if (!bl) break block5;
            }
            checkerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_INVALID, new String[0])));
        }
        return checkerResult;
    }

    private void a(Signer signer, Signer signer2, SignatureValidationResult signatureValidationResult, Map<String, Object> map) throws CMSSignatureException {
        Serializable serializable;
        ECertificate eCertificate;
        block12: {
            map.put(SignatureValidator.a(29609, -31029), signer.getSignerInfo());
            eCertificate = this.a(this.c, signer2.getSignerInfo().getSignerIdentifier(), map);
            if (eCertificate == null) {
                throw new CMSSignatureException(SignatureValidator.a(29630, -17126));
            }
            map.put(SignatureValidator.a(29625, 17083), eCertificate);
            try {
                if (map.containsKey(SignatureValidator.a(29626, -21773))) break block12;
                serializable = signer2.getESAv2Time();
                if (serializable == null) {
                    serializable = signer2.getESAv3Time();
                }
                if (serializable != null) {
                    map.put(SignatureValidator.a(29613, -2317), serializable);
                }
            }
            catch (ESYAException eSYAException) {
                a.warn(SignatureValidator.a(29601, -5162), (Throwable)eSYAException);
                throw new CMSSignatureException(SignatureValidator.a(29604, -12467));
            }
        }
        serializable = new SignatureValidationResult();
        if (signatureValidationResult.getSignatureStatus() != Types.Signature_Status.VALID) {
            ((SignatureValidationResult)serializable).setSignatureStatus(signatureValidationResult.getSignatureStatus());
        }
        this.verify((SignatureValidationResult)serializable, signer2, true, map);
        ((SignatureValidationResult)serializable).setSignerCertificate(eCertificate);
        signatureValidationResult.addCounterSigValidationResult((SignatureValidationResult)serializable);
        map.remove(SignatureValidator.a(29613, -2317));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate) {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(SignatureValidator.a(29631, 17825))) return;
            throw new ESYARuntimeException(SignatureValidator.a(29619, -17513));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SignatureValidator.a(29621, -15018) + lE.getMessage());
        }
    }

    private void a(Map<String, Object> map) {
        block39: {
            block38: {
                boolean bl;
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        bl = Types.b;
                                        if (map.containsKey(SignatureValidator.a(29612, 22095))) break block32;
                                        map.put(SignatureValidator.a(29608, -2491), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!a.isDebugEnabled()) break block33;
                                        a.debug(SignatureValidator.a(29600, 17332));
                                        if (!bl) break block33;
                                    }
                                    if (map.get(SignatureValidator.a(29608, -2491)) instanceof Boolean) break block33;
                                    map.put(SignatureValidator.a(29608, -2491), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                    a.debug(SignatureValidator.a(29611, -30076));
                                }
                                if (map.containsKey(SignatureValidator.a(29583, 13586))) break block34;
                                map.put(SignatureValidator.a(29614, 22860), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!a.isDebugEnabled()) break block35;
                                a.debug(SignatureValidator.a(29628, -18530) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (!bl) break block35;
                            }
                            if (map.get(SignatureValidator.a(29614, 22860)) instanceof Long) break block35;
                            map.put(SignatureValidator.a(29614, 22860), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                            a.debug(SignatureValidator.a(29581, -16883) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                        }
                        if (map.containsKey(SignatureValidator.a(29622, -2135))) break block36;
                        map.put(SignatureValidator.a(29615, 22546), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!a.isDebugEnabled()) break block37;
                        a.debug(SignatureValidator.a(29582, -4143) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (!bl) break block37;
                    }
                    if (map.get(SignatureValidator.a(29615, 22546)) instanceof Long) break block37;
                    map.put(SignatureValidator.a(29615, 22546), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                    a.debug(SignatureValidator.a(29606, -31344) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                }
                if (map.containsKey(SignatureValidator.a(29603, -10006))) break block38;
                map.put(SignatureValidator.a(29602, 15521), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!a.isDebugEnabled()) break block39;
                a.debug(SignatureValidator.a(29576, 28069) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (!bl) break block39;
            }
            if (map.get(SignatureValidator.a(29602, 15521)) instanceof Boolean) break block39;
            map.put(SignatureValidator.a(29602, 15521), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
            a.debug(SignatureValidator.a(29610, 19444) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
        }
    }

    private ECertificate a(List<ECertificate> list, ESignerIdentifier eSignerIdentifier, Map<String, Object> map) {
        Iterator<ECertificate> iterator = list.iterator();
        boolean bl = Types.b;
        while (iterator.hasNext()) {
            ECertificate eCertificate = iterator.next();
            if (eSignerIdentifier.isEqual(eCertificate)) {
                return eCertificate;
            }
            if (!bl) continue;
        }
        return this.a(eSignerIdentifier, map);
    }

    private ECertificate a(ESignerIdentifier eSignerIdentifier, Map<String, Object> map) {
        ECertificate eCertificate;
        block10: {
            List list;
            block8: {
                CertificateSearchCriteria certificateSearchCriteria;
                boolean bl;
                block9: {
                    eCertificate = null;
                    bl = Types.b;
                    certificateSearchCriteria = null;
                    if (eSignerIdentifier.getIssuerAndSerialNumber() != null) {
                        certificateSearchCriteria = new CertificateSearchCriteria(eSignerIdentifier.getIssuerAndSerialNumber().getIssuer().stringValue(), eSignerIdentifier.getIssuerAndSerialNumber().getSerialNumber());
                    } else if (eSignerIdentifier.getSubjectKeyIdentifier() != null) {
                        certificateSearchCriteria = new CertificateSearchCriteria(eSignerIdentifier.getSubjectKeyIdentifier());
                    }
                    if (certificateSearchCriteria != null) break block9;
                    eCertificate = null;
                    if (!bl) break block10;
                }
                ValidationInfoResolver validationInfoResolver = new ValidationInfoResolver();
                validationInfoResolver.addCertificates(this.c);
                list = validationInfoResolver.resolve(certificateSearchCriteria);
                if (list != null && list.size() != 0) break block8;
                eCertificate = null;
                if (!bl) break block10;
            }
            eCertificate = (ECertificate)list.get(0);
        }
        return eCertificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(SignatureValidationResult signatureValidationResult) {
        block18: {
            boolean bl;
            block22: {
                block21: {
                    CheckerResult checkerResult;
                    List<CheckerResult> list = signatureValidationResult.getCheckerResults();
                    CertificateStatusInfo certificateStatusInfo = list.iterator();
                    bl = Types.b;
                    while (certificateStatusInfo.hasNext()) {
                        checkerResult = certificateStatusInfo.next();
                        if (checkerResult.getResultStatus() != Types.CheckerResult_Status.SUCCESS && !checkerResult.getCheckerClass().equals(CertificateChecker.class)) {
                            signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                            signatureValidationResult.setDescription(SignatureValidator.a(29579, 22859));
                            return;
                        }
                        if (!bl) continue;
                    }
                    if ((certificateStatusInfo = signatureValidationResult.getCertStatusInfo()) == null || certificateStatusInfo.getValidationHistory() == null || certificateStatusInfo.getValidationHistory().size() == 0) {
                        signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                        signatureValidationResult.setDescription(SignatureValidator.a(29577, -3747));
                        if (!bl) return;
                    }
                    if ((checkerResult = certificateStatusInfo.getCertificateStatus()) != CertificateStatus.PATH_VALIDATION_FAILURE) break block18;
                    List list2 = certificateStatusInfo.getValidationHistory();
                    boolean bl2 = true;
                    for (PathValidationRecord pathValidationRecord : list2) {
                        block20: {
                            block19: {
                                if (pathValidationRecord.getResultCode() != PathValidationResult.REVOCATION_CONTROL_FAILURE) break block19;
                                bl2 = true;
                                if (!bl) break block20;
                            }
                            bl2 = false;
                        }
                        if (!bl) continue;
                    }
                    if (!bl2) break block21;
                    signatureValidationResult.setSignatureStatus(Types.Signature_Status.INCOMPLETE);
                    signatureValidationResult.setDescription(SignatureValidator.a(29577, -3747));
                    if (!bl) break block22;
                }
                signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                signatureValidationResult.setDescription(SignatureValidator.a(29577, -3747));
            }
            if (!bl) return;
        }
        signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
        signatureValidationResult.setDescription(SignatureValidator.a(29577, -3747));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(SignatureValidationResult signatureValidationResult) {
        int n;
        OCSPResponseStatusInfo oCSPResponseStatusInfo;
        List list;
        boolean bl;
        Calendar calendar;
        block11: {
            block13: {
                block12: {
                    CertificateStatusInfo certificateStatusInfo = signatureValidationResult.getCertStatusInfo();
                    calendar = signatureValidationResult.getSigningTime();
                    List list2 = certificateStatusInfo.getOCSPResponseInfoList();
                    bl = Types.b;
                    list = certificateStatusInfo.getCRLInfoList();
                    if (list2.size() == 0) break block11;
                    oCSPResponseStatusInfo = (OCSPResponseStatusInfo)list2.get(0);
                    for (n = 1; n < list2.size(); ++n) {
                        if (!((OCSPResponseStatusInfo)list2.get(n)).getOCSPResponse().getBasicOCSPResponse().getProducedAt().after(oCSPResponseStatusInfo.getOCSPResponse().getBasicOCSPResponse().getProducedAt())) continue;
                        oCSPResponseStatusInfo = (OCSPResponseStatusInfo)list2.get(n);
                        if (!bl) continue;
                    }
                    if (!oCSPResponseStatusInfo.getOCSPResponse().getBasicOCSPResponse().getProducedAt().after(calendar)) break block12;
                    signatureValidationResult.setValidationState(ValidationState.MATURE);
                    if (!bl) break block13;
                }
                signatureValidationResult.setValidationState(ValidationState.PREMATURE);
            }
            if (!bl) return;
        }
        if (list.size() == 0) return;
        oCSPResponseStatusInfo = (CRLStatusInfo)list.get(0);
        for (n = 1; n < list.size(); ++n) {
            if (!((CRLStatusInfo)list.get(n)).getCRL().getThisUpdate().after(oCSPResponseStatusInfo.getCRL().getThisUpdate())) continue;
            oCSPResponseStatusInfo = (CRLStatusInfo)list.get(n);
            if (!bl) continue;
        }
        if (oCSPResponseStatusInfo.getCRL().getThisUpdate().after(calendar)) {
            signatureValidationResult.setValidationState(ValidationState.MATURE);
            if (!bl) return;
        }
        signatureValidationResult.setValidationState(ValidationState.PREMATURE);
    }

    protected void setUserDefinedCheckers(List<Checker> aUserDefinedCheckers) {
        this.b = aUserDefinedCheckers;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[41];
                var3_1 = 0;
                var2_2 = "\u0010\u000bf\u00ed4\u00cd\u0099O\u00f6\nZ\u00cf9Z\u00bd\u00e4\u0088\u001f\u00c7w\u0017\u0015\u00f2\u00c2\u00c1#/\u0086\u00cc@\n\u000f\u009f[s\u0003\u00a0\u00e8\u00fe\u00c8&\u00e9\u00b6\u00acX\u00de\u0082\u00bb\u00cf\f\u00eec\u00f4\u00fc\r\u0098\u007f\u00a9o]##\u008e\u00b1(\u00c6wI~8zW*\u00f4pD\u00db\u00f0\u00ce\u0003\u00d3ky~\u0089e*\u0006\u00dbQ_P\u0084\u0013F\u00cb\u00a8\u00e6n\u00cb/Pu\u0099\u00a9\u00ed\u008f=\u0099i\u00bb\u00c7\u00a2\u0001\u00a4R\u0005\u00da\u00a8\u00fc-\u00b8\u00abc\u00f2\u009b\u00e5\u00f5\u0003\u00a7\u00f2\u00c3\u00d2H\u001d\u00b2G\u0083\u00c3\t\u009a\u00f4\u00d9\u0003lp\u0004\u00a4\u0088#\u0099\u00f3\u0098\u000eQ\u0013r\u0000\u001b\u00a1\u0017\u00c9\u0001\u00ac\u00a7\u00b8A]\f\u008e\u00caIr<\u0091\u0001\u001c\u00b7AT\u00fd}lwc\u00ae\u00f5\u00f0\u0001\u0010\u00c5\u00f98\u001d\u00db\u00f4\u00b6\u0086\u00af\u00d0\u00cd\u0083\f\u00b7\u00851\u0011\u00fa\u00a9;\u00b9\u009fG\u00ec\u001eX6\u0095\u009a\u0088'\u00a3j?\u0017\u0001P@\u0095s\u00a5\u008c\u009d\u0001 '\u00da^\u00db\u00a3\u00b5\u00fc\\Jr\u00b9<\u00a6\"u}\u00ce-\u00bb\u001a\u00a9\u00a0dVt\u0084/\u00a7\u0084\u000f7\u00bf\u00cePm\u00d6\u0095\u000fd\u00fc\u0085\u00f7\u000e\u0099\r/\u00b3m\u000e\u0094\u00d5\u00e1%\"\u00a3!O\u0084v\u00e1\u009a7>\u001d\u0019m\u0082\u00f7\u00f5o\u00d4!e\u0000\u00b1\u0000'\u0017\u0081\u0015\u0089\u00e3I\u009e\n4\u00ac\u00cciL\u00ed\u00e2z]9\u00e0G\u0083\u0093g\u0090\u00c5\u0082+W\u00bbP\u00f7b0\u00c4\u00ecMdY\u00fe\u00baOF\\\u0098\u00ee\r\u00e8{\u00c8\u0017\u00ac\u00fe\u008d\u00a6\u00ac\u00e6\u00b2\"\u0096J\u00a6\u00ce5t\u00f4\u00e4\u0086?\u00d1y\u00a6\u00c7\u0093Q\u00e4\u000fNw\u0018Z2x\u00ce\u00bf\u000exn\u00d3\u00f5\u00b1~\u00fb\u001f\u00c8\u00ddS\u00b1}\u0087\u009aP\u0092\\\u00e6\u0016iXZ\u00c0e\u000es\u0017\u0013h\u00bc\u00b1\u000b\u009a;\u0097\u00f8\u00ec\u0018\u00f8\u000e@\u00bbu\u00fdp\u0003\u0092\u00cc\b]\u009e\u00b5\u00d4\u00d3\u0012X\u008f~p\u001a\u00c8\u008c\u00a7\u00f5#\u0096\f\u00a7\u0005\u009a\u00c2\u0011\u00acH\u0011\u00fd\u00d3\u0095\u00c4L\u0082\u0081\u00ac$\u0091\u00dd7\u00aa@\u00d7*s\u00bc\u0013\u001f\u0087\u00b2\u00f4)\u00cc\u001f\u00b8\u008f\u0089`\u0004o\u00ca\u00c0xH\u001bZ}\u00c6\u000f\u00db\u00aa\u0004d\u0097I\u0006\fC\u0006\u009bm!\u00d3!S\u00c9\u0004\u00b9\u00e6\u0080\u00dc\u001am\u0000\u000b\u00fez\u00db\u0085\u0011\u00980w\u008a\u0000!\u00d6\u00d9\u00ad\u00a8\u00b2\u00cb\u00e4\u00e3\u00ef\u00ed)g>`\u00120\u000f\u0007\"\u009c\u0007[\u00db9\u00f9\"\u00ef\u001c\n\u0081\u00bf\u0097,^\u000f\t\u00d4\u00fdGHZj\u000b\u00d2X!\u009a\u0090\u00b3\u00ef*\u00b6\u00b6r\u00ccr\u0006M\u0092\u0090\u00f9\u0089\u00ce\u0016\u00e5>\u00cc\u00df\u00feR\u001d\u00bb\u00ba~I\u00e4@\u00bbE5\u00e5\u00a3\u0014e\u000b\u00c9.)7/B\u00ce=\u0005\u00aa\u00c1\u00ae\u00893\u00a1\u00dd%\u0007\u00c3<\u0095\u00bfL\u0011\u0081\u0004\u00c4`\u00aa&\u0015\u0081PW\u008ed\u00a3#\u00f2^\u00e8^\u001c\u00ees\u00c3\u00eb?\u00c96\u001a\u00a3\u0011\u00a21%\u00b8\u00f8$\f\b\u0088\u0099N\u009fvy)\u00d5\u00f2\u001a\u00f1\u00e3K\u00fd\u00bcyY\u0095o\u00fc\u00eeP\u00e5\u00b4\u0006\u00f0\u00c8o\u0018\u00fa\u00f7f\u00f7WEp\u0011\u00c5\\\u00dc\u0007c\u0090s\u00e4\u00abi\u00ebqGZZ\u00c5\u0000\u0014\u00c0\u00cfo{x\u00c1\u0084\u00e74JhCw\u00e9p\u00c4\u008d\u00bfv&E\u00fb\u00b4\f\t\u009f&\u0096\u00ffr`?X\u00ecfTm\u00a1\u00d8\u00e8\u0016|9>\u00c1W\u009d\u00e1\u009e\u0000\u0085\u00b9kNp\u00e9\u00a8\u00b8&`\u0017\u0007\u0015\u00c0X\u001a\u00c6\u00aebrX\u007f\u0011+#1\u0089>\b/\u00ddB\u0083o~\u0099H\u00c4\u00b2\u001e\u0004 4\u00e3B!h\u00ec=\u00ce\u00b9T\u0097\u00ba\u00ae`\u0011\u00a9\u00e2Q\u00da\u0012N\u0013\u00e3\u0094p\u00bc*z\u00a4\u00fe\u00c69\u00dc\u00e5\u0019z^\u0012\u00d35\u000f'4\"I\u00faM\u0088\u0081yE\u00ab\u00c6\u0017\u009a\u0016\n\u00ed\u0080\u00c8\u0091\u00cc\u00f4V7\u00b0\u00c3n\u0083\u00c8\u0019\u00c2`AVOO:\u00d1>\u00db\u00b3\u00a2&\u00b8\u009c\u0086u_\u00d0\u001f\u00a4\u00d1G\u00c4\u0019\u0092_Q^\u0090y\u0081\u00a1\u000e\r\u0006l6\u0085\u00f4\u0010\u00a5\u00e7iiA\u0019\u001d\u00c43\u0001v\u00f2\u0090.\u00e5\u00f7-T.V\u00fb\u0093\u0085\u00bd\u00bc\u00fdQ\u001f{@\u008a\u0004w\\\u00a1\u00c6\u00ce\u00ca\u00cftv\u00d8\u00c2\u008d\u0007C\u000b\u00ea9\u00fdv\u00af4\u00fek\u000bBe\u0005\u00a5u\u00d6z\u0091M\u00ea\r\u0007\u00b7\u0087r~<l\u000b\"\u0087\u00c8\u0098m\u001b=\u00de\u007f\u0087l\u0092Gk\u00bekXL\u00c2\u0090\u00e0\u00ce\u00cb\u00e5\u00d4\u00cc\u00bc\u00f2\u00c5\u001d\u00a69\u009d\n\u001a\u00db6\u00fa\u0013\u0099\u00ad\u009a\u00cfv\u001aO\u00ee\u009c\\FM\u0006\u0013\u0084,\u0093JJ\u00f7\u00f3\u0098vb\u00cf[\rR\u00a8\u00d1\u00ae\u00a0\"5\u00b5\u00c64\u00ba9\u0089\u00c4`\u00da\u00f4\u0015?\u0095\u0086Iww\u00c6Il\u00f5\u00b5k`p\u0005f\u001e\u00ab\u000fi\u00f3\u00a5\u0012U\u0094\u00deJ>\u001c\u00c5gU|\u0083\u00c5\u00a3\u00dd\u00f5\u008at\fE{\u00e5\u001c#\u009dc\u00d6Wzu>\u00fa\u00cc2P\u00e7!\u0089\u00f8<~|~i_\u0088\u00e0< \u00d1\u00bd\u00e1\u00ce!\u00f9\u0082\u00bac \u00bf\u000f\u0000\u00c1\u00fa:\u0092\u00aa\u00e8\u00f2\to;)fq!6\u001d.\u007fb\u00d7k\u00f4\u0019\u0019\u00d4\u0098\u001c\u0012,G\u00f10\u00dbSy\u008e\u00c2Aqb\u00fd)>\u0014\r\u00df\u0015]\u00c7\u00cc|\u0017\u00fdM9\u0093\u0091\u00e73\u00d9\u0096%W\u00e3^\u00ad\u00e8\u00d0Hh\u00c3\u00e9\u00ad\u0016\u00cc L\u0080\u0001\u0087\u008b\u0080L\u00e2e:q\u00e0V\u00d39\"E\u0011\tV\u00dc)\u000e\u00a2\u00ec\u00e1\u00d7\u0018\u00dfHc\"y\u009b\u00a9]\u00a2i\u00f6\u00f8)\u00cc\u00f3b\u00fen\u0003\u00e5\u0094\u0002\u0087\u008a\u00de\u0085\u0001\\8\u00f2\u0007fyy\u00e8+\u00da\u0016\u00d5\u0082`\u00e4\u00b1\u0014\u0093t\u009f\u00ad\u00d4o,s\u00f2\u00fb\u008e\u001a\u00bcBp4\u000elW\u00feu\u00c1\u00a9]\u000e\u000b^\u0010\u009f\t\u009e";
                var4_3 = "\u0010\u000bf\u00ed4\u00cd\u0099O\u00f6\nZ\u00cf9Z\u00bd\u00e4\u0088\u001f\u00c7w\u0017\u0015\u00f2\u00c2\u00c1#/\u0086\u00cc@\n\u000f\u009f[s\u0003\u00a0\u00e8\u00fe\u00c8&\u00e9\u00b6\u00acX\u00de\u0082\u00bb\u00cf\f\u00eec\u00f4\u00fc\r\u0098\u007f\u00a9o]##\u008e\u00b1(\u00c6wI~8zW*\u00f4pD\u00db\u00f0\u00ce\u0003\u00d3ky~\u0089e*\u0006\u00dbQ_P\u0084\u0013F\u00cb\u00a8\u00e6n\u00cb/Pu\u0099\u00a9\u00ed\u008f=\u0099i\u00bb\u00c7\u00a2\u0001\u00a4R\u0005\u00da\u00a8\u00fc-\u00b8\u00abc\u00f2\u009b\u00e5\u00f5\u0003\u00a7\u00f2\u00c3\u00d2H\u001d\u00b2G\u0083\u00c3\t\u009a\u00f4\u00d9\u0003lp\u0004\u00a4\u0088#\u0099\u00f3\u0098\u000eQ\u0013r\u0000\u001b\u00a1\u0017\u00c9\u0001\u00ac\u00a7\u00b8A]\f\u008e\u00caIr<\u0091\u0001\u001c\u00b7AT\u00fd}lwc\u00ae\u00f5\u00f0\u0001\u0010\u00c5\u00f98\u001d\u00db\u00f4\u00b6\u0086\u00af\u00d0\u00cd\u0083\f\u00b7\u00851\u0011\u00fa\u00a9;\u00b9\u009fG\u00ec\u001eX6\u0095\u009a\u0088'\u00a3j?\u0017\u0001P@\u0095s\u00a5\u008c\u009d\u0001 '\u00da^\u00db\u00a3\u00b5\u00fc\\Jr\u00b9<\u00a6\"u}\u00ce-\u00bb\u001a\u00a9\u00a0dVt\u0084/\u00a7\u0084\u000f7\u00bf\u00cePm\u00d6\u0095\u000fd\u00fc\u0085\u00f7\u000e\u0099\r/\u00b3m\u000e\u0094\u00d5\u00e1%\"\u00a3!O\u0084v\u00e1\u009a7>\u001d\u0019m\u0082\u00f7\u00f5o\u00d4!e\u0000\u00b1\u0000'\u0017\u0081\u0015\u0089\u00e3I\u009e\n4\u00ac\u00cciL\u00ed\u00e2z]9\u00e0G\u0083\u0093g\u0090\u00c5\u0082+W\u00bbP\u00f7b0\u00c4\u00ecMdY\u00fe\u00baOF\\\u0098\u00ee\r\u00e8{\u00c8\u0017\u00ac\u00fe\u008d\u00a6\u00ac\u00e6\u00b2\"\u0096J\u00a6\u00ce5t\u00f4\u00e4\u0086?\u00d1y\u00a6\u00c7\u0093Q\u00e4\u000fNw\u0018Z2x\u00ce\u00bf\u000exn\u00d3\u00f5\u00b1~\u00fb\u001f\u00c8\u00ddS\u00b1}\u0087\u009aP\u0092\\\u00e6\u0016iXZ\u00c0e\u000es\u0017\u0013h\u00bc\u00b1\u000b\u009a;\u0097\u00f8\u00ec\u0018\u00f8\u000e@\u00bbu\u00fdp\u0003\u0092\u00cc\b]\u009e\u00b5\u00d4\u00d3\u0012X\u008f~p\u001a\u00c8\u008c\u00a7\u00f5#\u0096\f\u00a7\u0005\u009a\u00c2\u0011\u00acH\u0011\u00fd\u00d3\u0095\u00c4L\u0082\u0081\u00ac$\u0091\u00dd7\u00aa@\u00d7*s\u00bc\u0013\u001f\u0087\u00b2\u00f4)\u00cc\u001f\u00b8\u008f\u0089`\u0004o\u00ca\u00c0xH\u001bZ}\u00c6\u000f\u00db\u00aa\u0004d\u0097I\u0006\fC\u0006\u009bm!\u00d3!S\u00c9\u0004\u00b9\u00e6\u0080\u00dc\u001am\u0000\u000b\u00fez\u00db\u0085\u0011\u00980w\u008a\u0000!\u00d6\u00d9\u00ad\u00a8\u00b2\u00cb\u00e4\u00e3\u00ef\u00ed)g>`\u00120\u000f\u0007\"\u009c\u0007[\u00db9\u00f9\"\u00ef\u001c\n\u0081\u00bf\u0097,^\u000f\t\u00d4\u00fdGHZj\u000b\u00d2X!\u009a\u0090\u00b3\u00ef*\u00b6\u00b6r\u00ccr\u0006M\u0092\u0090\u00f9\u0089\u00ce\u0016\u00e5>\u00cc\u00df\u00feR\u001d\u00bb\u00ba~I\u00e4@\u00bbE5\u00e5\u00a3\u0014e\u000b\u00c9.)7/B\u00ce=\u0005\u00aa\u00c1\u00ae\u00893\u00a1\u00dd%\u0007\u00c3<\u0095\u00bfL\u0011\u0081\u0004\u00c4`\u00aa&\u0015\u0081PW\u008ed\u00a3#\u00f2^\u00e8^\u001c\u00ees\u00c3\u00eb?\u00c96\u001a\u00a3\u0011\u00a21%\u00b8\u00f8$\f\b\u0088\u0099N\u009fvy)\u00d5\u00f2\u001a\u00f1\u00e3K\u00fd\u00bcyY\u0095o\u00fc\u00eeP\u00e5\u00b4\u0006\u00f0\u00c8o\u0018\u00fa\u00f7f\u00f7WEp\u0011\u00c5\\\u00dc\u0007c\u0090s\u00e4\u00abi\u00ebqGZZ\u00c5\u0000\u0014\u00c0\u00cfo{x\u00c1\u0084\u00e74JhCw\u00e9p\u00c4\u008d\u00bfv&E\u00fb\u00b4\f\t\u009f&\u0096\u00ffr`?X\u00ecfTm\u00a1\u00d8\u00e8\u0016|9>\u00c1W\u009d\u00e1\u009e\u0000\u0085\u00b9kNp\u00e9\u00a8\u00b8&`\u0017\u0007\u0015\u00c0X\u001a\u00c6\u00aebrX\u007f\u0011+#1\u0089>\b/\u00ddB\u0083o~\u0099H\u00c4\u00b2\u001e\u0004 4\u00e3B!h\u00ec=\u00ce\u00b9T\u0097\u00ba\u00ae`\u0011\u00a9\u00e2Q\u00da\u0012N\u0013\u00e3\u0094p\u00bc*z\u00a4\u00fe\u00c69\u00dc\u00e5\u0019z^\u0012\u00d35\u000f'4\"I\u00faM\u0088\u0081yE\u00ab\u00c6\u0017\u009a\u0016\n\u00ed\u0080\u00c8\u0091\u00cc\u00f4V7\u00b0\u00c3n\u0083\u00c8\u0019\u00c2`AVOO:\u00d1>\u00db\u00b3\u00a2&\u00b8\u009c\u0086u_\u00d0\u001f\u00a4\u00d1G\u00c4\u0019\u0092_Q^\u0090y\u0081\u00a1\u000e\r\u0006l6\u0085\u00f4\u0010\u00a5\u00e7iiA\u0019\u001d\u00c43\u0001v\u00f2\u0090.\u00e5\u00f7-T.V\u00fb\u0093\u0085\u00bd\u00bc\u00fdQ\u001f{@\u008a\u0004w\\\u00a1\u00c6\u00ce\u00ca\u00cftv\u00d8\u00c2\u008d\u0007C\u000b\u00ea9\u00fdv\u00af4\u00fek\u000bBe\u0005\u00a5u\u00d6z\u0091M\u00ea\r\u0007\u00b7\u0087r~<l\u000b\"\u0087\u00c8\u0098m\u001b=\u00de\u007f\u0087l\u0092Gk\u00bekXL\u00c2\u0090\u00e0\u00ce\u00cb\u00e5\u00d4\u00cc\u00bc\u00f2\u00c5\u001d\u00a69\u009d\n\u001a\u00db6\u00fa\u0013\u0099\u00ad\u009a\u00cfv\u001aO\u00ee\u009c\\FM\u0006\u0013\u0084,\u0093JJ\u00f7\u00f3\u0098vb\u00cf[\rR\u00a8\u00d1\u00ae\u00a0\"5\u00b5\u00c64\u00ba9\u0089\u00c4`\u00da\u00f4\u0015?\u0095\u0086Iww\u00c6Il\u00f5\u00b5k`p\u0005f\u001e\u00ab\u000fi\u00f3\u00a5\u0012U\u0094\u00deJ>\u001c\u00c5gU|\u0083\u00c5\u00a3\u00dd\u00f5\u008at\fE{\u00e5\u001c#\u009dc\u00d6Wzu>\u00fa\u00cc2P\u00e7!\u0089\u00f8<~|~i_\u0088\u00e0< \u00d1\u00bd\u00e1\u00ce!\u00f9\u0082\u00bac \u00bf\u000f\u0000\u00c1\u00fa:\u0092\u00aa\u00e8\u00f2\to;)fq!6\u001d.\u007fb\u00d7k\u00f4\u0019\u0019\u00d4\u0098\u001c\u0012,G\u00f10\u00dbSy\u008e\u00c2Aqb\u00fd)>\u0014\r\u00df\u0015]\u00c7\u00cc|\u0017\u00fdM9\u0093\u0091\u00e73\u00d9\u0096%W\u00e3^\u00ad\u00e8\u00d0Hh\u00c3\u00e9\u00ad\u0016\u00cc L\u0080\u0001\u0087\u008b\u0080L\u00e2e:q\u00e0V\u00d39\"E\u0011\tV\u00dc)\u000e\u00a2\u00ec\u00e1\u00d7\u0018\u00dfHc\"y\u009b\u00a9]\u00a2i\u00f6\u00f8)\u00cc\u00f3b\u00fen\u0003\u00e5\u0094\u0002\u0087\u008a\u00de\u0085\u0001\\8\u00f2\u0007fyy\u00e8+\u00da\u0016\u00d5\u0082`\u00e4\u00b1\u0014\u0093t\u009f\u00ad\u00d4o,s\u00f2\u00fb\u008e\u001a\u00bcBp4\u000elW\u00feu\u00c1\u00a9]\u000e\u000b^\u0010\u009f\t\u009e".length();
                var1_4 = 20;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "A9H\u00a5k\u000b\u00b3\u0082'\u0012\u001c\f\"\u00b6%-\u0003\u00fbH\u00d8\u00bd\u00c7\u008f-'\u00b8\u00ed\u007f\u0003\u0088\u00ac\r\u0087)U#\u00f2\u0006\u000ba\u0015\u00d1A\u00af\u00af\u00d9R\u0003pd\u00c4@h\u00b98\u0097\u00d0\u00b2z\f\u00e8c;\u00c4\u0016B\u00b5Cx\u00c2\u00d7\u00e9\u00d8hj\u00ef\u00f9\u00cc\f\u00111\u00f5\u00a2\f\u00e6\u000f\u0097#\u00ad\u00d5\u00a9\u00d4\u00d9\u008e\u00e0D\u00a2\u0015\u00f7\u00ef\u00c7\u00e0f\u0001\u00ec\u0086\u000e\u00f5b!\t\u0085\u0011\u00e3<\u00f1'\u000e\u00b8\u00f6\u00d3{\u00ba\u000b\u00d1Y/z\u00cf\u00b9\u00f5\u0019\u009a\u00ce\u00b2h\u0004\u00eb\u0084\u00bf\u00121?";
                    var4_3 = "A9H\u00a5k\u000b\u00b3\u0082'\u0012\u001c\f\"\u00b6%-\u0003\u00fbH\u00d8\u00bd\u00c7\u008f-'\u00b8\u00ed\u007f\u0003\u0088\u00ac\r\u0087)U#\u00f2\u0006\u000ba\u0015\u00d1A\u00af\u00af\u00d9R\u0003pd\u00c4@h\u00b98\u0097\u00d0\u00b2z\f\u00e8c;\u00c4\u0016B\u00b5Cx\u00c2\u00d7\u00e9\u00d8hj\u00ef\u00f9\u00cc\f\u00111\u00f5\u00a2\f\u00e6\u000f\u0097#\u00ad\u00d5\u00a9\u00d4\u00d9\u008e\u00e0D\u00a2\u0015\u00f7\u00ef\u00c7\u00e0f\u0001\u00ec\u0086\u000e\u00f5b!\t\u0085\u0011\u00e3<\u00f1'\u000e\u00b8\u00f6\u00d3{\u00ba\u000b\u00d1Y/z\u00cf\u00b9\u00f5\u0019\u009a\u00ce\u00b2h\u0004\u00eb\u0084\u00bf\u00121?".length();
                    var1_4 = 109;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 9;
                            break;
                        }
                        case 1: {
                            v13 = 80;
                            break;
                        }
                        case 2: {
                            v13 = 79;
                            break;
                        }
                        case 3: {
                            v13 = 115;
                            break;
                        }
                        case 4: {
                            v13 = 25;
                            break;
                        }
                        case 5: {
                            v13 = 50;
                            break;
                        }
                        default: {
                            v13 = 106;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        SignatureValidator.h = var5;
        SignatureValidator.i = new String[41];
        SignatureValidator.a = LoggerFactory.getLogger(SignatureValidator.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x73A9) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 14;
                    break;
                }
                case 1: {
                    n5 = 30;
                    break;
                }
                case 2: {
                    n5 = 28;
                    break;
                }
                case 3: {
                    n5 = 211;
                    break;
                }
                case 4: {
                    n5 = 56;
                    break;
                }
                case 5: {
                    n5 = 69;
                    break;
                }
                case 6: {
                    n5 = 18;
                    break;
                }
                case 7: {
                    n5 = 214;
                    break;
                }
                case 8: {
                    n5 = 247;
                    break;
                }
                case 9: {
                    n5 = 150;
                    break;
                }
                case 10: {
                    n5 = 17;
                    break;
                }
                case 11: {
                    n5 = 141;
                    break;
                }
                case 12: {
                    n5 = 1;
                    break;
                }
                case 13: {
                    n5 = 218;
                    break;
                }
                case 14: {
                    n5 = 157;
                    break;
                }
                case 15: {
                    n5 = 77;
                    break;
                }
                case 16: {
                    n5 = 143;
                    break;
                }
                case 17: {
                    n5 = 36;
                    break;
                }
                case 18: {
                    n5 = 219;
                    break;
                }
                case 19: {
                    n5 = 53;
                    break;
                }
                case 20: {
                    n5 = 164;
                    break;
                }
                case 21: {
                    n5 = 209;
                    break;
                }
                case 22: {
                    n5 = 12;
                    break;
                }
                case 23: {
                    n5 = 75;
                    break;
                }
                case 24: {
                    n5 = 240;
                    break;
                }
                case 25: {
                    n5 = 130;
                    break;
                }
                case 26: {
                    n5 = 175;
                    break;
                }
                case 27: {
                    n5 = 237;
                    break;
                }
                case 28: {
                    n5 = 249;
                    break;
                }
                case 29: {
                    n5 = 202;
                    break;
                }
                case 30: {
                    n5 = 155;
                    break;
                }
                case 31: {
                    n5 = 51;
                    break;
                }
                case 32: {
                    n5 = 96;
                    break;
                }
                case 33: {
                    n5 = 31;
                    break;
                }
                case 34: {
                    n5 = 231;
                    break;
                }
                case 35: {
                    n5 = 6;
                    break;
                }
                case 36: {
                    n5 = 9;
                    break;
                }
                case 37: {
                    n5 = 223;
                    break;
                }
                case 38: {
                    n5 = 163;
                    break;
                }
                case 39: {
                    n5 = 108;
                    break;
                }
                case 40: {
                    n5 = 85;
                    break;
                }
                case 41: {
                    n5 = 68;
                    break;
                }
                case 42: {
                    n5 = 187;
                    break;
                }
                case 43: {
                    n5 = 0;
                    break;
                }
                case 44: {
                    n5 = 71;
                    break;
                }
                case 45: {
                    n5 = 181;
                    break;
                }
                case 46: {
                    n5 = 124;
                    break;
                }
                case 47: {
                    n5 = 122;
                    break;
                }
                case 48: {
                    n5 = 84;
                    break;
                }
                case 49: {
                    n5 = 93;
                    break;
                }
                case 50: {
                    n5 = 5;
                    break;
                }
                case 51: {
                    n5 = 73;
                    break;
                }
                case 52: {
                    n5 = 222;
                    break;
                }
                case 53: {
                    n5 = 225;
                    break;
                }
                case 54: {
                    n5 = 35;
                    break;
                }
                case 55: {
                    n5 = 45;
                    break;
                }
                case 56: {
                    n5 = 113;
                    break;
                }
                case 57: {
                    n5 = 115;
                    break;
                }
                case 58: {
                    n5 = 172;
                    break;
                }
                case 59: {
                    n5 = 162;
                    break;
                }
                case 60: {
                    n5 = 61;
                    break;
                }
                case 61: {
                    n5 = 138;
                    break;
                }
                case 62: {
                    n5 = 134;
                    break;
                }
                case 63: {
                    n5 = 144;
                    break;
                }
                case 64: {
                    n5 = 147;
                    break;
                }
                case 65: {
                    n5 = 166;
                    break;
                }
                case 66: {
                    n5 = 109;
                    break;
                }
                case 67: {
                    n5 = 89;
                    break;
                }
                case 68: {
                    n5 = 178;
                    break;
                }
                case 69: {
                    n5 = 121;
                    break;
                }
                case 70: {
                    n5 = 243;
                    break;
                }
                case 71: {
                    n5 = 54;
                    break;
                }
                case 72: {
                    n5 = 185;
                    break;
                }
                case 73: {
                    n5 = 136;
                    break;
                }
                case 74: {
                    n5 = 236;
                    break;
                }
                case 75: {
                    n5 = 167;
                    break;
                }
                case 76: {
                    n5 = 34;
                    break;
                }
                case 77: {
                    n5 = 139;
                    break;
                }
                case 78: {
                    n5 = 238;
                    break;
                }
                case 79: {
                    n5 = 220;
                    break;
                }
                case 80: {
                    n5 = 250;
                    break;
                }
                case 81: {
                    n5 = 224;
                    break;
                }
                case 82: {
                    n5 = 11;
                    break;
                }
                case 83: {
                    n5 = 8;
                    break;
                }
                case 84: {
                    n5 = 90;
                    break;
                }
                case 85: {
                    n5 = 52;
                    break;
                }
                case 86: {
                    n5 = 190;
                    break;
                }
                case 87: {
                    n5 = 125;
                    break;
                }
                case 88: {
                    n5 = 70;
                    break;
                }
                case 89: {
                    n5 = 104;
                    break;
                }
                case 90: {
                    n5 = 151;
                    break;
                }
                case 91: {
                    n5 = 78;
                    break;
                }
                case 92: {
                    n5 = 72;
                    break;
                }
                case 93: {
                    n5 = 135;
                    break;
                }
                case 94: {
                    n5 = 229;
                    break;
                }
                case 95: {
                    n5 = 83;
                    break;
                }
                case 96: {
                    n5 = 27;
                    break;
                }
                case 97: {
                    n5 = 232;
                    break;
                }
                case 98: {
                    n5 = 199;
                    break;
                }
                case 99: {
                    n5 = 10;
                    break;
                }
                case 100: {
                    n5 = 148;
                    break;
                }
                case 101: {
                    n5 = 221;
                    break;
                }
                case 102: {
                    n5 = 194;
                    break;
                }
                case 103: {
                    n5 = 38;
                    break;
                }
                case 104: {
                    n5 = 153;
                    break;
                }
                case 105: {
                    n5 = 176;
                    break;
                }
                case 106: {
                    n5 = 19;
                    break;
                }
                case 107: {
                    n5 = 248;
                    break;
                }
                case 108: {
                    n5 = 59;
                    break;
                }
                case 109: {
                    n5 = 64;
                    break;
                }
                case 110: {
                    n5 = 132;
                    break;
                }
                case 111: {
                    n5 = 116;
                    break;
                }
                case 112: {
                    n5 = 82;
                    break;
                }
                case 113: {
                    n5 = 123;
                    break;
                }
                case 114: {
                    n5 = 131;
                    break;
                }
                case 115: {
                    n5 = 161;
                    break;
                }
                case 116: {
                    n5 = 191;
                    break;
                }
                case 117: {
                    n5 = 128;
                    break;
                }
                case 118: {
                    n5 = 79;
                    break;
                }
                case 119: {
                    n5 = 215;
                    break;
                }
                case 120: {
                    n5 = 97;
                    break;
                }
                case 121: {
                    n5 = 119;
                    break;
                }
                case 122: {
                    n5 = 192;
                    break;
                }
                case 123: {
                    n5 = 182;
                    break;
                }
                case 124: {
                    n5 = 230;
                    break;
                }
                case 125: {
                    n5 = 25;
                    break;
                }
                case 126: {
                    n5 = 254;
                    break;
                }
                case 127: {
                    n5 = 186;
                    break;
                }
                case 128: {
                    n5 = 169;
                    break;
                }
                case 129: {
                    n5 = 86;
                    break;
                }
                case 130: {
                    n5 = 110;
                    break;
                }
                case 131: {
                    n5 = 63;
                    break;
                }
                case 132: {
                    n5 = 4;
                    break;
                }
                case 133: {
                    n5 = 37;
                    break;
                }
                case 134: {
                    n5 = 43;
                    break;
                }
                case 135: {
                    n5 = 160;
                    break;
                }
                case 136: {
                    n5 = 227;
                    break;
                }
                case 137: {
                    n5 = 193;
                    break;
                }
                case 138: {
                    n5 = 196;
                    break;
                }
                case 139: {
                    n5 = 33;
                    break;
                }
                case 140: {
                    n5 = 94;
                    break;
                }
                case 141: {
                    n5 = 48;
                    break;
                }
                case 142: {
                    n5 = 245;
                    break;
                }
                case 143: {
                    n5 = 112;
                    break;
                }
                case 144: {
                    n5 = 111;
                    break;
                }
                case 145: {
                    n5 = 24;
                    break;
                }
                case 146: {
                    n5 = 46;
                    break;
                }
                case 147: {
                    n5 = 170;
                    break;
                }
                case 148: {
                    n5 = 174;
                    break;
                }
                case 149: {
                    n5 = 126;
                    break;
                }
                case 150: {
                    n5 = 179;
                    break;
                }
                case 151: {
                    n5 = 3;
                    break;
                }
                case 152: {
                    n5 = 156;
                    break;
                }
                case 153: {
                    n5 = 65;
                    break;
                }
                case 154: {
                    n5 = 120;
                    break;
                }
                case 155: {
                    n5 = 55;
                    break;
                }
                case 156: {
                    n5 = 117;
                    break;
                }
                case 157: {
                    n5 = 127;
                    break;
                }
                case 158: {
                    n5 = 98;
                    break;
                }
                case 159: {
                    n5 = 133;
                    break;
                }
                case 160: {
                    n5 = 92;
                    break;
                }
                case 161: {
                    n5 = 234;
                    break;
                }
                case 162: {
                    n5 = 26;
                    break;
                }
                case 163: {
                    n5 = 212;
                    break;
                }
                case 164: {
                    n5 = 100;
                    break;
                }
                case 165: {
                    n5 = 226;
                    break;
                }
                case 166: {
                    n5 = 228;
                    break;
                }
                case 167: {
                    n5 = 200;
                    break;
                }
                case 168: {
                    n5 = 152;
                    break;
                }
                case 169: {
                    n5 = 154;
                    break;
                }
                case 170: {
                    n5 = 20;
                    break;
                }
                case 171: {
                    n5 = 203;
                    break;
                }
                case 172: {
                    n5 = 208;
                    break;
                }
                case 173: {
                    n5 = 41;
                    break;
                }
                case 174: {
                    n5 = 105;
                    break;
                }
                case 175: {
                    n5 = 207;
                    break;
                }
                case 176: {
                    n5 = 106;
                    break;
                }
                case 177: {
                    n5 = 50;
                    break;
                }
                case 178: {
                    n5 = 40;
                    break;
                }
                case 179: {
                    n5 = 62;
                    break;
                }
                case 180: {
                    n5 = 140;
                    break;
                }
                case 181: {
                    n5 = 180;
                    break;
                }
                case 182: {
                    n5 = 66;
                    break;
                }
                case 183: {
                    n5 = 21;
                    break;
                }
                case 184: {
                    n5 = 246;
                    break;
                }
                case 185: {
                    n5 = 173;
                    break;
                }
                case 186: {
                    n5 = 39;
                    break;
                }
                case 187: {
                    n5 = 188;
                    break;
                }
                case 188: {
                    n5 = 49;
                    break;
                }
                case 189: {
                    n5 = 95;
                    break;
                }
                case 190: {
                    n5 = 2;
                    break;
                }
                case 191: {
                    n5 = 107;
                    break;
                }
                case 192: {
                    n5 = 60;
                    break;
                }
                case 193: {
                    n5 = 241;
                    break;
                }
                case 194: {
                    n5 = 195;
                    break;
                }
                case 195: {
                    n5 = 210;
                    break;
                }
                case 196: {
                    n5 = 103;
                    break;
                }
                case 197: {
                    n5 = 13;
                    break;
                }
                case 198: {
                    n5 = 22;
                    break;
                }
                case 199: {
                    n5 = 149;
                    break;
                }
                case 200: {
                    n5 = 42;
                    break;
                }
                case 201: {
                    n5 = 239;
                    break;
                }
                case 202: {
                    n5 = 114;
                    break;
                }
                case 203: {
                    n5 = 44;
                    break;
                }
                case 204: {
                    n5 = 87;
                    break;
                }
                case 205: {
                    n5 = 16;
                    break;
                }
                case 206: {
                    n5 = 142;
                    break;
                }
                case 207: {
                    n5 = 213;
                    break;
                }
                case 208: {
                    n5 = 184;
                    break;
                }
                case 209: {
                    n5 = 81;
                    break;
                }
                case 210: {
                    n5 = 118;
                    break;
                }
                case 211: {
                    n5 = 197;
                    break;
                }
                case 212: {
                    n5 = 88;
                    break;
                }
                case 213: {
                    n5 = 57;
                    break;
                }
                case 214: {
                    n5 = 244;
                    break;
                }
                case 215: {
                    n5 = 253;
                    break;
                }
                case 216: {
                    n5 = 137;
                    break;
                }
                case 217: {
                    n5 = 47;
                    break;
                }
                case 218: {
                    n5 = 198;
                    break;
                }
                case 219: {
                    n5 = 165;
                    break;
                }
                case 220: {
                    n5 = 201;
                    break;
                }
                case 221: {
                    n5 = 145;
                    break;
                }
                case 222: {
                    n5 = 58;
                    break;
                }
                case 223: {
                    n5 = 29;
                    break;
                }
                case 224: {
                    n5 = 189;
                    break;
                }
                case 225: {
                    n5 = 171;
                    break;
                }
                case 226: {
                    n5 = 217;
                    break;
                }
                case 227: {
                    n5 = 101;
                    break;
                }
                case 228: {
                    n5 = 129;
                    break;
                }
                case 229: {
                    n5 = 102;
                    break;
                }
                case 230: {
                    n5 = 251;
                    break;
                }
                case 231: {
                    n5 = 183;
                    break;
                }
                case 232: {
                    n5 = 242;
                    break;
                }
                case 233: {
                    n5 = 76;
                    break;
                }
                case 234: {
                    n5 = 67;
                    break;
                }
                case 235: {
                    n5 = 206;
                    break;
                }
                case 236: {
                    n5 = 23;
                    break;
                }
                case 237: {
                    n5 = 235;
                    break;
                }
                case 238: {
                    n5 = 233;
                    break;
                }
                case 239: {
                    n5 = 7;
                    break;
                }
                case 240: {
                    n5 = 32;
                    break;
                }
                case 241: {
                    n5 = 146;
                    break;
                }
                case 242: {
                    n5 = 252;
                    break;
                }
                case 243: {
                    n5 = 80;
                    break;
                }
                case 244: {
                    n5 = 168;
                    break;
                }
                case 245: {
                    n5 = 74;
                    break;
                }
                case 246: {
                    n5 = 205;
                    break;
                }
                case 247: {
                    n5 = 216;
                    break;
                }
                case 248: {
                    n5 = 91;
                    break;
                }
                case 249: {
                    n5 = 99;
                    break;
                }
                case 250: {
                    n5 = 159;
                    break;
                }
                case 251: {
                    n5 = 255;
                    break;
                }
                case 252: {
                    n5 = 15;
                    break;
                }
                case 253: {
                    n5 = 177;
                    break;
                }
                case 254: {
                    n5 = 158;
                    break;
                }
                default: {
                    n5 = 204;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            SignatureValidator.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

