/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.h;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Asn1BerOutputStream
extends Asn1OutputStream {
    private static final byte[] b = new byte[]{0, 0};
    private static h c = h.a();

    public Asn1BerOutputStream(OutputStream outputStream) {
        super(new BufferedOutputStream(outputStream));
    }

    public Asn1BerOutputStream(OutputStream outputStream, int n2) {
        super(n2 == 0 ? outputStream : new BufferedOutputStream(outputStream, n2));
    }

    public void encodeIdentifier(long l2) throws IOException {
        block6: {
            block5: {
                boolean bl = Asn1Exception.z;
                long l3 = 127L;
                int n2 = 0;
                n2 = h.d(l2);
                l3 <<= 7 * n2;
                if (n2 <= 0) break block5;
                while (n2 > 0) {
                    long l4 = (l2 & (l3 >>>= 7)) >>> --n2 * 7;
                    if (n2 != 0) {
                        l4 |= 0x80L;
                    }
                    this.os.write((byte)l4);
                    if (!bl) continue;
                }
                if (!bl) break block6;
            }
            this.os.write(0);
        }
        c.lcheck(1);
    }

    public void encodeTag(Asn1Tag asn1Tag) throws IOException {
        block3: {
            byte by;
            block2: {
                by = (byte)(asn1Tag.mClass | asn1Tag.mForm);
                if (asn1Tag.mIDCode >= 31) break block2;
                this.os.write((byte)(by | asn1Tag.mIDCode));
                if (!Asn1Exception.z) break block3;
            }
            this.os.write((byte)(by | 0x1F));
            this.encodeIdentifier(asn1Tag.mIDCode);
        }
        c.lcheck(1);
    }

    public void encodeTag(short s2, short s3, int n2) throws IOException {
        this.encodeTag(new Asn1Tag(s2, s3, n2));
    }

    public void encodeLength(int n2) throws IOException {
        block7: {
            block6: {
                boolean bl = Asn1Exception.z;
                if (n2 < 0) break block6;
                int n3 = Asn1Util.getBytesCount(n2);
                if (n2 > 127) {
                    this.os.write((byte)(n3 | 0x80));
                }
                for (int i2 = 8 * n3 - 8; i2 >= 0; i2 -= 8) {
                    byte by = (byte)(n2 >> i2 & 0xFF);
                    this.os.write(by);
                    if (!bl) continue;
                }
                if (!bl) break block7;
            }
            if (n2 == -9999) {
                this.os.write(128);
            }
        }
    }

    public void encodeTagAndLength(Asn1Tag asn1Tag, int n2) throws IOException {
        this.encodeTag(asn1Tag);
        this.encodeLength(n2);
    }

    public void encodeTagAndIndefLen(Asn1Tag asn1Tag) throws IOException {
        this.encodeTag(asn1Tag);
        this.os.write(128);
    }

    public void encodeTagAndIndefLen(short s2, short s3, int n2) throws IOException {
        this.encodeTag(new Asn1Tag(s2, s3, n2));
        this.os.write(128);
    }

    public void encodeEOC() throws IOException {
        this.os.write(b);
    }

    public void encodeIntValue(long l2, boolean bl) throws IOException {
        int n2;
        int n3;
        byte[] byArray;
        block8: {
            long l3;
            block7: {
                boolean bl2 = Asn1Exception.z;
                long l4 = l2;
                byArray = new byte[9];
                n3 = 0;
                n2 = byArray.length;
                do {
                    l3 = l4 % 256L;
                    if ((l4 /= 256L) < 0L && l3 != 0L) {
                        --l4;
                    }
                    byArray[--n2] = (byte)l3;
                    ++n3;
                } while (l4 != 0L && l4 != -1L);
                if (l2 <= 0L || (l3 & 0x80L) != 128L) break block7;
                byArray[--n2] = 0;
                ++n3;
                if (!bl2) break block8;
            }
            if (l2 < 0L && (l3 & 0x80L) == 0L) {
                byArray[--n2] = -1;
                ++n3;
            }
        }
        if (bl) {
            this.encodeLength(n3);
        }
        this.os.write(byArray, n2, n3);
        c.lcheck(1);
    }

    public void encodeBMPString(String string, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        block6: {
            boolean bl2;
            block5: {
                bl2 = Asn1Exception.z;
                if (bl) {
                    this.encodeTag(asn1Tag);
                }
                if (string != null) break block5;
                this.encodeLength(0);
                if (!bl2) break block6;
            }
            this.encodeLength(string.length() * 2);
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                int n3 = c2 / 256;
                int n4 = c2 % 256;
                this.os.write((byte)n3);
                this.os.write((byte)n4);
                if (!bl2) continue;
            }
        }
    }

    public void encodeBitString(byte[] byArray, int n2, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        if (bl) {
            this.encodeTag(asn1Tag);
        }
        int n3 = (n2 + 7) / 8;
        this.encodeLength(n3 + 1);
        int n4 = n2 % 8;
        if (n4 != 0) {
            n4 = 8 - n4;
            int n5 = n3 - 1;
            byArray[n5] = (byte)(byArray[n5] & ~((1 << n4) - 1));
        }
        this.os.write(n4);
        if (n3 > 0) {
            this.os.write(byArray, 0, n3);
        }
        c.lcheck(1);
    }

    public void encodeCharString(String string, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        block6: {
            boolean bl2;
            block5: {
                bl2 = Asn1Exception.z;
                if (bl) {
                    this.encodeTag(asn1Tag);
                }
                if (string != null) break block5;
                this.encodeLength(0);
                if (!bl2) break block6;
            }
            this.encodeLength(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.os.write((byte)string.charAt(i2));
                if (!bl2) continue;
            }
        }
    }

    public void encodeOctetString(byte[] byArray, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        block5: {
            block4: {
                if (bl) {
                    this.encodeTag(asn1Tag);
                }
                if (byArray != null) break block4;
                this.encodeLength(0);
                if (!Asn1Exception.z) break block5;
            }
            this.encodeLength(byArray.length);
            this.os.write(byArray);
        }
        c.lcheck(1);
    }

    public void encodeUnivString(int[] nArray, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        block6: {
            boolean bl2;
            block5: {
                bl2 = Asn1Exception.z;
                if (bl) {
                    this.encodeTag(asn1Tag);
                }
                if (nArray != null) break block5;
                this.encodeLength(0);
                if (!bl2) break block6;
            }
            this.encodeLength(nArray.length * 4);
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                this.os.write((byte)(n3 >>> 24 & 0xFF));
                this.os.write((byte)(n3 >>> 16 & 0xFF));
                this.os.write((byte)(n3 >>> 8 & 0xFF));
                this.os.write((byte)(n3 & 0xFF));
                if (!bl2) continue;
            }
        }
    }

    public void encode(Asn1Type asn1Type, boolean bl) throws IOException, Asn1Exception {
        asn1Type.encode(this, bl);
    }

    public boolean isBER() {
        return true;
    }
}

