/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import java.util.Arrays;
import sune.security.util.DerInputStream;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;
import sune.security.util.ObjectIdentifier;

public class Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;
    private static final int hashMagic = 31;

    public Extension() {
    }

    public Extension(DerValue derVal) throws IOException {
        DerInputStream in = derVal.toDerInputStream();
        this.extensionId = in.getOID();
        DerValue val = in.getDerValue();
        if (val.tag == 1) {
            this.critical = val.getBoolean();
            val = in.getDerValue();
            this.extensionValue = val.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = val.getOctetString();
        }
    }

    public Extension(ObjectIdentifier extensionId, boolean critical, byte[] extensionValue) throws IOException {
        this.extensionId = extensionId;
        this.critical = critical;
        DerValue inDerVal = new DerValue(extensionValue);
        this.extensionValue = inDerVal.getOctetString();
    }

    public Extension(Extension ext) {
        this.extensionId = ext.extensionId;
        this.critical = ext.critical;
        this.extensionValue = ext.extensionValue;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (this.extensionId == null) {
            throw new IOException("Null OID to encode for the extension!");
        }
        if (this.extensionValue == null) {
            throw new IOException("No value to encode for the extension!");
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(this.extensionId);
        if (this.critical) {
            dos.putBoolean(this.critical);
        }
        dos.putOctetString(this.extensionValue);
        out.write((byte)48, dos);
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ObjectIdentifier getExtensionId() {
        return this.extensionId;
    }

    public byte[] getExtensionValue() {
        return this.extensionValue;
    }

    public String toString() {
        String s = "ObjectId: " + this.extensionId.toString();
        s = this.critical ? s + " Criticality=true\n" : s + " Criticality=false\n";
        return s;
    }

    public int hashCode() {
        int h = 0;
        if (this.extensionValue != null) {
            byte[] val = this.extensionValue;
            int len = val.length;
            while (len > 0) {
                h += len-- * val[len];
            }
        }
        h = h * 31 + this.extensionId.hashCode();
        h = h * 31 + (this.critical ? 1231 : 1237);
        return h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Extension)) {
            return false;
        }
        Extension otherExt = (Extension)other;
        if (this.critical != otherExt.critical) {
            return false;
        }
        if (!this.extensionId.equals(otherExt.extensionId)) {
            return false;
        }
        return Arrays.equals(this.extensionValue, otherExt.extensionValue);
    }
}

