/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncoder;
import java.io.IOException;

public class Asn1PerTime {
    public static final int ANY = 32768;
    public static final int CENTURY = 16384;
    public static final int YEAR = 8192;
    public static final int MONTH = 4096;
    public static final int WEEK = 2048;
    public static final int DAY = 1024;
    public static final int HOURS = 512;
    public static final int MINUTES = 256;
    public static final int SECONDS = 128;
    public static final int UTC = 64;
    public static final int DIFF = 32;
    public static final int FRACTION = 15;
    public static final int DURATION = 16;
    public static final int DT_ANY_CENTURY = 49152;
    public static final int DT_ANY_YEAR = 40960;
    public static final int DT_ANY_YEAR_MONTH = 45056;
    public static final int DT_ANY_YEAR_MONTH_DAY = 46080;
    public static final int DT_ANY_YEAR_DAY = 41984;
    public static final int DT_ANY_YEAR_WEEK = 43008;
    public static final int DT_ANY_YEAR_WEEK_DAY = 44032;
    public static final int DT_CENTURY = 16384;
    public static final int DT_YEAR = 8192;
    public static final int DT_YEAR_MONTH = 12288;
    public static final int DT_YEAR_MONTH_DAY = 13312;
    public static final int DT_YEAR_DAY = 9216;
    public static final int DT_YEAR_WEEK = 10240;
    public static final int DT_YEAR_WEEK_DAY = 11264;
    public static final int DT_HOURS = 512;
    public static final int DT_HOURS_UTC = 576;
    public static final int DT_HOURS_AND_DIFF = 544;
    public static final int DT_MINUTES = 768;
    public static final int DT_MINUTES_UTC = 832;
    public static final int DT_MINUTES_AND_DIFF = 800;
    public static final int DT_SECONDS = 896;
    public static final int DT_SECONDS_UTC = 960;
    public static final int DT_SECONDS_AND_DIFF = 928;
    public static final int DT_HOURS_AND_FRACTION = 515;
    public static final int DT_HOURS_UTC_AND_FRACTION = 579;
    public static final int DT_HOURS_AND_DIFF_AND_FRACTION = 547;
    public static final int DT_MINUTES_AND_FRACTION = 771;
    public static final int DT_MINUTES_UTC_AND_FRACTION = 835;
    public static final int DT_MINUTES_AND_DIFF_AND_FRACTION = 803;
    public static final int DT_SECONDS_AND_FRACTION = 899;
    public static final int DT_SECONDS_UTC_AND_FRACTION = 963;
    public static final int DT_SECONDS_AND_DIFF_AND_FRACTION = 931;
    public static final int DATE = 13312;
    public static final int TIME_OF_DAY = 896;
    public static final int DATE_TIME = 14208;
    private static final int[] a = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] b = new int[]{31, 15, 63, 31, 31, 63, 63, 3, 999};
    private static final char[] c = new char[]{'Y', 'M', 'W', 'D', 'H', 'M', 'S'};

    public static String decodeDate(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2) throws Asn1Exception {
        try {
            StringBuffer stringBuffer = new StringBuffer(Asn1PerTime.b(n2));
            Asn1PerTime.a(asn1PerDecodeBuffer, stringBuffer, n2);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static void a(Asn1PerDecodeBuffer asn1PerDecodeBuffer, StringBuffer stringBuffer, int n2) throws IOException, Asn1Exception {
        block33: {
            int n3;
            block35: {
                boolean bl;
                block34: {
                    int n4;
                    block28: {
                        block32: {
                            long l2;
                            block31: {
                                block30: {
                                    block29: {
                                        int n5;
                                        block25: {
                                            block27: {
                                                block26: {
                                                    block23: {
                                                        block24: {
                                                            block21: {
                                                                block22: {
                                                                    bl = Asn1Exception.z;
                                                                    l2 = 0L;
                                                                    n4 = 0;
                                                                    n3 = 0;
                                                                    if ((n2 & 0x2000) == 0) break block21;
                                                                    if ((n2 & 0x8000) == 0) break block22;
                                                                    l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
                                                                    if (!bl) break block23;
                                                                }
                                                                l2 = Asn1PerTime.a(asn1PerDecodeBuffer);
                                                                if (!bl) break block23;
                                                            }
                                                            if ((n2 & 0x4000) == 0) break block23;
                                                            if ((n2 & 0x8000) == 0) break block24;
                                                            l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
                                                            if (!bl) break block23;
                                                        }
                                                        l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 99L);
                                                    }
                                                    if ((n2 & 0x1800) != 0) {
                                                        n5 = (n2 & 0x1000) != 0 ? 12 : 53;
                                                        n4 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 1L, n5);
                                                    }
                                                    if ((n2 & 0x400) == 0) break block25;
                                                    n5 = 366;
                                                    if ((n2 & 0x1000) == 0) break block26;
                                                    n5 = 31;
                                                    if (!bl) break block27;
                                                }
                                                if ((n2 & 0x800) != 0) {
                                                    n5 = 7;
                                                }
                                            }
                                            n3 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 1L, n5);
                                        }
                                        if ((n2 & 0x6000) == 0) break block28;
                                        int n6 = n5 = (n2 & 0x2000) != 0 ? 9999 : 99;
                                        if (l2 <= (long)n5) break block29;
                                        stringBuffer.append('+');
                                        if (!bl) break block30;
                                    }
                                    if (l2 < 0L) {
                                        l2 = -l2;
                                        stringBuffer.append("-");
                                    }
                                }
                                if ((n2 & 0x2000) == 0) break block31;
                                Asn1PerTime.a(stringBuffer, l2, 4);
                                if (!bl) break block32;
                            }
                            Asn1PerTime.a(stringBuffer, l2, 2);
                        }
                        if ((n2 & 0x4000) != 0) {
                            stringBuffer.append('C');
                        }
                    }
                    if ((n2 & 0x1800) != 0) {
                        stringBuffer.append('-');
                        if ((n2 & 0x800) != 0) {
                            stringBuffer.append('W');
                        }
                        Asn1PerTime.a(stringBuffer, n4, 2);
                    }
                    if ((n2 & 0x400) == 0) break block33;
                    stringBuffer.append('-');
                    if ((n2 & 0x1000) == 0) break block34;
                    Asn1PerTime.a(stringBuffer, n3, 2);
                    if (!bl) break block33;
                }
                if ((n2 & 0x800) != 0) break block35;
                Asn1PerTime.a(stringBuffer, n3, 3);
                if (!bl) break block33;
            }
            stringBuffer.append(n3);
        }
    }

    public static String decodeDateTime(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2) throws Asn1Exception {
        StringBuffer stringBuffer = new StringBuffer(Asn1PerTime.b(n2));
        try {
            Asn1PerTime.a(asn1PerDecodeBuffer, stringBuffer, n2);
            stringBuffer.append('T');
            Asn1PerTime.b(asn1PerDecodeBuffer, stringBuffer, n2);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static long a(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws IOException, Asn1Exception {
        long l2;
        boolean bl = Asn1Exception.z;
        int n2 = (int)asn1PerDecodeBuffer.decodeConsWholeNumber(4L, "index");
        switch (n2) {
            case 0: {
                l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer, 2005L, 2020L);
                if (!bl) break;
            }
            case 1: {
                l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer, 2021L, 2276L);
                if (!bl) break;
            }
            case 2: {
                l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer, 1749L, 2004L);
                if (!bl) break;
            }
            case 3: {
                l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
                if (!bl) break;
            }
            default: {
                throw new Asn1Exception("unexpected index for YEAR-ENCODING: " + n2);
            }
        }
        return l2;
    }

    private static void a(StringBuffer stringBuffer, long l2, int n2) {
        block3: {
            block2: {
                if (n2 != 1 && l2 <= Integer.MAX_VALUE) break block2;
                stringBuffer.append(l2);
                if (!Asn1Exception.z) break block3;
            }
            int n3 = (int)l2;
            Asn1PerTime.a(stringBuffer, n3, n2);
        }
    }

    private static void a(StringBuffer stringBuffer, int n2, int n3) {
        block4: {
            int n4;
            boolean bl;
            block5: {
                int n5;
                block3: {
                    bl = Asn1Exception.z;
                    if (n3 != 1) break block3;
                    stringBuffer.append(n2);
                    if (!bl) break block4;
                }
                if (n2 < (n5 = a[n3 - 2])) break block5;
                stringBuffer.append(n2);
                if (!bl) break block4;
            }
            for (int i2 = n4 = Asn1PerTime.a(n2); i2 < n3; ++i2) {
                stringBuffer.append('0');
                if (!bl) continue;
            }
            stringBuffer.append(n2);
        }
    }

    private static int a(int n2) {
        boolean bl = Asn1Exception.z;
        if (n2 < a[a.length - 1]) {
            for (int i2 = 0; i2 < a.length; ++i2) {
                if (n2 >= a[i2]) continue;
                return i2 + 1;
            }
        }
        return 10;
    }

    private static int b(int n2) {
        int n3;
        block16: {
            block21: {
                boolean bl;
                block20: {
                    block18: {
                        block19: {
                            block17: {
                                bl = Asn1Exception.z;
                                n3 = 0;
                                if ((n2 & 0x7C00) == 0) break block16;
                                if ((n2 & 0x8000) == 0) break block17;
                                n3 += 11;
                                if (!bl) break block18;
                            }
                            if ((n2 & 0x4000) == 0) break block19;
                            n3 += 3;
                            if (!bl) break block18;
                        }
                        if ((n2 & 0x2000) != 0) {
                            n3 += 4;
                        }
                    }
                    if ((n2 & 0x1000) == 0) break block20;
                    n3 += 3;
                    if ((n2 & 0x400) == 0) break block16;
                    n3 += 3;
                    if (!bl) break block16;
                }
                if ((n2 & 0x800) == 0) break block21;
                n3 += 4;
                if ((n2 & 0x400) == 0) break block16;
                n3 += 2;
                if (!bl) break block16;
            }
            if ((n2 & 0x400) != 0) {
                n3 += 4;
            }
        }
        if ((n2 & 0x380) != 0) {
            if (n3 > 0) {
                ++n3;
            }
            if ((n2 & 0x200) != 0) {
                n3 += 2;
            }
            if ((n2 & 0x100) != 0) {
                n3 += 3;
            }
            if ((n2 & 0x80) != 0) {
                n3 += 3;
            }
            if ((n2 & 0xF) != 0) {
                n3 += (n2 & 0xF) + 1;
            }
            if ((n2 & 0x40) != 0) {
                ++n3;
            }
            if ((n2 & 0x20) != 0) {
                n3 += 6;
            }
        }
        return n3;
    }

    private static void a(Asn1PerDecodeBuffer asn1PerDecodeBuffer, StringBuffer stringBuffer) throws IOException, Asn1Exception {
        int n2;
        char c2;
        boolean bl = Asn1Exception.z;
        long[] lArray = new long[9];
        boolean[] blArray = new boolean[9];
        boolean bl2 = true;
        for (c2 = '\u0000'; c2 < '\b'; ++c2) {
            blArray[c2] = asn1PerDecodeBuffer.decodeBit();
            if (!bl) continue;
        }
        blArray[8] = blArray[7];
        for (c2 = '\u0000'; c2 < '\t'; ++c2) {
            if (!blArray[c2]) continue;
            n2 = asn1PerDecodeBuffer.decodeBit();
            if (n2 != 0) {
                lArray[c2] = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
                if (!bl) continue;
            }
            lArray[c2] = Asn1Integer.decodeValue(asn1PerDecodeBuffer, c2 >= '\u0007' ? 1L : 0L, b[c2]);
            if (!bl) continue;
        }
        c2 = 'P';
        for (n2 = 0; n2 < 7; ++n2) {
            if (!blArray[n2]) continue;
            stringBuffer.append(c2);
            if (n2 >= 4 && n2 <= 6 && bl2) {
                bl2 = false;
                stringBuffer.append('T');
            }
            stringBuffer.append(lArray[n2]);
            c2 = c[n2];
            if (!bl) continue;
        }
        if (blArray[7]) {
            stringBuffer.append('.');
            Asn1PerTime.a(stringBuffer, lArray[8], (int)lArray[7]);
        }
        stringBuffer.append(c2);
    }

    private static void b(Asn1PerDecodeBuffer asn1PerDecodeBuffer, StringBuffer stringBuffer) throws IOException, Asn1Exception {
        boolean bl = asn1PerDecodeBuffer.decodeBit();
        stringBuffer.append('R');
        if (bl) {
            long l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
            stringBuffer.append(l2);
        }
        stringBuffer.append('/');
    }

    public static String decodeDuration(Asn1PerDecodeBuffer asn1PerDecodeBuffer, boolean bl) throws Asn1Exception {
        StringBuffer stringBuffer = new StringBuffer(90);
        try {
            if (bl) {
                Asn1PerTime.b(asn1PerDecodeBuffer, stringBuffer);
            }
            Asn1PerTime.a(asn1PerDecodeBuffer, stringBuffer);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    public static String decodeIntervalSE(Asn1PerDecodeBuffer asn1PerDecodeBuffer, boolean bl, int n2) throws Asn1Exception {
        return Asn1PerTime.a(asn1PerDecodeBuffer, bl, n2, n2);
    }

    public static String decodeIntervalSD(Asn1PerDecodeBuffer asn1PerDecodeBuffer, boolean bl, int n2) throws Asn1Exception {
        return Asn1PerTime.a(asn1PerDecodeBuffer, bl, n2, 16);
    }

    public static String decodeIntervalDE(Asn1PerDecodeBuffer asn1PerDecodeBuffer, boolean bl, int n2) throws Asn1Exception {
        return Asn1PerTime.a(asn1PerDecodeBuffer, bl, 16, n2);
    }

    private static String a(Asn1PerDecodeBuffer asn1PerDecodeBuffer, boolean bl, int n2, int n3) throws Asn1Exception {
        boolean bl2 = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if ((n2 & n3 & 0x10) != 0) {
                throw new Asn1Exception("interval cannot have two durations");
            }
            if (bl) {
                Asn1PerTime.b(asn1PerDecodeBuffer, stringBuffer);
            }
            int n4 = n2;
            for (int i2 = 0; i2 < 2; ++i2) {
                block12: {
                    block11: {
                        if ((n4 & 0x10) == 0) break block11;
                        Asn1PerTime.a(asn1PerDecodeBuffer, stringBuffer);
                        if (!bl2) break block12;
                    }
                    if ((n4 & 0x7C00) != 0) {
                        Asn1PerTime.a(asn1PerDecodeBuffer, stringBuffer, n4);
                        if ((n4 & 0x380) != 0) {
                            stringBuffer.append('T');
                        }
                    }
                    if ((n4 & 0x380) != 0) {
                        Asn1PerTime.b(asn1PerDecodeBuffer, stringBuffer, n4);
                    }
                }
                if (i2 != 0) continue;
                stringBuffer.append('/');
                n4 = n3;
                if (!bl2) continue;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static void c(Asn1PerDecodeBuffer asn1PerDecodeBuffer, StringBuffer stringBuffer) throws IOException, Asn1Exception {
        int n2;
        int n3;
        boolean bl;
        block6: {
            block5: {
                bl = asn1PerDecodeBuffer.decodeBit();
                int n4 = (int)asn1PerDecodeBuffer.decodeConsWholeNumber(2L);
                n3 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 15L);
                n2 = 0;
                if (bl) {
                    n2 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 1L, 59L);
                }
                if (n4 != 0) break block5;
                stringBuffer.append('+');
                if (!Asn1Exception.z) break block6;
            }
            stringBuffer.append('-');
        }
        Asn1PerTime.a(stringBuffer, n3, 2);
        if (bl) {
            stringBuffer.append(':');
            Asn1PerTime.a(stringBuffer, n2, 2);
        }
    }

    private static void b(Asn1PerDecodeBuffer asn1PerDecodeBuffer, StringBuffer stringBuffer, int n2) throws IOException, Asn1Exception {
        block15: {
            block14: {
                int n3;
                int n4;
                long l2;
                int n5;
                int n6;
                boolean bl;
                block12: {
                    block13: {
                        bl = Asn1Exception.z;
                        n6 = 0;
                        n5 = 0;
                        l2 = 0L;
                        n4 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 24L);
                        if ((n2 & 0x100) != 0) {
                            n6 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 59L);
                        }
                        if ((n2 & 0x80) != 0) {
                            n5 = (int)Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 60L);
                        }
                        if ((n2 & 0xF) == 0) break block12;
                        n3 = asn1PerDecodeBuffer.decodeBit();
                        if (n3 == 0) break block13;
                        l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
                        if (!bl) break block12;
                    }
                    l2 = Asn1Integer.decodeValue(asn1PerDecodeBuffer, 0L, 999L);
                }
                Asn1PerTime.a(stringBuffer, n4, 2);
                if ((n2 & 0x100) != 0) {
                    stringBuffer.append(':');
                    Asn1PerTime.a(stringBuffer, n6, 2);
                }
                if ((n2 & 0x80) != 0) {
                    stringBuffer.append(':');
                    Asn1PerTime.a(stringBuffer, n5, 2);
                }
                if ((n2 & 0xF) != 0) {
                    n3 = n2 & 0xF;
                    stringBuffer.append('.');
                    Asn1PerTime.a(stringBuffer, l2, n3);
                }
                if ((n2 & 0x40) == 0) break block14;
                stringBuffer.append('Z');
                if (!bl) break block15;
            }
            if ((n2 & 0x20) != 0) {
                Asn1PerTime.c(asn1PerDecodeBuffer, stringBuffer);
            }
        }
    }

    public static String decodeTime(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2) throws Asn1Exception {
        try {
            StringBuffer stringBuffer = new StringBuffer(Asn1PerTime.b(n2));
            Asn1PerTime.b(asn1PerDecodeBuffer, stringBuffer, n2);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static int a(String string, char c2, int n2, int n3) {
        int n4 = string.indexOf(c2, n2);
        if (n4 >= n3 || n4 == -1) {
            return n3;
        }
        return n4;
    }

    private static void a(Asn1PerEncoder asn1PerEncoder, long l2) throws Asn1Exception, IOException {
        block8: {
            block12: {
                boolean bl;
                block11: {
                    block6: {
                        block10: {
                            block9: {
                                block7: {
                                    bl = Asn1Exception.z;
                                    if (l2 < 2005L) break block6;
                                    if (l2 > 2020L) break block7;
                                    Asn1Integer.encodeValue(asn1PerEncoder, 0L, 0L, 3L);
                                    Asn1Integer.encodeValue(asn1PerEncoder, l2, 2005L, 2020L);
                                    if (!bl) break block8;
                                }
                                if (l2 > 2276L) break block9;
                                Asn1Integer.encodeValue(asn1PerEncoder, 1L, 0L, 3L);
                                Asn1Integer.encodeValue(asn1PerEncoder, l2, 2021L, 2276L);
                                if (!bl) break block8;
                            }
                            if (l2 > 9999L) break block10;
                            Asn1Integer.encodeValue(asn1PerEncoder, 3L, 0L, 3L);
                            asn1PerEncoder.encodeInt(l2, true, true);
                            if (!bl) break block8;
                        }
                        throw new Asn1Exception("year out of range 0..9999.");
                    }
                    if (l2 < 1749L) break block11;
                    Asn1Integer.encodeValue(asn1PerEncoder, 2L, 0L, 3L);
                    Asn1Integer.encodeValue(asn1PerEncoder, l2, 1749L, 2004L);
                    if (!bl) break block8;
                }
                if (l2 < 0L) break block12;
                Asn1Integer.encodeValue(asn1PerEncoder, 3L, 0L, 3L);
                asn1PerEncoder.encodeInt(l2, true, true);
                if (!bl) break block8;
            }
            throw new Asn1Exception("year out of range 0..9999.");
        }
    }

    public static void encodeDate(Asn1PerEncoder asn1PerEncoder, String string, int n2) throws Asn1Exception {
        try {
            Asn1PerTime.a(asn1PerEncoder, string, 0, string.length(), n2);
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static void a(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3, int n4) throws Asn1Exception, IOException {
        int n5;
        int n6;
        int n7;
        int n8;
        block45: {
            long l2;
            block46: {
                boolean bl;
                block44: {
                    block41: {
                        int n9;
                        block43: {
                            block42: {
                                String string2;
                                int n10;
                                char c2;
                                block40: {
                                    block39: {
                                        bl = Asn1Exception.z;
                                        l2 = 0L;
                                        n8 = 0;
                                        n7 = 0;
                                        n6 = 0;
                                        n5 = 0;
                                        c2 = string.charAt(n2);
                                        if (c2 != '+' && c2 != '-') break block39;
                                        ++n2;
                                        if (!bl) break block40;
                                    }
                                    c2 = '\u0000';
                                }
                                if (string.charAt(n10 = n3 - 1) == 'C') {
                                    if ((n4 & 0x4000) == 0) {
                                        throw new Asn1Exception("Century designator not expected");
                                    }
                                } else {
                                    if ((n4 & 0x4000) != 0) {
                                        throw new Asn1Exception("Century designator expected");
                                    }
                                    n10 = Asn1PerTime.a(string, '-', n2, n3);
                                }
                                l2 = Long.parseLong(string.substring(n2, n10));
                                if (c2 == '-') {
                                    l2 = -l2;
                                }
                                int n11 = n10 - n2;
                                boolean bl2 = (n4 & 0x2000) != 0;
                                int n12 = bl2 ? 9999 : 99;
                                int n13 = bl2 ? 4 : 2;
                                String string3 = string2 = bl2 ? "year" : "century";
                                if (n11 > n13 && string.charAt(n2) == '0') {
                                    throw new Asn1Exception("leading zero not allowed or too many leading zeros");
                                }
                                if ((n4 & 0x8000) != 0 && (n4 & 0x6000) != 0) {
                                    if (l2 >= 0L && l2 <= (long)n12) {
                                        throw new Asn1Exception("year out of range 100000...");
                                    }
                                    if (c2 == '\u0000' && l2 > (long)n12) {
                                        throw new Asn1Exception("leading '+' required for " + string2 + " > " + n12);
                                    }
                                } else {
                                    if (l2 < 0L) {
                                        throw new Asn1Exception("negative " + string2 + " not expected");
                                    }
                                    if (c2 == '+') {
                                        throw new Asn1Exception("leading sign not allowed");
                                    }
                                    if (l2 > (long)n12) {
                                        throw new Asn1Exception(string2 + " > " + n12);
                                    }
                                }
                                if ((n4 & 0x6000) != 0 && n11 < n13) {
                                    throw new Asn1Exception(string2 + " requires at least " + n13 + " digits");
                                }
                                n2 = n10;
                                if ((n4 & 0x4000) != 0) {
                                    ++n2;
                                }
                                if ((n4 & 0x1800) != 0) {
                                    int n14;
                                    n9 = (n4 & 0x1000) != 0 ? 1 : 0;
                                    n5 = n9 != 0 ? 12 : 53;
                                    string2 = n9 != 0 ? "month" : "week";
                                    int n15 = n14 = n9 != 0 ? 3 : 4;
                                    if (n3 - n2 < n14) {
                                        throw new Asn1Exception("string ends unexpectedly at " + string2);
                                    }
                                    if (string.charAt(n2++) != '-') {
                                        throw new Asn1Exception("expected '-' separator");
                                    }
                                    if (n9 == 0 && string.charAt(n2++) != 'W') {
                                        throw new Asn1Exception("week designator 'W' expected");
                                    }
                                    n8 = Asn1PerTime.a(string, n2, n2 + 2, false);
                                    n2 += 2;
                                    if (n8 < 1 || n8 > n5) {
                                        throw new Asn1Exception("bad value for " + string2);
                                    }
                                }
                                if ((n4 & 0x400) == 0) break block41;
                                n9 = 3;
                                n6 = 366;
                                if ((n4 & 0x1000) == 0) break block42;
                                n6 = 31;
                                n9 = 2;
                                if (!bl) break block43;
                            }
                            if ((n4 & 0x800) != 0) {
                                n6 = 7;
                                n9 = 1;
                            }
                        }
                        if (n3 - n2 < n9 + 1) {
                            throw new Asn1Exception("string ends unexpectedly at day");
                        }
                        if (string.charAt(n2++) != '-') {
                            throw new Asn1Exception("expected '-' separator");
                        }
                        n7 = Asn1PerTime.a(string, n2, n2 + n9, false);
                        n2 += n9;
                    }
                    if (n2 < n3) {
                        throw new Asn1Exception("unexpected input for date");
                    }
                    if ((n4 & 0x8000) == 0) break block44;
                    asn1PerEncoder.encodeInt(l2, true, true);
                    if (!bl) break block45;
                }
                if ((n4 & 0x4000) == 0) break block46;
                Asn1Integer.encodeValue(asn1PerEncoder, l2, 0L, 99L);
                if (!bl) break block45;
            }
            if ((n4 & 0x2000) != 0) {
                Asn1PerTime.a(asn1PerEncoder, l2);
            }
        }
        if ((n4 & 0x1800) != 0) {
            Asn1Integer.encodeValue(asn1PerEncoder, n8, 1L, n5);
        }
        if ((n4 & 0x400) != 0) {
            Asn1Integer.encodeValue(asn1PerEncoder, n7, 1L, n6);
        }
    }

    private static void b(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3, int n4) throws Asn1Exception, IOException {
        int n5 = Asn1PerTime.a(string, 'T', n2, n3);
        if (n5 == n3) {
            throw new Asn1Exception("Missing time separator 'T'");
        }
        Asn1PerTime.a(asn1PerEncoder, string, n2, n5, n4);
        Asn1PerTime.d(asn1PerEncoder, string, n5 + 1, n3, n4);
    }

    public static void encodeDateTime(Asn1PerEncoder asn1PerEncoder, String string, int n2) throws Asn1Exception {
        try {
            Asn1PerTime.b(asn1PerEncoder, string, 0, string.length(), n2);
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static void a(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3) throws Asn1Exception, IOException {
        int n4;
        boolean bl = Asn1Exception.z;
        char[] cArray = new char[n3 - n2];
        string.getChars(n2, n3, cArray, 0);
        n2 = 0;
        n3 = cArray.length;
        long[] lArray = new long[9];
        boolean[] blArray = new boolean[9];
        if (cArray[n2++] != 'P') {
            throw new Asn1Exception("Duration must begin with 'P'");
        }
        for (n4 = 0; n4 < 7 && !blArray[7] && !blArray[2] && n2 < n3; ++n4) {
            int n5;
            long l2 = 0L;
            if (n4 == 4 && cArray[n2] != 'T') {
                throw new Asn1Exception("Expected T separator in duration");
            }
            if (n4 <= 4 && cArray[n2] == 'T') {
                ++n2;
                n4 = 4;
            }
            while (n2 < n3 && '0' <= cArray[n2] && cArray[n2] <= '9') {
                n5 = cArray[n2] - 48;
                if (l2 == 0L && n5 == 0) {
                    throw new Asn1Exception("leading zero not allowed");
                }
                l2 = l2 * 10L + (long)n5;
                ++n2;
                if (!bl) continue;
            }
            if ((n5 = cArray[n2++]) == 46 || n5 == 44) {
                blArray[8] = true;
                blArray[7] = true;
                lArray[8] = 0L;
                lArray[7] = 0L;
                while (n2 < n3 && '0' <= cArray[n2] && cArray[n2] <= '9') {
                    lArray[7] = lArray[7] + 1L;
                    lArray[8] = lArray[8] * 10L + (long)(cArray[n2] - 48);
                    ++n2;
                    if (!bl) continue;
                }
                n5 = cArray[n2++];
            }
            int n6 = n4;
            while (n4 < 7) {
                if (n6 < 4 && n4 == 4) {
                    throw new Asn1Exception("Expected T separator in duration");
                }
                if (n5 == c[n4]) {
                    blArray[n4] = true;
                    lArray[n4] = l2;
                    if (!bl) break;
                }
                ++n4;
                if (!bl) continue;
            }
            if (n4 == 7) {
                throw new Asn1Exception("Incorrect duration suffix");
            }
            if (n4 != 2 || !blArray[0] && !blArray[1]) continue;
            throw new Asn1Exception("durations with weeks cannot have other fields");
        }
        if (n2 != n3) {
            throw new Asn1Exception("duration does not end when expected");
        }
        for (n4 = 0; n4 < 8; ++n4) {
            asn1PerEncoder.encodeBit(blArray[n4]);
            if (!bl) continue;
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (!blArray[n4]) continue;
            boolean bl2 = lArray[n4] > (long)b[n4];
            asn1PerEncoder.encodeBit(bl2);
            if (bl2) {
                asn1PerEncoder.encodeInt(lArray[n4], true, true);
                if (!bl) continue;
            }
            Asn1Integer.encodeValue(asn1PerEncoder, lArray[n4], n4 >= 7 ? 1L : 0L, b[n4]);
            if (!bl) continue;
        }
    }

    public static void encodeDuration(Asn1PerEncoder asn1PerEncoder, String string, boolean bl) throws Asn1Exception {
        try {
            int n2 = 0;
            if (bl) {
                n2 = Asn1PerTime.a(asn1PerEncoder, string);
            }
            Asn1PerTime.a(asn1PerEncoder, string, n2, string.length());
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static int a(Asn1PerEncoder asn1PerEncoder, String string) throws Asn1Exception, IOException {
        int n2;
        block7: {
            block6: {
                if (string.charAt(0) != 'R') {
                    throw new Asn1Exception("Recurring interval should begin with R");
                }
                int n3 = string.length();
                n2 = Asn1PerTime.a(string, '/', 1, n3);
                if (n2 == n3) {
                    throw new Asn1Exception("missing / after recurrences");
                }
                if (n2 < 2) break block6;
                if (string.charAt(1) == '0') {
                    throw new Asn1Exception("leading zero not allowed on recurrence");
                }
                int n4 = Asn1PerTime.a(string, 1, n2, false);
                asn1PerEncoder.encodeBit(true);
                asn1PerEncoder.encodeInt((long)n4, true, true);
                if (!Asn1Exception.z) break block7;
            }
            asn1PerEncoder.encodeBit(false);
        }
        return n2 + 1;
    }

    public static void encodeIntervalSE(Asn1PerEncoder asn1PerEncoder, String string, boolean bl, int n2) throws Asn1Exception {
        Asn1PerTime.a(asn1PerEncoder, string, bl, n2, n2);
    }

    public static void encodeIntervalSD(Asn1PerEncoder asn1PerEncoder, String string, boolean bl, int n2) throws Asn1Exception {
        Asn1PerTime.a(asn1PerEncoder, string, bl, n2, 16);
    }

    public static void encodeIntervalDE(Asn1PerEncoder asn1PerEncoder, String string, boolean bl, int n2) throws Asn1Exception {
        Asn1PerTime.a(asn1PerEncoder, string, bl, 16, n2);
    }

    private static void a(Asn1PerEncoder asn1PerEncoder, String string, boolean bl, int n2, int n3) throws Asn1Exception {
        try {
            int n4;
            int n5 = string.length();
            int n6 = 0;
            if (bl) {
                n6 = Asn1PerTime.a(asn1PerEncoder, string);
            }
            if ((n4 = Asn1PerTime.a(string, '/', n6, n5)) == n5) {
                throw new Asn1Exception("interval missing '/' separator");
            }
            if ((n2 & n3 & 0x10) != 0) {
                throw new Asn1Exception("intervals cannot have two durations");
            }
            Asn1PerTime.c(asn1PerEncoder, string, n6, n4, n2);
            Asn1PerTime.c(asn1PerEncoder, string, n4 + 1, n5, n3);
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static void c(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3, int n4) throws Asn1Exception, IOException {
        block3: {
            block5: {
                boolean bl;
                boolean bl2;
                block4: {
                    boolean bl3;
                    block2: {
                        bl2 = Asn1Exception.z;
                        if ((n4 & 0x10) == 0) break block2;
                        Asn1PerTime.a(asn1PerEncoder, string, n2, n3);
                        if (!bl2) break block3;
                    }
                    bl = (n4 & 0x7C00) != 0;
                    boolean bl4 = bl3 = (n4 & 0x380) != 0;
                    if (!bl || !bl3) break block4;
                    Asn1PerTime.b(asn1PerEncoder, string, n2, n3, n4);
                    if (!bl2) break block3;
                }
                if (!bl) break block5;
                Asn1PerTime.a(asn1PerEncoder, string, n2, n3, n4);
                if (!bl2) break block3;
            }
            Asn1PerTime.d(asn1PerEncoder, string, n2, n3, n4);
        }
    }

    private static void b(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3) throws Asn1Exception, IOException {
        int n4;
        boolean bl;
        boolean bl2;
        int n5;
        block12: {
            char c2;
            block11: {
                n5 = 0;
                bl2 = false;
                bl = false;
                if ((c2 = string.charAt(n2++)) != '-') break block11;
                bl = true;
                if (!Asn1Exception.z) break block12;
            }
            if (c2 != '+') {
                throw new Asn1Exception("timezone diff require sign");
            }
        }
        if ((n4 = Asn1PerTime.a(string, n2, n2 + 2, false)) > 15) {
            throw new Asn1Exception("timezone diff hours out of range -15..15");
        }
        if ((n2 += 2) < n3) {
            if (string.charAt(n2++) != ':') {
                throw new Asn1Exception("only colon should follow 2 digit hour");
            }
            if (n3 - n2 != 2) {
                throw new Asn1Exception("timezone diff requires two digits for minutes");
            }
            n5 = Asn1PerTime.a(string, n2, n3, false);
            if (n5 > 0) {
                bl2 = true;
            }
            if (n5 > 59) {
                throw new Asn1Exception("timezone minutes out of range 0..59");
            }
        }
        asn1PerEncoder.encodeBit(bl2);
        asn1PerEncoder.encodeConsWholeNumber(bl ? 1L : 0L, 2L);
        Asn1Integer.encodeValue(asn1PerEncoder, n4, 0L, 15L);
        if (bl2) {
            Asn1Integer.encodeValue(asn1PerEncoder, n5, 1L, 59L);
        }
    }

    private static void d(Asn1PerEncoder asn1PerEncoder, String string, int n2, int n3, int n4) throws Asn1Exception, IOException {
        block16: {
            long l2;
            block17: {
                int n5;
                int n6 = 0;
                int n7 = 0;
                l2 = 0L;
                int n8 = Asn1PerTime.a(string, n2, n2 + 2, false);
                if (n8 > 24) {
                    throw new Asn1Exception("hour > 24");
                }
                n2 += 2;
                if ((n4 & 0x100) != 0) {
                    if (string.charAt(n2++) != ':') {
                        throw new Asn1Exception("expected minutes");
                    }
                    n6 = Asn1PerTime.a(string, n2, n2 + 2, false);
                    if (n6 > 59) {
                        throw new Asn1Exception("minute > 59");
                    }
                    n2 += 2;
                }
                if ((n4 & 0x80) != 0) {
                    if (string.charAt(n2++) != ':') {
                        throw new Asn1Exception("expected seconds");
                    }
                    n7 = Asn1PerTime.a(string, n2, n2 + 2, false);
                    if (n7 > 60) {
                        throw new Asn1Exception("second > 60");
                    }
                    n2 += 2;
                }
                if ((n4 & 0xF) != 0) {
                    char c2;
                    n5 = n4 & 0xF;
                    if ((c2 = string.charAt(n2++)) != '.' && c2 != ',') {
                        throw new Asn1Exception("expected fraction");
                    }
                    l2 = Long.parseLong(string.substring(n2, n2 + n5));
                    n2 += n5;
                }
                if ((n4 & 0x40) != 0 && string.charAt(n2) != 'Z') {
                    throw new Asn1Exception("expected UTC designation 'Z'");
                }
                Asn1Integer.encodeValue(asn1PerEncoder, n8, 0L, 24L);
                if ((n4 & 0x100) != 0) {
                    Asn1Integer.encodeValue(asn1PerEncoder, n6, 0L, 59L);
                }
                if ((n4 & 0x80) != 0) {
                    Asn1Integer.encodeValue(asn1PerEncoder, n7, 0L, 60L);
                }
                if ((n4 & 0xF) == 0) break block16;
                n5 = l2 > 999L ? 1 : 0;
                asn1PerEncoder.encodeBit(n5 != 0);
                if (n5 == 0) break block17;
                asn1PerEncoder.encodeInt(l2, true, true);
                if (!Asn1Exception.z) break block16;
            }
            Asn1Integer.encodeValue(asn1PerEncoder, l2, 0L, 999L);
        }
        if ((n4 & 0x20) != 0) {
            Asn1PerTime.b(asn1PerEncoder, string, n2, n3);
        }
    }

    public static void encodeTime(Asn1PerEncoder asn1PerEncoder, String string, int n2) throws Asn1Exception {
        try {
            Asn1PerTime.d(asn1PerEncoder, string, 0, string.length(), n2);
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    private static int a(String string, int n2, int n3, boolean bl) {
        boolean bl2 = Asn1Exception.z;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                if ((n4 = n4 * 10 + (c2 - 48)) >= 0) continue;
                if (bl && n4 == Integer.MIN_VALUE && n2 == n3) {
                    return n4;
                }
                throw new NumberFormatException("value outside range of int");
            }
            throw new NumberFormatException(c2 + "");
        }
        return n4;
    }
}

