/*
 * Decompiled with CFR 0.152.
 */
package sune.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class ThreadLocalCoders {
    private static final int CACHE_SIZE = 3;
    private static Cache decoderCache = new Cache(3){

        @Override
        boolean hasName(Object ob, Object name) {
            if (name instanceof String) {
                return ((CharsetDecoder)ob).charset().name().equals(name);
            }
            if (name instanceof Charset) {
                return ((CharsetDecoder)ob).charset().equals(name);
            }
            return false;
        }

        @Override
        Object create(Object name) {
            if (name instanceof String) {
                return Charset.forName((String)name).newDecoder();
            }
            if (name instanceof Charset) {
                return ((Charset)name).newDecoder();
            }
            assert (false);
            return null;
        }
    };
    private static Cache encoderCache = new Cache(3){

        @Override
        boolean hasName(Object ob, Object name) {
            if (name instanceof String) {
                return ((CharsetEncoder)ob).charset().name().equals(name);
            }
            if (name instanceof Charset) {
                return ((CharsetEncoder)ob).charset().equals(name);
            }
            return false;
        }

        @Override
        Object create(Object name) {
            if (name instanceof String) {
                return Charset.forName((String)name).newEncoder();
            }
            if (name instanceof Charset) {
                return ((Charset)name).newEncoder();
            }
            assert (false);
            return null;
        }
    };

    public static CharsetDecoder decoderFor(Object name) {
        CharsetDecoder cd = (CharsetDecoder)decoderCache.forName(name);
        cd.reset();
        return cd;
    }

    public static CharsetEncoder encoderFor(Object name) {
        CharsetEncoder ce = (CharsetEncoder)encoderCache.forName(name);
        ce.reset();
        return ce;
    }

    private static abstract class Cache {
        private ThreadLocal cache = new ThreadLocal();
        private final int size;

        Cache(int size) {
            this.size = size;
        }

        abstract Object create(Object var1);

        private void moveToFront(Object[] oa, int i) {
            Object ob = oa[i];
            for (int j = i; j > 0; --j) {
                oa[j] = oa[j - 1];
            }
            oa[0] = ob;
        }

        abstract boolean hasName(Object var1, Object var2);

        Object forName(Object name) {
            Object ob;
            Object[] oa = (Object[])this.cache.get();
            if (oa == null) {
                oa = new Object[this.size];
                this.cache.set(oa);
            } else {
                for (int i = 0; i < oa.length; ++i) {
                    Object ob2 = oa[i];
                    if (ob2 == null || !this.hasName(ob2, name)) continue;
                    if (i > 0) {
                        this.moveToFront(oa, i);
                    }
                    return ob2;
                }
            }
            oa[oa.length - 1] = ob = this.create(name);
            this.moveToFront(oa, oa.length - 1);
            return ob;
        }
    }
}

