/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerUtil;
import com.objsys.asn1j.runtime.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Asn1XerEncodeBuffer
extends Asn1EncodeBuffer
implements Asn1XerEncoder {
    int a = 0;
    int b = 0;
    String c = "\n";
    String d;
    boolean e;
    private static h f = h.a();

    public Asn1XerEncodeBuffer() {
        this.e = false;
    }

    public Asn1XerEncodeBuffer(boolean bl) {
        super(0);
        this.e = bl;
    }

    public Asn1XerEncodeBuffer(boolean bl, int n2) {
        super(n2);
        this.e = bl;
    }

    public void binDump(PrintStream printStream, String string) {
        this.hexDump();
    }

    public void copy(byte by) {
        this.checkSize(1);
        this.mData[this.mByteIndex++] = by;
    }

    public void copy(byte[] byArray) throws Asn1Exception {
        this.checkSize(byArray.length);
        System.arraycopy(byArray, 0, this.mData, this.mByteIndex, byArray.length);
        this.mByteIndex += byArray.length;
    }

    public void copy(byte[] byArray, int n2, int n3) throws Asn1Exception {
        this.checkSize(n3);
        System.arraycopy(byArray, n2, this.mData, this.mByteIndex, n3);
        this.mByteIndex += n3;
    }

    public void copy(String string) throws Asn1Exception {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.copy(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void decrLevel() {
        --this.a;
    }

    public void encodeByte(byte by) {
        block7: {
            byte by2;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        bl = Asn1Exception.z;
                        this.checkSize(2);
                        by2 = (byte)((by & 0xFF) >>> 4);
                        if (by2 < 0 || by2 > 9) break block4;
                        this.mData[this.mByteIndex++] = (byte)(by2 + 48);
                        if (!bl) break block5;
                    }
                    this.mData[this.mByteIndex++] = (byte)(by2 - 10 + 65);
                }
                if ((by2 = (byte)(by & 0xF)) < 0 || by2 > 9) break block6;
                this.mData[this.mByteIndex++] = (byte)(by2 + 48);
                if (!bl) break block7;
            }
            this.mData[this.mByteIndex++] = (byte)(by2 - 10 + 65);
        }
        f.lcheck(4);
    }

    public void encodeData(String string) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                if (!bl) continue;
            }
            if (c2 == '<') {
                stringBuffer.append("&lt;");
                if (!bl) continue;
            }
            if (c2 == '>') {
                stringBuffer.append("&gt;");
                if (!bl) continue;
            }
            if (c2 == '\'') {
                stringBuffer.append("&apos;");
                if (!bl) continue;
            }
            if (c2 == '\"') {
                stringBuffer.append("&quot;");
                if (!bl) continue;
            }
            stringBuffer.append(c2);
            if (!bl) continue;
        }
        this.copy(stringBuffer.toString());
        this.b = 2;
    }

    public void encodeBinStrValue(byte[] byArray, int n2) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        int n3 = 128;
        this.checkSize(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mData[this.mByteIndex++] = (byte)((byArray[i2 / 8] & n3) != 0 ? 49 : 48);
            if (0 != (n3 >>>= 1)) continue;
            n3 = 128;
            if (!bl) continue;
        }
        f.lcheck(4);
    }

    public void encodeHexStrValue(byte[] byArray) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        this.checkSize(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.encodeByte(byArray[i2]);
            if (!bl) continue;
        }
    }

    public void encodeEndDocument() throws Asn1Exception {
    }

    public void encodeEndElement(String string) throws Asn1Exception {
        if (this.b == 3) {
            this.indent();
        }
        if (string != null) {
            String string2 = new String("</" + string + ">");
            this.copy(string2);
        }
        this.b = 3;
    }

    public void encodeStartDocument() throws Asn1Exception {
        this.copy("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void encodeStartElement(String string) throws Asn1Exception {
        this.indent();
        if (string != null) {
            String string2 = new String("<" + string + ">");
            this.copy(string2);
        }
        this.b = 1;
    }

    public void encodeEmptyElement(String string) throws Asn1Exception {
        String string2 = new String("<" + string + "/>");
        this.copy(string2);
        this.b = 3;
    }

    public void encodeNamedValueElement(String string) throws Asn1Exception {
        String string2 = new String("<" + string + "/>");
        this.copy(string2);
        this.b = 2;
    }

    public void encodeRealValue(double d2, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "REAL";
        }
        f.lcheck(4);
        Asn1XerUtil.encodeReal(this, d2, string);
    }

    public byte[] getBuffer() {
        return this.mData;
    }

    public byte[] getMsgCopy() {
        byte[] byArray = new byte[this.mByteIndex];
        System.arraycopy(this.mData, 0, byArray, 0, this.mByteIndex);
        return byArray;
    }

    public int getMsgLength() {
        return this.mByteIndex;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.mData, 0, this.mByteIndex);
    }

    public int getState() {
        return this.b;
    }

    public void incrLevel() {
        ++this.a;
    }

    public void indent() throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        if (!this.e) {
            this.copy(this.c);
            int n2 = this.a * 3;
            this.checkSize(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mData[this.mByteIndex++] = 32;
                if (!bl) continue;
            }
        }
    }

    public void reset() {
        this.mByteIndex = 0;
    }

    public void setCanonical(boolean bl) {
        this.e = bl;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.mData, 0, this.mByteIndex);
    }

    public void setState(int n2) {
        this.b = n2;
    }

    public void encodeNamedValue(String string, String string2) throws Asn1Exception {
        if (string2.length() > 0) {
            this.encodeStartElement(string2);
        }
        this.encodeNamedValueElement(string);
        if (string2.length() > 0) {
            this.encodeEndElement(string2);
        }
    }
}

