/*
 * Decompiled with CFR 0.152.
 */
package sune.net.www;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.BitSet;
import sune.nio.cs.ThreadLocalCoders;

public class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);
    private static final char[] hexDigits;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private static final long L_HEX;
    private static final long H_HEX;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA;
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA;
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA;
    private static final long L_ALPHANUM;
    private static final long H_ALPHANUM;
    private static final long L_MARK;
    private static final long H_MARK;
    private static final long L_UNRESERVED;
    private static final long H_UNRESERVED;
    private static final long L_RESERVED;
    private static final long H_RESERVED;
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_DASH;
    private static final long H_DASH;
    private static final long L_URIC;
    private static final long H_URIC;
    private static final long L_PCHAR;
    private static final long H_PCHAR;
    private static final long L_PATH;
    private static final long H_PATH;
    private static final long L_USERINFO;
    private static final long H_USERINFO;
    private static final long L_REG_NAME;
    private static final long H_REG_NAME;
    private static final long L_SERVER;
    private static final long H_SERVER;

    public static String encodePath(String path) {
        return ParseUtil.encodePath(path, true);
    }

    public static String encodePath(String path, boolean flag) {
        char[] retCC = new char[path.length() * 2 + 16];
        int retLen = 0;
        char[] pathCC = path.toCharArray();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = pathCC[i];
            if (!flag && c == '/' || flag && c == File.separatorChar) {
                retCC[retLen++] = 47;
            } else if (c <= '\u007f') {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                    retCC[retLen++] = c;
                } else if (encodedInPath.get(c)) {
                    retLen = ParseUtil.escape(retCC, c, retLen);
                } else {
                    retCC[retLen++] = c;
                }
            } else if (c > '\u07ff') {
                retLen = ParseUtil.escape(retCC, (char)(0xE0 | c >> 12 & 0xF), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 6 & 0x3F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            } else {
                retLen = ParseUtil.escape(retCC, (char)(0xC0 | c >> 6 & 0x1F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            }
            if (retLen + 9 <= retCC.length) continue;
            int newLen = retCC.length * 2 + 16;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            char[] buf = new char[newLen];
            System.arraycopy(retCC, 0, buf, 0, retLen);
            retCC = buf;
        }
        return new String(retCC, 0, retLen);
    }

    private static int escape(char[] cc, char c, int index) {
        cc[index++] = 37;
        cc[index++] = Character.forDigit(c >> 4 & 0xF, 16);
        cc[index++] = Character.forDigit(c & 0xF, 16);
        return index;
    }

    private static byte unescape(String s, int i) {
        return (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    public static String decode(String s) {
        int n = s.length();
        if (n == 0 || s.indexOf(37) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        char c = s.charAt(0);
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c != '%') {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            int ui = i;
            do {
                assert (n - i >= 2);
                try {
                    bb.put(ParseUtil.unescape(s, i));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            } while ((i += 3) < n && (c = s.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            if (cr.isError()) {
                throw new IllegalArgumentException("Error decoding percent encoded characters");
            }
            cr = dec.flush(cb);
            if (cr.isError()) {
                throw new IllegalArgumentException("Error decoding percent encoded characters");
            }
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }

    public String canonizeString(String file) {
        int i = 0;
        int lim = file.length();
        while ((i = file.indexOf("/../")) >= 0) {
            lim = file.lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = file.substring(0, lim) + file.substring(i + 3);
                continue;
            }
            file = file.substring(i + 3);
        }
        while ((i = file.indexOf("/./")) >= 0) {
            file = file.substring(0, i) + file.substring(i + 2);
        }
        while (file.endsWith("/..")) {
            i = file.indexOf("/..");
            lim = file.lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = file.substring(0, lim + 1);
                continue;
            }
            file = file.substring(0, i);
        }
        if (file.endsWith("/.")) {
            file = file.substring(0, file.length() - 1);
        }
        return file;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (!(path = ParseUtil.encodePath(path)).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static URI toURI(URL url) {
        URI uri;
        String protocol = url.getProtocol();
        String auth = url.getAuthority();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (auth != null && auth.endsWith(":-1")) {
            auth = auth.substring(0, auth.length() - 3);
        }
        try {
            uri = ParseUtil.createURI(protocol, auth, path, query, ref);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        return uri;
    }

    private static URI createURI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        String s = ParseUtil.toString(scheme, null, authority, null, null, -1, path, query, fragment);
        ParseUtil.checkPath(s, scheme, path);
        return new URI(s);
    }

    private static String toString(String scheme, String opaquePart, String authority, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuffer sb = new StringBuffer();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        ParseUtil.appendSchemeSpecificPart(sb, opaquePart, authority, userInfo, host, port, path, query);
        ParseUtil.appendFragment(sb, fragment);
        return sb.toString();
    }

    private static void appendSchemeSpecificPart(StringBuffer sb, String opaquePart, String authority, String userInfo, String host, int port, String path, String query) {
        if (opaquePart != null) {
            if (opaquePart.startsWith("//[")) {
                int end = opaquePart.indexOf("]");
                if (end != -1 && opaquePart.indexOf(":") != -1) {
                    String doquote;
                    String dontquote;
                    if (end == opaquePart.length()) {
                        dontquote = opaquePart;
                        doquote = "";
                    } else {
                        dontquote = opaquePart.substring(0, end + 1);
                        doquote = opaquePart.substring(end + 1);
                    }
                    sb.append(dontquote);
                    sb.append(ParseUtil.quote(doquote, L_URIC, H_URIC));
                }
            } else {
                sb.append(ParseUtil.quote(opaquePart, L_URIC, H_URIC));
            }
        } else {
            ParseUtil.appendAuthority(sb, authority, userInfo, host, port);
            if (path != null) {
                sb.append(ParseUtil.quote(path, L_PATH, H_PATH));
            }
            if (query != null) {
                sb.append('?');
                sb.append(ParseUtil.quote(query, L_URIC, H_URIC));
            }
        }
    }

    private static void appendAuthority(StringBuffer sb, String authority, String userInfo, String host, int port) {
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(ParseUtil.quote(userInfo, L_USERINFO, H_USERINFO));
                sb.append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        } else if (authority != null) {
            sb.append("//");
            if (authority.startsWith("[")) {
                int end = authority.indexOf("]");
                if (end != -1 && authority.indexOf(":") != -1) {
                    String doquote;
                    String dontquote;
                    if (end == authority.length()) {
                        dontquote = authority;
                        doquote = "";
                    } else {
                        dontquote = authority.substring(0, end + 1);
                        doquote = authority.substring(end + 1);
                    }
                    sb.append(dontquote);
                    sb.append(ParseUtil.quote(doquote, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
                }
            } else {
                sb.append(ParseUtil.quote(authority, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            }
        }
    }

    private static void appendFragment(StringBuffer sb, String fragment) {
        if (fragment != null) {
            sb.append('#');
            sb.append(ParseUtil.quote(fragment, L_URIC, H_URIC));
        }
    }

    private static String quote(String s, long lowMask, long highMask) {
        int n = s.length();
        StringBuffer sb = null;
        boolean allowNonASCII = (lowMask & 1L) != 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (!ParseUtil.match(c, lowMask, highMask) && !ParseUtil.isEscaped(s, i)) {
                    if (sb == null) {
                        sb = new StringBuffer();
                        sb.append(s.substring(0, i));
                    }
                    ParseUtil.appendEscape(sb, (byte)c);
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (allowNonASCII && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(s.substring(0, i));
                }
                ParseUtil.appendEncoded(sb, c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    private static boolean isEscaped(String s, int pos) {
        if (s == null || s.length() <= pos + 2) {
            return false;
        }
        return s.charAt(pos) == '%' && ParseUtil.match(s.charAt(pos + 1), L_HEX, H_HEX) && ParseUtil.match(s.charAt(pos + 2), L_HEX, H_HEX);
    }

    private static void appendEncoded(StringBuffer sb, char c) {
        Buffer bb;
        block4: {
            bb = null;
            try {
                bb = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + c));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (bb.hasRemaining()) {
            int b = ((ByteBuffer)bb).get() & 0xFF;
            if (b >= 128) {
                ParseUtil.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b >> 0 & 0xF]);
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static void checkPath(String s, String scheme, String path) throws URISyntaxException {
        if (scheme != null && path != null && path.length() > 0 && path.charAt(0) != '/') {
            throw new URISyntaxException(s, "Relative path in absolute URI");
        }
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        L_HEX = L_DIGIT = ParseUtil.lowMask('0', '9');
        H_HEX = ParseUtil.highMask('A', 'F') | ParseUtil.highMask('a', 'f');
        H_UPALPHA = ParseUtil.highMask('A', 'Z');
        H_LOWALPHA = ParseUtil.highMask('a', 'z');
        H_ALPHA = H_LOWALPHA | H_UPALPHA;
        L_ALPHANUM = L_DIGIT | 0L;
        H_ALPHANUM = 0L | H_ALPHA;
        L_MARK = ParseUtil.lowMask("-_.!~*'()");
        H_MARK = ParseUtil.highMask("-_.!~*'()");
        L_UNRESERVED = L_ALPHANUM | L_MARK;
        H_UNRESERVED = H_ALPHANUM | H_MARK;
        L_RESERVED = ParseUtil.lowMask(";/?:@&=+$,[]");
        H_RESERVED = ParseUtil.highMask(";/?:@&=+$,[]");
        L_DASH = ParseUtil.lowMask("-");
        H_DASH = ParseUtil.highMask("-");
        L_URIC = L_RESERVED | L_UNRESERVED | 1L;
        H_URIC = H_RESERVED | H_UNRESERVED | 0L;
        L_PCHAR = L_UNRESERVED | 1L | ParseUtil.lowMask(":@&=+$,");
        H_PCHAR = H_UNRESERVED | 0L | ParseUtil.highMask(":@&=+$,");
        L_PATH = L_PCHAR | ParseUtil.lowMask(";/");
        H_PATH = H_PCHAR | ParseUtil.highMask(";/");
        L_USERINFO = L_UNRESERVED | 1L | ParseUtil.lowMask(";:&=+$,");
        H_USERINFO = H_UNRESERVED | 0L | ParseUtil.highMask(";:&=+$,");
        L_REG_NAME = L_UNRESERVED | 1L | ParseUtil.lowMask("$,;:@&=+");
        H_REG_NAME = H_UNRESERVED | 0L | ParseUtil.highMask("$,;:@&=+");
        L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | ParseUtil.lowMask(".:@[]");
        H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | ParseUtil.highMask(".:@[]");
    }
}

