/*
 * Decompiled with CFR 0.152.
 */
package sune.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sune.misc.BASE64Decoder;
import sune.security.jca.Providers;
import sune.security.pkcs.PKCS9Attribute;
import sune.security.pkcs.PKCS9Attributes;
import sune.security.pkcs.android.PKCS7;
import sune.security.pkcs.android.SignerInfo;
import sune.security.timestamp.TimestampToken;
import sune.security.util.Debug;
import sune.security.util.ManifestDigester;

public class SignatureFileVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private ArrayList<CodeSigner[]> signerCache;
    private static final String ATTR_DIGEST = "-DIGEST-Manifest-Main-Attributes".toUpperCase(Locale.ENGLISH);
    private PKCS7 block;
    private byte[] sfBytes;
    private String name;
    private ManifestDigester md;
    private HashMap<String, MessageDigest> createdDigests;
    private boolean workaround = false;
    private CertificateFactory certificateFactory = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureFileVerifier(ArrayList<CodeSigner[]> signerCache, ManifestDigester md, String name, byte[] rawBytes) throws IOException, CertificateException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            this.block = new PKCS7(rawBytes);
            this.sfBytes = this.block.getContentInfo().getData();
            this.certificateFactory = CertificateFactory.getInstance("X509");
        }
        finally {
            Providers.stopJarVerification(obj);
        }
        this.name = name.substring(0, name.lastIndexOf(".")).toUpperCase(Locale.ENGLISH);
        this.md = md;
        this.signerCache = signerCache;
    }

    public boolean needSignatureFileBytes() {
        return this.sfBytes == null;
    }

    public boolean needSignatureFile(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public void setSignatureFile(byte[] sfBytes) {
        this.sfBytes = sfBytes;
    }

    public static boolean isBlockOrSF(String s) {
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA");
    }

    private MessageDigest getDigest(String algorithm) {
        MessageDigest digest;
        if (this.createdDigests == null) {
            this.createdDigests = new HashMap();
        }
        if ((digest = this.createdDigests.get(algorithm)) == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
                this.createdDigests.put(algorithm, digest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return digest;
    }

    public void process(Hashtable<String, CodeSigner[]> signers) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            this.processImpl(signers);
        }
        finally {
            Providers.stopJarVerification(obj);
        }
    }

    private void processImpl(Hashtable<String, CodeSigner[]> signers) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Manifest sf = new Manifest();
        sf.read(new ByteArrayInputStream(this.sfBytes));
        String version = sf.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION);
        if (version == null || !version.equalsIgnoreCase("1.0")) {
            return;
        }
        SignerInfo[] infos = this.block.verify(this.sfBytes);
        if (infos == null) {
            throw new SecurityException("cannot verify signature block file " + this.name);
        }
        BASE64Decoder decoder = new BASE64Decoder();
        CodeSigner[] newSigners = this.getSigners(infos, this.block);
        if (newSigners == null) {
            return;
        }
        Iterator<Map.Entry<String, Attributes>> entries = sf.getEntries().entrySet().iterator();
        boolean manifestSigned = this.verifyManifestHash(sf, this.md, decoder);
        if (!manifestSigned && !this.verifyManifestMainAttrs(sf, this.md, decoder)) {
            throw new SecurityException("Invalid signature file digest for Manifest main attributes");
        }
        while (entries.hasNext()) {
            Map.Entry<String, Attributes> e = entries.next();
            String name = e.getKey();
            if (manifestSigned || this.verifySection(e.getValue(), name, this.md, decoder)) {
                if (name.startsWith("./")) {
                    name = name.substring(2);
                }
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                this.updateSigners(newSigners, signers, name);
                if (debug == null) continue;
                debug.println("processSignature signed name = " + name);
                continue;
            }
            if (debug == null) continue;
            debug.println("processSignature unsigned name = " + name);
        }
    }

    private boolean verifyManifestHash(Manifest sf, ManifestDigester md, BASE64Decoder decoder) throws IOException {
        Attributes mattr = sf.getMainAttributes();
        boolean manifestSigned = false;
        for (Map.Entry<Object, Object> se : mattr.entrySet()) {
            String algorithm;
            MessageDigest digest;
            String key = se.getKey().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST-MANIFEST") || (digest = this.getDigest(algorithm = key.substring(0, key.length() - 16))) == null) continue;
            byte[] computedHash = md.manifestDigest(digest);
            byte[] expectedHash = decoder.decodeBuffer((String)se.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest digest " + digest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(expectedHash));
                debug.println("  computed " + SignatureFileVerifier.toHex(computedHash));
                debug.println();
            }
            if (!MessageDigest.isEqual(computedHash, expectedHash)) continue;
            manifestSigned = true;
        }
        return manifestSigned;
    }

    private boolean verifyManifestMainAttrs(Manifest sf, ManifestDigester md, BASE64Decoder decoder) throws IOException {
        Attributes mattr = sf.getMainAttributes();
        boolean attrsVerified = true;
        for (Map.Entry<Object, Object> se : mattr.entrySet()) {
            String algorithm;
            MessageDigest digest;
            String key = se.getKey().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith(ATTR_DIGEST) || (digest = this.getDigest(algorithm = key.substring(0, key.length() - ATTR_DIGEST.length()))) == null) continue;
            ManifestDigester.Entry mde = md.get("Manifest-Main-Attributes", false);
            byte[] computedHash = mde.digest(digest);
            byte[] expectedHash = decoder.decodeBuffer((String)se.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest Main Attributes digest " + digest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(expectedHash));
                debug.println("  computed " + SignatureFileVerifier.toHex(computedHash));
                debug.println();
            }
            if (MessageDigest.isEqual(computedHash, expectedHash)) continue;
            attrsVerified = false;
            if (debug == null) break;
            debug.println("Verification of Manifest main attributes failed");
            debug.println();
            break;
        }
        return attrsVerified;
    }

    private boolean verifySection(Attributes sfAttr, String name, ManifestDigester md, BASE64Decoder decoder) throws IOException {
        boolean oneDigestVerified = false;
        ManifestDigester.Entry mde = md.get(name, this.block.isOldStyle());
        if (mde == null) {
            throw new SecurityException("no manifiest section for signature file entry " + name);
        }
        if (sfAttr != null) {
            for (Map.Entry<Object, Object> se : sfAttr.entrySet()) {
                String algorithm;
                MessageDigest digest;
                String key = se.getKey().toString();
                if (!key.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST") || (digest = this.getDigest(algorithm = key.substring(0, key.length() - 7))) == null) continue;
                boolean ok = false;
                byte[] expected = decoder.decodeBuffer((String)se.getValue());
                byte[] computed = this.workaround ? mde.digestWorkaround(digest) : mde.digest(digest);
                if (debug != null) {
                    debug.println("Signature Block File: " + name + " digest=" + digest.getAlgorithm());
                    debug.println("  expected " + SignatureFileVerifier.toHex(expected));
                    debug.println("  computed " + SignatureFileVerifier.toHex(computed));
                    debug.println();
                }
                if (MessageDigest.isEqual(computed, expected)) {
                    oneDigestVerified = true;
                    ok = true;
                } else if (!this.workaround && MessageDigest.isEqual(computed = mde.digestWorkaround(digest), expected)) {
                    if (debug != null) {
                        debug.println("  re-computed " + SignatureFileVerifier.toHex(computed));
                        debug.println();
                    }
                    this.workaround = true;
                    oneDigestVerified = true;
                    ok = true;
                }
                if (ok) continue;
                throw new SecurityException("invalid " + digest.getAlgorithm() + " signature file digest for " + name);
            }
        }
        return oneDigestVerified;
    }

    private CodeSigner[] getSigners(SignerInfo[] infos, PKCS7 block) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> signers = null;
        for (int i = 0; i < infos.length; ++i) {
            SignerInfo info = infos[i];
            ArrayList<X509Certificate> chain = info.getCertificateChain(block);
            CertPath certChain = this.certificateFactory.generateCertPath(chain);
            if (signers == null) {
                signers = new ArrayList<CodeSigner>();
            }
            signers.add(new CodeSigner(certChain, this.getTimestamp(info)));
            if (debug == null) continue;
            debug.println("Signature Block Certificate: " + chain.get(0));
        }
        if (signers != null) {
            return signers.toArray(new CodeSigner[signers.size()]);
        }
        return null;
    }

    private Timestamp getTimestamp(SignerInfo info) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute timestampTokenAttr;
        Timestamp timestamp = null;
        PKCS9Attributes unsignedAttrs = info.getUnauthenticatedAttributes();
        if (unsignedAttrs != null && (timestampTokenAttr = unsignedAttrs.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 timestampToken = new PKCS7((byte[])timestampTokenAttr.getValue());
            byte[] encodedTimestampTokenInfo = timestampToken.getContentInfo().getData();
            SignerInfo[] tsa = timestampToken.verify(encodedTimestampTokenInfo);
            ArrayList<X509Certificate> chain = tsa[0].getCertificateChain(timestampToken);
            CertPath tsaChain = this.certificateFactory.generateCertPath(chain);
            TimestampToken timestampTokenInfo = new TimestampToken(encodedTimestampTokenInfo);
            timestamp = new Timestamp(timestampTokenInfo.getDate(), tsaChain);
        }
        return timestamp;
    }

    static String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hexc[data[i] >> 4 & 0xF]);
            sb.append(hexc[data[i] & 0xF]);
        }
        return sb.toString();
    }

    static boolean contains(CodeSigner[] set, CodeSigner signer) {
        for (int i = 0; i < set.length; ++i) {
            if (!set[i].equals(signer)) continue;
            return true;
        }
        return false;
    }

    static boolean isSubSet(CodeSigner[] subset, CodeSigner[] set) {
        if (set == subset) {
            return true;
        }
        for (int i = 0; i < subset.length; ++i) {
            if (SignatureFileVerifier.contains(set, subset[i])) continue;
            return false;
        }
        return true;
    }

    static boolean matches(CodeSigner[] signers, CodeSigner[] oldSigners, CodeSigner[] newSigners) {
        if (oldSigners == null && signers == newSigners) {
            return true;
        }
        if (oldSigners != null && !SignatureFileVerifier.isSubSet(oldSigners, signers)) {
            return false;
        }
        if (!SignatureFileVerifier.isSubSet(newSigners, signers)) {
            return false;
        }
        for (int i = 0; i < signers.length; ++i) {
            boolean found;
            boolean bl = found = oldSigners != null && SignatureFileVerifier.contains(oldSigners, signers[i]) || SignatureFileVerifier.contains(newSigners, signers[i]);
            if (found) continue;
            return false;
        }
        return true;
    }

    void updateSigners(CodeSigner[] newSigners, Hashtable<String, CodeSigner[]> signers, String name) {
        CodeSigner[] cachedSigners;
        CodeSigner[] oldSigners = signers.get(name);
        for (int i = this.signerCache.size() - 1; i != -1; --i) {
            cachedSigners = this.signerCache.get(i);
            if (!SignatureFileVerifier.matches(cachedSigners, oldSigners, newSigners)) continue;
            signers.put(name, cachedSigners);
            return;
        }
        if (oldSigners == null) {
            cachedSigners = newSigners;
        } else {
            cachedSigners = new CodeSigner[oldSigners.length + newSigners.length];
            System.arraycopy(oldSigners, 0, cachedSigners, 0, oldSigners.length);
            System.arraycopy(newSigners, 0, cachedSigners, oldSigners.length, newSigners.length);
        }
        this.signerCache.add(cachedSigners);
        signers.put(name, cachedSigners);
    }
}

