/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;
import sune.security.x509.AlgorithmId;
import sune.security.x509.X500Name;

public final class X500Signer
extends Signer {
    private static final long serialVersionUID = -8609982645394364834L;
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;

    public void update(byte[] buf, int offset, int len) throws SignatureException {
        this.sig.update(buf, offset, len);
    }

    public byte[] sign() throws SignatureException {
        return this.sig.sign();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public X500Name getSigner() {
        return this.agent;
    }

    public X500Signer(Signature sig, X500Name agent) {
        if (sig == null || agent == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = sig;
        this.agent = agent;
        try {
            this.algid = AlgorithmId.getAlgorithmId(sig.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("internal error! " + e.getMessage());
        }
    }
}

