/*
 * Decompiled with CFR 0.152.
 */
package sune.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sune.security.action.GetPropertyAction;
import sune.util.calendar.ZoneInfo;

public class ZoneInfoFile {
    protected static Logger logger = LoggerFactory.getLogger(ZoneInfoFile.class);
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    public static final byte TAG_ExcludedZones = 69;
    private static Map<String, ZoneInfo> zoneInfoObjects = null;
    private static volatile SoftReference<List<String>> zoneIDs = null;
    private static volatile SoftReference<List<String>> excludedIDs = null;
    private static volatile boolean hasNoExcludeList = false;
    private static volatile SoftReference<byte[]> rawOffsetIndices = null;
    private static volatile SoftReference<int[]> rawOffsets = null;
    private static volatile SoftReference<byte[]> zoneInfoMappings = null;

    public static String getFileName(String ID) {
        if (File.separatorChar == '/') {
            return ID;
        }
        return ID.replace('/', File.separatorChar);
    }

    public static ZoneInfo getCustomTimeZone(String originalId, int gmtOffset) {
        String id = ZoneInfoFile.toCustomID(gmtOffset);
        ZoneInfo zi = ZoneInfoFile.getFromCache(id);
        if (zi == null) {
            zi = new ZoneInfo(id, gmtOffset);
            zi = ZoneInfoFile.addToCache(id, zi);
            if (!id.equals(originalId)) {
                zi = ZoneInfoFile.addToCache(originalId, zi);
            }
        }
        return (ZoneInfo)zi.clone();
    }

    public static String toCustomID(int gmtOffset) {
        char sign;
        int offset = gmtOffset / 60000;
        if (offset >= 0) {
            sign = '+';
        } else {
            sign = '-';
            offset = -offset;
        }
        int hh = offset / 60;
        int mm = offset % 60;
        char[] buf = new char[]{'G', 'M', 'T', sign, '0', '0', ':', '0', '0'};
        if (hh >= 10) {
            buf[4] = (char)(buf[4] + hh / 10);
        }
        buf[5] = (char)(buf[5] + hh % 10);
        if (mm != 0) {
            buf[7] = (char)(buf[7] + mm / 10);
            buf[8] = (char)(buf[8] + mm % 10);
        }
        return new String(buf);
    }

    public static ZoneInfo getZoneInfo(String id) {
        ZoneInfo zi = ZoneInfoFile.getFromCache(id);
        if (zi == null) {
            zi = ZoneInfoFile.createZoneInfo(id);
            if (zi == null) {
                return null;
            }
            zi = ZoneInfoFile.addToCache(id, zi);
        }
        return (ZoneInfo)zi.clone();
    }

    static synchronized ZoneInfo getFromCache(String id) {
        if (zoneInfoObjects == null) {
            return null;
        }
        return zoneInfoObjects.get(id);
    }

    static synchronized ZoneInfo addToCache(String id, ZoneInfo zi) {
        if (zoneInfoObjects == null) {
            zoneInfoObjects = new HashMap<String, ZoneInfo>();
        } else {
            ZoneInfo zone = zoneInfoObjects.get(id);
            if (zone != null) {
                return zone;
            }
        }
        zoneInfoObjects.put(id, zi);
        return zi;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ZoneInfo createZoneInfo(String id) {
        buf = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(id));
        if (buf == null) {
            return null;
        }
        for (index = 0; index < ZoneInfoFile.JAVAZI_LABEL.length; ++index) {
            if (buf[index] == ZoneInfoFile.JAVAZI_LABEL[index]) continue;
            System.err.println("ZoneInfo: wrong magic number: " + id);
            return null;
        }
        if (buf[index++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + buf[index - 1] + "): " + id);
            return null;
        }
        filesize = buf.length;
        rawOffset = 0;
        dstSavings = 0;
        checksum = 0;
        willGMTOffsetChange = false;
        transitions = null;
        offsets = null;
        simpleTimeZoneParams = null;
lbl19:
        // 5 sources

        try {
            block12: while (index < filesize) {
                tag = buf[index++];
                if (filesize < index + (len = ((buf[index++] & 255) << 8) + (buf[index++] & 255))) break;
                switch (tag) {
                    case 3: {
                        val = buf[index++] & 255;
                        val = (val << 8) + (buf[index++] & 255);
                        val = (val << 8) + (buf[index++] & 255);
                        checksum = val = (val << 8) + (buf[index++] & 255);
                        ** GOTO lbl19
                    }
                    case 2: {
                        val = (short)(buf[index++] & 255);
                        val = (short)((val << 8) + (buf[index++] & 255));
                        dstSavings = val * 1000;
                        ** GOTO lbl19
                    }
                    case 1: {
                        val = buf[index++] & 255;
                        val = (val << 8) + (buf[index++] & 255);
                        val = (val << 8) + (buf[index++] & 255);
                        rawOffset = val = (val << 8) + (buf[index++] & 255);
                        ** GOTO lbl19
                    }
                    case 4: {
                        n = len / 8;
                        transitions = new long[n];
                        for (i = 0; i < n; ++i) {
                            val = buf[index++] & 255;
                            val = (val << 8) + (long)(buf[index++] & 255);
                            val = (val << 8) + (long)(buf[index++] & 255);
                            val = (val << 8) + (long)(buf[index++] & 255);
                            val = (val << 8) + (long)(buf[index++] & 255);
                            val = (val << 8) + (long)(buf[index++] & 255);
                            val = (val << 8) + (long)(buf[index++] & 255);
                            transitions[i] = val = (val << 8) + (long)(buf[index++] & 255);
                        }
                        continue block12;
                    }
                    case 5: {
                        n = len / 4;
                        offsets = new int[n];
                        for (i = 0; i < n; ++i) {
                            val = buf[index++] & 255;
                            val = (val << 8) + (buf[index++] & 255);
                            val = (val << 8) + (buf[index++] & 255);
                            offsets[i] = val = (val << 8) + (buf[index++] & 255);
                        }
                        continue block12;
                    }
                    case 6: {
                        if (len != 32 && len != 40) {
                            System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                            return null;
                        }
                        n = len / 4;
                        simpleTimeZoneParams = new int[n];
                        for (i = 0; i < n; ++i) {
                            val = buf[index++] & 255;
                            val = (val << 8) + (buf[index++] & 255);
                            val = (val << 8) + (buf[index++] & 255);
                            simpleTimeZoneParams[i] = val = (val << 8) + (buf[index++] & 255);
                        }
                        continue block12;
                    }
                    case 7: {
                        if (len != 1) {
                            System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                        }
                        willGMTOffsetChange = buf[index++] == 1;
                        ** GOTO lbl19
                    }
                }
                System.err.println("ZoneInfo: unknown tag < " + tag + ">. ignored.");
                index += len;
            }
        }
        catch (Exception e) {
            ZoneInfoFile.logger.warn("Warning in ZoneInfoFile", (Throwable)e);
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + id);
            return null;
        }
        if (index != filesize) {
            System.err.println("ZoneInfo: wrong file size: " + id);
            return null;
        }
        return new ZoneInfo(id, rawOffset, dstSavings, checksum, transitions, offsets, simpleTimeZoneParams, willGMTOffsetChange);
    }

    static List<String> getZoneIDs() {
        List<String> ids;
        block8: {
            ids = null;
            SoftReference<List<String>> cache = zoneIDs;
            if (cache != null && (ids = cache.get()) != null) {
                return ids;
            }
            byte[] buf = null;
            buf = ZoneInfoFile.getZoneInfoMappings();
            int filesize = buf.length;
            try {
                int len;
                block5: for (int index = JAVAZM_LABEL_LENGTH + 1; index < filesize; index += len) {
                    byte tag = buf[index++];
                    len = ((buf[index++] & 0xFF) << 8) + (buf[index++] & 0xFF);
                    switch (tag) {
                        case 64: {
                            int n = (buf[index++] << 8) + (buf[index++] & 0xFF);
                            ids = new ArrayList<String>(n);
                            for (int i = 0; i < n; ++i) {
                                byte m = buf[index++];
                                ids.add(new String(buf, index, (int)m, "UTF-8"));
                                index += m;
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference<List<String>>(ids);
        return ids;
    }

    static Map<String, String> getZoneAliases() {
        HashMap<String, String> aliases;
        block7: {
            byte[] buf = ZoneInfoFile.getZoneInfoMappings();
            int filesize = buf.length;
            aliases = null;
            try {
                int len;
                block5: for (int index = JAVAZM_LABEL_LENGTH + 1; index < filesize; index += len) {
                    byte tag = buf[index++];
                    len = ((buf[index++] & 0xFF) << 8) + (buf[index++] & 0xFF);
                    switch (tag) {
                        case 67: {
                            int n = (buf[index++] << 8) + (buf[index++] & 0xFF);
                            aliases = new HashMap<String, String>(n);
                            for (int i = 0; i < n; ++i) {
                                byte m = buf[index++];
                                String name = new String(buf, index, (int)m, "UTF-8");
                                index += m;
                                m = buf[index++];
                                String realName = new String(buf, index, (int)m, "UTF-8");
                                index += m;
                                aliases.put(name, realName);
                            }
                            break block7;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return aliases;
    }

    static List<String> getExcludedZones() {
        List<String> excludeList;
        block11: {
            if (hasNoExcludeList) {
                return null;
            }
            excludeList = null;
            SoftReference<List<String>> cache = excludedIDs;
            if (cache != null && (excludeList = cache.get()) != null) {
                return excludeList;
            }
            byte[] buf = ZoneInfoFile.getZoneInfoMappings();
            int filesize = buf.length;
            try {
                int len;
                block5: for (int index = JAVAZM_LABEL_LENGTH + 1; index < filesize; index += len) {
                    byte tag = buf[index++];
                    len = ((buf[index++] & 0xFF) << 8) + (buf[index++] & 0xFF);
                    switch (tag) {
                        case 69: {
                            int n = (buf[index++] << 8) + (buf[index++] & 0xFF);
                            excludeList = new ArrayList<String>();
                            for (int i = 0; i < n; ++i) {
                                byte m = buf[index++];
                                String name = new String(buf, index, (int)m, "UTF-8");
                                index += m;
                                excludeList.add(name);
                            }
                            break block11;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        if (excludeList != null) {
            excludedIDs = new SoftReference<List<String>>(excludeList);
        } else {
            hasNoExcludeList = true;
        }
        return excludeList;
    }

    static byte[] getRawOffsetIndices() {
        byte[] indices;
        block8: {
            indices = null;
            SoftReference<byte[]> cache = rawOffsetIndices;
            if (cache != null && (indices = cache.get()) != null) {
                return indices;
            }
            byte[] buf = ZoneInfoFile.getZoneInfoMappings();
            int filesize = buf.length;
            try {
                int len;
                block5: for (int index = JAVAZM_LABEL_LENGTH + 1; index < filesize; index += len) {
                    byte tag = buf[index++];
                    len = ((buf[index++] & 0xFF) << 8) + (buf[index++] & 0xFF);
                    switch (tag) {
                        case 66: {
                            indices = new byte[len];
                            for (int i = 0; i < len; ++i) {
                                indices[i] = buf[index++];
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference<byte[]>(indices);
        return indices;
    }

    static int[] getRawOffsets() {
        int[] offsets;
        block8: {
            offsets = null;
            SoftReference<int[]> cache = rawOffsets;
            if (cache != null && (offsets = cache.get()) != null) {
                return offsets;
            }
            byte[] buf = ZoneInfoFile.getZoneInfoMappings();
            int filesize = buf.length;
            try {
                int len;
                block5: for (int index = JAVAZM_LABEL_LENGTH + 1; index < filesize; index += len) {
                    byte tag = buf[index++];
                    len = ((buf[index++] & 0xFF) << 8) + (buf[index++] & 0xFF);
                    switch (tag) {
                        case 65: {
                            int n = len / 4;
                            offsets = new int[n];
                            for (int i = 0; i < n; ++i) {
                                int val = buf[index++] & 0xFF;
                                val = (val << 8) + (buf[index++] & 0xFF);
                                val = (val << 8) + (buf[index++] & 0xFF);
                                offsets[i] = val = (val << 8) + (buf[index++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference<int[]>(offsets);
        return offsets;
    }

    private static byte[] getZoneInfoMappings() {
        int index;
        byte[] data;
        SoftReference<byte[]> cache = zoneInfoMappings;
        if (cache != null && (data = cache.get()) != null) {
            return data;
        }
        data = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (data == null) {
            return null;
        }
        for (index = 0; index < JAVAZM_LABEL.length; ++index) {
            if (data[index] == JAVAZM_LABEL[index]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (data[index++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + data[index - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference<byte[]>(data);
        return data;
    }

    private static byte[] readZoneInfoFile(String fileName) {
        byte[] buffer;
        block2: {
            buffer = null;
            try {
                String homeDir = AccessController.doPrivileged(new GetPropertyAction("java.home"));
                final String fname = homeDir + File.separator + "lib" + File.separator + "zi" + File.separator + fileName;
                buffer = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file = new File(fname);
                        if (!file.canRead()) {
                            return null;
                        }
                        FileInputStream fis = new FileInputStream(file);
                        int filesize = (int)file.length();
                        byte[] buf = new byte[filesize];
                        if (fis.read(buf) != filesize) {
                            fis.close();
                            throw new IOException("read error on " + fname);
                        }
                        fis.close();
                        return buf;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                logger.warn("Warning in ZoneInfoFile", (Throwable)e);
                Exception ex = e.getException();
                if (ex instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(fileName)) break block2;
                System.err.println("ZoneInfo: " + ex.getMessage());
            }
        }
        return buffer;
    }
}

