/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.check;

import java.util.Calendar;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSignatureImpl;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.PAdESSignature;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.PadesChecker;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.ValidationResultDetailImpl;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultDetail;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;

public class PadesTurkishProfileAttributesChecker
implements PadesChecker {
    private static final int a = 300;

    @Override
    public ValidationResultDetail check(PAdESSignature signature) {
        String string = CMSSignatureI18n.getMsg((Enum)E_KEYS.TURKISH_PROFILE_ATTRIBUTES_CHECKER, (String[])new String[0]);
        String string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.TURKISH_PROFILE_ATTRIBUTES_CHECKER_SUCCESSFUL, (String[])new String[0]);
        SignaturePolicyIdentifier signaturePolicyIdentifier = signature.getSignaturePolicy();
        if (signaturePolicyIdentifier == null) {
            return null;
        }
        TurkishESigProfile turkishESigProfile = signature.getContainer().getContext().getConfig().getCertificateValidationConfig().getValidationProfile();
        if (turkishESigProfile == null) {
            turkishESigProfile = signaturePolicyIdentifier.getTurkishESigProfile();
        }
        if (turkishESigProfile != null) {
            DigestAlg digestAlg = signaturePolicyIdentifier.getDigestAlg();
            if (digestAlg == null || digestAlg.getOID() != _algorithmsValues.id_sha256) {
                string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_POLICY_HASH_NOT_SHA256, (String[])new String[0]);
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
            }
            if (signature.getSigningTimeAttrFromM() == null) {
                string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.SIGNING_TIME_ATTRIBUTE_MISSING, (String[])new String[0]);
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
            }
            List list = ((CMSSignatureImpl)signature.getUnderlyingObject()).getSigner().getSignerInfo().getSignedAttribute(AttributeOIDs.id_aa_signingCertificateV2);
            if (list == null || list.size() == 0) {
                string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.SIGNING_CERTIFICATE_V2_ATTRIBUTE_MISSING, (String[])new String[0]);
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
            }
            if (turkishESigProfile != TurkishESigProfile.P1_1) {
                boolean bl = false;
                Calendar calendar = signature.getSigningTimeAttrFromM();
                Calendar calendar2 = signature.getDocTimeStampTime();
                if (calendar2 != null) {
                    calendar.add(13, -300);
                    if (calendar.after(calendar2)) {
                        bl = true;
                    }
                    calendar.add(13, 7500);
                    if (calendar2.after(calendar)) {
                        bl = true;
                    }
                    if (bl) {
                        string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.TS_TIME_NOT_AFTER_2H, (String[])new String[0]);
                        return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
                    }
                } else {
                    string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.SIGNATURE_TS_NOT_FOUND, (String[])new String[0]);
                    return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
                }
            }
            return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.VALID);
        }
        return null;
    }
}

