/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

import java.util.Arrays;

public class Features {
    public static final int FEATURE_VERIFY_PIN_START = 1;
    public static final int FEATURE_VERIFY_PIN_FINISH = 2;
    public static final int FEATURE_MODIFY_PIN_START = 3;
    public static final int FEATURE_MODIFY_PIN_FINISH = 4;
    public static final int FEATURE_GET_KEY_PRESSED = 5;
    public static final int FEATURE_VERIFY_PIN_DIRECT = 6;
    public static final int FEATURE_MODIFY_PIN_DIRECT = 7;
    public static final int FEATURE_MCT_READER_DIRECT = 8;
    public static final int FEATURE_MCT_UNIVERSAL = 9;
    public static final int FEATURE_IFD_PIN_PROPERTIES = 10;
    public static final int FEATURE_ABORT = 11;
    public static final int FEATURE_SET_SPE_MESSAGE = 12;
    public static final int FEATURE_VERIFY_PIN_DIRECT_APP_ID = 13;
    public static final int FEATURE_MODIFY_PIN_DIRECT_APP_ID = 14;
    public static final int FEATURE_WRITE_DISPLAY = 15;
    public static final int FEATURE_GET_KEY = 16;
    public static final int FEATURE_IFD_DISPLAY_PROPERTIES = 17;
    public static final int FEATURE_GET_TLV_PROPERTIES = 18;
    public static final int FEATURE_CCID_ESC_COMMAND = 19;
    private int[] a = new int[20];

    public Features() {
    }

    public Features(byte[] buffer, int bufferLength) {
        this.fromByteArray(buffer, bufferLength);
    }

    public void clear() {
        Arrays.fill(this.a, -1);
    }

    public int getControlCode(int feature) {
        if (!Features.a(feature)) {
            return -1;
        }
        return this.a[feature];
    }

    public void fromByteArray(byte[] buffer, int bufferLength) {
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        if (bufferLength <= 0) {
            throw new IllegalArgumentException("The buffer length is less than or equal to zero.");
        }
        if (bufferLength > buffer.length) {
            throw new IllegalArgumentException("The buffer length is greater than the buffer size.");
        }
        this.clear();
        int n = 0;
        while (n < bufferLength) {
            int n2;
            int n3 = buffer[n] & 0xFF;
            if (Features.a(n3) && n + 1 < bufferLength && (n2 = buffer[n + 1] & 0xFF) == 4 && n + 1 + n2 < bufferLength) {
                this.a[n3] = (buffer[n + 2] & 0xFF) << 24 | (buffer[n + 3] & 0xFF) << 16 | (buffer[n + 4] & 0xFF) << 8 | buffer[n + 5] & 0xFF;
            }
            if (n + 1 >= bufferLength) break;
            n += (buffer[n + 1] & 0xFF) + 2;
        }
    }

    private static boolean a(int n) {
        return n > 0 && n <= 19;
    }
}

