/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import com.acs.smartcard.CardTimeoutException;
import com.acs.smartcard.CommunicationErrorException;
import com.acs.smartcard.InsufficientBufferException;
import com.acs.smartcard.InvalidDeviceStateException;
import com.acs.smartcard.ProtocolMismatchException;
import com.acs.smartcard.ReaderException;
import com.acs.smartcard.RemovedCardException;
import com.acs.smartcard.UnpoweredCardException;
import com.acs.smartcard.UnsupportedCardException;
import com.acs.smartcard.c;
import com.acs.smartcard.d;
import com.acs.smartcard.g;
import com.acs.smartcard.h;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Reader {
    public static final int CARD_POWER_DOWN = 0;
    public static final int CARD_COLD_RESET = 1;
    public static final int CARD_WARM_RESET = 2;
    public static final int PROTOCOL_UNDEFINED = 0;
    public static final int PROTOCOL_T0 = 1;
    public static final int PROTOCOL_T1 = 2;
    public static final int PROTOCOL_RAW = 65536;
    public static final int PROTOCOL_TX = 3;
    public static final int PROTOCOL_DEFAULT = Integer.MIN_VALUE;
    public static final int PROTOCOL_OPTIMAL = 0;
    public static final int CARD_UNKNOWN = 0;
    public static final int CARD_ABSENT = 1;
    public static final int CARD_PRESENT = 2;
    public static final int CARD_SWALLOWED = 3;
    public static final int CARD_POWERED = 4;
    public static final int CARD_NEGOTIABLE = 5;
    public static final int CARD_SPECIFIC = 6;
    public static final int IOCTL_CCID_ESCAPE = 3500;
    public static final int IOCTL_ACR128_READER_COMMAND = 2079;
    public static final int IOCTL_ACR83_GET_FIRMWARE_VERSION = 2078;
    public static final int IOCTL_ACR83_DISPLAY_LCD_MESSAGE = 2079;
    public static final int IOCTL_ACR83_READ_KEY = 2080;
    public static final int IOCTL_GET_FEATURE_REQUEST = 3400;
    private static final int[] a = new int[]{120566529, 120566532, 120566533, 120554240, 120554242, 120554247, 120554241, 120557568, 120557775, 120557772, 120557784, 120566016, 120566017, 120566018, 120566019, 120566020, 120566028, 120565760, 120557778, 120528913, 120555776, 120555777, 120555778, 120525317, 120525316, 120525318, 120529408, 120529454, 120529463, 120529457, 120529428, 120525440, 120529415, 120529451, 120529414, 120529445, 120529411, 120529434, 120529449, 120529503, 120529504, 120529432, 120529435, 120529458, 120529474, 120529464, 120529487, 120529467, 120529470, 120529476, 120529497, 120529469, 120529471, 120529465, 120529425, 120529490, 120529152, 120529444, 120529423, 120529443, 120529416, 120523009, 120529418, 120529429, 120529440, 120529459, 120529460, 120529461, 120529462, 120529427, 120529452, 120529496, 120529482, 120553985, 120553990, 120557574, 120557787, 120566272, 120566022, 120566034};
    private UsbManager b;
    private UsbDevice c;
    private int d;
    private List<UsbInterface> e = new ArrayList<UsbInterface>();
    private List<d> f = new ArrayList<d>();
    private List<h> g = new ArrayList<h>();
    private UsbDeviceConnection h;
    private String i;
    private Thread j;
    private OnStateChangeListener k;

    public Reader(UsbManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("The manager is null.");
        }
        this.b = manager;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSupported(UsbDevice device) {
        boolean bl = false;
        if (device == null) return bl;
        int n = device.getVendorId() << 16 | device.getProductId();
        int n2 = 0;
        while (n2 < 80) {
            if (a[n2] == n) {
                return true;
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void open(UsbDevice device) {
        UsbDeviceConnection usbDeviceConnection;
        int n;
        block86: {
            String string;
            String string2;
            Reader reader;
            block85: {
                Object object;
                int n2;
                Object object2;
                c[] cArray;
                if (device == null) {
                    throw new IllegalArgumentException("The device is null.");
                }
                if (this.c != null) {
                    if (device.equals((Object)this.c)) {
                        return;
                    }
                    this.close();
                }
                if (!this.isSupported(device)) {
                    throw new IllegalArgumentException("The device is not supported.");
                }
                n = device.getVendorId() << 16 | device.getProductId();
                new StringBuilder("Reader ID: ").append(Integer.toHexString(n));
                usbDeviceConnection = this.b.openDevice(device);
                if (usbDeviceConnection == null) {
                    throw new IllegalArgumentException("Cannot open device.");
                }
                int n3 = 0;
                block6 : switch (n) {
                    case 120557568: 
                    case 120557574: {
                        c[] cArray2 = new c[1];
                        cArray = cArray2;
                        cArray2[0] = new c();
                        cArray[0].a = 0;
                        cArray[0].b = 7;
                        cArray[0].c = 3;
                        cArray[0].d = 4000;
                        cArray[0].e = 4000;
                        cArray[0].f = 10752;
                        cArray[0].g = 229390;
                        cArray[0].h = 248;
                        cArray[0].i = 65584;
                        cArray[0].j = 271;
                        n3 = 38;
                        break;
                    }
                    case 120557775: {
                        c[] cArray3 = new c[1];
                        cArray = cArray3;
                        cArray3[0] = new c();
                        cArray[0].a = 1;
                        cArray[0].b = 7;
                        cArray[0].c = 3;
                        cArray[0].d = 4000;
                        cArray[0].e = 4000;
                        cArray[0].f = 10752;
                        cArray[0].g = 229390;
                        cArray[0].h = 248;
                        cArray[0].i = 65584;
                        cArray[0].j = 271;
                        n3 = 38;
                        break;
                    }
                    case 120528913: {
                        c[] cArray4 = new c[1];
                        cArray = cArray4;
                        cArray4[0] = new c();
                        cArray[0].a = 4;
                        cArray[0].b = 3;
                        cArray[0].c = 3;
                        cArray[0].d = 3600;
                        cArray[0].e = 3600;
                        cArray[0].f = 9677;
                        cArray[0].g = 116129;
                        cArray[0].h = 248;
                        cArray[0].i = 132282;
                        cArray[0].j = 271;
                        cArray[0].k = 2069;
                        break;
                    }
                    case 120529152: {
                        c[] cArray5 = new c[1];
                        cArray = cArray5;
                        cArray5[0] = new c();
                        cArray[0].a = 2;
                        cArray[0].b = 3;
                        cArray[0].c = 3;
                        cArray[0].d = 3600;
                        cArray[0].e = 3600;
                        cArray[0].f = 9677;
                        cArray[0].g = 116129;
                        cArray[0].h = 248;
                        cArray[0].i = 132282;
                        cArray[0].j = 271;
                        break;
                    }
                    case 120529425: 
                    case 120529429: 
                    case 120529444: 
                    case 120529474: {
                        c[] cArray6 = new c[1];
                        cArray = cArray6;
                        cArray6[0] = new c();
                        cArray[0].a = 2;
                        cArray[0].b = 3;
                        cArray[0].c = 3;
                        cArray[0].d = 4000;
                        cArray[0].e = 4000;
                        cArray[0].f = 10752;
                        cArray[0].g = 344100;
                        cArray[0].h = 248;
                        cArray[0].i = 132282;
                        cArray[0].j = 271;
                        break;
                    }
                    default: {
                        cArray = new c[device.getInterfaceCount()];
                        int n4 = Reader.a(usbDeviceConnection, cArray);
                        if (n4 <= 0) {
                            usbDeviceConnection.close();
                            throw new IllegalArgumentException("Cannot find CCID descriptor.");
                        }
                        switch (n) {
                            case 120566529: {
                                cArray[0].a = 0;
                                break block6;
                            }
                            case 120529415: 
                            case 120529428: {
                                cArray[0].a = 1;
                                break block6;
                            }
                            case 120525440: {
                                cArray[0].a = 2;
                                break block6;
                            }
                        }
                    }
                }
                int n5 = device.getInterfaceCount();
                if (n5 > cArray.length) {
                    n5 = cArray.length;
                }
                int n6 = 0;
                while (n6 < n5) {
                    block82: {
                        if (cArray[n6] == null) break block82;
                        UsbInterface usbInterface = device.getInterface(n6);
                        UsbEndpoint usbEndpoint = null;
                        UsbEndpoint usbEndpoint2 = null;
                        UsbEndpoint usbEndpoint3 = null;
                        int n7 = usbInterface.getEndpointCount();
                        int n8 = 0;
                        while (n8 < n7) {
                            block84: {
                                int n9;
                                UsbEndpoint usbEndpoint4;
                                block83: {
                                    usbEndpoint4 = usbInterface.getEndpoint(n8);
                                    n9 = usbEndpoint4.getType();
                                    if (n9 != 2) break block83;
                                    if (usbEndpoint4.getDirection() == 0) {
                                        if (usbEndpoint == null) {
                                            usbEndpoint = usbEndpoint4;
                                        }
                                        break block84;
                                    } else if (usbEndpoint2 == null) {
                                        usbEndpoint2 = usbEndpoint4;
                                    }
                                    break block84;
                                }
                                if (n9 == 3 && usbEndpoint4.getDirection() == 128 && usbEndpoint3 == null) {
                                    usbEndpoint3 = usbEndpoint4;
                                }
                            }
                            ++n8;
                        }
                        if (usbEndpoint == null || usbEndpoint2 == null || usbEndpoint3 == null) {
                            usbDeviceConnection.close();
                            throw new IllegalArgumentException("Cannot find endpoints.");
                        }
                        if (!usbDeviceConnection.claimInterface(usbInterface, false) && !usbDeviceConnection.claimInterface(usbInterface, true)) {
                            usbDeviceConnection.close();
                            throw new IllegalArgumentException("Cannot claim interface.");
                        }
                        this.e.add(usbInterface);
                        d d2 = n3 == 38 ? new com.acs.smartcard.a(usbDeviceConnection, usbEndpoint, usbEndpoint2, usbEndpoint3) : new d(usbDeviceConnection, usbEndpoint, usbEndpoint2, usbEndpoint3);
                        this.f.add(d2);
                        switch (n) {
                            case 120553985: {
                                d2.d(10);
                                break;
                            }
                        }
                        int n10 = 0;
                        while (n10 <= cArray[n6].a) {
                            h h2 = new h();
                            new h().a = n10;
                            h2.e = d2;
                            h2.f = new c(cArray[n6]);
                            int n11 = n6;
                            int n12 = n;
                            object2 = h2;
                            reader = this;
                            d d3 = object2.e;
                            switch (n12) {
                                case 120554240: 
                                case 120554241: 
                                case 120554242: 
                                case 120554247: {
                                    if (object2.a <= 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120557775: {
                                    if (object2.a != 1) break;
                                    object2.f.g = 10752;
                                    object2.b = true;
                                    break;
                                }
                                case 120566020: {
                                    if (object2.a != 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120557778: {
                                    object2.f.k = 528;
                                    n2 = Reader.e((h)object2);
                                    if (n2 >= 17664) {
                                        object2.f.i &= 0xFFF8FFFF;
                                        object2.f.i |= 0x20000;
                                        break;
                                    }
                                    object2.f.l = 0;
                                    break;
                                }
                                case 120553985: {
                                    object2.f.k = 528;
                                    object2.f.i &= 0xFFF8FFFF;
                                    object2.f.i |= 0x20000;
                                    break;
                                }
                                case 120528913: {
                                    if (object2.a < 2) {
                                        object2.f.g = 116129;
                                        break;
                                    }
                                    object2.f.g = 9677;
                                    object2.b = true;
                                    break;
                                }
                                case 120555776: 
                                case 120555778: {
                                    if (object2.a <= 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120555777: {
                                    if (object2.a <= 2) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120529408: {
                                    try {
                                        d d4 = d3;
                                        object = d4;
                                        // MONITORENTER : d4
                                        d3.b(object2.a);
                                        // MONITOREXIT : object
                                    }
                                    catch (ReaderException readerException) {}
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    break;
                                }
                                case 120529428: {
                                    if (object2.a != 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120525440: {
                                    if (object2.a != 2) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120529414: {
                                    if (object2.a <= 0) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120529454: {
                                    if (object2.a <= 0) break;
                                    object2.f.i = 132282;
                                    object2.f.g = 125000;
                                    object2.b = true;
                                    break;
                                }
                                case 120529457: {
                                    if (object2.a <= 0) break;
                                    object2.f.i = 132282;
                                    object2.f.g = 129032;
                                    object2.b = true;
                                    break;
                                }
                                case 120529432: 
                                case 120529434: 
                                case 120529467: 
                                case 120529504: {
                                    if (n11 != 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120529152: {
                                    if (object2.a == 0) {
                                        object2.f.i = 132282;
                                        object2.f.g = 116129;
                                        break;
                                    }
                                    if (object2.a == 1) {
                                        object2.f.i = 132218;
                                        object2.f.g = 116129;
                                        break;
                                    }
                                    object2.f.i = 132282;
                                    object2.f.g = 9677;
                                    object2.b = true;
                                    break;
                                }
                                case 120529425: 
                                case 120529444: 
                                case 120529474: {
                                    if (object2.a == 0) {
                                        object2.f.i = 132282;
                                        object2.f.g = 344100;
                                        if (n12 != 120529444 || Reader.f((h)object2) < 526) break;
                                        object2.f.i = 263354;
                                        break;
                                    }
                                    if (object2.a == 1) {
                                        object2.f.i = 263290;
                                        object2.f.g = 344100;
                                        break;
                                    }
                                    object2.f.i = 132282;
                                    object2.f.g = 125000;
                                    object2.b = true;
                                    break;
                                }
                                case 120529429: {
                                    if (object2.a == 1) {
                                        object2.f.i = 263290;
                                        object2.f.g = 344100;
                                        break;
                                    }
                                    object2.f.i = 132282;
                                    object2.f.g = 125000;
                                    object2.b = true;
                                    break;
                                }
                                case 120529440: {
                                    if (n11 != 1) break;
                                    object2.b = true;
                                    break;
                                }
                                case 120529460: 
                                case 120529461: 
                                case 120529462: {
                                    if (object2.a == 1) {
                                        object2.f.i = 132282;
                                        object2.f.g = 600000;
                                        break;
                                    }
                                    if (object2.a <= 1) break;
                                    object2.f.i = 132282;
                                    object2.f.g = 172043;
                                    object2.b = true;
                                    break;
                                }
                                case 120529427: {
                                    if (object2.a <= 0) break;
                                    object2.b = true;
                                    break;
                                }
                            }
                            g cfr_ignored_0 = h2.c;
                            int cfr_ignored_1 = h2.f.c;
                            h2.c.b = h2.f.d;
                            g cfr_ignored_2 = h2.c;
                            int cfr_ignored_3 = h2.f.e;
                            h2.c.c = h2.f.f;
                            h2.c.d = h2.f.g;
                            h2.c.e = h2.f.h;
                            h2.c.a = 1;
                            this.g.add(h2);
                            d2.a().add(h2);
                            ++n10;
                        }
                    }
                    ++n6;
                }
                object2 = usbDeviceConnection;
                reader = this;
                object = new byte[255];
                string2 = null;
                string = null;
                int n13 = object2.controlTransfer(128, 6, 256, 0, object, 255, 2000);
                if (n13 <= 15 || (object[0] & 0xFF) <= 15 || (object[1] & 0xFF) != 1) break block85;
                int n14 = object[14] & 0xFF;
                int n15 = object[15] & 0xFF;
                new StringBuilder("iManufacturer: ").append(n14);
                new StringBuilder("iProduct: ").append(n15);
                if (n14 == 0 || n15 == 0) break block86;
                n13 = object2.controlTransfer(128, 6, 768, 0, object, 255, 2000);
                if (n13 > 3 && (object[0] & 0xFF) > 3 && (object[1] & 0xFF) == 3) {
                    int n16;
                    n2 = object[2] & 0xFF | (object[3] & 0xFF) << 8;
                    new StringBuilder("langId: ").append(n2);
                    int n17 = 0x300 | n14;
                    n13 = object2.controlTransfer(128, 6, n17, n2, object, 255, 2000);
                    if (n13 > 2 && (object[0] & 0xFF) > 2 && (object[1] & 0xFF) == 3) {
                        try {
                            n16 = object[0] & 0xFF;
                            string2 = new String((byte[])object, 2, n16 - 2, "UTF-16LE");
                            new StringBuilder("Manufacturer: ").append(string2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    if ((n13 = object2.controlTransfer(128, 6, n17 = 0x300 | n15, n2, object, 255, 2000)) > 2 && (object[0] & 0xFF) > 2 && (object[1] & 0xFF) == 3) {
                        try {
                            n16 = object[0] & 0xFF;
                            string = new String((byte[])object, 2, n16 - 2, "UTF-16LE");
                            new StringBuilder("Product: ").append(string);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                }
            }
            reader.i = "";
            if (string2 != null) {
                reader.i = String.valueOf(reader.i) + string2.trim();
            }
            if (string != null) {
                if (reader.i.length() > 0) {
                    reader.i = String.valueOf(reader.i) + " ";
                }
                reader.i = String.valueOf(reader.i) + string.trim();
            }
            new StringBuilder("Reader name: ").append(reader.i);
        }
        this.c = device;
        this.d = n;
        this.h = usbDeviceConnection;
        this.j = new Thread(new a(this, 0));
        this.j.start();
    }

    public void close() {
        if (this.h != null) {
            int n = 0;
            while (n < this.g.size()) {
                try {
                    this.power(n, 0);
                }
                catch (ReaderException readerException) {}
                ++n;
            }
            this.j.interrupt();
            for (d d2 : this.f) {
                d2.d();
            }
            for (UsbInterface usbInterface : this.e) {
                this.h.releaseInterface(usbInterface);
            }
            this.h.close();
            try {
                this.j.join();
            }
            catch (InterruptedException interruptedException) {}
            this.j = null;
            for (d d3 : this.f) {
                d3.e();
            }
            this.g.clear();
            this.f.clear();
            this.e.clear();
            this.c = null;
            this.d = 0;
            this.h = null;
            this.i = null;
        }
    }

    public boolean isOpened() {
        return this.h != null;
    }

    public UsbDevice getDevice() {
        return this.c;
    }

    public int getNumSlots() {
        return this.g.size();
    }

    public String getReaderName() {
        return this.i;
    }

    public void setOnStateChangeListener(OnStateChangeListener listener) {
        this.k = listener;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] power(int slotNum, int action) throws ReaderException {
        var3_3 = null;
        var4_4 = false;
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0) throw new IllegalArgumentException("The slot number is invalid.");
        if (slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        var5_5 = this.g.get(slotNum);
        slotNum = var5_5.a;
        var6_6 = var5_5.c;
        var7_7 = var5_5.d;
        var8_8 = var5_5.e;
        var9_9 = var5_5.f;
        var10_10 = var5_5;
        // MONITORENTER : var10_10
        if (var6_6.a <= 1) {
            throw new RemovedCardException();
        }
        var13_11 = var5_5;
        var5_5.d.m = 65536;
        var13_11.d.q.a = 0;
        var13_11.l.n = 0;
        var13_11.l.m = 0;
        var13_11.l.l = 0;
        var13_11.l.b = var13_11.c.e != 0 && var13_11.c.e < 254 ? var13_11.c.e : 254;
        Arrays.fill(var7_7.c, (byte)0);
        var7_7.d = 0;
        var7_7.n = 0;
        switch (action) {
            case 1: {
                var11_12 = var8_8;
                // MONITORENTER : var11_12
                var8_8.b(slotNum);
                // MONITOREXIT : var11_12
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException v1) {}
            }
            case 2: {
                try {
                    var11_12 = var8_8;
                    // MONITORENTER : var11_12
                    var3_3 = var8_8.a(slotNum, 0);
                    // MONITOREXIT : var11_12
                }
                catch (ReaderException v3) {
                    var4_4 = true;
                }
                if (!var4_4) break;
                try {
                    var11_12 = var8_8;
                    // MONITORENTER : var11_12
                    try {
                        var3_3 = var8_8.a(slotNum, 0);
                        // MONITOREXIT : var11_12
                        ** break;
                    }
                    catch (Throwable v4) {
                        // MONITOREXIT : var11_12
                        throw v4;
lbl68:
                        // 1 sources

                        break;
                    }
                }
                catch (ReaderException var11_13) {
                    if (var5_5.b == false) throw var11_13;
                    var6_6.a = 1;
                    throw new RemovedCardException();
                }
            }
            case 0: {
                var11_14 = var8_8;
                // MONITORENTER : var11_14
                var8_8.b(slotNum);
                // MONITOREXIT : var11_14
                var6_6.a = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("The action is invalid.");
            }
        }
        if (var3_3 != null && var3_3.length > 0) {
            if (var3_3.length > var7_7.c.length) {
                throw new InsufficientBufferException();
            }
            System.arraycopy(var3_3, 0, var7_7.c, 0, var3_3.length);
            var7_7.d = var3_3.length;
            var11_15 = var5_5.a();
            com.acs.smartcard.h.a(var11_15);
            if (var6_6.a == 6 && (var9_9.i & 64) == 0) {
                try {
                    var12_16 = var8_8;
                    // MONITORENTER : var12_16
                    var8_8.a(slotNum, var7_7);
                    // MONITOREXIT : var12_16
                    return var3_3;
                }
                catch (ReaderException v7) {}
            }
        }
        // MONITOREXIT : var10_10
        return var3_3;
    }

    public byte[] getAtr(int slotNum) {
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        h h2 = this.g.get(slotNum);
        com.acs.smartcard.b b2 = h2.d;
        byte[] byArray = null;
        h h3 = h2;
        synchronized (h3) {
            int n = b2.d;
            if (n > 0) {
                byArray = new byte[n];
                System.arraycopy(b2.c, 0, byArray, 0, n);
            }
        }
        return byArray;
    }

    public int setProtocol(int slotNum, int preferredProtocols) throws ReaderException {
        int activeProtocol;
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        h h2 = this.g.get(slotNum);
        slotNum = h2.a;
        g g2 = h2.c;
        com.acs.smartcard.b b2 = h2.d;
        d d2 = h2.e;
        c c2 = h2.f;
        h h3 = h2;
        synchronized (h3) {
            if (g2.a <= 1) {
                throw new RemovedCardException();
            }
            if (g2.a <= 3) {
                throw new UnpoweredCardException();
            }
            if (g2.a == 6) {
                if ((preferredProtocols & b2.n) == 0) {
                    throw new ProtocolMismatchException();
                }
            } else {
                int n;
                if ((preferredProtocols & 3) == 0) {
                    throw new UnsupportedCardException();
                }
                b2.q.a = (preferredProtocols & Integer.MIN_VALUE) != 0 ? 0 : 1;
                int n2 = h2.a();
                com.acs.smartcard.h.a(n2);
                if (g2.a < 5) {
                    throw new InvalidDeviceStateException();
                }
                if ((preferredProtocols & 2) != 0 && (b2.m & 2) != 0) {
                    n = 2;
                } else if ((preferredProtocols & 1) != 0 && (b2.m & 1) != 0) {
                    n = 1;
                } else {
                    throw new ProtocolMismatchException();
                }
                b b3 = com.acs.smartcard.Reader$b.c;
                byte[] byArray = new byte[4];
                byte[] byArray2 = new byte[4];
                byArray[0] = -1;
                while (b3 == com.acs.smartcard.Reader$b.c) {
                    d d3;
                    if ((n & 2) != 0) {
                        byArray[1] = 17;
                        b2.n = 2;
                    } else {
                        byArray[1] = 16;
                        b2.n = 1;
                    }
                    if ((c2.i & 0x40) != 0) {
                        b3 = com.acs.smartcard.Reader$b.a;
                        break;
                    }
                    if ((c2.i & 0x80) != 0) {
                        b3 = com.acs.smartcard.Reader$b.a;
                    } else {
                        byArray[2] = (byte)(b2.q.b << 4 | b2.q.c);
                        byArray[3] = (byte)(byArray[0] ^ byArray[1] ^ byArray[2]);
                        try {
                            int n3;
                            d3 = d2;
                            synchronized (d3) {
                                d2.a(slotNum, byArray, 0, 4, 0);
                                n3 = d2.a(slotNum, byArray2, 4, null, 0);
                            }
                            boolean bl = n3 == 4;
                            if (bl) {
                                int n4 = 0;
                                while (n4 < n3) {
                                    if (!(bl = bl && byArray2[n4] == byArray[n4])) break;
                                    ++n4;
                                }
                            }
                            if (bl) {
                                b3 = com.acs.smartcard.Reader$b.a;
                            }
                        }
                        catch (ReaderException readerException) {
                            b3 = com.acs.smartcard.Reader$b.b;
                        }
                    }
                    if (b3 == com.acs.smartcard.Reader$b.a) {
                        try {
                            d3 = d2;
                            synchronized (d3) {
                                d2.a(slotNum, b2);
                            }
                            b2.h = b2.q.c;
                            b2.g = b2.q.b;
                            break;
                        }
                        catch (ReaderException readerException) {
                            b3 = com.acs.smartcard.Reader$b.b;
                        }
                    }
                    if (b2.q.a == 0) break;
                    b2.q.a = 0;
                    try {
                        this.power(slotNum, 1);
                        b3 = com.acs.smartcard.Reader$b.c;
                    }
                    catch (ReaderException readerException) {
                        b3 = com.acs.smartcard.Reader$b.b;
                    }
                }
                if (b3 == com.acs.smartcard.Reader$b.a) {
                    g2.a = 6;
                } else {
                    b2.n = 0;
                }
            }
            activeProtocol = b2.n;
        }
        return activeProtocol;
    }

    public int getProtocol(int slotNum) {
        int n;
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        h h2 = this.g.get(slotNum);
        com.acs.smartcard.b b2 = h2.d;
        h h3 = h2;
        synchronized (h3) {
            n = b2.n;
        }
        return n;
    }

    public int getState(int slotNum) {
        int n;
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        h h2 = this.g.get(slotNum);
        g g2 = h2.c;
        h h3 = h2;
        synchronized (h3) {
            n = g2.a;
        }
        return n;
    }

    public int transmit(int slotNum, byte[] sendBuffer, int sendBufferLength, byte[] recvBuffer, int recvBufferLength) throws ReaderException {
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        if (sendBuffer == null) {
            throw new IllegalArgumentException("The send buffer is null.");
        }
        if (sendBufferLength <= 0) {
            throw new IllegalArgumentException("The send buffer length is less than or equal to zero.");
        }
        if (sendBufferLength > sendBuffer.length) {
            throw new IllegalArgumentException("The send buffer length is greater than the send buffer size.");
        }
        if (recvBuffer == null) {
            throw new IllegalArgumentException("The receive buffer is null.");
        }
        if (recvBufferLength <= 0) {
            throw new IllegalArgumentException("The receive buffer length is less than or equal to zero.");
        }
        if (recvBufferLength > recvBuffer.length) {
            throw new IllegalArgumentException("The receive buffer length is greater than the receive buffer size.");
        }
        h h2 = this.g.get(slotNum);
        g g2 = h2.c;
        com.acs.smartcard.b b2 = h2.d;
        c c2 = h2.f;
        int n = 0;
        h h3 = h2;
        synchronized (h3) {
            if (g2.a != 6) {
                throw new InvalidDeviceStateException("The current state is not equal to specific.");
            }
            int n2 = b2.n;
            if (n2 == 0) {
                throw new InvalidDeviceStateException("The active protocol is not equal to either T=0 or T=1");
            }
            h2.k.b = sendBuffer;
            h2.k.c = sendBufferLength;
            h2.k.d = recvBuffer;
            h2.k.e = recvBufferLength;
            h2.k.a = 0;
            if ((c2.i & 0x10000) != 0) {
                switch (n2) {
                    case 1: {
                        n = Reader.a(h2);
                        break;
                    }
                    case 2: {
                        n = Reader.b(h2);
                        break;
                    }
                }
            } else if ((c2.i & 0x20000) != 0) {
                n = Reader.c(h2);
            } else if ((c2.i & 0x40000) != 0) {
                n = Reader.d(h2);
            } else {
                throw new CommunicationErrorException("The CCID exchange level is not supported.");
            }
        }
        com.acs.smartcard.h.a(n);
        return h2.k.a;
    }

    public int control(int slotNum, int controlCode, byte[] inBuffer, int inBufferLength, byte[] outBuffer, int outBufferLength) throws ReaderException {
        int n;
        if (!this.isOpened()) {
            throw new IllegalArgumentException("The reader is not opened.");
        }
        if (slotNum < 0 || slotNum >= this.g.size()) {
            throw new IllegalArgumentException("The slot number is invalid.");
        }
        switch (controlCode) {
            case 3500: {
                n = this.a(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                break;
            }
            case 2078: {
                if (this.d == 120557778 || this.d == 120553985 || this.d == 120553990) {
                    n = this.a(slotNum, outBuffer, outBufferLength);
                    break;
                }
                throw new IllegalArgumentException("The control code is invalid.");
            }
            case 2079: {
                if (this.d == 120557778 || this.d == 120553985 || this.d == 120553990) {
                    n = this.c(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                    break;
                }
                n = this.b(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                break;
            }
            case 2080: {
                if (this.d == 120557778 || this.d == 120553985 || this.d == 120553990) {
                    n = this.d(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                    break;
                }
                throw new IllegalArgumentException("The control code is invalid.");
            }
            case 3400: {
                int n2 = outBufferLength;
                byte[] byArray = outBuffer;
                int n3 = slotNum;
                Reader reader = this;
                if (byArray == null) {
                    throw new IllegalArgumentException("The output buffer is null.");
                }
                h h2 = reader.g.get(n3);
                int n4 = 24;
                if ((h2.f.l & 1) != 0) {
                    n4 += 6;
                }
                if ((h2.f.l & 2) != 0) {
                    n4 += 6;
                }
                if (reader.d == 120553990) {
                    n4 += 12;
                }
                if (n2 < n4) {
                    throw new IllegalArgumentException("The output buffer length is less than " + n4 + ".");
                }
                if (n2 > byArray.length) {
                    throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
                }
                int n5 = 0;
                if ((h2.f.l & 1) != 0) {
                    ++n5;
                    byArray[0] = 6;
                    ++n5;
                    byArray[1] = 4;
                    ++n5;
                    byArray[2] = 0;
                    ++n5;
                    byArray[3] = 0;
                    ++n5;
                    byArray[4] = 13;
                    ++n5;
                    byArray[5] = 78;
                }
                if ((h2.f.l & 2) != 0) {
                    byArray[n5++] = 7;
                    byArray[n5++] = 4;
                    byArray[n5++] = 0;
                    byArray[n5++] = 0;
                    byArray[n5++] = 13;
                    byArray[n5++] = 79;
                }
                byArray[n5++] = 10;
                byArray[n5++] = 4;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 13;
                byArray[n5++] = 82;
                if (reader.d == 120553990) {
                    byArray[n5++] = 15;
                    byArray[n5++] = 4;
                    byArray[n5++] = 0;
                    byArray[n5++] = 0;
                    byArray[n5++] = 13;
                    byArray[n5++] = 87;
                }
                if (reader.d == 120553990) {
                    byArray[n5++] = 16;
                    byArray[n5++] = 4;
                    byArray[n5++] = 0;
                    byArray[n5++] = 0;
                    byArray[n5++] = 13;
                    byArray[n5++] = 88;
                }
                byArray[n5++] = 17;
                byArray[n5++] = 4;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 13;
                byArray[n5++] = 89;
                byArray[n5++] = 18;
                byArray[n5++] = 4;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 13;
                byArray[n5++] = 90;
                byArray[n5++] = 19;
                byArray[n5++] = 4;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 13;
                byArray[n5++] = -84;
                n = n5;
                break;
            }
            case 3406: {
                n = this.e(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                break;
            }
            case 3407: {
                n = this.f(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                break;
            }
            case 3410: {
                int n6 = outBufferLength;
                byte[] byArray = outBuffer;
                int n7 = slotNum;
                Reader reader = this;
                if (byArray == null) {
                    throw new IllegalArgumentException("The output buffer is null.");
                }
                if (n6 < 4) {
                    throw new IllegalArgumentException("The output buffer length is less than 4.");
                }
                if (n6 > byArray.length) {
                    throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
                }
                h h3 = reader.g.get(n7);
                int n8 = h3.f.k;
                byArray[0] = (byte)n8;
                byArray[1] = (byte)(n8 >> 8);
                byArray[2] = 7;
                byArray[3] = 0;
                n = 4;
                break;
            }
            case 3415: {
                if (this.d == 120553990) {
                    n = this.b(slotNum, inBuffer, inBufferLength);
                    break;
                }
                throw new IllegalArgumentException("The control code is invalid.");
            }
            case 3416: {
                if (this.d == 120553990) {
                    n = this.g(slotNum, inBuffer, inBufferLength, outBuffer, outBufferLength);
                    break;
                }
                throw new IllegalArgumentException("The control code is invalid.");
            }
            case 3417: {
                int n9 = outBufferLength;
                byte[] byArray = outBuffer;
                int n10 = slotNum;
                Reader reader = this;
                if (byArray == null) {
                    throw new IllegalArgumentException("The output buffer is null.");
                }
                if (n9 < 4) {
                    throw new IllegalArgumentException("The output buffer length is less than 4.");
                }
                if (n9 > byArray.length) {
                    throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
                }
                h h4 = reader.g.get(n10);
                int n11 = h4.f.k;
                int n12 = n11 & 0xFF;
                byArray[0] = (byte)n12;
                byArray[1] = (byte)(n12 >> 8);
                n12 = n11 >> 8 & 0xFF;
                byArray[2] = (byte)n12;
                byArray[3] = (byte)(n12 >> 8);
                n = 4;
                break;
            }
            case 3418: {
                int n13;
                int n14 = outBufferLength;
                byte[] byArray = outBuffer;
                int n15 = slotNum;
                Reader reader = this;
                if (byArray == null) {
                    throw new IllegalArgumentException("The output buffer is null.");
                }
                h h5 = reader.g.get(n15);
                int n16 = h5.f.k;
                int n17 = 24;
                if (n16 != 0) {
                    n17 += 8;
                }
                if (reader.d == 120557778 || reader.d == 120553985 || reader.d == 120553990) {
                    n17 += 9;
                }
                if (n14 < n17) {
                    throw new IllegalArgumentException("The output buffer length is less than " + n17 + ".");
                }
                if (n14 > byArray.length) {
                    throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
                }
                int n18 = 0;
                ++n18;
                byArray[0] = 1;
                ++n18;
                byArray[1] = 2;
                ++n18;
                byArray[2] = (byte)n16;
                ++n18;
                byArray[3] = (byte)(n16 >> 8);
                if (n16 != 0) {
                    n13 = n16 & 0xFF;
                    ++n18;
                    byArray[4] = 4;
                    ++n18;
                    byArray[5] = 2;
                    ++n18;
                    byArray[6] = (byte)n13;
                    ++n18;
                    byArray[7] = (byte)(n13 >> 8);
                    n13 = n16 >> 8 & 0xFF;
                    ++n18;
                    byArray[8] = 5;
                    ++n18;
                    byArray[9] = 2;
                    ++n18;
                    byArray[10] = (byte)n13;
                    byArray[11] = (byte)(n13 >> 8);
                }
                int n19 = ++n18;
                byArray[n19] = 3;
                int n20 = ++n18;
                byArray[n20] = 1;
                int n21 = ++n18;
                ++n18;
                byArray[n21] = 0;
                if (reader.d == 120557778 || reader.d == 120553985 || reader.d == 120553990) {
                    byArray[n18++] = 6;
                    byArray[n18++] = 1;
                    byArray[n18++] = 1;
                    byArray[n18++] = 7;
                    byArray[n18++] = 1;
                    byArray[n18++] = 16;
                    byArray[n18++] = 2;
                    byArray[n18++] = 1;
                    byArray[n18++] = 7;
                }
                byArray[n18++] = 9;
                byArray[n18++] = 1;
                byArray[n18++] = 1;
                n13 = reader.c.getVendorId();
                byArray[n18++] = 11;
                byArray[n18++] = 2;
                byArray[n18++] = (byte)n13;
                byArray[n18++] = (byte)(n13 >> 8);
                int n22 = reader.c.getProductId();
                byArray[n18++] = 12;
                byArray[n18++] = 2;
                byArray[n18++] = (byte)n22;
                byArray[n18++] = (byte)(n22 >> 8);
                int n23 = 0;
                if ((h5.f.i & 0x10000) != 0 || (h5.f.i & 0x40000) != 0) {
                    n23 = 65536;
                }
                byArray[n18++] = 10;
                byArray[n18++] = 4;
                byArray[n18++] = (byte)n23;
                byArray[n18++] = (byte)(n23 >> 8);
                byArray[n18++] = (byte)(n23 >> 16);
                byArray[n18++] = (byte)(n23 >>> 24);
                n = n18;
                break;
            }
            case 2060: {
                if (this.d == 120557568 || this.d == 120557775) {
                    n = this.c(slotNum, inBuffer, inBufferLength);
                    break;
                }
                throw new IllegalArgumentException("The control code is invalid.");
            }
            default: {
                throw new IllegalArgumentException("The control code is invalid.");
            }
        }
        return n;
    }

    private static int a(UsbDeviceConnection usbDeviceConnection, c[] cArray) {
        byte[] byArray = new byte[512];
        int n = usbDeviceConnection.controlTransfer(128, 6, 512, 0, byArray, 512, 2000);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 + 1 < n) {
            int n5 = byArray[n4] & 0xFF;
            int n6 = byArray[n4 + 1] & 0xFF;
            if (n5 == 9 && n6 == 4) {
                ++n2;
            } else if (n5 == 54 && n6 == 33 && n2 <= cArray.length && n4 + n5 < n) {
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, n4, byArray2, 0, n5);
                cArray[n2 - 1] = new c(byArray2);
                ++n3;
            }
            n4 += n5;
        }
        return n3;
    }

    private static int a(h h2) throws ReaderException {
        d d2 = h2.e;
        h2.h = 0;
        int n = h2.b();
        if (n == 0) {
            d d3 = d2;
            synchronized (d3) {
                d2.b(h2.a, h2.g, 0, h2.h, 0);
                h2.j = h2.i.length;
                h2.j = d2.a(h2.a, h2.i, h2.j, null, 0);
            }
            n = h2.c();
        }
        return n;
    }

    private static int b(h h2) throws ReaderException {
        int n;
        d d2 = h2.e;
        do {
            h2.h = 0;
            h2.l.h = 0;
            n = h2.d();
            if (n != 0) continue;
            d d3 = d2;
            synchronized (d3) {
                d2.b(h2.a, h2.g, 0, h2.h, 0);
                h2.j = h2.i.length;
                try {
                    h2.j = d2.a(h2.a, h2.i, h2.j, null, 0);
                }
                catch (CardTimeoutException cardTimeoutException) {
                    h2.j = 0;
                }
            }
            n = h2.e();
        } while (n == -1073741802);
        return n;
    }

    private static int c(h h2) throws ReaderException {
        d d2 = h2.e;
        if (h2.k.c > h2.f.j - 10) {
            return -2147483643;
        }
        d d3 = d2;
        synchronized (d3) {
            d2.b(h2.a, h2.k.b, 0, h2.k.c, 0);
            h2.k.a = d2.a(h2.a, h2.k.d, h2.k.e, null, 0);
        }
        return 0;
    }

    private static int d(h h2) throws ReaderException {
        int n;
        int n2;
        int n3;
        d d2 = h2.e;
        byte[] byArray = h2.k.b;
        int n4 = h2.k.c;
        byte[] byArray2 = h2.k.d;
        int n5 = h2.k.e;
        int n6 = h2.f.j - 10;
        int[] nArray = new int[1];
        int n7 = 0;
        if (n4 > n6) {
            n3 = n6;
            n2 = 1;
        } else {
            n3 = n4;
            n2 = 0;
        }
        d d3 = d2;
        synchronized (d3) {
            while (n4 > 0) {
                d2.b(h2.a, byArray, n7, n3, n2);
                n4 -= n3;
                n7 += n3;
                if (n2 == 0 || n2 == 2) break;
                d2.a(h2.a, null, 0, null, 0);
                if (n4 > n6) {
                    n3 = n6;
                    n2 = 3;
                    continue;
                }
                n3 = n4;
                n2 = 2;
            }
            n = 0;
            boolean bl = false;
            while (!bl) {
                int n8 = d2.a(h2.a, byArray2, n, n5, nArray, 0);
                n5 -= n8;
                n += n8;
                switch (nArray[0]) {
                    case 0: 
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 16: {
                        d2.b(h2.a, null, 0, 0, 16);
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
        }
        h2.k.a = n;
        return 0;
    }

    private static int e(h h2) {
        d d2 = h2.e;
        int n = 0;
        byte[] byArray = new byte[5];
        byArray[0] = 4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[9];
        try {
            int n2;
            d d3 = d2;
            synchronized (d3) {
                n2 = d2.a(h2.a, byArray2, 5, byArray3, 9, 2000);
            }
            if (n2 >= 7 && byArray3[0] == -124) {
                n = (byArray3[5] & 0xFF) << 8 | byArray3[6] & 0xFF;
            }
        }
        catch (ReaderException readerException) {}
        return n;
    }

    private static int f(h h2) {
        int n;
        Object object;
        d d2 = h2.e;
        byte[] byArray = new byte[5];
        byArray[0] = -32;
        byArray[3] = 24;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[35];
        try {
            object = d2;
            synchronized (object) {
                n = d2.a(h2.a, byArray2, 5, byArray3, 35, 2000);
            }
        }
        catch (ReaderException readerException) {
            n = 0;
        }
        object = "";
        if (n > 5) {
            try {
                object = new String(byArray3, 5, n - 5, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = "";
            }
        }
        new StringBuilder("Firmware Version: ").append((String)object);
        int n2 = 0;
        String[] stringArray = new String[]{""};
        int n3 = 0;
        while (n3 < ((String)object).length()) {
            char c2 = ((String)object).charAt(n3);
            if (n2 <= 0) {
                if (c2 == '.') {
                    ++n2;
                } else if (c2 >= '0' && c2 <= '9') {
                    int n4 = n2;
                    stringArray[n4] = String.valueOf(stringArray[n4]) + c2;
                } else {
                    n2 = 0;
                    stringArray[0] = "";
                }
            }
            ++n3;
        }
        n3 = Integer.parseInt(stringArray[0]);
        new StringBuilder("Major: ").append(n3);
        return n3;
    }

    private int a(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        d d2;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The input buffer length is less than or equal to zero.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d3 = d2 = h2.e;
        synchronized (d2) {
            int n4 = d2.a(n, byArray, n2, byArray2, n3, 0);
            // ** MonitorExit[var9_8] (shouldn't be in output)
            return n4;
        }
    }

    private int b(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The input buffer length is less than or equal to zero.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        int n5 = n2 + 3;
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = byArray3;
        byArray3[0] = -32;
        byArray4[1] = 0;
        byArray4[2] = 0;
        System.arraycopy(byArray, 0, byArray4, 3, n2);
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.a(n, byArray4, n5, byArray2, n3, 0);
        }
        return n4;
    }

    private int a(int n, byte[] byArray, int n2) throws ReaderException {
        int n3;
        if (byArray == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray2 = new byte[5];
        byArray2[0] = 4;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = new byte[9];
        d d3 = d2;
        synchronized (d3) {
            n3 = d2.a(n, byArray3, 5, byArray4, 9, 2000);
        }
        if (n3 > 3 && byArray4[0] == -124) {
            if (n2 < (n3 -= 3)) {
                throw new InsufficientBufferException("Required output buffer length: " + n3);
            }
        } else {
            throw new CommunicationErrorException("The response is invalid.");
        }
        System.arraycopy(byArray4, 3, byArray, 0, n3);
        return n3;
    }

    private int c(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 <= 0 || n2 > 32) {
            throw new IllegalArgumentException("The input buffer length is less than or equal to zero or greater than 32.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray3 = new byte[37];
        byte[] byArray4 = new byte[5];
        byArray3[0] = 5;
        byArray3[1] = 0;
        byArray3[2] = 32;
        byArray3[3] = 0;
        byArray3[4] = 0;
        Arrays.fill(byArray3, 5, 37, (byte)32);
        System.arraycopy(byArray, 0, byArray3, 5, n2);
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.a(n, byArray3, 37, byArray4, 5, 2000);
        }
        if (n4 > 3 && byArray4[0] == -123) {
            if (n3 < (n4 -= 3)) {
                throw new InsufficientBufferException("Required output buffer length: " + n4);
            }
        } else {
            throw new CommunicationErrorException("The response is invalid.");
        }
        System.arraycopy(byArray4, 3, byArray2, 0, n4);
        return n4;
    }

    private int d(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 != 6) {
            throw new IllegalArgumentException("The input buffer length is not equal to 6.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray3 = new byte[11];
        byte[] byArray4 = new byte[38];
        byArray3[0] = 6;
        byArray3[1] = 0;
        byArray3[2] = 6;
        byArray3[3] = 0;
        byArray3[4] = 0;
        System.arraycopy(byArray, 0, byArray3, 5, n2);
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.a(n, byArray3, 11, byArray4, 38, 0);
        }
        if (n4 > 3 && byArray4[0] == -122) {
            if (n3 < (n4 -= 3)) {
                throw new InsufficientBufferException("Required output buffer length: " + n4);
            }
        } else {
            throw new CommunicationErrorException("The response is invalid.");
        }
        System.arraycopy(byArray4, 3, byArray2, 0, n4);
        return n4;
    }

    private int e(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 < 23) {
            throw new IllegalArgumentException("The input buffer length is less than 23.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        int n5 = byArray[15] & 0xFF | (byArray[16] & 0xFF) << 8 | (byArray[17] & 0xFF) << 16 | (byArray[18] & 0xFF) << 24;
        if (n5 + 19 != n2) {
            throw new IllegalArgumentException("The ulDataLength is invalid.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray3 = new byte[n2 + 1];
        byte[] byArray4 = byArray3;
        byArray3[0] = 0;
        int n6 = 1;
        int n7 = 0;
        while (n7 < n2) {
            if (n7 != 1 && (n7 < 15 || n7 > 18)) {
                byArray4[n6] = byArray[n7];
                ++n6;
            }
            ++n7;
        }
        int n8 = n6;
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.b(n, byArray4, n8, byArray2, n3, 0);
        }
        return n4;
    }

    private int f(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 < 28) {
            throw new IllegalArgumentException("The input buffer length is less than 28.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        int n5 = byArray[20] & 0xFF | (byArray[21] & 0xFF) << 8 | (byArray[22] & 0xFF) << 16 | (byArray[23] & 0xFF) << 24;
        if (n5 + 24 != n2) {
            throw new IllegalArgumentException("The ulDataLength is invalid.");
        }
        h h2 = this.g.get(n);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray3 = new byte[n2 + 1];
        byte[] byArray4 = byArray3;
        byArray3[0] = 1;
        int n6 = 1;
        int n7 = 0;
        while (n7 < n2) {
            if (!(n7 == 1 || n7 == 15 && byArray[11] == 0 || n7 == 16 && byArray[11] < 3 || n7 >= 20 && n7 <= 23)) {
                byArray4[n6] = byArray[n7];
                ++n6;
            }
            ++n7;
        }
        int n8 = n6;
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.b(n, byArray4, n8, byArray2, n3, 0);
        }
        return n4;
    }

    private int b(int n, byte[] byArray, int n2) throws ReaderException {
        int n3;
        byte[] byArray2;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 < 8) {
            throw new IllegalArgumentException("The input buffer length is less than 8.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        h h2 = this.g.get(n);
        int n4 = h2.f.k;
        int n5 = n4 & 0xFF;
        int n6 = n4 >> 8 & 0xFF;
        int n7 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        int n8 = byArray[2] & 0xFF;
        int n9 = byArray[3] & 0xFF;
        int n10 = byArray[6] & 0xFF;
        if (n7 / 1000 > 255) {
            throw new IllegalArgumentException("The display time is greater than 255000.");
        }
        if (n8 >= n5) {
            throw new IllegalArgumentException("The column is greater than or equal to the maximum number of characters.");
        }
        if (n9 >= n6) {
            throw new IllegalArgumentException("The row is greater than or equal to the maximum number of lines.");
        }
        if (n10 != n2 - 7) {
            throw new IllegalArgumentException("The message length is invalid.");
        }
        try {
            String string = new String(byArray, 7, n10, "UTF-8");
            byArray2 = string.getBytes("ISO-8859-2");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("The message contains invalid characters.");
        }
        int n11 = 2 + byArray2.length;
        byte[] byArray3 = new byte[n11 + 5];
        byte[] byArray4 = byArray3;
        byArray3[0] = 7;
        byArray4[1] = (byte)(n11 >> 8);
        byArray4[2] = (byte)n11;
        byArray4[3] = 0;
        byArray4[4] = 0;
        byArray4[5] = (byte)(n7 / 1000);
        byArray4[6] = (byte)(n9 * n5 + n8);
        System.arraycopy(byArray2, 0, byArray4, 7, byArray2.length);
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray5 = new byte[5];
        d d3 = d2;
        synchronized (d3) {
            n3 = d2.a(n, byArray4, byArray4.length, byArray5, 5, 10000);
        }
        if (n3 <= 4 || byArray5[0] != -121 || byArray5[3] != 0 || byArray5[4] != 0) {
            throw new CommunicationErrorException("The response is invalid.");
        }
        return 0;
    }

    private int g(int n, byte[] byArray, int n2, byte[] byArray2, int n3) throws ReaderException {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 < 5) {
            throw new IllegalArgumentException("The input buffer length is less than 5.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("The output buffer is null.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The output buffer length is less than or equal to zero.");
        }
        if (n3 > byArray2.length) {
            throw new IllegalArgumentException("The output buffer length is greater than the output buffer size.");
        }
        h h2 = this.g.get(n);
        int n5 = h2.f.k;
        int n6 = n5 & 0xFF;
        int n7 = n5 >> 8 & 0xFF;
        int n8 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        int n9 = byArray[2] & 0xFF;
        int n10 = byArray[3] & 0xFF;
        int n11 = byArray[4] & 0xFF;
        if (n8 == 0 || n8 > 255) {
            throw new IllegalArgumentException("The waiting time is equal to zero or greater than 255.");
        }
        if (n9 > 2) {
            throw new IllegalArgumentException("The display mode is greater than 2.");
        }
        if (n10 >= n6) {
            throw new IllegalArgumentException("The column is greater than or equal to the maximum number of characters.");
        }
        if (n11 >= n7) {
            throw new IllegalArgumentException("The row is greater than or equal to the maximum number of lines.");
        }
        byte[] byArray3 = new byte[11];
        byte[] byArray4 = byArray3;
        byArray3[0] = 10;
        byArray4[1] = 0;
        byArray4[2] = 6;
        byArray4[3] = 0;
        byArray4[4] = 0;
        byArray4[5] = (byte)n8;
        byArray4[6] = 1;
        byArray4[7] = 1;
        byArray4[8] = 5;
        byArray4[9] = (byte)(n11 * n6 + n10);
        byArray4[10] = (byte)n9;
        n = h2.a;
        d d2 = h2.e;
        byte[] byArray5 = new byte[7];
        d d3 = d2;
        synchronized (d3) {
            n4 = d2.a(n, byArray4, 11, byArray5, 7, (n8 + 10) * 1000);
        }
        if (n4 > 5 && byArray5[0] == -118 && byArray5[3] == 0 && byArray5[4] == 0) {
            if (n4 > 6) {
                n4 = 1;
                if (n3 <= 0) {
                    throw new InsufficientBufferException("Required output buffer length: 1");
                }
                byArray2[0] = byArray5[6];
            } else {
                n4 = 0;
            }
        } else {
            throw new CommunicationErrorException("The response is invalid.");
        }
        return n4;
    }

    private int c(int n, byte[] byArray, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("The input buffer is null.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The input buffer length is less than 1.");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The input buffer length is greater than the input buffer size.");
        }
        h h2 = this.g.get(n);
        com.acs.smartcard.a a2 = (com.acs.smartcard.a)h2.e;
        int n3 = byArray[0] & 0xFF;
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                com.acs.smartcard.a a3 = a2;
                synchronized (a3) {
                    a2.a(n3);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("The card type is invalid.");
            }
        }
        return 0;
    }

    static /* synthetic */ void a(Reader reader, h h2) throws ReaderException {
        h h3 = h2;
        d d2 = h3.e;
        Object object = d2;
        synchronized (d2) {
            int n = d2.c(h3.a);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            object = h3.c;
            h h4 = h3;
            synchronized (h4) {
                switch (n) {
                    case 0: 
                    case 1: {
                        if (((g)object).a > 1) break;
                        ((g)object).a = 2;
                        break;
                    }
                    case 2: {
                        ((g)object).a = 1;
                        break;
                    }
                    default: {
                        ((g)object).a = 0;
                    }
                }
                return;
            }
        }
    }

    static /* synthetic */ void a(Reader reader, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        int n6 = n;
        Reader reader2 = reader;
        if (n5 > 1 && n4 <= 1 || n5 <= 1 && n4 > 1) {
            new StringBuilder("run: slot ").append(n6).append(": ").append(n4 <= 1 ? "removed" : "inserted");
            if (reader2.k != null) {
                new Thread(new Runnable(reader2, n6, n5, n4){
                    private /* synthetic */ Reader a;
                    private final /* synthetic */ int b;
                    private final /* synthetic */ int c;
                    private final /* synthetic */ int d;
                    {
                        this.a = reader;
                        this.b = n;
                        this.c = n2;
                        this.d = n3;
                    }

                    @Override
                    public final void run() {
                        if (this.a.k != null) {
                            this.a.k.onStateChange(this.b, this.c, this.d);
                        }
                    }
                }).start();
            }
        }
    }

    final class a
    implements Runnable {
        private /* synthetic */ Reader a;

        private a(Reader reader) {
            this.a = reader;
        }

        @Override
        public final void run() {
            int n;
            int n2;
            Object object2;
            g g2;
            h h2;
            int n3 = 0;
            while (n3 < this.a.g.size()) {
                h2 = (h)this.a.g.get(n3);
                g2 = h2.c;
                object2 = h2;
                synchronized (object2) {
                    n2 = g2.a;
                    if (h2.b) {
                        g2.a = 2;
                    } else {
                        try {
                            Reader.a(this.a, h2);
                        }
                        catch (ReaderException readerException) {}
                    }
                    n = g2.a;
                }
                Reader.a(this.a, n3, n2, n);
                ++n3;
            }
            for (Object object2 : this.a.f) {
                ((d)object2).b();
            }
            while (!this.a.j.isInterrupted()) {
                UsbRequest usbRequest = this.a.h.requestWait();
                if (usbRequest == null) continue;
                d d2 = (d)usbRequest.getClientData();
                byte[] byArray = d2.c();
                int n4 = byArray.length;
                d2.b();
                if (n4 < 2) continue;
                if ((byArray[0] & 0xFF) == 1) {
                    byArray[0] = 80;
                    byArray[1] = (byArray[1] & 0xFF) == 192 ? 2 : 3;
                    n4 = 2;
                }
                if ((byArray[0] & 0xFF) != 80) continue;
                List<h> list = d2.a();
                n3 = 0;
                while (n3 < list.size()) {
                    h2 = list.get(n3);
                    if (!h2.b) {
                        g2 = h2.c;
                        object2 = h2;
                        synchronized (object2) {
                            n2 = g2.a;
                            int n5 = n3 / 4;
                            int n6 = 2 * (n3 % 4);
                            if (n5 + 1 < n4) {
                                if ((byArray[n5 + 1] & 1 << n6) != 0) {
                                    if (g2.a <= 1) {
                                        g2.a = 2;
                                    }
                                } else {
                                    g2.a = 1;
                                }
                            }
                            n = g2.a;
                        }
                        int n7 = this.a.g.indexOf(h2);
                        Reader.a(this.a, n7, n2, n);
                    }
                    ++n3;
                }
            }
        }

        /* synthetic */ a(Reader reader, byte by) {
            this(reader);
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(int var1, int var2, int var3);
    }

    static enum b {
        a,
        b,
        c;

    }
}

