/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.signature;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1IA5String;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateChoices;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EOtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationInfoChoice;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESigPolicyQualifierInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.esya.EESYAOID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.SignableByteArray;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.IAttribute;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MessageDigestAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MimeTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignaturePolicyIdentifierAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSigProviderUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.SignatureParser;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.CertificateValidationException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ProfileRevocationValueMatcherChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.HashInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECUtil;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.IMobileSigner;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.TimestampInfo;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.impl.TimestampInfoImp;
import tr.gov.tubitak.uekae.esya.asn.cms.SPUserNotice;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms._etsi101733Values;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public abstract class Signer {
    protected EAttribute mParentCounterSignatureAttribute;
    protected Signer mParent;
    protected boolean mIsCounterSignature;
    protected int mCSIndex = -1;
    protected ESignerInfo mSignerInfo;
    protected ESignatureType mSignatureType;
    protected BaseSignedData mSignedData;
    private static final DigestAlg a;
    private static final Boolean b;
    private static final int c = 1;
    private static final Boolean d;
    static Asn1ObjectIdentifier e;
    static Asn1ObjectIdentifier f;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int g;
    private static final String[] h;
    private static final String[] i;

    Signer() {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-30566, -24855) + lE.getMessage(), (Throwable)lE);
        }
    }

    Signer(BaseSignedData baseSignedData) {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-30566, -24855) + lE.getMessage(), (Throwable)lE);
        }
        this.mSignedData = baseSignedData;
        this.mSignerInfo = new ESignerInfo(new SignerInfo());
    }

    public ESignerInfo getSignerInfo() {
        return this.mSignerInfo;
    }

    public BaseSignedData getBaseSignedData() {
        return this.mSignedData;
    }

    public ECertificate getSignerCertificate() {
        List list = this.mSignedData.getSignedData().getCertificates();
        return this.mSignerInfo.getSignerCertificate(list);
    }

    public Pair<SignatureAlg, AlgorithmParams> getSignatureAlg() throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = this.mSignerInfo.getSignatureAlgorithm();
        Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eAlgorithmIdentifier);
        return pair;
    }

    public HashInfo getContentHashInfo() throws ESYAException {
        List list = this.mSignerInfo.getSignedAttribute(MessageDigestAttr.OID);
        if (!list.isEmpty()) {
            EAttribute eAttribute = (EAttribute)list.get(0);
            byte[] byArray = MessageDigestAttr.toMessageDigest(eAttribute).getHash();
            DigestAlg digestAlg = DigestAlg.fromOID((int[])this.mSignerInfo.getDigestAlgorithm().getAlgorithm().value);
            return new HashInfo(digestAlg, byArray);
        }
        return null;
    }

    public void convert(ESignatureType aType, Map<String, Object> aParameters) throws CMSSignatureException {
        this.a(null, aType);
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        this._convert(aType, this.mIsCounterSignature, hashMap);
        this.c();
        this.mSignatureType = aType;
    }

    private boolean a() {
        Signer signer = this.mParent;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                return true;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv2Time() throws ESYAException {
        Signer signer = this.mParent;
        int n = g;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                calendar = SignatureTimeStampAttr.toTime(list.get(0));
                return calendar;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    public List<TimestampInfo> getAllTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_contentTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_escTimeStamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_signatureTimeStampToken);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_certCRLTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        Collections.sort(arrayList, new c(this));
        return arrayList;
    }

    public List<TimestampInfo> getAllArchiveTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        arrayList.sort(Comparator.comparingLong(timestampInfo -> timestampInfo.getTSTInfo().getTime().getTimeInMillis()));
        return arrayList;
    }

    private void a(List<TimestampInfo> list, List<TimestampInfo> list2) {
        Iterator<TimestampInfo> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            TimestampInfo timestampInfo = iterator.next();
            list2.add(timestampInfo);
            if (n == 0) continue;
        }
    }

    private List<TimestampInfo> a(Asn1ObjectIdentifier asn1ObjectIdentifier) throws ESYAException {
        List list = this.mSignerInfo.getUnsignedAttribute(asn1ObjectIdentifier);
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>(list.size());
        int n = g;
        for (EAttribute eAttribute : list) {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
            TimestampInfoImp timestampInfoImp = new TimestampInfoImp(CMSSigProviderUtil.convertTimestampType(asn1ObjectIdentifier), eSignedData, eTSTInfo);
            arrayList.add((TimestampInfo)timestampInfoImp);
            if (n == 0) continue;
        }
        return arrayList;
    }

    public boolean _checkIfSignerIsESAV3() {
        block4: {
            List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
            if (list == null || list.size() <= 0) break block4;
            return true;
        }
        return false;
    }

    public boolean _checkIfSignerIsESAV2() {
        block9: {
            List list;
            block8: {
                List list2 = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                if (list2 == null || list2.size() <= 0) break block8;
                return true;
            }
            if (list == null || list.size() <= 0) break block9;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _convert(ESignatureType aType, boolean aIsCounterSignature, Map<String, Object> aParameters) throws CMSSignatureException {
        ECertificate eCertificate;
        ESignatureType eSignatureType = SignatureParser.parse(this.mSignerInfo, aIsCounterSignature);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        arrayList.addAll(this.mSignedData.getSignedData().getCertificates());
        Object object = aParameters.get(Signer.a(-30477, 13672));
        ECertificate eCertificate2 = null;
        if (object != null && object instanceof ECertificate) {
            eCertificate2 = (ECertificate)object;
            arrayList.add(eCertificate2);
        }
        if ((eCertificate = this.getSignerCertificate()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-30555, -16178));
            }
            throw new CMSSignatureException(Signer.a(-30530, 13278));
        }
        aParameters.put(Signer.a(-30586, -1750), eCertificate);
        Signer signer = null;
        try {
            signer = ESignatureType.createSigner(aType, this.mSignedData, this.mSignerInfo);
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-30562, 26397), (Throwable)exception);
            }
            throw new CMSSignatureException(Signer.a(-30482, 24161), exception);
        }
        this.a(aIsCounterSignature, eCertificate, null, aParameters);
        signer._convert(eSignatureType, aParameters);
    }

    public boolean remove() throws CMSSignatureException {
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        if (!this.mIsCounterSignature) {
            return this.mSignedData.removeSigner(this.mSignerInfo);
        }
        return this.mParent.removeUnSignedAttribute(this.mParentCounterSignatureAttribute);
    }

    private boolean b() throws CMSSignatureException {
        Signer signer = this.mParent;
        Signer signer2 = this;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                return true;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new CMSSignatureException(Signer.a(-30590, -19051), eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv3Time() throws ESYAException {
        Signer signer = this.mParent;
        Signer signer2 = this;
        Calendar calendar = null;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                int n2 = this.a(list, eAttribute);
                                calendar = SignatureTimeStampAttr.toTime(list.get(n2));
                                return calendar;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new ESYAException(Signer.a(-30536, 10964), (Throwable)eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    private int a(List<EAttribute> list, EAttribute eAttribute) throws CryptoException {
        int n = g;
        for (int i = 0; i < list.size() - 1; ++i) {
            EATSHashIndex eATSHashIndex = this.a(list.get(i));
            List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
            asn1DerEncodeBuffer.reset();
            if (!list2.contains(asn1OctetString)) continue;
            return i;
        }
        return list.size() - 1;
    }

    private EATSHashIndex a(EAttribute eAttribute) {
        try {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            EAttribute eAttribute2 = (EAttribute)eSignedData.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            return new EATSHashIndex(eAttribute2.getValue(0));
        }
        catch (ESYAException eSYAException) {
            throw new ESYARuntimeException(Signer.a(-30547, 27023), (Throwable)eSYAException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(ESignatureType aType, ECertificate aCer, BaseSigner aSignerInterface, List<IAttribute> aOptionalAttributes, Map<String, Object> aParameters) throws CertificateValidationException, CMSSignatureException {
        this.a(aCer, aType);
        int n = g;
        if (this.mSignedData.checkIfAnyESAv2Exist() && this.b()) {
            if (!this.logger.isDebugEnabled()) throw new CMSSignatureException(Signer.a(-30554, -8904));
            this.logger.error(Signer.a(-30494, 17965));
            throw new CMSSignatureException(Signer.a(-30554, -8904));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Signer.a(-30548, -884) + aCer + Signer.a(-30567, 10594));
        }
        Signer signer = null;
        SignatureAlg signatureAlg = null;
        try {
            signatureAlg = SignatureAlg.fromName((String)aSignerInterface.getSignatureAlgorithmStr());
            signer = ESignatureType.createSigner(aType, this.mSignedData);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-30488, 21588), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-30475, 28010), exception);
        }
        DigestAlg digestAlg = signatureAlg.getDigestAlg();
        AlgorithmParameterSpec algorithmParameterSpec = aSignerInterface.getAlgorithmParameterSpec();
        digestAlg = CMSSignatureUtil.getDigestAlgFromParameters(digestAlg, algorithmParameterSpec);
        hashMap.put(Signer.a(-30574, 236), new SignableByteArray(this.mSignerInfo.getSignature()));
        signer.a(true, aCer, aSignerInterface, aOptionalAttributes, hashMap, digestAlg);
        EAttribute eAttribute = new EAttribute(new Attribute());
        eAttribute.setType(AttributeOIDs.id_countersignature);
        eAttribute.addValue(signer.getSignerInfo().getEncoded());
        this.mSignerInfo.addUnsignedAttribute(eAttribute);
        if (digestAlg != null) {
            CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), digestAlg.toAlgorithmIdentifier());
        }
        this.c();
        if (BaseChecker.d == 0) return;
        g = ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(Signer signer) {
        int n = g;
        if (this.checkSignerMessageDigest(signer, this.mSignerInfo.getSignature())) {
            EAttribute eAttribute = new EAttribute(new Attribute());
            eAttribute.setType(AttributeOIDs.id_countersignature);
            eAttribute.addValue(signer.getSignerInfo().getEncoded());
            this.mSignerInfo.addUnsignedAttribute(eAttribute);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), signer.getSignerCertificate());
            EAlgorithmIdentifier eAlgorithmIdentifier = signer.getSignerInfo().getDigestAlgorithm();
            if (eAlgorithmIdentifier != null) {
                CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), eAlgorithmIdentifier);
            }
            this.c();
            if (n == 0) return;
        }
        this.logger.error(Signer.a(-30561, -28480));
    }

    public boolean checkSignerMessageDigest(Signer aSigner, byte[] aContent) {
        Object object;
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_messageDigest);
        if (list.isEmpty()) {
            this.logger.error(Signer.a(-30573, -29763));
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        try {
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1OctetString.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            this.logger.error(Signer.a(-30546, 25657), (Throwable)exception);
            return false;
        }
        DigestAlg digestAlg = DigestAlg.fromOID((int[])aSigner.getSignerInfo().getDigestAlgorithm().getAlgorithm().value);
        if (digestAlg == null) {
            this.logger.error(Signer.a(-30543, 29872));
            return false;
        }
        try {
            object = DigestUtil.digest((DigestAlg)digestAlg, (byte[])aContent);
        }
        catch (CryptoException cryptoException) {
            this.logger.error(Signer.a(-30553, -24068), (Throwable)cryptoException);
            return false;
        }
        boolean bl = Arrays.equals(asn1OctetString.value, (byte[])object);
        if (!bl) {
            this.logger.error(Signer.a(-30483, -10784));
            return false;
        }
        this.logger.error(Signer.a(-30538, -28484));
        return true;
    }

    public List<Signer> getCounterSigners() throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_countersignature);
        ArrayList<Signer> arrayList = new ArrayList<Signer>();
        Iterator iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            try {
                for (int i = 0; i < eAttribute.getValueCount(); ++i) {
                    ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(i));
                    ESignatureType eSignatureType = SignatureParser.parse(eSignerInfo, true);
                    Signer signer = ESignatureType.createSigner(eSignatureType, this.mSignedData, eSignerInfo);
                    signer.setParent(this, eAttribute, i);
                    arrayList.add(signer);
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CMSSignatureException(Signer.a(-30531, 26086), exception);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    public ESignatureType getType() {
        return this.mSignatureType;
    }

    protected void setParent(Signer aParent, EAttribute aAttr, int aIndex) {
        this.mParent = aParent;
        this.mParentCounterSignatureAttribute = aAttr;
        this.mCSIndex = aIndex;
        if (this.mParent != null) {
            this.mIsCounterSignature = true;
        }
    }

    public boolean isCounterSignature() {
        return this.mIsCounterSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, ECertificate eCertificate, BaseSigner baseSigner, List<IAttribute> list, Map<String, Object> map, DigestAlg digestAlg) throws CMSSignatureException {
        Object object2;
        List<IAttribute> list2;
        HashMap<String, Object> hashMap;
        int n;
        block33: {
            block30: {
                block32: {
                    block31: {
                        n = g;
                        if (bl && this.b(list)) {
                            throw new CMSSignatureException(Signer.a(-30592, 24717));
                        }
                        hashMap = new HashMap<String, Object>();
                        if (map != null) {
                            hashMap.putAll(map);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(Signer.a(-30485, -17017) + digestAlg);
                        }
                        this.a(bl, eCertificate, digestAlg, hashMap);
                        DigestAlg digestAlg2 = (DigestAlg)hashMap.get(Signer.a(-30493, -12763));
                        if (this.mSignatureType == ESignatureType.TYPE_EPES && !this.a(list)) {
                            throw new CMSSignatureException(Signer.a(-30583, -3847));
                        }
                        list2 = this._getMandatorySignedAttributes(bl, digestAlg2);
                        this.mSignerInfo.setVersion(1);
                        if (eCertificate != null || !(baseSigner instanceof IMobileSigner)) break block30;
                        object2 = ((IMobileSigner)baseSigner).getSignerIdentifier();
                        if (object2 == null) {
                            throw new CMSSignatureException(Signer.a(-30492, -30155));
                        }
                        this.mSignerInfo.setSignerIdentifier(object2);
                        DigestAlg object3 = ((IMobileSigner)baseSigner).getDigestAlg();
                        list2 = this._getMandatorySignedAttributes(bl, object3);
                        if (!object3.equals((Object)DigestAlg.SHA1)) break block31;
                        hashMap.put(Signer.a(-30552, 28892), ((IMobileSigner)baseSigner).getSigningCertAttr());
                        if (n == 0) break block32;
                        int n2 = BaseChecker.d;
                        BaseChecker.d = ++n2;
                    }
                    hashMap.put(Signer.a(-30578, -4738), ((IMobileSigner)baseSigner).getSigningCertAttrv2());
                }
                if (n == 0) break block33;
            }
            object2 = new ESignerIdentifier(new SignerIdentifier());
            object2.setIssuerAndSerialNumber(new EIssuerAndSerialNumber(eCertificate));
            this.mSignerInfo.setSignerIdentifier(object2);
        }
        if (list != null) {
            list2.addAll(list);
        }
        this.mSignerInfo.setDigestAlgorithm(digestAlg.toAlgorithmIdentifier());
        for (IAttribute exception : list2) {
            if (exception.isSigned()) {
                exception.setParameters(hashMap);
                exception.setValue();
                this.mSignerInfo.addSignedAttribute(exception.getAttribute());
            }
            if (n == 0) continue;
        }
        this.a(hashMap);
        object2 = null;
        try {
            SignatureAlg signatureAlg = SignatureAlg.fromName((String)baseSigner.getSignatureAlgorithmStr());
            AlgorithmParameterSpec algorithmParameterSpec = baseSigner.getAlgorithmParameterSpec();
            EAlgorithmIdentifier eAlgorithmIdentifier = signatureAlg.toAlgorithmIdentifierFromSpec(algorithmParameterSpec);
            this.mSignerInfo.setSignatureAlgorithm(eAlgorithmIdentifier);
            Chronometer chronometer = new Chronometer(Signer.a(-30491, -3375));
            chronometer.start();
            byte[] byArray = this.mSignerInfo.getSignedAttributes().getEncoded();
            object2 = baseSigner.sign(byArray);
            if (eCertificate == null && baseSigner instanceof IMobileSigner) {
                eCertificate = ((IMobileSigner)baseSigner).getSigningCert();
                hashMap.put(Signer.a(-30565, 6781), eCertificate);
            }
            this.logger.info(chronometer.stopSingleRun());
            this.mSignerInfo.setSignature((byte[])object2);
            ECUtil.checkDigestAlgForECCAlgorithm((ECertificate)eCertificate, (SignatureAlg)signatureAlg);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), eCertificate);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-30484, 21504), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-30549, -16865) + exception.getMessage(), exception);
        }
        this._addUnsignedAttributes(hashMap);
    }

    private boolean a(List<IAttribute> list) {
        Iterator<IAttribute> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            IAttribute iAttribute = iterator.next();
            if (iAttribute instanceof SignaturePolicyIdentifierAttr) {
                return true;
            }
            if (n == 0) continue;
        }
        return false;
    }

    private boolean b(List<IAttribute> list) {
        int n = g;
        if (list != null) {
            for (IAttribute iAttribute : list) {
                if (iAttribute instanceof MimeTypeAttr) {
                    return true;
                }
                if (n == 0) continue;
            }
        }
        return false;
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCer, Map<String, Object> aParams, Calendar aDate, boolean gelismis) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        block8: {
            CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(gelismis);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(aCer, aParams, aDate);
            List<CertRevocationInfoFinder.CertRevocationInfo> list = certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
            aParams.put(Signer.a(-30478, -12432), list);
            int n = g;
            try {
                boolean bl = Boolean.TRUE.equals(aParams.get(Signer.a(-30480, -12721)));
                if (!this.isTurkishProfile() || bl) break block8;
                ArrayList<BaseChecker> arrayList = new ArrayList<BaseChecker>();
                ProfileRevocationValueMatcherChecker profileRevocationValueMatcherChecker = new ProfileRevocationValueMatcherChecker(certificateStatusInfo, true);
                TurkishProfileAttributesChecker turkishProfileAttributesChecker = new TurkishProfileAttributesChecker(true);
                arrayList.add(profileRevocationValueMatcherChecker);
                arrayList.add(turkishProfileAttributesChecker);
                for (Checker checker : arrayList) {
                    CheckerResult checkerResult = new CheckerResult();
                    checker.setParameters(aParams);
                    boolean bl2 = checker.check(this, checkerResult);
                    if (!bl2) {
                        throw new CMSSignatureException(checkerResult.getCheckResult());
                    }
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.logger.error(Signer.a(-30473, 29198) + exception.getMessage());
                throw new SignatureRuntimeException((Throwable)exception);
            }
        }
        return certificateStatusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, ECertificate eCertificate, DigestAlg digestAlg, Map<String, Object> map) {
        int n;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block75: {
                                                                n = g;
                                                                if (digestAlg != null) {
                                                                    map.put(Signer.a(-30557, 7052), digestAlg);
                                                                    map.put(Signer.a(-30559, 11090), digestAlg);
                                                                }
                                                                if (eCertificate != null) {
                                                                    map.put(Signer.a(-30586, -1750), eCertificate);
                                                                }
                                                                map.put(Signer.a(-30476, 28834), this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContentType());
                                                                if (bl) break block74;
                                                                if (this.mSignedData.a() != null) break block75;
                                                                byte[] byArray = this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContent();
                                                                if (byArray != null) {
                                                                    map.put(Signer.a(-30481, 9550), new SignableByteArray(byArray));
                                                                }
                                                                if (n == 0) break block74;
                                                            }
                                                            map.put(Signer.a(-30481, 9550), this.mSignedData.a());
                                                        }
                                                        if (map.containsKey(Signer.a(-30559, 11090))) break block76;
                                                        map.put(Signer.a(-30559, 11090), a);
                                                        if (!this.logger.isDebugEnabled()) break block77;
                                                        this.logger.debug(Signer.a(-30589, 29234) + digestAlg + Signer.a(-30479, 2143));
                                                        if (n == 0) break block77;
                                                    }
                                                    if (!(map.get(Signer.a(-30559, 11090)) instanceof DigestAlg)) {
                                                        map.put(Signer.a(-30559, 11090), a);
                                                        this.logger.debug(Signer.a(-30490, 26085) + digestAlg + Signer.a(-30534, 32676));
                                                    }
                                                }
                                                if (map.containsKey(Signer.a(-30568, 8725))) break block78;
                                                map.put(Signer.a(-30577, -27543), b);
                                                if (!this.logger.isDebugEnabled()) break block79;
                                                this.logger.debug(Signer.a(-30581, 18908));
                                                if (n == 0) break block79;
                                            }
                                            if (!(map.get(Signer.a(-30577, -27543)) instanceof Boolean)) {
                                                map.put(Signer.a(-30577, -27543), b);
                                                this.logger.debug(Signer.a(-30486, -575));
                                            }
                                        }
                                        if (!map.containsKey(Signer.a(-30558, -10218))) {
                                            map.put(Signer.a(-30556, 17112), new ValidationInfoResolverFromCertStore());
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(Signer.a(-30575, -3076));
                                            }
                                        }
                                        ValidationInfoResolver validationInfoResolver = (ValidationInfoResolver)map.get(Signer.a(-30556, 17112));
                                        List list = (List)map.get(Signer.a(-30550, -10882));
                                        List list2 = (List)map.get(Signer.a(-30564, -29290));
                                        List list3 = (List)map.get(Signer.a(-30474, -5482));
                                        if (list != null) {
                                            validationInfoResolver.addCertificates(list);
                                        }
                                        if (list2 != null) {
                                            validationInfoResolver.addCRLs(list2);
                                        }
                                        if (list3 != null) {
                                            validationInfoResolver.addOCSPResponses(list3);
                                        }
                                        if (map.containsKey(Signer.a(-30537, 20332))) break block80;
                                        map.put(Signer.a(-30585, 12005), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!this.logger.isDebugEnabled()) break block81;
                                        this.logger.debug(Signer.a(-30495, 28568));
                                        if (n == 0) break block81;
                                    }
                                    if (!(map.get(Signer.a(-30585, 12005)) instanceof Boolean)) {
                                        map.put(Signer.a(-30585, 12005), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        this.logger.debug(Signer.a(-30529, 31728));
                                    }
                                }
                                if (map.containsKey(Signer.a(-30560, -21089))) break block82;
                                map.put(Signer.a(-30569, -23670), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!this.logger.isDebugEnabled()) break block83;
                                this.logger.debug(Signer.a(-30540, 12318) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (n == 0) break block83;
                            }
                            if (!(map.get(Signer.a(-30569, -23670)) instanceof Long)) {
                                map.put(Signer.a(-30569, -23670), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                this.logger.debug(Signer.a(-30539, -31263) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                            }
                        }
                        if (map.containsKey(Signer.a(-30496, 3759))) break block84;
                        map.put(Signer.a(-30532, -8069), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!this.logger.isDebugEnabled()) break block85;
                        this.logger.debug(Signer.a(-30541, 17405) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (n == 0) break block85;
                    }
                    if (!(map.get(Signer.a(-30532, -8069)) instanceof Long)) {
                        map.put(Signer.a(-30532, -8069), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        this.logger.debug(Signer.a(-30542, 11080) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                    }
                }
                if (map.containsKey(Signer.a(-30572, 14159))) break block86;
                map.put(Signer.a(-30588, -3623), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!this.logger.isDebugEnabled()) break block87;
                this.logger.debug(Signer.a(-30570, -11882) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (n == 0) break block87;
            }
            if (!(map.get(Signer.a(-30588, -3623)) instanceof Boolean)) {
                map.put(Signer.a(-30588, -3623), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                this.logger.debug(Signer.a(-30571, 13260) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
            }
        }
        if (!map.containsKey(Signer.a(-30533, -28070))) {
            map.put(Signer.a(-30584, -17273), d);
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug(Signer.a(-30576, 7097));
            if (n == 0) return;
        }
        if (map.get(Signer.a(-30584, -17273)) instanceof Boolean) return;
        map.put(Signer.a(-30584, -17273), d);
        this.logger.debug(Signer.a(-30487, 16565));
    }

    public List<EAttribute> getSignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getSignedAttribute(aOID);
    }

    public List<EAttribute> getUnsignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getUnsignedAttribute(aOID);
    }

    public List<EAttribute> getAttribute(Asn1ObjectIdentifier aOID) {
        List list = this.mSignerInfo.getUnsignedAttribute(aOID);
        List list2 = this.mSignerInfo.getSignedAttribute(aOID);
        list.addAll(list2);
        return list;
    }

    public boolean removeUnSignedAttribute(EAttribute aAttribute) {
        boolean bl = this.mSignerInfo.removeUnSignedAttribute(aAttribute);
        this.c();
        return bl;
    }

    private void c() {
        Signer signer = this.mParent;
        EAttribute eAttribute = this.mParentCounterSignatureAttribute;
        int n = g;
        ESignerInfo eSignerInfo = this.mSignerInfo;
        while (signer != null) {
            eAttribute.setValue(this.mCSIndex, eSignerInfo.getEncoded());
            eAttribute = signer.mParentCounterSignatureAttribute;
            eSignerInfo = signer.mSignerInfo;
            signer = signer.mParent;
            if (n == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate, ESignatureType eSignatureType) {
        int n = g;
        try {
            block11: {
                block10: {
                    if (eSignatureType != ESignatureType.TYPE_BES && eSignatureType != ESignatureType.TYPE_EPES) break block10;
                    LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
                    if (n == 0) break block11;
                }
                LV.getInstance().checkLD(LV.Urunler.CMSIMZAGELISMIS);
            }
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (eCertificate == null) return;
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(Signer.a(-30591, 451))) return;
            throw new ESYARuntimeException(Signer.a(-30587, 2765));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-30545, 9115) + lE.getMessage(), (Throwable)lE);
        }
    }

    public boolean isTurkishProfile() {
        try {
            TurkishESigProfile turkishESigProfile = this.mSignerInfo.getProfile();
            if (turkishESigProfile == null) {
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-30579, 9946), (Throwable)exception);
            return false;
        }
        return true;
    }

    protected void _addCertRevocationValuesToSignedData(List<CertRevocationInfoFinder.CertRevocationInfo> aList) throws CMSSignatureException {
        this.a(aList, this.mSignedData.getSignedData());
    }

    protected void _addCertRevocationValuesToSignedData(List<ECertificate> aCerts, List<ECRL> aCrls, List<EOCSPResponse> aOCSPResponses) throws CMSSignatureException {
        this.a(aCerts, aCrls, aOCSPResponses, this.mSignedData.getSignedData());
    }

    public List<CertRevocationInfoFinder.CertRevocationInfo> findTSCertificateRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap) throws CMSSignatureException {
        return this.a(aTSAttr, aParamMap);
    }

    private List<CertRevocationInfoFinder.CertRevocationInfo> a(EAttribute eAttribute, Map<String, Object> map) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        Calendar calendar = null;
        EContentInfo eContentInfo = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-30544, 19146), exception);
        }
        BaseSignedData baseSignedData = new BaseSignedData(eContentInfo);
        ECertificate eCertificate = baseSignedData.getSignerList().get(0).getSignerCertificate();
        if (eCertificate == null) {
            throw new CMSSignatureException(Signer.a(-30580, 19299));
        }
        calendar = Calendar.getInstance();
        CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(true);
        try {
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        catch (CertificateValidationException certificateValidationException) {
            try {
                calendar = SignatureTimeStampAttr.toTime(eAttribute);
            }
            catch (ESYAException eSYAException) {
                this.logger.warn(Signer.a(-30489, -32676), (Throwable)eSYAException);
                throw certificateValidationException;
            }
            certRevocationInfoFinder = new CertRevocationInfoFinder(true);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        return certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
    }

    protected void _addTSCertRevocationValues(Map<String, Object> aParameters, Asn1ObjectIdentifier aTSOID, boolean intoTimestamp) throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(aTSOID);
        if (list.isEmpty()) {
            list = this.mSignerInfo.getSignedAttribute(aTSOID);
            if (list.isEmpty()) {
                throw new CMSSignatureException(Signer.a(-30582, 10053) + aTSOID);
            }
        }
        this._addTSCertRevocationValues((EAttribute)list.get(list.size() - 1), aParameters, intoTimestamp);
    }

    protected void _addTSCertRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap, boolean intoTimestamp) throws CMSSignatureException {
        block5: {
            List<CertRevocationInfoFinder.CertRevocationInfo> list;
            block4: {
                list = this.a(aTSAttr, aParamMap);
                int n = g;
                if (!intoTimestamp) break block4;
                this.b(list, aTSAttr);
                if (n == 0) break block5;
            }
            this._addCertRevocationValuesToSignedData(list);
        }
    }

    private void b(List<CertRevocationInfoFinder.CertRevocationInfo> list, EAttribute eAttribute) throws CMSSignatureException {
        EContentInfo eContentInfo = null;
        ESignedData eSignedData = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
            eSignedData = new ESignedData(eContentInfo.getContent());
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-30563, 25699), exception);
        }
        this.a(list, eSignedData);
        eContentInfo.setContent(eSignedData.getEncoded());
        eAttribute.setValue(0, eContentInfo.getEncoded());
    }

    private void a(List<CertRevocationInfoFinder.CertRevocationInfo> list, ESignedData eSignedData) throws CMSSignatureException {
        List<ECertificate> list2 = AttributeUtil.getCertificates(list);
        List<ECRL> list3 = AttributeUtil.getCRLs(list);
        List<EOCSPResponse> list4 = AttributeUtil.getOCSPResponses(list);
        this.a(list2, list3, list4, eSignedData);
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<ECertificate> list, List<ECRL> list2, List<EOCSPResponse> list3, ESignedData eSignedData) throws CMSSignatureException {
        List<Object> list4 = new ArrayList();
        int n = g;
        if (eSignedData.getCertificateSet() != null) {
            list4 = Arrays.asList(eSignedData.getCertificateSet().getCertificates());
        }
        for (ECertificate object2 : list) {
            if (!list4.contains(object2)) {
                eSignedData.addCertificateChoices(new ECertificateChoices(object2));
            }
            if (n == 0) continue;
        }
        Object object3 = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            object3 = eSignedData.getRevocationInfoChoices().getCRLs();
        }
        for (ECRL eCRL : list2) {
            if (!object3.contains(eCRL)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eCRL));
            }
            if (n == 0) continue;
        }
        ArrayList arrayList = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            List list5 = eSignedData.getOSCPResponses();
        }
        for (EOCSPResponse eOCSPResponse : list3) {
            void var8_12;
            if (!var8_12.contains(eOCSPResponse)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eOCSPResponse));
            }
            if (n == 0) continue;
        }
    }

    private void a(Map<String, Object> map) throws CMSSignatureException {
        Asn1ObjectIdentifier asn1ObjectIdentifier = AttributeOIDs.id_aa_ets_contentTimestamp;
        if (this.mSignerInfo.getSignedAttribute(asn1ObjectIdentifier).size() > 0) {
            this._addTSCertRevocationValues(map, asn1ObjectIdentifier, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignaturePolicyIdentifier getSignaturePolicy() {
        int n = g;
        if (this.getType() == ESignatureType.TYPE_BES) {
            return null;
        }
        ESignaturePolicy eSignaturePolicy = null;
        try {
            eSignaturePolicy = this.getSignerInfo().getPolicyAttr();
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-30535, 30133), (Throwable)exception);
            throw new SignatureRuntimeException();
        }
        if (eSignaturePolicy == null) {
            return null;
        }
        OID oID = new OID(eSignaturePolicy.getSignaturePolicyId().getPolicyObjectIdentifier().value);
        EOtherHashAlgAndValue eOtherHashAlgAndValue = eSignaturePolicy.getSignaturePolicyId().getHashInfo();
        SignaturePolicyIdentifier signaturePolicyIdentifier = eSignaturePolicy.getSignaturePolicyId().getPolicyQualifiers();
        String string = null;
        String string2 = null;
        SignaturePolicyIdentifier signaturePolicyIdentifier2 = signaturePolicyIdentifier;
        int n2 = ((ESigPolicyQualifierInfo[])signaturePolicyIdentifier2).length;
        int n3 = 0;
        do {
            block13: {
                ESigPolicyQualifierInfo eSigPolicyQualifierInfo;
                block14: {
                    Asn1IA5String asn1IA5String;
                    block12: {
                        if (n3 >= n2) return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
                        eSigPolicyQualifierInfo = signaturePolicyIdentifier2[n3];
                        if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_uri)) break block12;
                        asn1IA5String = new Asn1IA5String();
                        eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                        string = asn1IA5String.value;
                        if (n == 0) break block13;
                    }
                    if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_unotice)) break block14;
                    asn1IA5String = new SPUserNotice();
                    eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                    string2 = ((Asn1UTF8String)asn1IA5String.explicitText.getElement()).value;
                    if (n == 0) break block13;
                }
                this.logger.warn(Signer.a(-30551, -17839) + eSigPolicyQualifierInfo.getObjectIdentifier());
            }
            ++n3;
        } while (n == 0);
        return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
    }

    protected abstract List<IAttribute> _getMandatorySignedAttributes(boolean var1, DigestAlg var2);

    protected abstract void _addUnsignedAttributes(Map<String, Object> var1) throws CMSSignatureException;

    protected abstract void _convert(ESignatureType var1, Map<String, Object> var2) throws CMSSignatureException;

    public abstract Calendar getTime() throws ESYAException;

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[88];
                var3_1 = 0;
                var2_2 = "\f\u00ceV\u008a\u00a5\u00b7Zd\u00cc\u009a\u00edf\u00c9\u007fw\u00e7\u00b3\u00afdN\u008aEh\u00b7W\u00e6\u00eeu\u008d\u0092\u00ea\r\u008f8\u00d8\u001b\u008d\u008e1c\u00ba*\u00e6\u0013@$\u00ba\u0018\u0011\u00bby\u00c3\u0097\u009emG#8J0\u0016\u00e5\u00bd\u00e3\u00e8\u008dD\u009d\u00f7\u00a1/\u0005\u00ed\u001d\f\u00a7\u00b2\u00b7\u0094\u00cb\u00ecH\u0003\u00f7\u0083C\u0081\u00bee\u00ae\u00ecc\u0011W\u00f9\u001e\u00f7V\"\u0085\u00f9\u0092g+f_\u0098a\u0012\u00e3\u0080\u00bb\u00ee\u00b53\u00b1<{v\u00f9\u00a4\u00d7$_\u00b1(\u00a4\u0000\u00f07\u00b3\u009d\u0092\u001aa\u00bc\\\u0010\u00ccy\u00cb\u0005*\u00fc\u00a6&v\u00d9?\u00d6Sy\t\u0085\u00b9\u0019\u0089\u00af\u00c3\u00ac\u0012K\u00bf\u000bx}q\u0080\u009c\u00bdp=\u00b7v\u00d8*\u009c\u0011r\u001a>7\u00b7a\u00b1Wd\u00c0\u00dfD\u00181\u00a1;\u00c5\u008a\f\u00f2\u00e2\u00f4\u00c47&j6\u0014\u0016\u00c5k\u00cc\u00eeP.\u0005f=\u001e\u0017 \u0010*\u0082\u00ab\u00d0\u00be\u00eb\u0013VG\u000e\u00cf\u00ba\u0098\u00c3jx\u00b2p \u0083~C\u00c3\u009f\u001b\u00aa_\u009f\u00bc\u0017\u00f2\u00b2#\u00d6p^H\u0005\u008a\\[N\\\u0003\u00fc\u00dc\u00b0\u001fG\u00f6\u0015\u0090'\u0096\u00df\u00f0\u00a3g\u00fe\u00d6\u0085P\u007f\u00c2\u0004y{\u008f\t\u00c0\u00dc\u00ae8\u00bb1%\u001f\u00b7Wa\u00ee\u0085\u008e\u008d\u00ad\u008b\u00af)X\u0085\u0090N,E\u00d0K;\u00b0\u009e\u008e\u0094\u00ea\u00e7\u000e\u00aa4\u00c7r\u008e\u00a17\u0080>)\u009c\u00d08\u001dy\u00ee\u00d9\u00e6\u00fcF\u00cd\u0099r\tS\u00ba/\u00ad\u00e1\u00b0\u00deG\u00ae&\u00aa~wQ\u00d6\u00b7\u0081\u0014\u0094\u00b3\u00be\u00cbb{\u00ae\u00ef\u00e4b'\u00cd&\u00fe\u0090\u00e6\u00ca\n\u007f/\u00b1\u00b2g\u00ed^\u009d0h.4\u0019\u00c8\u00127|S\u00c5ct\u00f1m\u001ft\u001a\b\u0002\u00ae\u00ec\u00eap,?C\u000f\u00998\u0016\u000f\u00b3\u008e\u00feoW\u0017~\u0005\u0085T\u00d6\u00a8\u00b0OE\u00bc\u0017!\u00c6\u00db^\u001b5\u00fdN\u00007\u008f\u00d9C#_\u0004\u0097Y\u001c\u000fo\u00cc\u00a1\u00b9KcOh\u00a3\u0096\u00e5\u008d!^\u0085\u00a09%\u00931\\wIa\u00c0Y!\u00f5]\u0089$\u00d8\u00f1.\u00fc);\u00bb\u0001UJ\u00e6\u001d@\u00ec\u0013\u0017z\u0018=\u0097\u00bb\u00e2\u000f1\u00a7\u00a7\u00f8M\u00a2\u00b3xn\u0095,\u0000{jY\n\u0018\u0010\u0019\u00d5p\u00d5\u00e8T\u008f\r\u00e7\u00d5\u00c9\u00ce\u009f\u0083F\u00b4\u00d0}\u00fb\u0007\u001c\u00edHH\u0019\u00fc\u00d5A\u00f6V\u00a6[\u0086\u00f1L\u00f2\u00fe\u00f9i\u0005Yv\u00eb\u00b1(\u0081\u008b@/\u00ce\u0096\u00beu\u0094;\u00b4\u00b5\u00db\b\u001a\u009c\u00c9\u00b3K\u00aeu\u00bf\u00ef'TVz\u0083\u00dd])\u0082\u009e\u007f\u00bd\u0015tz\u00ab\u00fc\u00a8\u00e9I\u0092;a\u0099\u009en\u0093\u00dcE\u0097\u00fe\u0093K\u000bi\u009eR\u00a5\u00c7\u00ce\u00cb\u00d5\u008e7\u00a6\u00df\u00aa@_\u00f3T\u0019~\u00b8\r\u001b\u0016\u001bB\u00c8\u0098\u0007\tZ\u00c3\u0018Y\u007f\u009f\u00e3\u009e\u0018\u00ff\u00139\u00e8\u009a \u0003\u00e3h\u00b3k%\u001a\u00f8\u00ac\u00e5B|w2\u00a4\u00e4\u0001`\u00fc\u008dm\u00ef\u00e2\u008f\u00d5\u00f4\u0002\u00da\u00e7\u00dc\u00ach\u00bc\u00ab:Pj\u00bf\u0018\u00b8\u00a39\u00ec\u00c9Z\u00e41\u0092\u00d4\u00a8+\u00cbr\f\u00c1\u00bezY?u!\u00ddC\u001c+\u0016B\u0002w\u00e0\u00ae\u0000\u000b\u00fb\u00b7M\u00cc:\u000f5\u00b0f\u00f3p\u0092\u00a9\u009aI?\u00e0\u00d7\u0080\u009d \u00ed\u0012Xl~hU\u00b6\u001aUk\\5\u00d2ob[\u00caAc.\u00bc7.\u00e1\"\u00a7o\u00e2\u0014F8*Br\u00e0g:c\u0080[:m\u001e\u0095Vh\u00fa8\u00da\u0098\u00cf\u009d\u001c\u00ba\u001a\u00f7\u0002\u0016\u001c\u0012\u00bd\u00f9mR[\u00ff9ky\u0011$\u00d2\u00b2\u00b5\u0001\u009a\u00d4m\u00c4G\u0015\u00e0\u0097\"\u00c3\u009b_F\u00dcS\u00ec\u00e8\u00beb\u0007\u00b6\u009e\u00d8WtU\u00bb\u00ecR\u00d7\u00d5\u0016}Y\u00c1\u0003/\b\u00absL\u00102\b\u00bd\u00be\u00d0#\u0081\u00b8&1\u00e7,\u0003\u00b6\u00f97\u00ad\u0084\u0097b\u00cb\u0001\u0018 \u0016&\u009a\u00bd\u00d9\u008dm2\u00fb\u00ba\u0011\u00e7\u00b9\u00dbkB\u00aa\u0095\u00be\u00ac\u00b5\u008a&L\u00c2=\u00bb\u0086\u00ae)Ui\u0080+\u001f[\u00e1\u00e0\u00deH\u00eb\u008b\u00e3\u000bn\u00c4G\u001b'g+\u001c\u00ed\u00b7\u008c\u0013'\u008a\u008a&\r\u00853:|\u00e99\u00a3\u00c7+\u00a6\u001b|@\u009e\u00dc\u00eb%\u00a5\u00ed\u00fe<\u0005.\u00d4\u00e5m\"L\u009a*\u0085D\u00cf[\u009eE\u000b\u00f9FX\u00fd1\u00cd\u00b2\u00a5F\u00cc\u00a5\u00df5\u00f7\u001fC\u00f9D'\u0012\u0005\u00f0^t\u00fd\u00c9=#u3Q<\u00c9O\u00e7\u00f6NY\u0087\u00f6\u00e1\u00c6\u00fdu>@\u008f\u008b\u00del\u00b3\u000e\u00e4\u00be\u00eeC\u00c1x@bN\u00cd\u00c5\u0000\u0005\u001a\u008c[\u000b\u008a\u00d3\u00af\u0010\u00c3E\u00fa\u00ab\u009fJN\u0003k\u00f5\u0091b\u00b3i+i@\u00aa%\u00d8\u00ff9\u00a7^~\u00f1\u00bb\u00b4RY\u0088\u00ec\u00ef_\u0013\u00ec8\u00d0\u00f6\u0082\u00afu6\u001d\u00d7\u00b3\u00fe\u00df\u008c\u00c6\u00ed\u00e0\u00ad\u0010Rv\u001e\u00d27c\u00f96/\u00c2L\u000e\u00b4L\u00e8K\u0085\u0018\u0097\u00d0F\u0005z<\t6w^\u00ae\u00a8\u008e\u00a0U\"(\u00c8w\u0090\u00eb\u00aa9\u00f2\u00a0\u000e\u00e7\u00e8Z\u00b0n;x2@\u00e6&D*O\u0098\u0093\u001d\u0080Y\u00a1\u00f5#\u00cb\u00eb\"`o|j\u00c86K\u00ec:\u00cd\u00b4\u00970\u00b2(*\u00c0O\u001c\u008b\u00ebwJf6~\u0007\u00a2\u0016\u00e1\u0090\u00a8Li\u000eF|\u00f9\b\u0080\u009b@9\u00cd\u00e7\u009c\u00d5\u00b1\u008e\u001b\u00d1o\u0089\u00bc\u00f3\u0001\u008e\u00a8\u00f8#\t\u0013\u0013\u00c9\u00de\u00a2\u00f9\fB\r\u00a3\"\u0001M\u00f6.)H\u0092\u0007\u00b1\u00c1\u00ef\u00c1}t\u0085\u0088\u00bf/\u00f5n\\\u0099\u00bb\u00b1\u00e9L/(b\u00138W:Qobnr\u00c9\u0003\u008e\u0005W\u00a6\u00b2\u00ad\u00dc\u008f\u00dcl\u00f6\u00b7\u00ae4\u00bb\u00e7\"i\u00bc\u00e7\u00c2\u0018\u0019\u00fc\u00dc\u00fa|>\u00a2\u0083\u0088\u0094YS\u00d2\u00eb\u001aa\u0017\u00b97Er\u00b4^\u00ee\u00a6\u009bU\u007f\u0013Rxf\u0017V\u0003x\u009ee\u00e5\u00eb\u0015\u0090\u0086g_\u0005\u009e\u0095\u0011^\u0086U\u00b6\u0088\u00bcK\u00c4<'1\u00c0\u00d9nD\u007f\u00f3?Z\u00f9\u008b\u001c\"BwV\b$\u009c\u0002m\u0013[\u0083~J\u00ed\u00e5\u0084\bijc\u00e7}Br\u00fdGu\u0000\u0085\u00cc\u001ah\u00d1{LFgr~\u00b8\u00bf\u00f4\u0002\u0005\u00be\u00b7\u009f\u00ecUx\u0093\u00f9\u00df.c-'TL\u0081Y\u00b2]\u0015\u0003 k\u00b8\u00f5\u008e\u00e1 I\u0015\u009eiS3\u00f7^\u000b\u00ba\u00a7\u00d9Fa\u00bf\u00d1f\u0093\u00ceO\u00d6\u00c3\u00d47\u00bc\u00e4\u00ce\u0095f\u000eX\u0007da5\u0097\u00a0\u001a\u0098\u0095\u0087\u00cb\u00f0\u00864\u00d5\u00d2\u00ce\u00d9\u0010\u00c8\r\u00ba<\u00857S\u0014D\u0002f\u00c0\u0007\u00e9$\u0016\u00a1\u00ec\u0097\u00aai\"\u00afg\u008a<\u00ab\u00f9{\u00bb\u0000\u00cf7\\\u00d3Y\u00e8I?\u00cd\u00c8 a\u0080\u0099\u00b4\u00a8Hqn\u00cd\u00ec`d\u008c\u00c0\u00bb\u001ex\u00fd\r4C\u00d2X\u00d8\u0095a\u00a0\u008d\u0093\u00a7\u0006\u00c1\u00fd\u0083\u00978q9*j\u00f2(\u00d8\u0003C\u0019\u00e2\u0019\u001b\u00be\u000e\u00ed\u00b1\u007fX\u008e^D3B3\u00ac'j\u001b(\u0084d\u00bd\u00c8k\u00fd%~]N\u00eb\u00d5\u0004$\u00b3q\u00b98q \u00dbW\f\f\u000f\u0000\u0019\"\u00f9\u0083]+3\u00f0+6LG\u00f0\u00a6\u00b4\u008b(1\u00fcm\u00d5hz(f'\u00f6n_\u00d5Yf\n\u00f3\u00e5sH\u00f5\u00d1\u00a8\u00934S- \u00ba\u00e1\u00cb%wG\u009eo\u0094\u0096\u00c0\u00f8KO\u009a\u00d0\u00f9\u00b0\u008d\u008cU\u00ca\u00f0#\u00b2C\u001c\u00bb\u0000\u00ac\u00f9\u009a\u00d7\u00df8t\u00ee\u00fb\u00e8\u00bd\u00f1#\u000f\u00db\u008a\u00f2`\u00ea\u0099sb\u00ac\u00c3|\r\u00b6\u007f\u00af\u00d8z\u00f2:k\u0085\u0081\u0014\u00ae\u00e4\u00f7\u00f6\u00b2\u008a\u00ca\u001eB0\u00b1\u0011\u00d2\u00f8\u00e9N\u00ff_\u000fc\u00c8Z\u000f,\u00f7\b\u00df$V1\u00ff\u00a20\u0007\"\u0006\u00eb\\\u008b\u0017\u001e4\u00e5\u00e8\u00e2J\r\u00f2\u0013~\u0099\u001eU\u00f4U\u00f8\u0018\u00bfC\u00eb\u00b6\u0090\u001d\u00e9t\u0006x/7\u0016j\\\u00d1a\u00f5\u00e3U\u00b0Dl^j\u00bb\u00ca0\"Tn\u00d9\u009d\u00c8\u008a\u00b3\u00fb\u00c4\u00e5|\u00e7\u00d5\u0086\u0016\u00f7\u0088-\u0092~\u00ab\u00c0\u009d\u0094q\u001d\u00c7\u00d6\u00cd\u0018U\u00d8\u0007\u00c9\u00b7\u00c6\u00ac;]\u00b9\u00b4\u0085\u0010\u00ec\u00ad\u0092\u008c\u0012h\u0018G\u00a1}\u00dee\u008e\\\u008d\u00fe\u00a2J\u00bc\u009c\u001d%=D\u00f8\u00d6ar\u000f_#\u00d4\u0006\u00e9\u00d2\u00b5\u00d0\u00c4\u00d7Ju\u00be 9\u00e4}\u0095\u001d\u00eb\u00f5\u00b8\u00f0$\u0007w\u00ec\u00c4\u00f9+\u001fw\u00c4\u0005\u00cb\u0084\u009f?o\u0011qJ\u00f2\u009f|\u00117\u0015C\u0097\u00ac}>`\u008bM<V9#\u00b6\u00f4>}9{\\5\u009d(2\u00fddwV\u00cf3\u0018zG\u00b5\u00c1\u00f1Od\u0091_}\u00e5\u00bf\u000e\n\u00c8\u00aeH&\u00a2Z\u0001\u00aa\u00b6\u00f0y\u00cdB\u00de%\u0091='\u00c1q\u0001\u00e0\u00da\u00d3\u0006\u00bd>s:\u009a}\u00d9|\"1\u0083V\u00f7\u008d\u0085\u00e3\u009a/\u0003\u0016Nd\u0089\u00a2M\u0091\u00a36\u0016\u00ae\u00c4\u00e2\u0010#\u00b0\u00a5{B\u00da\u001a\u00cf\u001d\u0085\u000e\u00ae\u000e\u00b4U\u00ef\u00aa\u0002*6\u00c8\u00bc*\u009b\u00b2E\u00bc>\u00f6S\u00a7j\u000b2\u0017\u00cb\u0098J\u001f\u00ben\u00a0\u00f4j%G_W\u008c\u001e\n\u0001M\u0097\u00d1r\u0091\u009e,\u00c9?\u00db\u00b4Z\u00ea\u00ffQ\u0092N~\u00d9\t\u00b1\u009c\u000b\u00c3\u0086p\u001fh\u00b0zJ\u00a0\u00b3\u00c3\u00b6Gk\u00a2\u00cf\u00c1\u0005\u00e4!Ha\u0097\u00da,\u0017\u00fb\u009a\u00ee\u000fR\u00bd=9\u0097k\u0093\u00f7\u00ee2\u00aa\u009e\u00c3]\b\u00f5\u00c7\u00cd\u009f\u001e\u00b0V0\u0018K\u00bd\b*\u008be\u0003t|\u00e4\u00ceLp;\u00fe.C\u00fd:-\u0005\u001d4\u0002\u00ab\u00d2\\\u00e1\u00dbk'\u00c2\u00f6k \u00dfY\u00bb:\u000e\u00c1\u009eWRS\u00f1l\u00d6\u0001\f\u00b4\u00f8\u0096\u00e0-\u00d0p8V~@\u00f5[>\u009aD-\u00a0=\u00c8\u00ce\u00f7\u00eez\u00ae\u0004z\n\u0080\u0089\u00fb\u0010\u0084\u00a2\u00f6e#\u001a\u00c7-\u00ce\u00f5\u00f5\u00f5\u00a1v\u00b9\u00f4\u00a6\\\t}&\u00caM\u00ab\u0000d\u009b\u00fep\u00fc\u0082\u00ef\u00d7\u00ba\u0081\u0005\u001a\u00f3\u001f\u009dZ\u0011V\u00d3'\u00ceG\u00baB\u00cf\u00e1G\u00b0\u001aO\u00d5R\u00f4\u008d\u00ce\u0092f\u00bd\u00b34T\u00af\u00af\u0006\u00ddXgb\u0019\u007f\u00dd]\u00f0\u00fd\u00db\u00e0^5\u00ff\u0092\u00e8$$\u00067\u001e\u0010T\u00edc\u00e50*\u00d3\u0082I\u00cb0H,.\n\u00c4\u00b2\u00a4 \u009e\u0016}Pn\u0017\u00d4\u00ef\u00c1\u0011\u00ef\u00fe\u00d8,(\u0001\u00b0\u0092\u0083\u00aa\u00ba\u0000\u00b6J\u0093\u009d\u00df\u0005\u000f\u00bcs*\u00cb5\u00fe\u00e1\u00a4n\u00be\u009e\u0087 \u00de\u00a2\u009bz\u000f\u008a\u00ebU\u001f\u00c2\u00e5o4\u00924\u0093\u00eb\u0084\u00c8\u00c2\u008d\u0006\u00cd\u00b4m\u0018\u00dd]}\u00d8\u00c8\u00bcZ\u0002l\u0080\u00b2\u00b0\u0016\n\u001c\u00baUe\u0090?\u0084\u0095\u00c1r\u00dd\u00f2W\u00f9\"A&\u00a37\u00fe\f;\u00dfq\u0019\u0000\u00bb\u00ee\u00bc\u0016x\n\u00e5\u00f1z\u00be\u00c9MG\u00e0]*\u00a9\u0019D\u00b1|\u009a\u0082xF\u00f6\u00d2d\u00b8\u00c9 \u0091w,\u00fb\u00b00Y\u001e\u00af\u009b\u00d7\u00ed\u00c2 \u0003\u00e6\u00e4\u00ed\u0094\u0000'\u0002\u0006\u00d4\u00f9\u0089\u008b\u00a6u}\u00fd\u0092\u00c3mcW\u00ea\u00ad\u0018\u0097?\u00d0\u00bfc}V\u00fbDb\u00d9\u0017\u00b7\u0093e\u00f8\u00de\u00c7\u001a\u00c9\u00cd\u008fZ\u0013\u0016%qO}\u00cdI\u0016\u00b54*\u00ee\u0093\r\u0007\u00c1\u00cc\u008cGP\b\u008aD\u000e\u00bc\u00c2\u00f8\u00d0\u00a1\u0092\u00ce\u00c6>\u00923#Z\u00fc\u0015R\u00b6?Y\u000e^\u00f4\tr\u0085\u00d0\u00d68\u00b0]E\u00fe\u0017i\u00c6\u00d2\u001b\u00199\u00e9p\u00d9kk\u0010\u00ed\u00169\u0084\u00e9\u0013\u00c1h\u00fd:u0\u0012)\u00c6t\u00cds\u00f7\u001a\u00e3\u00ecE\u00f79P\u00dc\u00c0\u00d3%\u0006\u009b\u00db\u0089\u00fdv* \u0099\u00851\u00f6\u00b3\u0088\u00eaW%\u00dd\u008f\u00cbv>\u00b5\u0095\u009c\u00e1\u00c3\u00cfAS\u0082\u00d8\u00ca\u00ff\u0002\u00a5:\u0018`I\u00df\u00aa \u00ac\u000b}\u00edm2D3\u00bd\u00a4[\u0011\u0014N1\u0098\u00e4\u0085l8\u00a41\u0082AF\u00a5\u00e9\u0091\u00900\u00b9~CL\u00a1z;\u00ec\u00faO\u00ef\n\u000foa\u0003\u00ac\u00abd\u00b1\u00a7\u0013\u00da\u00c1l\u00a3\u00fa\u00f6|\u00a1_\u00ce\u0095\u00d6$\u00c7\"\u00ee`\u00bc\u0005\u00a1(\u0000$\u00f8 \u0014\u000b\u00b1$\u0014\u00dc\u00fb\u0011Kf \u00ca\\\u0019\u0090\u0007\u00e8y\u00c8\u0010B@\u00bd\u00d5\u0094\u0001\u0001\u00d6n\u0000\u009d\u00a8\u0006\u0006\u00e4Y\u00f8?\u00b9\u0016.>\u00b1D\u00ff{\u00f0\u00cc\u0083K\u00c0\u008a\u00ea\u007f\u00dd\u0001;\u00eb\u0096\u00b9\u00f9\u0012N\u0097\u00d6\u00cb\u00c5#\u00a8`\u00bc\\\u00ab\u00d0*\u00c8\u00dc0\u0087\u0090\u001d\u0092\u0011\u00cedh\u00da\u0091\u001d\u0080?V_\u0091_\u008a\r\u00ce5Wv\u00c4\u00f9\u00c7\u00dc\u0087\u00c4\u00afi\u00ac\u0001\u00ea2\u008cw\u0099S\u0082nc\u008e\u00ae\u00ec\u00ab\u00ac\u00ebk\u009e\u00d0\"\u00cc\u0011\u00e0b\u00aa\u00c0n\u00c39\u00b0\u00b2]\u00a7\u00cb\u0086\u00ed\u00cc\u00ad\u00e1\u00d8z\u009aC\u00ea\u00d5G\u0096\u00f0H\u00ff\u00bb\u0001\u001d\u0016\u00e4@\u0086\u00da\u0087\u00a4\u00aaw\u009d0\u00ac\u00b4\u0013\u00ca\u00cdV\u0080\u008a\u00e9\u000bw\u00c3{\u0092\u00a5\u0007D\u00bc\u00fd\u0084*k\u00aa\u00b0\u00b8V \u0013\u00f5\u00b4\u0090\u00e3\u00f7\u00e6El \u00b8\u009c\u00f9J\u00f4\u00e3IQS\u00b6r\u00ca\u0098k)\u00e8\u00a5\u00bb\"\u00a5\u00d9Y\u00b4\u00d3\" \u00c6vQ\u00cb\u0092=\u00f5 \u00ee\u00f7\u00f4X3.Kp<A'\u0006|.H\u0018s\r\u009c[\"\u00b5S\u00c3\u00e5\t_\u00c3\u008e\u00f1#\u0097ui\u00dc\u00185EE\u0089q\u00c8\u00a8X\u00ba\u00a7h\u0019|\u001eU\u00e1\u0089\u0018\u00cc\u0005\u00f7\u008f\u00a0\u00a7\u001a\u0011y\u00f5|\u00d1i\u00d4\u00bf\u001d\u00e1\u00d7\t\u008e\u0081\u0090S\u00b8f8\u00fd\u00a8\u000e\u00a5\u00d5\u0000\u009a\u001b\u00ba\u0015\u00bf\u001d\t,\u001e7\u00d8\u00d7\u0013G\u00d3\u00ecI\u00de\u00eb\u00b5B\u00a5\u00b11\u0004\u00b1\u00ba\u008d\u009b\u001a\u00ae\u0002\u00f7\u0018\u0087\u0089\u00cdu\u0091\u00ab\rm\u00db\u0086\u00cd&^\u00fev\n\u00e4\u00a1\u001fd\u0006Dh\u0081\n@\u00c6O\u00a3\u00bb^$\u009bwJD\u00e3:\u00e6\u00a3\u0087.\u008aivg\u001dox\u0014\u0000j\u008c\u008f\u001e\u0018\u00b66\u0014*Y\u00e8\u00f9J\u00c0\u0013\u00fb\u00aa\u00a1J\u0086\u00ce\u009e\u0004\u00c2\u0098\u0099\u00be\u00b29\u001e\u00a4\u00ec\u0089\u00f5\u00b2?\u0013\u00c2\u00ad\u009ar\u00ad\u008c[\u00961\u009f\u00c3m\u0086Nm8{R\u0003\u0004\u007f\u00d8\u0018\u00a9\u00c4\u00ce\r\u00fbWPsc\u00fc\u00e9\u00fc\u009e\u00cc\u00eb\ro\u0015\u00c9\u00d2\u00be\u001d\u00ac\u00f1\u00bfm\u00a7^\u00dam\u001b\u0083\u001f\u00b5\u00e9\u00b2_>\u00ed\u00f05a\u0014\u00ed\u00efKH;\u009d9\u00cfS-\u00e4\u00d5\u00c2|+\u00e8\u00c2^\u00cd\u00edk\u00f0\u00d3\u007f\u00e7e\u00dc\u00deC\u00f7>\u00bf\u0088\u00d5\u001fU<T\u009c\u00d6`l\u00cfrs<\u00effO \u0083w(\u00ab\u00cc\u00ef>\u00da\u00c1\u00b5\u00dez\u00b1j\u00cb\u00a0{O\u00ba\u00b8[\u00a0\u000e\u009e\u00d4H\u0083\u0019y\u00cc\u00a1#xwg \u00d4\u00a6\u00b8\u008cj\u001d\u00a6 \u00a1d\u00eeS\u00ac7g\u00c6\u00d8\u0086\u001b\u00ce\u0019\u0085\u008c\u00bf\u00a8\u00b7\u00ec\u00b4\u00dc43\u0018$\u00f9*\u00dcdBu\u00d0\u00e9!Hw_\n}\u009e@*_N\u0094\u008e\u00ba\u0099\u00c3\u0000\u0092\u00e6\u00d4K|\u00dc\u00d8wh\u00fd\u00ef\u0018\u00bc'\u00f8l\u00a1\u0005\u00ce4>\u00cc?\u00f9I\u0097D1\u0005\u001f\u008a\u00ce\u0096'\u00db\u00f2\u0018\u0014ha,\u00f5|8\u00ce\u00a8u*C4U\\\u0088\u00a85\u00e8\u00a0s;01\u000e\u007f\u00ea\u008a\u00d4\u00a33e\u00fd\u00de\u001b#\u0019\u00b1\u00c7\u001e\u00a1\u00dbW\u00e5\u00c4\u00f1\u00c7\u0096je\t\u00ad\u0087\u0018\u00d5.\u000f\u0090\u00ae\u00a5\u00f7\u00c6\u008c\u00f5{\u0000\u00f9\u00f2K\u00b9\u001d\u00b4R\u00f3\u00c9\u0090\u00db\u0090\u00e8\u00f0\u00acM}\u00de\u00fdo\u0085\u00df`\u00b3\u00b0\u00da=\u0001\u00f5\u00ab\u00e2\u00d3\u0019E";
                var4_3 = "\f\u00ceV\u008a\u00a5\u00b7Zd\u00cc\u009a\u00edf\u00c9\u007fw\u00e7\u00b3\u00afdN\u008aEh\u00b7W\u00e6\u00eeu\u008d\u0092\u00ea\r\u008f8\u00d8\u001b\u008d\u008e1c\u00ba*\u00e6\u0013@$\u00ba\u0018\u0011\u00bby\u00c3\u0097\u009emG#8J0\u0016\u00e5\u00bd\u00e3\u00e8\u008dD\u009d\u00f7\u00a1/\u0005\u00ed\u001d\f\u00a7\u00b2\u00b7\u0094\u00cb\u00ecH\u0003\u00f7\u0083C\u0081\u00bee\u00ae\u00ecc\u0011W\u00f9\u001e\u00f7V\"\u0085\u00f9\u0092g+f_\u0098a\u0012\u00e3\u0080\u00bb\u00ee\u00b53\u00b1<{v\u00f9\u00a4\u00d7$_\u00b1(\u00a4\u0000\u00f07\u00b3\u009d\u0092\u001aa\u00bc\\\u0010\u00ccy\u00cb\u0005*\u00fc\u00a6&v\u00d9?\u00d6Sy\t\u0085\u00b9\u0019\u0089\u00af\u00c3\u00ac\u0012K\u00bf\u000bx}q\u0080\u009c\u00bdp=\u00b7v\u00d8*\u009c\u0011r\u001a>7\u00b7a\u00b1Wd\u00c0\u00dfD\u00181\u00a1;\u00c5\u008a\f\u00f2\u00e2\u00f4\u00c47&j6\u0014\u0016\u00c5k\u00cc\u00eeP.\u0005f=\u001e\u0017 \u0010*\u0082\u00ab\u00d0\u00be\u00eb\u0013VG\u000e\u00cf\u00ba\u0098\u00c3jx\u00b2p \u0083~C\u00c3\u009f\u001b\u00aa_\u009f\u00bc\u0017\u00f2\u00b2#\u00d6p^H\u0005\u008a\\[N\\\u0003\u00fc\u00dc\u00b0\u001fG\u00f6\u0015\u0090'\u0096\u00df\u00f0\u00a3g\u00fe\u00d6\u0085P\u007f\u00c2\u0004y{\u008f\t\u00c0\u00dc\u00ae8\u00bb1%\u001f\u00b7Wa\u00ee\u0085\u008e\u008d\u00ad\u008b\u00af)X\u0085\u0090N,E\u00d0K;\u00b0\u009e\u008e\u0094\u00ea\u00e7\u000e\u00aa4\u00c7r\u008e\u00a17\u0080>)\u009c\u00d08\u001dy\u00ee\u00d9\u00e6\u00fcF\u00cd\u0099r\tS\u00ba/\u00ad\u00e1\u00b0\u00deG\u00ae&\u00aa~wQ\u00d6\u00b7\u0081\u0014\u0094\u00b3\u00be\u00cbb{\u00ae\u00ef\u00e4b'\u00cd&\u00fe\u0090\u00e6\u00ca\n\u007f/\u00b1\u00b2g\u00ed^\u009d0h.4\u0019\u00c8\u00127|S\u00c5ct\u00f1m\u001ft\u001a\b\u0002\u00ae\u00ec\u00eap,?C\u000f\u00998\u0016\u000f\u00b3\u008e\u00feoW\u0017~\u0005\u0085T\u00d6\u00a8\u00b0OE\u00bc\u0017!\u00c6\u00db^\u001b5\u00fdN\u00007\u008f\u00d9C#_\u0004\u0097Y\u001c\u000fo\u00cc\u00a1\u00b9KcOh\u00a3\u0096\u00e5\u008d!^\u0085\u00a09%\u00931\\wIa\u00c0Y!\u00f5]\u0089$\u00d8\u00f1.\u00fc);\u00bb\u0001UJ\u00e6\u001d@\u00ec\u0013\u0017z\u0018=\u0097\u00bb\u00e2\u000f1\u00a7\u00a7\u00f8M\u00a2\u00b3xn\u0095,\u0000{jY\n\u0018\u0010\u0019\u00d5p\u00d5\u00e8T\u008f\r\u00e7\u00d5\u00c9\u00ce\u009f\u0083F\u00b4\u00d0}\u00fb\u0007\u001c\u00edHH\u0019\u00fc\u00d5A\u00f6V\u00a6[\u0086\u00f1L\u00f2\u00fe\u00f9i\u0005Yv\u00eb\u00b1(\u0081\u008b@/\u00ce\u0096\u00beu\u0094;\u00b4\u00b5\u00db\b\u001a\u009c\u00c9\u00b3K\u00aeu\u00bf\u00ef'TVz\u0083\u00dd])\u0082\u009e\u007f\u00bd\u0015tz\u00ab\u00fc\u00a8\u00e9I\u0092;a\u0099\u009en\u0093\u00dcE\u0097\u00fe\u0093K\u000bi\u009eR\u00a5\u00c7\u00ce\u00cb\u00d5\u008e7\u00a6\u00df\u00aa@_\u00f3T\u0019~\u00b8\r\u001b\u0016\u001bB\u00c8\u0098\u0007\tZ\u00c3\u0018Y\u007f\u009f\u00e3\u009e\u0018\u00ff\u00139\u00e8\u009a \u0003\u00e3h\u00b3k%\u001a\u00f8\u00ac\u00e5B|w2\u00a4\u00e4\u0001`\u00fc\u008dm\u00ef\u00e2\u008f\u00d5\u00f4\u0002\u00da\u00e7\u00dc\u00ach\u00bc\u00ab:Pj\u00bf\u0018\u00b8\u00a39\u00ec\u00c9Z\u00e41\u0092\u00d4\u00a8+\u00cbr\f\u00c1\u00bezY?u!\u00ddC\u001c+\u0016B\u0002w\u00e0\u00ae\u0000\u000b\u00fb\u00b7M\u00cc:\u000f5\u00b0f\u00f3p\u0092\u00a9\u009aI?\u00e0\u00d7\u0080\u009d \u00ed\u0012Xl~hU\u00b6\u001aUk\\5\u00d2ob[\u00caAc.\u00bc7.\u00e1\"\u00a7o\u00e2\u0014F8*Br\u00e0g:c\u0080[:m\u001e\u0095Vh\u00fa8\u00da\u0098\u00cf\u009d\u001c\u00ba\u001a\u00f7\u0002\u0016\u001c\u0012\u00bd\u00f9mR[\u00ff9ky\u0011$\u00d2\u00b2\u00b5\u0001\u009a\u00d4m\u00c4G\u0015\u00e0\u0097\"\u00c3\u009b_F\u00dcS\u00ec\u00e8\u00beb\u0007\u00b6\u009e\u00d8WtU\u00bb\u00ecR\u00d7\u00d5\u0016}Y\u00c1\u0003/\b\u00absL\u00102\b\u00bd\u00be\u00d0#\u0081\u00b8&1\u00e7,\u0003\u00b6\u00f97\u00ad\u0084\u0097b\u00cb\u0001\u0018 \u0016&\u009a\u00bd\u00d9\u008dm2\u00fb\u00ba\u0011\u00e7\u00b9\u00dbkB\u00aa\u0095\u00be\u00ac\u00b5\u008a&L\u00c2=\u00bb\u0086\u00ae)Ui\u0080+\u001f[\u00e1\u00e0\u00deH\u00eb\u008b\u00e3\u000bn\u00c4G\u001b'g+\u001c\u00ed\u00b7\u008c\u0013'\u008a\u008a&\r\u00853:|\u00e99\u00a3\u00c7+\u00a6\u001b|@\u009e\u00dc\u00eb%\u00a5\u00ed\u00fe<\u0005.\u00d4\u00e5m\"L\u009a*\u0085D\u00cf[\u009eE\u000b\u00f9FX\u00fd1\u00cd\u00b2\u00a5F\u00cc\u00a5\u00df5\u00f7\u001fC\u00f9D'\u0012\u0005\u00f0^t\u00fd\u00c9=#u3Q<\u00c9O\u00e7\u00f6NY\u0087\u00f6\u00e1\u00c6\u00fdu>@\u008f\u008b\u00del\u00b3\u000e\u00e4\u00be\u00eeC\u00c1x@bN\u00cd\u00c5\u0000\u0005\u001a\u008c[\u000b\u008a\u00d3\u00af\u0010\u00c3E\u00fa\u00ab\u009fJN\u0003k\u00f5\u0091b\u00b3i+i@\u00aa%\u00d8\u00ff9\u00a7^~\u00f1\u00bb\u00b4RY\u0088\u00ec\u00ef_\u0013\u00ec8\u00d0\u00f6\u0082\u00afu6\u001d\u00d7\u00b3\u00fe\u00df\u008c\u00c6\u00ed\u00e0\u00ad\u0010Rv\u001e\u00d27c\u00f96/\u00c2L\u000e\u00b4L\u00e8K\u0085\u0018\u0097\u00d0F\u0005z<\t6w^\u00ae\u00a8\u008e\u00a0U\"(\u00c8w\u0090\u00eb\u00aa9\u00f2\u00a0\u000e\u00e7\u00e8Z\u00b0n;x2@\u00e6&D*O\u0098\u0093\u001d\u0080Y\u00a1\u00f5#\u00cb\u00eb\"`o|j\u00c86K\u00ec:\u00cd\u00b4\u00970\u00b2(*\u00c0O\u001c\u008b\u00ebwJf6~\u0007\u00a2\u0016\u00e1\u0090\u00a8Li\u000eF|\u00f9\b\u0080\u009b@9\u00cd\u00e7\u009c\u00d5\u00b1\u008e\u001b\u00d1o\u0089\u00bc\u00f3\u0001\u008e\u00a8\u00f8#\t\u0013\u0013\u00c9\u00de\u00a2\u00f9\fB\r\u00a3\"\u0001M\u00f6.)H\u0092\u0007\u00b1\u00c1\u00ef\u00c1}t\u0085\u0088\u00bf/\u00f5n\\\u0099\u00bb\u00b1\u00e9L/(b\u00138W:Qobnr\u00c9\u0003\u008e\u0005W\u00a6\u00b2\u00ad\u00dc\u008f\u00dcl\u00f6\u00b7\u00ae4\u00bb\u00e7\"i\u00bc\u00e7\u00c2\u0018\u0019\u00fc\u00dc\u00fa|>\u00a2\u0083\u0088\u0094YS\u00d2\u00eb\u001aa\u0017\u00b97Er\u00b4^\u00ee\u00a6\u009bU\u007f\u0013Rxf\u0017V\u0003x\u009ee\u00e5\u00eb\u0015\u0090\u0086g_\u0005\u009e\u0095\u0011^\u0086U\u00b6\u0088\u00bcK\u00c4<'1\u00c0\u00d9nD\u007f\u00f3?Z\u00f9\u008b\u001c\"BwV\b$\u009c\u0002m\u0013[\u0083~J\u00ed\u00e5\u0084\bijc\u00e7}Br\u00fdGu\u0000\u0085\u00cc\u001ah\u00d1{LFgr~\u00b8\u00bf\u00f4\u0002\u0005\u00be\u00b7\u009f\u00ecUx\u0093\u00f9\u00df.c-'TL\u0081Y\u00b2]\u0015\u0003 k\u00b8\u00f5\u008e\u00e1 I\u0015\u009eiS3\u00f7^\u000b\u00ba\u00a7\u00d9Fa\u00bf\u00d1f\u0093\u00ceO\u00d6\u00c3\u00d47\u00bc\u00e4\u00ce\u0095f\u000eX\u0007da5\u0097\u00a0\u001a\u0098\u0095\u0087\u00cb\u00f0\u00864\u00d5\u00d2\u00ce\u00d9\u0010\u00c8\r\u00ba<\u00857S\u0014D\u0002f\u00c0\u0007\u00e9$\u0016\u00a1\u00ec\u0097\u00aai\"\u00afg\u008a<\u00ab\u00f9{\u00bb\u0000\u00cf7\\\u00d3Y\u00e8I?\u00cd\u00c8 a\u0080\u0099\u00b4\u00a8Hqn\u00cd\u00ec`d\u008c\u00c0\u00bb\u001ex\u00fd\r4C\u00d2X\u00d8\u0095a\u00a0\u008d\u0093\u00a7\u0006\u00c1\u00fd\u0083\u00978q9*j\u00f2(\u00d8\u0003C\u0019\u00e2\u0019\u001b\u00be\u000e\u00ed\u00b1\u007fX\u008e^D3B3\u00ac'j\u001b(\u0084d\u00bd\u00c8k\u00fd%~]N\u00eb\u00d5\u0004$\u00b3q\u00b98q \u00dbW\f\f\u000f\u0000\u0019\"\u00f9\u0083]+3\u00f0+6LG\u00f0\u00a6\u00b4\u008b(1\u00fcm\u00d5hz(f'\u00f6n_\u00d5Yf\n\u00f3\u00e5sH\u00f5\u00d1\u00a8\u00934S- \u00ba\u00e1\u00cb%wG\u009eo\u0094\u0096\u00c0\u00f8KO\u009a\u00d0\u00f9\u00b0\u008d\u008cU\u00ca\u00f0#\u00b2C\u001c\u00bb\u0000\u00ac\u00f9\u009a\u00d7\u00df8t\u00ee\u00fb\u00e8\u00bd\u00f1#\u000f\u00db\u008a\u00f2`\u00ea\u0099sb\u00ac\u00c3|\r\u00b6\u007f\u00af\u00d8z\u00f2:k\u0085\u0081\u0014\u00ae\u00e4\u00f7\u00f6\u00b2\u008a\u00ca\u001eB0\u00b1\u0011\u00d2\u00f8\u00e9N\u00ff_\u000fc\u00c8Z\u000f,\u00f7\b\u00df$V1\u00ff\u00a20\u0007\"\u0006\u00eb\\\u008b\u0017\u001e4\u00e5\u00e8\u00e2J\r\u00f2\u0013~\u0099\u001eU\u00f4U\u00f8\u0018\u00bfC\u00eb\u00b6\u0090\u001d\u00e9t\u0006x/7\u0016j\\\u00d1a\u00f5\u00e3U\u00b0Dl^j\u00bb\u00ca0\"Tn\u00d9\u009d\u00c8\u008a\u00b3\u00fb\u00c4\u00e5|\u00e7\u00d5\u0086\u0016\u00f7\u0088-\u0092~\u00ab\u00c0\u009d\u0094q\u001d\u00c7\u00d6\u00cd\u0018U\u00d8\u0007\u00c9\u00b7\u00c6\u00ac;]\u00b9\u00b4\u0085\u0010\u00ec\u00ad\u0092\u008c\u0012h\u0018G\u00a1}\u00dee\u008e\\\u008d\u00fe\u00a2J\u00bc\u009c\u001d%=D\u00f8\u00d6ar\u000f_#\u00d4\u0006\u00e9\u00d2\u00b5\u00d0\u00c4\u00d7Ju\u00be 9\u00e4}\u0095\u001d\u00eb\u00f5\u00b8\u00f0$\u0007w\u00ec\u00c4\u00f9+\u001fw\u00c4\u0005\u00cb\u0084\u009f?o\u0011qJ\u00f2\u009f|\u00117\u0015C\u0097\u00ac}>`\u008bM<V9#\u00b6\u00f4>}9{\\5\u009d(2\u00fddwV\u00cf3\u0018zG\u00b5\u00c1\u00f1Od\u0091_}\u00e5\u00bf\u000e\n\u00c8\u00aeH&\u00a2Z\u0001\u00aa\u00b6\u00f0y\u00cdB\u00de%\u0091='\u00c1q\u0001\u00e0\u00da\u00d3\u0006\u00bd>s:\u009a}\u00d9|\"1\u0083V\u00f7\u008d\u0085\u00e3\u009a/\u0003\u0016Nd\u0089\u00a2M\u0091\u00a36\u0016\u00ae\u00c4\u00e2\u0010#\u00b0\u00a5{B\u00da\u001a\u00cf\u001d\u0085\u000e\u00ae\u000e\u00b4U\u00ef\u00aa\u0002*6\u00c8\u00bc*\u009b\u00b2E\u00bc>\u00f6S\u00a7j\u000b2\u0017\u00cb\u0098J\u001f\u00ben\u00a0\u00f4j%G_W\u008c\u001e\n\u0001M\u0097\u00d1r\u0091\u009e,\u00c9?\u00db\u00b4Z\u00ea\u00ffQ\u0092N~\u00d9\t\u00b1\u009c\u000b\u00c3\u0086p\u001fh\u00b0zJ\u00a0\u00b3\u00c3\u00b6Gk\u00a2\u00cf\u00c1\u0005\u00e4!Ha\u0097\u00da,\u0017\u00fb\u009a\u00ee\u000fR\u00bd=9\u0097k\u0093\u00f7\u00ee2\u00aa\u009e\u00c3]\b\u00f5\u00c7\u00cd\u009f\u001e\u00b0V0\u0018K\u00bd\b*\u008be\u0003t|\u00e4\u00ceLp;\u00fe.C\u00fd:-\u0005\u001d4\u0002\u00ab\u00d2\\\u00e1\u00dbk'\u00c2\u00f6k \u00dfY\u00bb:\u000e\u00c1\u009eWRS\u00f1l\u00d6\u0001\f\u00b4\u00f8\u0096\u00e0-\u00d0p8V~@\u00f5[>\u009aD-\u00a0=\u00c8\u00ce\u00f7\u00eez\u00ae\u0004z\n\u0080\u0089\u00fb\u0010\u0084\u00a2\u00f6e#\u001a\u00c7-\u00ce\u00f5\u00f5\u00f5\u00a1v\u00b9\u00f4\u00a6\\\t}&\u00caM\u00ab\u0000d\u009b\u00fep\u00fc\u0082\u00ef\u00d7\u00ba\u0081\u0005\u001a\u00f3\u001f\u009dZ\u0011V\u00d3'\u00ceG\u00baB\u00cf\u00e1G\u00b0\u001aO\u00d5R\u00f4\u008d\u00ce\u0092f\u00bd\u00b34T\u00af\u00af\u0006\u00ddXgb\u0019\u007f\u00dd]\u00f0\u00fd\u00db\u00e0^5\u00ff\u0092\u00e8$$\u00067\u001e\u0010T\u00edc\u00e50*\u00d3\u0082I\u00cb0H,.\n\u00c4\u00b2\u00a4 \u009e\u0016}Pn\u0017\u00d4\u00ef\u00c1\u0011\u00ef\u00fe\u00d8,(\u0001\u00b0\u0092\u0083\u00aa\u00ba\u0000\u00b6J\u0093\u009d\u00df\u0005\u000f\u00bcs*\u00cb5\u00fe\u00e1\u00a4n\u00be\u009e\u0087 \u00de\u00a2\u009bz\u000f\u008a\u00ebU\u001f\u00c2\u00e5o4\u00924\u0093\u00eb\u0084\u00c8\u00c2\u008d\u0006\u00cd\u00b4m\u0018\u00dd]}\u00d8\u00c8\u00bcZ\u0002l\u0080\u00b2\u00b0\u0016\n\u001c\u00baUe\u0090?\u0084\u0095\u00c1r\u00dd\u00f2W\u00f9\"A&\u00a37\u00fe\f;\u00dfq\u0019\u0000\u00bb\u00ee\u00bc\u0016x\n\u00e5\u00f1z\u00be\u00c9MG\u00e0]*\u00a9\u0019D\u00b1|\u009a\u0082xF\u00f6\u00d2d\u00b8\u00c9 \u0091w,\u00fb\u00b00Y\u001e\u00af\u009b\u00d7\u00ed\u00c2 \u0003\u00e6\u00e4\u00ed\u0094\u0000'\u0002\u0006\u00d4\u00f9\u0089\u008b\u00a6u}\u00fd\u0092\u00c3mcW\u00ea\u00ad\u0018\u0097?\u00d0\u00bfc}V\u00fbDb\u00d9\u0017\u00b7\u0093e\u00f8\u00de\u00c7\u001a\u00c9\u00cd\u008fZ\u0013\u0016%qO}\u00cdI\u0016\u00b54*\u00ee\u0093\r\u0007\u00c1\u00cc\u008cGP\b\u008aD\u000e\u00bc\u00c2\u00f8\u00d0\u00a1\u0092\u00ce\u00c6>\u00923#Z\u00fc\u0015R\u00b6?Y\u000e^\u00f4\tr\u0085\u00d0\u00d68\u00b0]E\u00fe\u0017i\u00c6\u00d2\u001b\u00199\u00e9p\u00d9kk\u0010\u00ed\u00169\u0084\u00e9\u0013\u00c1h\u00fd:u0\u0012)\u00c6t\u00cds\u00f7\u001a\u00e3\u00ecE\u00f79P\u00dc\u00c0\u00d3%\u0006\u009b\u00db\u0089\u00fdv* \u0099\u00851\u00f6\u00b3\u0088\u00eaW%\u00dd\u008f\u00cbv>\u00b5\u0095\u009c\u00e1\u00c3\u00cfAS\u0082\u00d8\u00ca\u00ff\u0002\u00a5:\u0018`I\u00df\u00aa \u00ac\u000b}\u00edm2D3\u00bd\u00a4[\u0011\u0014N1\u0098\u00e4\u0085l8\u00a41\u0082AF\u00a5\u00e9\u0091\u00900\u00b9~CL\u00a1z;\u00ec\u00faO\u00ef\n\u000foa\u0003\u00ac\u00abd\u00b1\u00a7\u0013\u00da\u00c1l\u00a3\u00fa\u00f6|\u00a1_\u00ce\u0095\u00d6$\u00c7\"\u00ee`\u00bc\u0005\u00a1(\u0000$\u00f8 \u0014\u000b\u00b1$\u0014\u00dc\u00fb\u0011Kf \u00ca\\\u0019\u0090\u0007\u00e8y\u00c8\u0010B@\u00bd\u00d5\u0094\u0001\u0001\u00d6n\u0000\u009d\u00a8\u0006\u0006\u00e4Y\u00f8?\u00b9\u0016.>\u00b1D\u00ff{\u00f0\u00cc\u0083K\u00c0\u008a\u00ea\u007f\u00dd\u0001;\u00eb\u0096\u00b9\u00f9\u0012N\u0097\u00d6\u00cb\u00c5#\u00a8`\u00bc\\\u00ab\u00d0*\u00c8\u00dc0\u0087\u0090\u001d\u0092\u0011\u00cedh\u00da\u0091\u001d\u0080?V_\u0091_\u008a\r\u00ce5Wv\u00c4\u00f9\u00c7\u00dc\u0087\u00c4\u00afi\u00ac\u0001\u00ea2\u008cw\u0099S\u0082nc\u008e\u00ae\u00ec\u00ab\u00ac\u00ebk\u009e\u00d0\"\u00cc\u0011\u00e0b\u00aa\u00c0n\u00c39\u00b0\u00b2]\u00a7\u00cb\u0086\u00ed\u00cc\u00ad\u00e1\u00d8z\u009aC\u00ea\u00d5G\u0096\u00f0H\u00ff\u00bb\u0001\u001d\u0016\u00e4@\u0086\u00da\u0087\u00a4\u00aaw\u009d0\u00ac\u00b4\u0013\u00ca\u00cdV\u0080\u008a\u00e9\u000bw\u00c3{\u0092\u00a5\u0007D\u00bc\u00fd\u0084*k\u00aa\u00b0\u00b8V \u0013\u00f5\u00b4\u0090\u00e3\u00f7\u00e6El \u00b8\u009c\u00f9J\u00f4\u00e3IQS\u00b6r\u00ca\u0098k)\u00e8\u00a5\u00bb\"\u00a5\u00d9Y\u00b4\u00d3\" \u00c6vQ\u00cb\u0092=\u00f5 \u00ee\u00f7\u00f4X3.Kp<A'\u0006|.H\u0018s\r\u009c[\"\u00b5S\u00c3\u00e5\t_\u00c3\u008e\u00f1#\u0097ui\u00dc\u00185EE\u0089q\u00c8\u00a8X\u00ba\u00a7h\u0019|\u001eU\u00e1\u0089\u0018\u00cc\u0005\u00f7\u008f\u00a0\u00a7\u001a\u0011y\u00f5|\u00d1i\u00d4\u00bf\u001d\u00e1\u00d7\t\u008e\u0081\u0090S\u00b8f8\u00fd\u00a8\u000e\u00a5\u00d5\u0000\u009a\u001b\u00ba\u0015\u00bf\u001d\t,\u001e7\u00d8\u00d7\u0013G\u00d3\u00ecI\u00de\u00eb\u00b5B\u00a5\u00b11\u0004\u00b1\u00ba\u008d\u009b\u001a\u00ae\u0002\u00f7\u0018\u0087\u0089\u00cdu\u0091\u00ab\rm\u00db\u0086\u00cd&^\u00fev\n\u00e4\u00a1\u001fd\u0006Dh\u0081\n@\u00c6O\u00a3\u00bb^$\u009bwJD\u00e3:\u00e6\u00a3\u0087.\u008aivg\u001dox\u0014\u0000j\u008c\u008f\u001e\u0018\u00b66\u0014*Y\u00e8\u00f9J\u00c0\u0013\u00fb\u00aa\u00a1J\u0086\u00ce\u009e\u0004\u00c2\u0098\u0099\u00be\u00b29\u001e\u00a4\u00ec\u0089\u00f5\u00b2?\u0013\u00c2\u00ad\u009ar\u00ad\u008c[\u00961\u009f\u00c3m\u0086Nm8{R\u0003\u0004\u007f\u00d8\u0018\u00a9\u00c4\u00ce\r\u00fbWPsc\u00fc\u00e9\u00fc\u009e\u00cc\u00eb\ro\u0015\u00c9\u00d2\u00be\u001d\u00ac\u00f1\u00bfm\u00a7^\u00dam\u001b\u0083\u001f\u00b5\u00e9\u00b2_>\u00ed\u00f05a\u0014\u00ed\u00efKH;\u009d9\u00cfS-\u00e4\u00d5\u00c2|+\u00e8\u00c2^\u00cd\u00edk\u00f0\u00d3\u007f\u00e7e\u00dc\u00deC\u00f7>\u00bf\u0088\u00d5\u001fU<T\u009c\u00d6`l\u00cfrs<\u00effO \u0083w(\u00ab\u00cc\u00ef>\u00da\u00c1\u00b5\u00dez\u00b1j\u00cb\u00a0{O\u00ba\u00b8[\u00a0\u000e\u009e\u00d4H\u0083\u0019y\u00cc\u00a1#xwg \u00d4\u00a6\u00b8\u008cj\u001d\u00a6 \u00a1d\u00eeS\u00ac7g\u00c6\u00d8\u0086\u001b\u00ce\u0019\u0085\u008c\u00bf\u00a8\u00b7\u00ec\u00b4\u00dc43\u0018$\u00f9*\u00dcdBu\u00d0\u00e9!Hw_\n}\u009e@*_N\u0094\u008e\u00ba\u0099\u00c3\u0000\u0092\u00e6\u00d4K|\u00dc\u00d8wh\u00fd\u00ef\u0018\u00bc'\u00f8l\u00a1\u0005\u00ce4>\u00cc?\u00f9I\u0097D1\u0005\u001f\u008a\u00ce\u0096'\u00db\u00f2\u0018\u0014ha,\u00f5|8\u00ce\u00a8u*C4U\\\u0088\u00a85\u00e8\u00a0s;01\u000e\u007f\u00ea\u008a\u00d4\u00a33e\u00fd\u00de\u001b#\u0019\u00b1\u00c7\u001e\u00a1\u00dbW\u00e5\u00c4\u00f1\u00c7\u0096je\t\u00ad\u0087\u0018\u00d5.\u000f\u0090\u00ae\u00a5\u00f7\u00c6\u008c\u00f5{\u0000\u00f9\u00f2K\u00b9\u001d\u00b4R\u00f3\u00c9\u0090\u00db\u0090\u00e8\u00f0\u00acM}\u00de\u00fdo\u0085\u00df`\u00b3\u00b0\u00da=\u0001\u00f5\u00ab\u00e2\u00d3\u0019E".length();
                var1_4 = 19;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f4\u00b0\u00af\u0091J\u00a8\u0019_\u00e6+\u00f9L\u001d\u00bd\u0011\u00c1\tN\u00a6@\u00a3D\u00cd)8)\u00be\u0090\u00d7%\u00bdb";
                    var4_3 = "\u00f4\u00b0\u00af\u0091J\u00a8\u0019_\u00e6+\u00f9L\u001d\u00bd\u0011\u00c1\tN\u00a6@\u00a3D\u00cd)8)\u00be\u0090\u00d7%\u00bdb".length();
                    var1_4 = 14;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 9;
                            break;
                        }
                        case 1: {
                            v13 = 65;
                            break;
                        }
                        case 2: {
                            v13 = 93;
                            break;
                        }
                        case 3: {
                            v13 = 90;
                            break;
                        }
                        case 4: {
                            v13 = 60;
                            break;
                        }
                        case 5: {
                            v13 = 16;
                            break;
                        }
                        default: {
                            v13 = 84;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        Signer.h = var5;
        Signer.i = new String[88];
        Signer.a = DigestAlg.SHA256;
        Signer.b = true;
        Signer.d = true;
        Signer.e = new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance);
        Signer.f = EESYAOID.oid_TK_nesoid;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFF88A7) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 136;
                    break;
                }
                case 1: {
                    n5 = 21;
                    break;
                }
                case 2: {
                    n5 = 153;
                    break;
                }
                case 3: {
                    n5 = 47;
                    break;
                }
                case 4: {
                    n5 = 113;
                    break;
                }
                case 5: {
                    n5 = 187;
                    break;
                }
                case 6: {
                    n5 = 40;
                    break;
                }
                case 7: {
                    n5 = 94;
                    break;
                }
                case 8: {
                    n5 = 241;
                    break;
                }
                case 9: {
                    n5 = 63;
                    break;
                }
                case 10: {
                    n5 = 158;
                    break;
                }
                case 11: {
                    n5 = 6;
                    break;
                }
                case 12: {
                    n5 = 215;
                    break;
                }
                case 13: {
                    n5 = 180;
                    break;
                }
                case 14: {
                    n5 = 208;
                    break;
                }
                case 15: {
                    n5 = 156;
                    break;
                }
                case 16: {
                    n5 = 141;
                    break;
                }
                case 17: {
                    n5 = 32;
                    break;
                }
                case 18: {
                    n5 = 116;
                    break;
                }
                case 19: {
                    n5 = 194;
                    break;
                }
                case 20: {
                    n5 = 218;
                    break;
                }
                case 21: {
                    n5 = 50;
                    break;
                }
                case 22: {
                    n5 = 248;
                    break;
                }
                case 23: {
                    n5 = 115;
                    break;
                }
                case 24: {
                    n5 = 132;
                    break;
                }
                case 25: {
                    n5 = 95;
                    break;
                }
                case 26: {
                    n5 = 129;
                    break;
                }
                case 27: {
                    n5 = 231;
                    break;
                }
                case 28: {
                    n5 = 105;
                    break;
                }
                case 29: {
                    n5 = 18;
                    break;
                }
                case 30: {
                    n5 = 68;
                    break;
                }
                case 31: {
                    n5 = 196;
                    break;
                }
                case 32: {
                    n5 = 99;
                    break;
                }
                case 33: {
                    n5 = 10;
                    break;
                }
                case 34: {
                    n5 = 140;
                    break;
                }
                case 35: {
                    n5 = 70;
                    break;
                }
                case 36: {
                    n5 = 28;
                    break;
                }
                case 37: {
                    n5 = 24;
                    break;
                }
                case 38: {
                    n5 = 192;
                    break;
                }
                case 39: {
                    n5 = 174;
                    break;
                }
                case 40: {
                    n5 = 238;
                    break;
                }
                case 41: {
                    n5 = 54;
                    break;
                }
                case 42: {
                    n5 = 91;
                    break;
                }
                case 43: {
                    n5 = 184;
                    break;
                }
                case 44: {
                    n5 = 11;
                    break;
                }
                case 45: {
                    n5 = 106;
                    break;
                }
                case 46: {
                    n5 = 254;
                    break;
                }
                case 47: {
                    n5 = 14;
                    break;
                }
                case 48: {
                    n5 = 220;
                    break;
                }
                case 49: {
                    n5 = 49;
                    break;
                }
                case 50: {
                    n5 = 7;
                    break;
                }
                case 51: {
                    n5 = 225;
                    break;
                }
                case 52: {
                    n5 = 149;
                    break;
                }
                case 53: {
                    n5 = 133;
                    break;
                }
                case 54: {
                    n5 = 146;
                    break;
                }
                case 55: {
                    n5 = 175;
                    break;
                }
                case 56: {
                    n5 = 31;
                    break;
                }
                case 57: {
                    n5 = 34;
                    break;
                }
                case 58: {
                    n5 = 138;
                    break;
                }
                case 59: {
                    n5 = 25;
                    break;
                }
                case 60: {
                    n5 = 232;
                    break;
                }
                case 61: {
                    n5 = 102;
                    break;
                }
                case 62: {
                    n5 = 69;
                    break;
                }
                case 63: {
                    n5 = 1;
                    break;
                }
                case 64: {
                    n5 = 22;
                    break;
                }
                case 65: {
                    n5 = 12;
                    break;
                }
                case 66: {
                    n5 = 122;
                    break;
                }
                case 67: {
                    n5 = 3;
                    break;
                }
                case 68: {
                    n5 = 223;
                    break;
                }
                case 69: {
                    n5 = 101;
                    break;
                }
                case 70: {
                    n5 = 104;
                    break;
                }
                case 71: {
                    n5 = 250;
                    break;
                }
                case 72: {
                    n5 = 144;
                    break;
                }
                case 73: {
                    n5 = 202;
                    break;
                }
                case 74: {
                    n5 = 61;
                    break;
                }
                case 75: {
                    n5 = 86;
                    break;
                }
                case 76: {
                    n5 = 134;
                    break;
                }
                case 77: {
                    n5 = 185;
                    break;
                }
                case 78: {
                    n5 = 90;
                    break;
                }
                case 79: {
                    n5 = 53;
                    break;
                }
                case 80: {
                    n5 = 117;
                    break;
                }
                case 81: {
                    n5 = 216;
                    break;
                }
                case 82: {
                    n5 = 201;
                    break;
                }
                case 83: {
                    n5 = 13;
                    break;
                }
                case 84: {
                    n5 = 75;
                    break;
                }
                case 85: {
                    n5 = 55;
                    break;
                }
                case 86: {
                    n5 = 72;
                    break;
                }
                case 87: {
                    n5 = 213;
                    break;
                }
                case 88: {
                    n5 = 127;
                    break;
                }
                case 89: {
                    n5 = 79;
                    break;
                }
                case 90: {
                    n5 = 35;
                    break;
                }
                case 91: {
                    n5 = 114;
                    break;
                }
                case 92: {
                    n5 = 98;
                    break;
                }
                case 93: {
                    n5 = 66;
                    break;
                }
                case 94: {
                    n5 = 236;
                    break;
                }
                case 95: {
                    n5 = 103;
                    break;
                }
                case 96: {
                    n5 = 212;
                    break;
                }
                case 97: {
                    n5 = 58;
                    break;
                }
                case 98: {
                    n5 = 205;
                    break;
                }
                case 99: {
                    n5 = 253;
                    break;
                }
                case 100: {
                    n5 = 228;
                    break;
                }
                case 101: {
                    n5 = 171;
                    break;
                }
                case 102: {
                    n5 = 221;
                    break;
                }
                case 103: {
                    n5 = 150;
                    break;
                }
                case 104: {
                    n5 = 160;
                    break;
                }
                case 105: {
                    n5 = 33;
                    break;
                }
                case 106: {
                    n5 = 227;
                    break;
                }
                case 107: {
                    n5 = 100;
                    break;
                }
                case 108: {
                    n5 = 118;
                    break;
                }
                case 109: {
                    n5 = 93;
                    break;
                }
                case 110: {
                    n5 = 210;
                    break;
                }
                case 111: {
                    n5 = 44;
                    break;
                }
                case 112: {
                    n5 = 224;
                    break;
                }
                case 113: {
                    n5 = 240;
                    break;
                }
                case 114: {
                    n5 = 42;
                    break;
                }
                case 115: {
                    n5 = 73;
                    break;
                }
                case 116: {
                    n5 = 200;
                    break;
                }
                case 117: {
                    n5 = 252;
                    break;
                }
                case 118: {
                    n5 = 124;
                    break;
                }
                case 119: {
                    n5 = 188;
                    break;
                }
                case 120: {
                    n5 = 88;
                    break;
                }
                case 121: {
                    n5 = 27;
                    break;
                }
                case 122: {
                    n5 = 214;
                    break;
                }
                case 123: {
                    n5 = 244;
                    break;
                }
                case 124: {
                    n5 = 67;
                    break;
                }
                case 125: {
                    n5 = 161;
                    break;
                }
                case 126: {
                    n5 = 59;
                    break;
                }
                case 127: {
                    n5 = 83;
                    break;
                }
                case 128: {
                    n5 = 206;
                    break;
                }
                case 129: {
                    n5 = 45;
                    break;
                }
                case 130: {
                    n5 = 159;
                    break;
                }
                case 131: {
                    n5 = 120;
                    break;
                }
                case 132: {
                    n5 = 247;
                    break;
                }
                case 133: {
                    n5 = 165;
                    break;
                }
                case 134: {
                    n5 = 65;
                    break;
                }
                case 135: {
                    n5 = 204;
                    break;
                }
                case 136: {
                    n5 = 233;
                    break;
                }
                case 137: {
                    n5 = 48;
                    break;
                }
                case 138: {
                    n5 = 139;
                    break;
                }
                case 139: {
                    n5 = 155;
                    break;
                }
                case 140: {
                    n5 = 239;
                    break;
                }
                case 141: {
                    n5 = 151;
                    break;
                }
                case 142: {
                    n5 = 96;
                    break;
                }
                case 143: {
                    n5 = 2;
                    break;
                }
                case 144: {
                    n5 = 143;
                    break;
                }
                case 145: {
                    n5 = 203;
                    break;
                }
                case 146: {
                    n5 = 226;
                    break;
                }
                case 147: {
                    n5 = 64;
                    break;
                }
                case 148: {
                    n5 = 245;
                    break;
                }
                case 149: {
                    n5 = 176;
                    break;
                }
                case 150: {
                    n5 = 15;
                    break;
                }
                case 151: {
                    n5 = 110;
                    break;
                }
                case 152: {
                    n5 = 119;
                    break;
                }
                case 153: {
                    n5 = 97;
                    break;
                }
                case 154: {
                    n5 = 178;
                    break;
                }
                case 155: {
                    n5 = 246;
                    break;
                }
                case 156: {
                    n5 = 148;
                    break;
                }
                case 157: {
                    n5 = 52;
                    break;
                }
                case 158: {
                    n5 = 80;
                    break;
                }
                case 159: {
                    n5 = 109;
                    break;
                }
                case 160: {
                    n5 = 23;
                    break;
                }
                case 161: {
                    n5 = 199;
                    break;
                }
                case 162: {
                    n5 = 181;
                    break;
                }
                case 163: {
                    n5 = 172;
                    break;
                }
                case 164: {
                    n5 = 222;
                    break;
                }
                case 165: {
                    n5 = 85;
                    break;
                }
                case 166: {
                    n5 = 219;
                    break;
                }
                case 167: {
                    n5 = 147;
                    break;
                }
                case 168: {
                    n5 = 112;
                    break;
                }
                case 169: {
                    n5 = 135;
                    break;
                }
                case 170: {
                    n5 = 211;
                    break;
                }
                case 171: {
                    n5 = 189;
                    break;
                }
                case 172: {
                    n5 = 169;
                    break;
                }
                case 173: {
                    n5 = 19;
                    break;
                }
                case 174: {
                    n5 = 154;
                    break;
                }
                case 175: {
                    n5 = 195;
                    break;
                }
                case 176: {
                    n5 = 5;
                    break;
                }
                case 177: {
                    n5 = 46;
                    break;
                }
                case 178: {
                    n5 = 4;
                    break;
                }
                case 179: {
                    n5 = 26;
                    break;
                }
                case 180: {
                    n5 = 217;
                    break;
                }
                case 181: {
                    n5 = 177;
                    break;
                }
                case 182: {
                    n5 = 30;
                    break;
                }
                case 183: {
                    n5 = 163;
                    break;
                }
                case 184: {
                    n5 = 230;
                    break;
                }
                case 185: {
                    n5 = 62;
                    break;
                }
                case 186: {
                    n5 = 142;
                    break;
                }
                case 187: {
                    n5 = 8;
                    break;
                }
                case 188: {
                    n5 = 249;
                    break;
                }
                case 189: {
                    n5 = 131;
                    break;
                }
                case 190: {
                    n5 = 56;
                    break;
                }
                case 191: {
                    n5 = 39;
                    break;
                }
                case 192: {
                    n5 = 41;
                    break;
                }
                case 193: {
                    n5 = 157;
                    break;
                }
                case 194: {
                    n5 = 125;
                    break;
                }
                case 195: {
                    n5 = 234;
                    break;
                }
                case 196: {
                    n5 = 36;
                    break;
                }
                case 197: {
                    n5 = 242;
                    break;
                }
                case 198: {
                    n5 = 9;
                    break;
                }
                case 199: {
                    n5 = 237;
                    break;
                }
                case 200: {
                    n5 = 183;
                    break;
                }
                case 201: {
                    n5 = 235;
                    break;
                }
                case 202: {
                    n5 = 207;
                    break;
                }
                case 203: {
                    n5 = 60;
                    break;
                }
                case 204: {
                    n5 = 182;
                    break;
                }
                case 205: {
                    n5 = 170;
                    break;
                }
                case 206: {
                    n5 = 255;
                    break;
                }
                case 207: {
                    n5 = 108;
                    break;
                }
                case 208: {
                    n5 = 82;
                    break;
                }
                case 209: {
                    n5 = 92;
                    break;
                }
                case 210: {
                    n5 = 191;
                    break;
                }
                case 211: {
                    n5 = 164;
                    break;
                }
                case 212: {
                    n5 = 145;
                    break;
                }
                case 213: {
                    n5 = 81;
                    break;
                }
                case 214: {
                    n5 = 128;
                    break;
                }
                case 215: {
                    n5 = 173;
                    break;
                }
                case 216: {
                    n5 = 38;
                    break;
                }
                case 217: {
                    n5 = 51;
                    break;
                }
                case 218: {
                    n5 = 152;
                    break;
                }
                case 219: {
                    n5 = 78;
                    break;
                }
                case 220: {
                    n5 = 166;
                    break;
                }
                case 221: {
                    n5 = 198;
                    break;
                }
                case 222: {
                    n5 = 84;
                    break;
                }
                case 223: {
                    n5 = 0;
                    break;
                }
                case 224: {
                    n5 = 137;
                    break;
                }
                case 225: {
                    n5 = 126;
                    break;
                }
                case 226: {
                    n5 = 20;
                    break;
                }
                case 227: {
                    n5 = 111;
                    break;
                }
                case 228: {
                    n5 = 121;
                    break;
                }
                case 229: {
                    n5 = 168;
                    break;
                }
                case 230: {
                    n5 = 71;
                    break;
                }
                case 231: {
                    n5 = 43;
                    break;
                }
                case 232: {
                    n5 = 209;
                    break;
                }
                case 233: {
                    n5 = 16;
                    break;
                }
                case 234: {
                    n5 = 162;
                    break;
                }
                case 235: {
                    n5 = 37;
                    break;
                }
                case 236: {
                    n5 = 29;
                    break;
                }
                case 237: {
                    n5 = 107;
                    break;
                }
                case 238: {
                    n5 = 229;
                    break;
                }
                case 239: {
                    n5 = 179;
                    break;
                }
                case 240: {
                    n5 = 89;
                    break;
                }
                case 241: {
                    n5 = 186;
                    break;
                }
                case 242: {
                    n5 = 123;
                    break;
                }
                case 243: {
                    n5 = 190;
                    break;
                }
                case 244: {
                    n5 = 76;
                    break;
                }
                case 245: {
                    n5 = 87;
                    break;
                }
                case 246: {
                    n5 = 193;
                    break;
                }
                case 247: {
                    n5 = 197;
                    break;
                }
                case 248: {
                    n5 = 167;
                    break;
                }
                case 249: {
                    n5 = 77;
                    break;
                }
                case 250: {
                    n5 = 74;
                    break;
                }
                case 251: {
                    n5 = 57;
                    break;
                }
                case 252: {
                    n5 = 17;
                    break;
                }
                case 253: {
                    n5 = 130;
                    break;
                }
                case 254: {
                    n5 = 251;
                    break;
                }
                default: {
                    n5 = 243;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            Signer.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

