/*
 * Decompiled with CFR 0.152.
 */
package sune.security.pkcs;

import java.io.IOException;
import sune.security.pkcs.ESSCertId;
import sune.security.util.DerValue;

public class SigningCertificateInfo {
    private byte[] ber = null;
    private ESSCertId[] certId = null;

    public SigningCertificateInfo(byte[] ber) throws IOException {
        this.parse(ber);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n");
        for (int i = 0; i < this.certId.length; ++i) {
            buffer.append(this.certId[i].toString());
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    public void parse(byte[] bytes) throws IOException {
        DerValue derValue = new DerValue(bytes);
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding for signingCertificate");
        }
        DerValue[] certs = derValue.data.getSequence(1);
        this.certId = new ESSCertId[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            this.certId[i] = new ESSCertId(certs[i]);
        }
        if (derValue.data.available() > 0) {
            DerValue[] policies = derValue.data.getSequence(1);
            for (int i = 0; i < policies.length; ++i) {
            }
        }
    }
}

