/*
 * Decompiled with CFR 0.152.
 */
package sune.security.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;
import sune.security.util.BitArray;
import sune.security.util.DerIndefLenConverter;
import sune.security.util.DerInputBuffer;
import sune.security.util.DerValue;
import sune.security.util.ObjectIdentifier;

public class DerInputStream {
    DerInputBuffer buffer;
    public byte tag;

    public DerInputStream(byte[] data) throws IOException {
        this.init(data, 0, data.length);
    }

    public DerInputStream(byte[] data, int offset, int len) throws IOException {
        this.init(data, offset, len);
    }

    private void init(byte[] data, int offset, int len) throws IOException {
        if (offset + 2 > data.length || offset + len > data.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(data[offset + 1])) {
            byte[] inData = new byte[len];
            System.arraycopy(data, offset, inData, 0, len);
            DerIndefLenConverter derIn = new DerIndefLenConverter();
            this.buffer = new DerInputBuffer(derIn.convert(inData));
        } else {
            this.buffer = new DerInputBuffer(data, offset, len);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int len, boolean do_skip) throws IOException {
        DerInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (do_skip) {
            this.buffer.skip(len);
        }
        return new DerInputStream(newbuf);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public int getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getInteger(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer), true);
    }

    public int getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getInteger(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        return this.buffer.getBitString(DerInputStream.getLength(this.buffer));
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int length = DerInputStream.getLength(this.buffer) - 1;
        int validBits = length * 8 - this.buffer.read();
        byte[] repn = new byte[length];
        if (length != 0 && this.buffer.read(repn) != length) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(validBits, repn);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER octet string");
        }
        return retval;
    }

    public void getBytes(byte[] val) throws IOException {
        if (val.length != 0 && this.buffer.read(val) != val.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int startLen) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen, boolean implicit) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (!implicit && this.tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    protected DerValue[] readVector(int startLen) throws IOException {
        byte lenByte = (byte)this.buffer.read();
        int len = DerInputStream.getLength(lenByte & 0xFF, this.buffer);
        if (len == -1) {
            int readLen = this.buffer.available();
            int offset = 2;
            byte[] indefData = new byte[readLen + offset];
            indefData[0] = this.tag;
            indefData[1] = lenByte;
            DataInputStream dis = new DataInputStream(this.buffer);
            dis.readFully(indefData, offset, readLen);
            dis.close();
            DerIndefLenConverter derIn = new DerIndefLenConverter();
            this.buffer = new DerInputBuffer(derIn.convert(indefData));
            if (this.tag != this.buffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            len = DerInputStream.getLength(this.buffer);
        }
        if (len == 0) {
            return new DerValue[0];
        }
        DerInputStream newstr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DerValue> vec = new Vector<DerValue>(startLen);
        do {
            DerValue value = new DerValue(newstr.buffer);
            vec.addElement(value);
        } while (newstr.available() > 0);
        if (newstr.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int max = vec.size();
        DerValue[] retval = new DerValue[max];
        for (int i = 0; i < max; ++i) {
            retval[i] = (DerValue)vec.elementAt(i);
        }
        return retval;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)12, "UTF-8", "UTF8");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public String getGeneralString() throws IOException {
        return this.readString((byte)27, "General", "ASCII");
    }

    private String readString(byte stringTag, String stringName, String enc) throws IOException {
        if (this.buffer.read() != stringTag) {
            throw new IOException("DER input not a " + stringName + " string");
        }
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER " + stringName + " string");
        }
        return new String(retval, enc);
    }

    public Date getUTCTime() throws IOException {
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        return this.buffer.getUTCTime(DerInputStream.getLength(this.buffer));
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        return this.buffer.getGeneralizedTime(DerInputStream.getLength(this.buffer));
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream in) throws IOException {
        return DerInputStream.getLength(in.read(), in);
    }

    static int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        return value;
    }

    public void mark(int value) {
        this.buffer.mark(value);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

