/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sune.security.x509.AlgorithmId;
import sune.security.x509.CertificateAlgorithmId;
import sune.security.x509.CertificateExtensions;
import sune.security.x509.CertificateIssuerName;
import sune.security.x509.CertificateSerialNumber;
import sune.security.x509.CertificateSubjectName;
import sune.security.x509.CertificateValidity;
import sune.security.x509.CertificateVersion;
import sune.security.x509.CertificateX509Key;
import sune.security.x509.KeyIdentifier;
import sune.security.x509.SubjectKeyIdentifierExtension;
import sune.security.x509.X500Name;
import sune.security.x509.X500Signer;
import sune.security.x509.X509Cert;
import sune.security.x509.X509CertImpl;
import sune.security.x509.X509CertInfo;
import sune.security.x509.X509Key;

public final class CertAndKeyGen {
    protected static Logger logger = LoggerFactory.getLogger(CertAndKeyGen.class);
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        } else {
            try {
                this.keyGen = KeyPairGenerator.getInstance(keyType, providerName);
            }
            catch (Exception e) {
                logger.warn("Warning in CertAndKeyGen", (Throwable)e);
                this.keyGen = KeyPairGenerator.getInstance(keyType);
            }
        }
        this.sigAlg = sigAlg;
    }

    public void setRandom(SecureRandom generator) {
        this.prng = generator;
    }

    public void generate(int keyBits) throws InvalidKeyException {
        KeyPair pair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(keyBits, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public X509Cert getSelfCert(X500Name myname, long validity) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        try {
            X509Certificate cert = this.getSelfCertificate(myname, validity);
            return new X509Cert(cert.getEncoded());
        }
        catch (CertificateException e) {
            throw new SignatureException(e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage(), e);
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            X500Signer issuer = this.getSigner(myname);
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", new CertificateSubjectName(myname));
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", new CertificateIssuerName(issuer.getSigner()));
            if (System.getProperty("sun.security.internal.keytool.skid") != null) {
                CertificateExtensions ext = new CertificateExtensions();
                ext.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(this.publicKey).getIdentifier()));
                info.set("extensions", ext);
            }
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(this.privateKey, this.sigAlg);
            return cert;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage(), e);
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, new Date(), validity);
    }

    private X500Signer getSigner(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance(this.sigAlg);
        signature.initSign(this.privateKey);
        return new X500Signer(signature, me);
    }
}

