/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider;

import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.Digester;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.MAC;
import tr.gov.tubitak.uekae.esya.api.crypto.RandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.Signer;
import tr.gov.tubitak.uekae.esya.api.crypto.Verifier;
import tr.gov.tubitak.uekae.esya.api.crypto.Wrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.KeyAgreementAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MACAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;

public interface CryptoProvider {
    public Cipher getEncryptor(CipherAlg var1) throws CryptoException;

    public Cipher getDecryptor(CipherAlg var1) throws CryptoException;

    public Digester getDigester(DigestAlg var1) throws CryptoException;

    public Signer getSigner(SignatureAlg var1) throws CryptoException;

    public Verifier getVerifier(SignatureAlg var1) throws CryptoException;

    public MAC getMAC(MACAlg var1) throws CryptoException;

    public Wrapper getWrapper(WrapAlg var1) throws CryptoException;

    public Wrapper getUnwrapper(WrapAlg var1) throws CryptoException;

    public KeyAgreement getKeyAgreement(KeyAgreementAlg var1) throws CryptoException;

    public KeyFactory getKeyFactory() throws CryptoException;

    public KeyPairGenerator getKeyPairGenerator(AsymmetricAlg var1) throws CryptoException;

    public RandomGenerator getRandomGenerator();

    public boolean isFipsMode();

    public void destroyProvider();
}

