/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.akisExceptions;

import tubitak.akis.cif.akisExceptions.CardErrorCodes;

public class AkisErrorMessages
implements CardErrorCodes {
    static final AkisErrorCode[] ERROR_CODE_TABLE = new AkisErrorCode[]{new AkisErrorCode(25024L, "OKUNACAK_DAHA_VERI_VAR"), new AkisErrorCode(25217L, "EDC_HATASI"), new AkisErrorCode(25218L, "LE_DOSYA_SONUNU_GECIYOR"), new AkisErrorCode(25223L, "BELLEK_TEMIZLENDI"), new AkisErrorCode(25631L, "NMI_HATASI"), new AkisErrorCode(25536L, "PIN/PUK_HATALI"), new AkisErrorCode(25601L, "SIT_TABLOSU_HATALI"), new AkisErrorCode(25602L, "DOSYA_BOYU_HATALI"), new AkisErrorCode(25603L, "BELLEK_DOLU_HATASI"), new AkisErrorCode(25604L, "DIZIN_YOK_HATASI"), new AkisErrorCode(25605L, "DIZIN_DOLU_HATASI"), new AkisErrorCode(25606L, "PIN_GIRILMEDI"), new AkisErrorCode(25616L, "ANAHTAR_HATALI"), new AkisErrorCode(25617L, "DOSYA_ACIK"), new AkisErrorCode(25618L, "HATALI_FID_TIPI"), new AkisErrorCode(25619L, "HATALI_FID_NO"), new AkisErrorCode(25620L, "ANAHTAR_ZATEN_VAR"), new AkisErrorCode(25621L, "ANAHTAR_DOSYASI_HATALI"), new AkisErrorCode(25622L, "ANAHTAR_OKUNAMAZ"), new AkisErrorCode(25623L, "ANAHTAR_DOLDU"), new AkisErrorCode(25624L, "MF_SECILMEDI"), new AkisErrorCode(25625L, "ANAHTAR_YOK"), new AkisErrorCode(25626L, "PIN_YOK"), new AkisErrorCode(25627L, "YASAM_EVRESI_HATALI"), new AkisErrorCode(25628L, "BELLEK_HATASI"), new AkisErrorCode(25629L, "YANLIS_ALANA_YAZILDI"), new AkisErrorCode(25630L, "BASLANGICTA_BELLEK_HATASI"), new AkisErrorCode(25631L, "YETERLI_BELLEK_YOK"), new AkisErrorCode(25632L, "KART_HATALI"), new AkisErrorCode(25633L, "ISIM_HATASI"), new AkisErrorCode(25634L, "ZINCIR_BOYU_HATALI"), new AkisErrorCode(25635L, "ZINCIR_MESAJ_DESTEKLENMIYOR"), new AkisErrorCode(25637L, "UYUMSUZ_VERI"), new AkisErrorCode(25985L, "EEPROM_YAZMA_HATASI"), new AkisErrorCode(25986L, "EEPROM_ARDES_HATASI"), new AkisErrorCode(26112L, "CANLANDIRMA_EVRESI_HATASI"), new AkisErrorCode(26368L, "LC_HATASI_LE_HATASI"), new AkisErrorCode(27009L, "ERISIM_HATASI_LC_KAYIT_UYUMSUZLUGU_DOSYA_TIPI_UYUMSUZLUGU"), new AkisErrorCode(27010L, "GUVENLIK_KOSULU_SAGLANAMADI"), new AkisErrorCode(27012L, "ALGORITMA_HATASI_ISTENILEN_VERI_GECERSIZ"), new AkisErrorCode(27013L, "KULLANIM_KOSULLARI_SAGLANMIYOR"), new AkisErrorCode(27014L, "DOSYA_YUVASI_BOS"), new AkisErrorCode(27015L, "ISTENILEN_ANAHTAR_YUKLU_DEGIL"), new AkisErrorCode(27136L, "BILGI_VERILMIYOR"), new AkisErrorCode(27265L, "FONKSIYON_DESTEKLENMIYOR"), new AkisErrorCode(27266L, "DOSYA_YOK_HATASI"), new AkisErrorCode(27267L, "KAYIT_BULUNAMADI"), new AkisErrorCode(27268L, "DOSYADA_YER_YOK"), new AkisErrorCode(27269L, "TLV_LC_UYUSMAZLIGI"), new AkisErrorCode(27270L, "DESTEKLENMEYEN_PARAMETRE_HATALI_PARAMETRE"), new AkisErrorCode(27271L, "PARAMETRELERLE_UYUSMAYAN_NC"), new AkisErrorCode(27272L, "BASVURULAN_VERI_YOK"), new AkisErrorCode(27273L, "DOSYA_ZATEN_VAR"), new AkisErrorCode(27274L, "DIZIN_ZATEN_VAR_HATASI"), new AkisErrorCode(27392L, "KAYIT_YOK"), new AkisErrorCode(27840L, "LE_DAHA_UZUN"), new AkisErrorCode(27904L, "INS_HATASI"), new AkisErrorCode(28160L, "CLA_HATASI")};

    public static String getAkisErrorMessage(long code) {
        if (code == 36864L) {
            return "BASARILI";
        }
        long OKUNACAK_DAHA_VERI_VAR_UPPER_LIM = 25087L;
        long OKUNACAK_DAHA_VERI_VAR_LOWER_LIM = 24832L;
        long PIN_HATALI_UPPER_LIM = 25552L;
        long PIN_HATALI_LOWER_LIM = 25535L;
        long LE_DAHA_UZUN_UPPER_LIM = 27856L;
        long LE_DAHA_UZUN_LOWER_LIM = 27839L;
        if (code < OKUNACAK_DAHA_VERI_VAR_UPPER_LIM && code > OKUNACAK_DAHA_VERI_VAR_LOWER_LIM) {
            return "OKUNACAK_DAHA_VERI_VAR";
        }
        if (code < PIN_HATALI_UPPER_LIM && code > PIN_HATALI_LOWER_LIM) {
            if (code == 25345L || code == 25537L) {
                return "PIN/PUK_HATALI(SON DENEME)";
            }
            if (code == 25345L || code == 25536L) {
                return "PIN/PUK_BLOKE_OLDU";
            }
            return "PIN/PUK_HATALI";
        }
        if (code < LE_DAHA_UZUN_UPPER_LIM && code > LE_DAHA_UZUN_LOWER_LIM) {
            return "LE_DAHA_UZUN";
        }
        for (int i = 0; i < ERROR_CODE_TABLE.length; ++i) {
            if (AkisErrorMessages.ERROR_CODE_TABLE[i].code != code) continue;
            return AkisErrorMessages.ERROR_CODE_TABLE[i].description;
        }
        return "UNKNOWN_ERROR";
    }

    static class AkisErrorCode {
        public long code;
        public String description;

        AkisErrorCode(long c, String d) {
            this.code = c;
            this.description = d;
        }
    }
}

