/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.math.BigInteger;
import java.util.Arrays;
import javax.smartcardio.ATR;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.UnrecognizedCardException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.commands.CommandsGezgin10;
import tubitak.akis.cif.commands.CommandsV10;
import tubitak.akis.cif.commands.CommandsV11;
import tubitak.akis.cif.commands.CommandsV14;
import tubitak.akis.cif.commands.CommandsV20;
import tubitak.akis.cif.commands.CommandsV25;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CIFFactory {
    protected static String V10_ATR = "3BBA11008131FE4D55454B41452056312E30AE";

    public static AbstractAkisCommands getAkisCIFInstance(ICommandTransmitter cc) throws AkisCardException {
        ATR atr = cc.atr();
        byte[] historicalBytes = atr.getHistoricalBytes();
        Version mCardVersion = CIFFactory.resolveVersionFromATR(atr.getBytes(), historicalBytes);
        if (historicalBytes[2] == 71 && (mCardVersion == Version.GEZGIN_V10_UEKAE_INF || mCardVersion == Version.GEZGIN_V10_UEKAE_NXP || mCardVersion == Version.GEZGIN_V01_UEKAE_NXP || mCardVersion == Version.GEZGIN_V11_UEKAE_NXP || mCardVersion == Version.GEZGIN_V11_UEKAE_INF)) {
            return new CommandsGezgin10(cc, mCardVersion);
        }
        if (mCardVersion == Version.V10_UEKAE) {
            return new CommandsV10(cc, mCardVersion);
        }
        if (mCardVersion == Version.V11_UEKAE_INF || mCardVersion == Version.V12_UEKAE_INF || mCardVersion == Version.V12_UEKAE_NXP || mCardVersion == Version.V121_UEKAE_INF || mCardVersion == Version.V121_UEKAE_NXP || mCardVersion == Version.V122_UEKAE_INF || mCardVersion == Version.V122_UEKAE_NXP || mCardVersion == Version.V122_UEKAE_UKiS_SMIC || mCardVersion == Version.V122_UEKAE_UKiS_HHNEC || mCardVersion == Version.V12_UEKAE_UKiS || mCardVersion == Version.V121_UEKAE_UKiS || mCardVersion == Version.V121_UEKAE_UKiS_SMIC || mCardVersion == Version.V121_UEKAE_UKIS_HHNEC || mCardVersion == Version.V13_UEKAE_INF) {
            return new CommandsV11(cc, mCardVersion);
        }
        if (mCardVersion == Version.V14_UEKAE_NXP || mCardVersion == Version.V14_UEKAE_INF) {
            return new CommandsV14(cc, mCardVersion);
        }
        if (mCardVersion == Version.V2_UEKAE_NXP || mCardVersion == Version.V2_UEKAE_INF || mCardVersion == Version.V21_UEKAE_NXP || mCardVersion == Version.V21_UEKAE_INF || mCardVersion == Version.V22_UEKAE_NXP || mCardVersion == Version.V22_UEKAE_INF || mCardVersion == Version.V22_UEKAE_UKIS_HHNEC || mCardVersion == Version.V22_UEKAE_UKIS_SMIC) {
            return new CommandsV20(cc, mCardVersion);
        }
        if (mCardVersion == Version.V25_UEKAE_NXP || mCardVersion == Version.V25_UEKAE_INF) {
            return new CommandsV25(cc, mCardVersion);
        }
        if (mCardVersion == Version.V26_UEKAE_NXP || mCardVersion == Version.V26_UEKAE_INF) {
            return new CommandsV25(cc, mCardVersion);
        }
        throw new UnrecognizedCardException();
    }

    public static Version resolveVersionFromATR(byte[] atr, byte[] historicalBytes) throws UnrecognizedCardException {
        byte[] akis = new byte[]{85, 69, 75, 65, 69};
        byte[] versionBytes = new byte[2];
        if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 0, 5))) {
            if (historicalBytes[2] == 71) {
                versionBytes[0] = (byte)(historicalBytes[4] & 0xF0 | ((historicalBytes[4] & 7) << 1) + (historicalBytes[5] >> 7 & 1));
                versionBytes[1] = (byte)(historicalBytes[3] & 0x3F | 0x30);
            } else if (historicalBytes[7] == 32 && historicalBytes[8] == 18) {
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            } else if (historicalBytes[7] == 32 && historicalBytes[8] == 19) {
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            } else if (historicalBytes[5] == 32) {
                if (historicalBytes[4] == 32) {
                    versionBytes[0] = historicalBytes[5];
                    versionBytes[1] = (byte)(historicalBytes[6] & 0x3F);
                } else {
                    versionBytes[0] = (byte)(historicalBytes[5] & 0xF0 | ((historicalBytes[5] & 7) << 1) + (historicalBytes[6] >> 7 & 1));
                    versionBytes[1] = historicalBytes[4];
                }
            } else if ((byte)(historicalBytes[5] & 0xF0) == 32) {
                versionBytes[0] = (byte)(historicalBytes[5] & 0xF0 | ((historicalBytes[5] & 7) << 1) + (historicalBytes[6] >> 7 & 1));
                versionBytes[1] = (byte)(historicalBytes[4] & 0x3F);
            } else if (atr[9] == 20 && atr[10] == 19) {
                versionBytes[0] = atr[9];
                versionBytes[1] = atr[10];
            } else if (atr[9] == 20 && atr[10] == 18) {
                versionBytes[0] = atr[9];
                versionBytes[1] = atr[10];
            } else if (historicalBytes[0] == 0 || historicalBytes[0] == -128) {
                if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 2, 7))) {
                    throw new UnrecognizedCardException();
                }
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            }
        } else {
            if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 0, 5))) {
                throw new UnrecognizedCardException();
            }
            versionBytes[0] = 16;
            versionBytes[1] = 18;
        }
        Version mCardVersion = Version.getVersion(new BigInteger(versionBytes).intValue());
        return mCardVersion;
    }

    static {
        System.out.println("Set property");
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        System.setProperty("sun.security.smartcardio.t1GetResponse", "false");
    }
}

