/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.akisExceptions.UnsupportedVersionException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.dataStructures.ARR;
import tubitak.akis.cif.dataStructures.ActivationType;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.FCI;
import tubitak.akis.cif.dataStructures.FileAccessRules;
import tubitak.akis.cif.dataStructures.FileDescriptor;
import tubitak.akis.cif.dataStructures.FileLevel;
import tubitak.akis.cif.dataStructures.FileTypes;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.LifeCycle;
import tubitak.akis.cif.dataStructures.Manufacturer;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.PIN;
import tubitak.akis.cif.dataStructures.RSAKey;
import tubitak.akis.cif.dataStructures.RSAKeyFields;
import tubitak.akis.cif.dataStructures.SDOHeader;
import tubitak.akis.cif.dataStructures.SymmetricKey;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Conversions;
import tubitak.akis.cif.functions.Crypto;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CommandsV20
extends AbstractAkisCommands {
    protected byte deletableKeyType = 0;
    protected byte undeletableKeyType = 1;
    protected byte[] K_SM_ENC = new byte[32];
    protected byte[] K_SM_MAC = new byte[32];
    protected byte[] SSC = new byte[16];

    public CommandsV20(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 3;
        this.fileAccessRules = new FileAccessRules(48, 48, 48, 0);
        this.fileTypes = new FileTypes(1, 1, 1, 1);
        this.putDataParam.cardLabel = new P1P2(1, 6);
        this.putDataParam.userInfo = new P1P2(1, 9);
        this.putDataParam.setBaudRate = new P1P2(1, 10);
        this.putDataParam.company = new P1P2(1, 13);
        this.putDataParam.applicationUnit = new P1P2(1, 14);
        this.putDataParam.cardSerialNumber = new P1P2(1, 15);
        this.putDataParam.currentDate = new P1P2(1, 16);
        this.putDataParam.atrOptionalBytes = new P1P2(1, 17);
        this.pso_param.cds = new P1P2(-98, -102);
        this.pso_param.vds = new P1P2(0, -88);
        this.pso_param.ccc = new P1P2(-114, -128);
        this.pso_param.vcc = new P1P2(0, -94);
        this.pso_param.enc = new P1P2(-122, -128);
        this.pso_param.dec = new P1P2(-128, -126);
        this.pso_param.hash = new P1P2(-112, -128);
        this.pso_param.cer = new P1P2(0, -82);
    }

    @Override
    public void createFile(FCI fci) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] createFileTmpl = new byte[]{0, -32, 0, 0, 0};
        byte[] taggedFci = new byte[100];
        int i = 0;
        int len = 0;
        if (fci == null || fci.getFDB() == null || fci.getARR() == null) {
            throw new AkisCIFException("Invalid parameter");
        }
        byte fileType = fci.getFDB()[0];
        taggedFci[i++] = FCI.FCP_62;
        taggedFci[i++] = 0;
        taggedFci[i++] = -126;
        taggedFci[i++] = (byte)fci.getFDB().length;
        System.arraycopy(fci.getFDB(), 0, taggedFci, i, fci.getFDB().length);
        i += fci.getFDB().length;
        if (fci.getFID() != null) {
            taggedFci[i++] = -125;
            taggedFci[i++] = 2;
            taggedFci[i++] = fci.getFID()[0];
            taggedFci[i++] = fci.getFID()[1];
        }
        if (fci.getFCI_FID() != null) {
            taggedFci[i++] = -121;
            taggedFci[i++] = 2;
            taggedFci[i++] = fci.getFCI_FID()[0];
            taggedFci[i++] = fci.getFCI_FID()[1];
        }
        taggedFci[i++] = -95;
        len = fci.getARR().toByteArray().length;
        taggedFci[i++] = (byte)len;
        System.arraycopy(fci.getARR().toByteArray(), 0, taggedFci, i, len);
        i += len;
        if (fileType == FileDescriptor.DedicatedFile.getValue() && fci.getDFName() != null) {
            taggedFci[i++] = -124;
            taggedFci[i++] = (byte)fci.getDFName().length;
            System.arraycopy(fci.getDFName(), 0, taggedFci, i, fci.getDFName().length);
            i += fci.getDFName().length;
        }
        if (fileType == FileDescriptor.Binary.getValue() || fileType == FileDescriptor.FixedRecord.getValue() || fileType == FileDescriptor.VarRecord.getValue() || fileType == FileDescriptor.FixedCycRecord.getValue()) {
            if (fci.getSFI() != 0) {
                taggedFci[i++] = -120;
                taggedFci[i++] = 1;
                taggedFci[i++] = fci.getSFI();
            } else {
                taggedFci[i++] = -120;
                taggedFci[i++] = 0;
            }
            if (fci.getFileLength() != -1) {
                taggedFci[i++] = -127;
                taggedFci[i++] = 2;
                taggedFci[i++] = (byte)(fci.getFileLength() >> 8);
                taggedFci[i++] = (byte)fci.getFileLength();
            }
        }
        taggedFci[1] = (byte)(i - 2);
        byte[] createFile = new byte[createFileTmpl.length + i];
        System.arraycopy(createFileTmpl, 0, createFile, 0, createFileTmpl.length);
        createFile[createFileTmpl.length - 1] = (byte)i;
        System.arraycopy(taggedFci, 0, createFile, createFileTmpl.length, i);
        this.sendCommand(createFile);
    }

    @Override
    public void createBinaryEFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteCurrent() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommand = new byte[]{0, -28, 0, 0, 0};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        this.deleteByFIDUnderDF(FID, level);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte p1 = (byte)(level == FileLevel.DF ? 1 : 2);
        byte[] eraseCommand = new byte[]{0, -28, p1, 0, 2, FID[0], FID[1], 0};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 4, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + name.length + 1];
        eraseCommandHeader[4] = (byte)name.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(name, 0, eraseCommand, eraseCommandHeader.length, name.length);
        eraseCommand[eraseCommand.length - 1] = 0;
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 8, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length + 1];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        eraseCommand[eraseCommand.length - 1] = 0;
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 9, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length + 1];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        eraseCommand[eraseCommand.length - 1] = 0;
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommand = new byte[]{0, -28, 3, 0, 0};
        this.sendCommand(eraseCommand);
    }

    @Override
    public FCI selectMF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 1, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 2, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 3, 0, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 4, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)name.length;
        selectFileCommand = new byte[name.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(name, 0, selectFileCommand, index += commandBytes.length, name.length);
        selectFileCommand[index += name.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 8, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 9, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        this.lastFCI.setFCI(responseData);
        return new FCI(responseData);
    }

    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = null;
        int fileLength = this.selectEFUnderDF(FID).getFileLength();
        if (fileLength > 0) {
            data = new byte[fileLength];
            data = this.readBinaryFile(fileLength);
        }
        return data;
    }

    @Override
    public byte[] readBinaryFile(int len) throws AkisSWException, AkisCardException, AkisCIFException {
        return this.readBinaryFile(0, len);
    }

    @Override
    public byte[] readBinaryFile(int start, int len) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data;
        block8: {
            int offset;
            int index;
            int unReadDataLength;
            block7: {
                data = null;
                int fileLen = this.lastFCI.getFileLength();
                if (fileLen < start + len) {
                    len = fileLen - start;
                }
                unReadDataLength = len;
                index = 0;
                offset = start;
                if (len < 32768) break block7;
                data = new byte[len];
                byte[] readOdd = new byte[]{0, -79, 0, 0, 4, 84, 2, 0, 0, 0};
                while (unReadDataLength > 0) {
                    readOdd[7] = (byte)(offset >> 8);
                    readOdd[8] = (byte)offset;
                    int dataLenInCommand = 0;
                    dataLenInCommand = unReadDataLength > 208 ? 208 : unReadDataLength;
                    readOdd[readOdd.length - 1] = (byte)dataLenInCommand;
                    ResponseAPDU response = this.sendCommand(readOdd);
                    int readDataLength = response.getData().length;
                    byte[] responseData = response.getData();
                    if (unReadDataLength > readDataLength) {
                        System.arraycopy(responseData, 0, data, index, readDataLength);
                    } else {
                        System.arraycopy(responseData, 0, data, index, unReadDataLength);
                    }
                    unReadDataLength -= readDataLength;
                    index += readDataLength;
                    offset += readDataLength;
                }
                break block8;
            }
            if (len <= 0) break block8;
            data = new byte[len];
            byte[] readEven = new byte[]{0, -80, 0, 0, 0};
            while (unReadDataLength > 0) {
                readEven[2] = (byte)((offset & 0xFF00) >> 8);
                readEven[3] = (byte)(offset & 0xFF);
                int dataLenInCommand = 0;
                dataLenInCommand = unReadDataLength > 208 ? 208 : unReadDataLength;
                readEven[4] = (byte)dataLenInCommand;
                ResponseAPDU response = this.sendCommand(readEven);
                int readDataLength = response.getData().length;
                byte[] responseData = response.getData();
                if (unReadDataLength > readDataLength) {
                    System.arraycopy(responseData, 0, data, index, readDataLength);
                } else {
                    System.arraycopy(responseData, 0, data, index, unReadDataLength);
                }
                unReadDataLength -= readDataLength;
                index += readDataLength;
                offset += readDataLength;
            }
        }
        return data;
    }

    @Override
    public byte[] readBinaryFile(int start, int len, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] FID = new byte[]{0, 0};
        FID[1] = SFI;
        return this.readBinaryFile(start, len, FID);
    }

    @Override
    public byte[] readBinaryFile(int start, int len, byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data;
        block8: {
            int offset;
            int index;
            int unReadDataLength;
            block7: {
                data = null;
                unReadDataLength = len;
                index = 0;
                offset = start;
                if (len < 32768) break block7;
                data = new byte[len];
                byte[] readOdd = new byte[]{0, -79, 0, 0, 4, 84, 2, 0, 0, 0};
                readOdd[2] = FID[0];
                readOdd[3] = FID[1];
                while (unReadDataLength > 0) {
                    readOdd[7] = (byte)(offset >> 8);
                    readOdd[8] = (byte)offset;
                    int dataLenInCommand = 0;
                    dataLenInCommand = unReadDataLength > 208 ? 208 : unReadDataLength;
                    readOdd[readOdd.length - 1] = (byte)dataLenInCommand;
                    ResponseAPDU response = this.sendCommand(readOdd);
                    int readDataLength = response.getData().length;
                    byte[] responseData = response.getData();
                    if (unReadDataLength > readDataLength) {
                        System.arraycopy(responseData, 0, data, index, readDataLength);
                    } else {
                        System.arraycopy(responseData, 0, data, index, unReadDataLength);
                    }
                    unReadDataLength -= readDataLength;
                    index += readDataLength;
                    offset += readDataLength;
                }
                break block8;
            }
            if (len <= 0) break block8;
            if (FID[0] != 0 || (FID[1] & 0xE0) != 0) {
                throw new AkisCIFException("Invalid parameter");
            }
            data = new byte[len];
            byte[] readEven = new byte[]{0, -80, 0, 0, 0};
            while (unReadDataLength > 0) {
                readEven[2] = (byte)(FID[1] | 0x80);
                readEven[3] = (byte)offset;
                int dataLenInCommand = 0;
                dataLenInCommand = unReadDataLength > 208 ? 208 : unReadDataLength;
                readEven[4] = (byte)dataLenInCommand;
                ResponseAPDU response = this.sendCommand(readEven);
                int readDataLength = response.getData().length;
                byte[] responseData = response.getData();
                if (unReadDataLength > readDataLength) {
                    System.arraycopy(responseData, 0, data, index, readDataLength);
                } else {
                    System.arraycopy(responseData, 0, data, index, unReadDataLength);
                }
                unReadDataLength -= readDataLength;
                index += readDataLength;
                offset += readDataLength;
            }
        }
        return data;
    }

    @Override
    public byte[] readRecordFile(byte recNo) throws AkisSWException, AkisCardException, AkisCIFException {
        return this.ReadRecord(recNo, (byte)0);
    }

    @Override
    public byte[] readRecordFile(byte recNo, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        return this.ReadRecord(recNo, SFI);
    }

    protected byte[] ReadRecord(byte recNo, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data;
        int eflen = 0;
        int i = 0;
        if (recNo != 0) {
            data = this.A_ReadRecord(recNo, (byte)(SFI << 3 | 4));
        } else {
            byte[] record;
            eflen = this.lastFCI.getFileLength();
            data = new byte[eflen];
            for (int index = 0; index < eflen; index += record.length) {
                record = this.A_ReadRecord((byte)i++, (byte)(SFI << 3 | 4));
                System.arraycopy(record, 0, data, index, record.length);
            }
        }
        return data;
    }

    protected byte[] A_ReadRecord(byte recNo, byte type) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] readRecCmd = new byte[]{0, -78, 0, 0, 0};
        int responseDataLen = 0;
        readRecCmd[2] = recNo;
        readRecCmd[3] = type;
        ResponseAPDU response = this.sendCommand(readRecCmd);
        responseDataLen = response.getData().length;
        byte[] data = new byte[responseDataLen];
        data = response.getData();
        return data;
    }

    @Override
    public void updateBinaryFile(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        this.updateBinaryFile(data, 0);
    }

    @Override
    public void updateBinaryFile(byte[] data, int start) throws AkisSWException, AkisCardException, AkisCIFException {
        block3: {
            int offset;
            int index;
            int unWrittenDataLength;
            block2: {
                unWrittenDataLength = data.length;
                index = 0;
                offset = start;
                if (unWrittenDataLength < 32768) break block2;
                byte[] updateOddTemplate = new byte[]{0, -41, 0, 0, 0, 84, 2, 0, 0, 83, 0};
                while (unWrittenDataLength > 0) {
                    updateOddTemplate[7] = (byte)(offset >> 8);
                    updateOddTemplate[8] = (byte)offset;
                    int dataLenInCommand = 0;
                    dataLenInCommand = unWrittenDataLength > 190 ? 190 : unWrittenDataLength;
                    updateOddTemplate[10] = (byte)dataLenInCommand;
                    updateOddTemplate[4] = (byte)(dataLenInCommand + updateOddTemplate.length);
                    byte[] updateOddCommand = new byte[updateOddTemplate.length + dataLenInCommand];
                    System.arraycopy(updateOddTemplate, 0, updateOddCommand, 0, updateOddTemplate.length);
                    System.arraycopy(data, index, updateOddCommand, updateOddTemplate.length, dataLenInCommand);
                    this.sendCommand(updateOddCommand);
                    index += dataLenInCommand;
                    unWrittenDataLength -= dataLenInCommand;
                    offset += dataLenInCommand;
                }
                break block3;
            }
            if (unWrittenDataLength <= 0) break block3;
            byte[] updateEvenTemplate = new byte[]{0, -42, 0, 0, 0};
            while (unWrittenDataLength > 0) {
                updateEvenTemplate[2] = (byte)((offset & 0xFF00) >> 8);
                updateEvenTemplate[3] = (byte)(offset & 0xFF);
                int dataLenInCommand = 0;
                dataLenInCommand = unWrittenDataLength > 196 ? 196 : unWrittenDataLength;
                updateEvenTemplate[4] = (byte)dataLenInCommand;
                byte[] updateBinaryCommand = new byte[updateEvenTemplate.length + dataLenInCommand];
                System.arraycopy(updateEvenTemplate, 0, updateBinaryCommand, 0, updateEvenTemplate.length);
                System.arraycopy(data, index, updateBinaryCommand, updateEvenTemplate.length, dataLenInCommand);
                this.sendCommand(updateBinaryCommand);
                index += dataLenInCommand;
                unWrittenDataLength -= dataLenInCommand;
                offset += dataLenInCommand;
            }
        }
    }

    @Override
    public void updateBinaryFile(byte[] data, int start, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] FID = new byte[]{0, 0};
        FID[1] = SFI;
        this.updateBinaryFile(data, start, FID);
    }

    @Override
    public void updateBinaryFile(byte[] data, int start, byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        block4: {
            int offset;
            int index;
            int unWrittenDataLength;
            block3: {
                unWrittenDataLength = data.length;
                index = 0;
                offset = start;
                if (unWrittenDataLength < 32768) break block3;
                byte[] updateOddTemplate = new byte[]{0, -41, 0, 0, 0, 84, 2, 0, 0, 83, 0};
                while (unWrittenDataLength > 0) {
                    updateOddTemplate[2] = FID[0];
                    updateOddTemplate[3] = FID[1];
                    updateOddTemplate[7] = (byte)(offset >> 8);
                    updateOddTemplate[8] = (byte)offset;
                    int dataLenInCommand = 0;
                    dataLenInCommand = unWrittenDataLength > 190 ? 190 : unWrittenDataLength;
                    updateOddTemplate[10] = (byte)dataLenInCommand;
                    updateOddTemplate[4] = (byte)(dataLenInCommand + updateOddTemplate.length - 5);
                    byte[] updateOddCommand = new byte[updateOddTemplate.length + dataLenInCommand];
                    System.arraycopy(updateOddTemplate, 0, updateOddCommand, 0, updateOddTemplate.length);
                    System.arraycopy(data, index, updateOddCommand, updateOddTemplate.length, dataLenInCommand);
                    this.sendCommand(updateOddCommand);
                    index += dataLenInCommand;
                    unWrittenDataLength -= dataLenInCommand;
                    offset += dataLenInCommand;
                }
                break block4;
            }
            if (unWrittenDataLength <= 0) break block4;
            byte[] updateEvenTemplate = new byte[]{0, -42, 0, 0, 0};
            if (FID[0] != 0 || (FID[1] & 0xE0) != 0) {
                throw new AkisCIFException("Invalid parameter");
            }
            while (unWrittenDataLength > 0) {
                updateEvenTemplate[2] = (byte)(FID[1] | 0x80);
                updateEvenTemplate[3] = (byte)offset;
                int dataLenInCommand = 0;
                dataLenInCommand = unWrittenDataLength > 196 ? 196 : unWrittenDataLength;
                updateEvenTemplate[4] = (byte)dataLenInCommand;
                byte[] updateBinaryCommand = new byte[updateEvenTemplate.length + dataLenInCommand];
                System.arraycopy(updateEvenTemplate, 0, updateBinaryCommand, 0, updateEvenTemplate.length);
                System.arraycopy(data, index, updateBinaryCommand, updateEvenTemplate.length, dataLenInCommand);
                this.sendCommand(updateBinaryCommand);
                index += dataLenInCommand;
                unWrittenDataLength -= dataLenInCommand;
                offset += dataLenInCommand;
            }
        }
    }

    @Override
    public void updateRecordFile(byte recNo, byte[] record) throws AkisSWException, AkisCardException, AkisCIFException {
        this.UpdateRecord(recNo, record, (byte)0);
    }

    @Override
    public void updateRecordFile(byte recNo, byte[] record, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        this.UpdateRecord(recNo, record, SFI);
    }

    protected void UpdateRecord(byte recNo, byte[] record, byte SFI) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] upRecCmdTmpl = new byte[]{0, -36, 0, 0, 0};
        if (record == null) {
            throw new AkisCIFException("Invalid parameter");
        }
        upRecCmdTmpl[2] = recNo;
        upRecCmdTmpl[3] = (byte)(SFI << 3 | 4);
        upRecCmdTmpl[4] = (byte)record.length;
        byte[] upRecCmd = new byte[upRecCmdTmpl.length + record.length];
        System.arraycopy(upRecCmdTmpl, 0, upRecCmd, 0, upRecCmdTmpl.length);
        System.arraycopy(record, 0, upRecCmd, upRecCmdTmpl.length, record.length);
        this.sendCommand(upRecCmd);
    }

    @Override
    public void appendRecordFile(byte[] record) throws AkisSWException, AkisCardException, AkisCIFException {
        this.AppendRecord(record, (byte)0);
    }

    @Override
    public void appendRecordFile(byte[] record, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        this.AppendRecord(record, SFI);
    }

    protected void AppendRecord(byte[] record, byte SFI) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] appRecCmdTmpl = new byte[]{0, -30, 0, 0, 0};
        if (record == null) {
            throw new AkisCIFException("Invalid parameter");
        }
        appRecCmdTmpl[3] = (byte)(SFI << 3);
        appRecCmdTmpl[4] = (byte)record.length;
        byte[] appRecCmd = new byte[appRecCmdTmpl.length + record.length];
        System.arraycopy(appRecCmdTmpl, 0, appRecCmd, 0, appRecCmdTmpl.length);
        System.arraycopy(record, 0, appRecCmd, appRecCmdTmpl.length, record.length);
        this.sendCommand(appRecCmd);
    }

    @Override
    public void eraseBinaryFile() throws AkisSWException, AkisCardException, AkisCIFException {
        this.eraseBinaryFile(0);
    }

    @Override
    public void eraseBinaryFile(int start) throws AkisSWException, AkisCardException, AkisCIFException {
        this.eraseBinaryFile(start, 0);
    }

    @Override
    public void eraseBinaryFile(int start, int len) throws AkisSWException, AkisCardException, AkisCIFException {
        int end = start + len;
        if (start >= 32768) {
            byte[] eraseOdd1Off = new byte[]{0, 15, 0, 0, 4, 84, 2, 0, 0};
            byte[] eraseOdd2Off = new byte[]{0, 15, 0, 0, 4, 84, 2, 0, 0, 84, 2, 0, 0, 0};
            if (this.version == Version.V22_UEKAE_INF || this.version == Version.V22_UEKAE_NXP) {
                eraseOdd1Off[0] = -128;
                eraseOdd2Off[0] = -128;
            }
            if (len == 0) {
                eraseOdd1Off[7] = (byte)(start >> 8);
                eraseOdd1Off[8] = (byte)start;
                this.sendCommand(eraseOdd1Off);
            } else {
                eraseOdd2Off[7] = (byte)(start >> 8);
                eraseOdd2Off[8] = (byte)start;
                eraseOdd2Off[11] = (byte)(end >> 8);
                eraseOdd2Off[12] = (byte)end;
                this.sendCommand(eraseOdd2Off);
            }
        } else if (start >= 0) {
            byte[] eraseEven1 = new byte[]{-128, 14, 0, 0, 0};
            byte[] eraseEven2 = new byte[]{-128, 14, 0, 0, 0, 0, 0};
            if (this.version == Version.V22_UEKAE_INF || this.version == Version.V22_UEKAE_NXP) {
                eraseEven1[0] = -128;
                eraseEven2[0] = -128;
            }
            if (len == 0) {
                eraseEven1[2] = (byte)((start & 0xFF00) >> 8);
                eraseEven1[3] = (byte)(start & 0xFF);
                this.sendCommand(eraseEven1);
            } else {
                eraseEven2[2] = (byte)((start & 0xFF00) >> 8);
                eraseEven2[3] = (byte)(start & 0xFF);
                if (end <= 255) {
                    eraseEven2[4] = 1;
                    eraseEven2[5] = (byte)end;
                } else {
                    eraseEven2[4] = 2;
                    eraseEven2[5] = (byte)(end >> 8);
                    eraseEven2[6] = (byte)end;
                }
                this.sendCommand(eraseEven2);
            }
        }
    }

    @Override
    public void eraseBinaryFile(int start, int len, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] FID = new byte[]{0, SFI};
        this.eraseBinaryFile(start, len, FID);
    }

    @Override
    public void eraseBinaryFile(int start, int len, byte[] FID) throws AkisCIFException, AkisSWException, AkisCardException {
        int end = start + len;
        if (FID == null) {
            throw new AkisCIFException("Invalid parameter");
        }
        if (start >= 32768) {
            byte[] eraseOdd = new byte[]{-128, 15, FID[0], FID[1], 4, 84, 2, 0, 0, 84, 2, 0, 0, 0};
            if (this.version == Version.V22_UEKAE_INF || this.version == Version.V22_UEKAE_NXP) {
                eraseOdd[0] = -128;
            }
            eraseOdd[7] = (byte)(start >> 8);
            eraseOdd[8] = (byte)start;
            eraseOdd[11] = (byte)(end >> 8);
            eraseOdd[12] = (byte)end;
            this.sendCommand(eraseOdd);
        } else if (start >= 0) {
            if (FID[0] != 0 || (FID[1] & 0xE0) != 0) {
                throw new AkisCIFException("Invalid parameter");
            }
            byte[] eraseEven = new byte[]{-128, 14, 0, 0, 0, 0, 0};
            if (this.version == Version.V22_UEKAE_INF || this.version == Version.V22_UEKAE_NXP) {
                eraseEven[0] = -128;
            }
            eraseEven[2] = (byte)(FID[1] | 0x80);
            eraseEven[3] = (byte)(start & 0xFF);
            if (end <= 255) {
                eraseEven[4] = 1;
                eraseEven[5] = (byte)end;
            } else {
                eraseEven[4] = 2;
                eraseEven[5] = (byte)(end >> 8);
                eraseEven[6] = (byte)end;
            }
            this.sendCommand(eraseEven);
        }
    }

    @Override
    public void closeEF() {
        throw new UnsupportedVersionException();
    }

    @Override
    public List<FCI> dirV2() throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response = null;
        byte[] data = null;
        ArrayList<FCI> children = new ArrayList<FCI>();
        byte[] getDir = new byte[]{-128, 29, 0, 0, 0};
        response = this.sendCommand(getDir);
        if (response.getSW() == 36864) {
            data = response.getData();
        }
        if (data == null || data.length == 0) {
            throw new AkisCIFException("Get Directory command returns NULL.");
        }
        int noOfDfEF = data[0];
        for (int i = 1; i <= noOfDfEF; ++i) {
            getDir[3] = (byte)i;
            response = this.sendCommand(getDir);
            if (response.getSW() == 36864) {
                data = response.getData();
            }
            if (data == null || data.length == 0) {
                throw new AkisCIFException("Get Directory command returns NULL.");
            }
            FCI fci = new FCI(data);
            children.add(fci);
        }
        return children;
    }

    @Override
    public int getMaxKeyID() {
        throw new UnsupportedVersionException();
    }

    @Override
    public int getPinRemainingUsageCount() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] remainedPinCountCommand = new byte[]{0, -53, 63, -1, 10, 77, 8, -65, -127, 1, 4, -96, 2, -101, -128, 0};
        ResponseAPDU response = this.sendCommand(remainedPinCountCommand);
        return response.getBytes()[8];
    }

    @Override
    public AkisKey[] getKeyInfos() {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getPublicExponent(byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getModulus(byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyType, byte keyID) throws AkisCIFException, AkisSWException, AkisCardException {
        if (keyType != 144 && keyType != 160 && keyType != 138) {
            throw new AkisCIFException("Invalid parameter");
        }
        byte[] deleteKey = new byte[]{-128, 30, 0, 0, 3, -65, (byte)keyType, keyID};
        ResponseAPDU response = this.sendCommand(deleteKey);
    }

    @Override
    public void writePublicKey(RSAKey publicKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = publicKey.CreateSDOHeaderList(KeyType.PUBLIC_RSA, false);
        this.putDataSDO(data);
        data = publicKey.CreateSDOHeaderList(KeyType.PUBLIC_RSA, true);
        this.putDataSDO(data);
        data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 129);
        this.putDataSDO(data);
        data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 130);
        this.putDataSDO(data);
        if (publicKey.isCHRExists()) {
            data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 32);
            this.putDataSDO(data);
        }
        if (publicKey.isCHAExists()) {
            data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 76);
            this.putDataSDO(data);
        }
    }

    @Override
    public void updatePublicKey(RSAKey publicKey) throws AkisSWException, AkisCardException, AkisCIFException {
        RSAKey rsakey = this.readPublicKey(publicKey.header.keyID);
        byte[] data = publicKey.CreateSDOHeaderList(KeyType.PUBLIC_RSA, true);
        this.putDataSDO(data);
        data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 129);
        this.putDataSDO(data);
        data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 130);
        this.putDataSDO(data);
        if (publicKey.isCHRExists()) {
            data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 32);
            this.putDataSDO(data);
        }
        if (publicKey.isCHAExists()) {
            data = publicKey.SDOUpdate(KeyType.PUBLIC_RSA, 76);
            this.putDataSDO(data);
        }
    }

    @Override
    public void writePrivateKey(RSAKey privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = privateKey.CreateSDOHeaderList(KeyType.PRIVATE_RSA, false);
        this.putDataSDO(data);
        data = privateKey.CreateSDOHeaderList(KeyType.PRIVATE_RSA, true);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 146);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 147);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 148);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 149);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 150);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 129);
        this.putDataSDO(data);
    }

    @Override
    public void updatePrivateKey(RSAKey privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        RSAKey rsakey = this.readPrivateKey(privateKey.header.keyID);
        byte[] data = privateKey.CreateSDOHeaderList(KeyType.PRIVATE_RSA, true);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 146);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 147);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 148);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 149);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 150);
        this.putDataSDO(data);
        data = privateKey.SDOUpdate(KeyType.PRIVATE_RSA, 129);
        this.putDataSDO(data);
    }

    @Override
    public void writeSymmetricKey(SymmetricKey symmetricKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = symmetricKey.CreateSDOHeaderList(KeyType.SYMMETRIC, false);
        this.putDataSDO(data);
        data = symmetricKey.CreateSDOHeaderList(KeyType.SYMMETRIC, true);
        this.putDataSDO(data);
        data = symmetricKey.SDOUpdate(145);
        this.putDataSDO(data);
        data = symmetricKey.SDOUpdate(144);
        this.putDataSDO(data);
    }

    @Override
    public void updateSymmetricKey(SymmetricKey symmetricKey) throws AkisSWException, AkisCardException, AkisCIFException {
        SymmetricKey symkey = this.readSymmetricKey(symmetricKey.header.keyID);
        byte[] data = symmetricKey.CreateSDOHeaderList(KeyType.SYMMETRIC, true);
        this.putDataSDO(data);
        data = symmetricKey.SDOUpdate(145);
        this.putDataSDO(data);
        data = symmetricKey.SDOUpdate(144);
        this.putDataSDO(data);
    }

    @Override
    public void writePIN(PIN pin) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = pin.CreateSDOHeaderList(false);
        this.putDataSDO(data);
        data = pin.CreateSDOHeaderList(true);
        this.putDataSDO(data);
        data = pin.SDOUpdate();
        this.putDataSDO(data);
    }

    @Override
    public RSAKey readPublicKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] hdr = new byte[]{77, 6, -65, -96, keyID, 2, -96, -128};
        byte[] pub = new byte[]{77, 9, -65, -96, keyID, 5, 127, 73, 2, -127, -128};
        byte[] chr = new byte[]{77, 10, -65, -96, keyID, 6, 127, 73, 3, 95, 76, -128};
        byte[] cha = new byte[]{77, 10, -65, -96, keyID, 6, 127, 73, 3, 95, 32, -128};
        RSAKey key = new RSAKey();
        key.header.keyID = keyID;
        byte[] data = this.getDataSDO(hdr);
        key.CreateKeyFromSDO(data);
        data = this.getDataSDO(pub);
        key.CreateKeyFromSDO(data);
        pub[9] = -126;
        data = this.getDataSDO(pub);
        key.CreateKeyFromSDO(data);
        data = this.getDataSDO(chr);
        key.CreateKeyFromSDO(data);
        boolean isCHAExist = true;
        try {
            data = this.getDataSDO(cha);
        }
        catch (AkisCIFException e) {
            isCHAExist = false;
        }
        if (isCHAExist) {
            key.CreateKeyFromSDO(data);
        }
        return key;
    }

    @Override
    public RSAKey readPrivateKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        RSAKey key = new RSAKey();
        key.header = this.readHeader(keyID, (byte)-112);
        return key;
    }

    protected SDOHeader readHeader(byte keyID, byte keyType) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] hdr = new byte[]{77, 6, -65, keyType, keyID, 2, -96, -128};
        SDOHeader header = new SDOHeader();
        header.keyID = keyID;
        byte[] data = this.getDataSDO(hdr);
        header.CreateHeaderFromSDO(data);
        return header;
    }

    @Override
    public SymmetricKey readSymmetricKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        SymmetricKey key = new SymmetricKey();
        key.header = this.readHeader(keyID, (byte)-118);
        return key;
    }

    @Override
    public PIN readPIN(byte pinID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] pinProp = new byte[]{77, 11, -65, -127, pinID, 7, 127, 65, 4, -128, -128, -127, -128};
        PIN pin = new PIN();
        pin.header = this.readHeader(pinID, (byte)-127);
        byte[] data = this.getDataSDO(pinProp);
        pin.CreateKeyFromSDO(data);
        return pin;
    }

    @Override
    public void deactivateObject(int keyType, byte keyID) throws AkisCIFException, AkisCardException, AkisSWException {
        if (!this.queryObject(keyType, keyID)) {
            throw new AkisCIFException("Object is not present.");
        }
    }

    @Override
    public boolean queryObject(int keyType, byte keyID) throws AkisCardException, AkisCIFException, AkisSWException {
        byte[] queryObject = new byte[]{0, -53, 63, -1, 8, 77, 6, -65, (byte)keyType, keyID, 2, -96, -128, 0};
        try {
            this.sendCommand(queryObject);
        }
        catch (AkisSWException ex) {
            if (ex.mAkisErrorCode == 27272L) {
                return false;
            }
            if (ex.mAkisErrorCode == 27010L) {
                return true;
            }
            throw ex;
        }
        return true;
    }

    protected void putDataSDO(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandTemplate = new byte[]{0, -37, 63, -1};
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                byte[] command = new byte[commandTemplate.length + 1 + dataPartLen];
                System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
                command[commandTemplate.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, command, commandTemplate.length + 1, dataPartLen);
                if (remaining > 196) {
                    command[0] = (byte)(command[0] | 0x10);
                }
                this.sendCommand(command);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            byte[] command = new byte[commandTemplate.length + 1 + data.length];
            command[commandTemplate.length] = (byte)data.length;
            System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
            System.arraycopy(data, 0, command, commandTemplate.length + 1, data.length);
            this.sendCommand(command);
        }
    }

    protected byte[] getDataSDO(byte[] dataTemplate) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataSDOTemplate = new byte[]{0, -53, 63, -1, 0};
        byte[] getData = new byte[getDataSDOTemplate.length + dataTemplate.length + 1];
        int index = 0;
        System.arraycopy(getDataSDOTemplate, 0, getData, index, getDataSDOTemplate.length);
        getData[(index += getDataSDOTemplate.length) - 1] = (byte)dataTemplate.length;
        System.arraycopy(dataTemplate, 0, getData, index, dataTemplate.length);
        getData[index += dataTemplate.length] = 0;
        ResponseAPDU response = this.sendCommand(getData);
        return response.getData();
    }

    @Override
    public RSAKey genKeyPair(int modLen, byte[] pubExp, ARR arrRec, byte keyID) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] pubKeyData = new byte[512];
        byte[] mod = new byte[modLen];
        byte[] p = new byte[modLen / 2];
        byte[] genApdu = new byte[]{0, 71, 0, 0, 5, 77, 3, -65, -112, keyID, 0};
        SDOHeader hdr = new SDOHeader(keyID, null, 0, 0, 0, 0, arrRec, null, null);
        RSAKey pub = new RSAKey(hdr, mod, pubExp, null, 0);
        RSAKey pri = new RSAKey(hdr, p, p, p, p, p, mod);
        byte[] data = pub.CreateSDOHeaderList(KeyType.PUBLIC_RSA, false);
        this.putDataSDO(data);
        data = pub.CreateSDOHeaderList(KeyType.PUBLIC_RSA, true);
        this.putDataSDO(data);
        data = pub.SDOUpdate(KeyType.PUBLIC_RSA, 130);
        this.putDataSDO(data);
        data = pri.CreateSDOHeaderList(KeyType.PRIVATE_RSA, false);
        this.putDataSDO(data);
        data = pri.CreateSDOHeaderList(KeyType.PRIVATE_RSA, true);
        this.putDataSDO(data);
        ResponseAPDU response = this.sendCommand(genApdu);
        byte[] temp = Conversions.GetBerLen(response.getData().length);
        int i = 0;
        pubKeyData[i++] = -65;
        pubKeyData[i++] = -96;
        pubKeyData[i++] = keyID;
        System.arraycopy(temp, 0, pubKeyData, i, temp.length);
        System.arraycopy(response.getData(), 0, pubKeyData, i += temp.length, response.getData().length);
        byte[] pubKeyData1 = new byte[i += response.getData().length];
        System.arraycopy(pubKeyData, 0, pubKeyData1, 0, i);
        pub.CreateKeyFromSDO(pubKeyData1);
        return pub;
    }

    @Override
    public RSAKey genKeyPair(SDOHeader prvHeader, SDOHeader pubHeader, int modLen, byte[] pubExp) throws AkisCIFException, AkisSWException, AkisCardException {
        if (prvHeader.keyID != pubHeader.keyID) {
            throw new RuntimeException("Key ID mismatch in headers!");
        }
        byte[] pubKeyData = new byte[512];
        byte[] mod = new byte[modLen];
        byte[] p = new byte[modLen / 2];
        byte[] genApdu = new byte[]{0, 71, 0, 0, 5, 77, 3, -65, -112, prvHeader.keyID, 0};
        RSAKey pub = new RSAKey(pubHeader, mod, pubExp, null, 0);
        RSAKey pri = new RSAKey(prvHeader, p, p, p, p, p, mod);
        byte[] data = pub.CreateSDOHeaderList(KeyType.PUBLIC_RSA, false);
        this.putDataSDO(data);
        data = pub.CreateSDOHeaderList(KeyType.PUBLIC_RSA, true);
        this.putDataSDO(data);
        data = pub.SDOUpdate(KeyType.PUBLIC_RSA, 130);
        this.putDataSDO(data);
        data = pri.CreateSDOHeaderList(KeyType.PRIVATE_RSA, false);
        this.putDataSDO(data);
        data = pri.CreateSDOHeaderList(KeyType.PRIVATE_RSA, true);
        this.putDataSDO(data);
        ResponseAPDU response = this.sendCommand(genApdu);
        byte[] temp = Conversions.GetBerLen(response.getData().length);
        int i = 0;
        pubKeyData[i++] = -65;
        pubKeyData[i++] = -96;
        pubKeyData[i++] = prvHeader.keyID;
        System.arraycopy(temp, 0, pubKeyData, i, temp.length);
        System.arraycopy(response.getData(), 0, pubKeyData, i += temp.length, response.getData().length);
        byte[] pubKeyData1 = new byte[i += response.getData().length];
        System.arraycopy(pubKeyData, 0, pubKeyData1, 0, i);
        pub.CreateKeyFromSDO(pubKeyData1);
        return pub;
    }

    @Override
    public void activate(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        this.exchangeChallenge(data);
    }

    @Override
    public void activate(byte[] data, ActivationType type) throws AkisSWException, AkisCardException, AkisCIFException {
        byte p2 = 0;
        if (type == ActivationType.GEM) {
            p2 = 1;
        }
        this.exchangeChallengeWithP2(data, p2);
    }

    @Override
    public void verifyInit(byte[] initKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] startInit = new byte[22];
        byte[] startInit_part1 = new byte[]{-128, 2, -1, -1, 16};
        System.arraycopy(startInit_part1, 0, startInit, 0, startInit_part1.length);
        System.arraycopy(initKey, 0, startInit, startInit_part1.length, 16);
        startInit[21] = 0;
        this.sendCommand(startInit);
    }

    @Override
    public void verifyPerso(byte[] persoKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] verifyPerso = new byte[22];
        byte[] verifyPerso_part1 = new byte[]{-128, 8, -1, -1, 16};
        System.arraycopy(verifyPerso_part1, 0, verifyPerso, 0, verifyPerso_part1.length);
        System.arraycopy(persoKey, 0, verifyPerso, verifyPerso_part1.length, 16);
        verifyPerso[21] = 0;
        this.sendCommand(verifyPerso);
    }

    @Override
    public void putData(P1P2 params, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        if (params == null || data == null || data.length == 0) {
            throw new AkisCIFException("Invalid input parameter");
        }
        byte[] putData = new byte[5 + data.length];
        byte[] putDataPart1 = new byte[]{0, -38, params.getp1(), params.getp2()};
        System.arraycopy(putDataPart1, 0, putData, 0, putDataPart1.length);
        putData[4] = Byte.valueOf(Integer.toString(data.length));
        System.arraycopy(data, 0, putData, 5, data.length);
        this.sendCommand(putData);
    }

    @Override
    public byte[] getData(byte mode) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataCommand = new byte[]{0, -54, 1, 0, 0};
        int Le = 0;
        if (mode == GetDataModes.copyright) {
            Le = 28;
        } else if (mode == GetDataModes.chip) {
            Le = 2;
        } else if (mode == GetDataModes.atr) {
            Le = 23;
        } else if (mode == GetDataModes.memory) {
            Le = 7;
        } else if (mode == GetDataModes.cardType) {
            Le = 1;
        } else if (mode == GetDataModes.cardLabel) {
            Le = 32;
        } else if (mode == GetDataModes.romCheckSum) {
            Le = 2;
        } else if (mode == GetDataModes.userInfo) {
            Le = 16;
        } else if (mode == GetDataModes.versionInfo) {
            Le = this.manufacturer == Manufacturer.INF ? 31 : (this.manufacturer == Manufacturer.NXP ? 24 : 27);
        } else if (mode == GetDataModes.serialNumber) {
            Le = 8;
        } else if (mode == GetDataModes.oaoaPublicKey) {
            Le = -121;
        } else if (mode == GetDataModes.company) {
            Le = 16;
        } else if (mode == GetDataModes.applicationUnit) {
            Le = 8;
        } else if (mode == GetDataModes.cardSerialNumber) {
            Le = 8;
        } else if (mode == GetDataModes.currentDate) {
            Le = 4;
        } else if (mode == GetDataModes.atrOptionalBytes) {
            Le = 2;
        } else if (mode == GetDataModes.gemKeySeeds) {
            Le = 80;
        }
        getDataCommand[3] = mode;
        getDataCommand[getDataCommand.length - 1] = Le;
        ResponseAPDU response = this.sendCommand(getDataCommand);
        return response.getData();
    }

    @Override
    public byte[] getSerial() throws AkisSWException, AkisCardException, AkisCIFException {
        if (this.getLifeCycle() == LifeCycle.ACTIVATION) {
            return this.getSerialByKartTest();
        }
        return this.getData(GetDataModes.serialNumber);
    }

    @Override
    public byte[] getSerialForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.getSerialByKartTest();
    }

    @Override
    protected byte[] getSerialByKartTest() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] ins_1b = new byte[]{-128, 27, 0, 17, 0};
        ResponseAPDU response = this.sendCommand(ins_1b);
        return response.getData();
    }

    @Override
    protected byte[] getSerialGetData() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.getData(GetDataModes.serialNumber);
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        if (this.getLifeCycle() == LifeCycle.ACTIVATION) {
            return this.getSerialByKartTest();
        }
        return this.getData(GetDataModes.serialNumber);
    }

    @Override
    public int getEmptyMemory() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] cardMemoryInfo = this.getData(GetDataModes.memory);
        if (cardMemoryInfo.length < 7) {
            throw new AkisCIFException("Phase can not be recognized. Returned data is not in expected length.");
        }
        int emptyMemory = 0xFF & cardMemoryInfo[4];
        emptyMemory <<= 8;
        emptyMemory += 0xFF & cardMemoryInfo[5];
        emptyMemory <<= 8;
        return emptyMemory += 0xFF & cardMemoryInfo[6];
    }

    @Override
    public LifeCycle getLifeCycle() throws AkisCardException, AkisCIFException, AkisSWException {
        try {
            byte[] cardMemoryInfo = this.getData(GetDataModes.memory);
            if (cardMemoryInfo.length < 7) {
                throw new AkisCIFException("Phase can not be recognized. Returned data is not in expected length.");
            }
            byte bLifeCycle = cardMemoryInfo[this.phaseBytePosition];
            LifeCycle faz = LifeCycle.getLifeCycle(bLifeCycle);
            if (faz == null) {
                throw new AkisCIFException("Phase can not be recognized.");
            }
            return faz;
        }
        catch (AkisSWException ex) {
            if (ex.mAkisErrorCode == 27904L) {
                return LifeCycle.ACTIVATION;
            }
            throw ex;
        }
    }

    @Override
    public byte[] getFID(byte[] AID) throws AkisSWException, AkisCardException, AkisCIFException {
        this.selectMF();
        FCI retFCI = this.selectDFByName(AID);
        byte[] FID = retFCI.getTagValue((byte)-125);
        if (FID != null) {
            return FID;
        }
        throw new AkisCIFException("FID cannot be read parsed from returned FCI.");
    }

    @Override
    public void format(byte[] encrypted_ba, boolean toInitialization) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void format(byte[] arrMF) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] format = new byte[]{-128, 64, 0, 0, 24, 98, 22, -126, 1, 56, -125, 2, 63, 0, -118, 1, 5, -95, 10, -53, 3, 47, 0, 1, -52, 3, 47, 0, 1};
        format[21] = arrMF[0];
        format[22] = arrMF[1];
        format[26] = arrMF[0];
        format[27] = arrMF[1];
        this.sendCommand(format);
    }

    @Override
    public void format(byte[] arrMF, byte recordNo) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] format = new byte[]{-128, 64, 0, 0, 24, 98, 22, -126, 1, 56, -125, 2, 63, 0, -118, 1, 5, -95, 10, -53, 3, 47, 0, 1, -52, 3, 47, 0, 1};
        format[21] = arrMF[0];
        format[22] = arrMF[1];
        format[23] = recordNo;
        format[26] = arrMF[0];
        format[27] = arrMF[1];
        format[28] = recordNo;
        this.sendCommand(format);
    }

    @Override
    public void changePhaseToAdmin(byte[] adminPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changePhaseToOperation() {
        throw new UnsupportedVersionException();
    }

    @Override
    public void terminateCardUsage() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] terminateCommand = new byte[]{0, -2, 0, 0};
        this.sendCommand(terminateCommand);
    }

    @Override
    public byte[] getChallenge(int len) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = null;
        if (len > 0) {
            int responseDataLen;
            data = new byte[len];
            byte[] getCh = new byte[]{0, -124, 0, 0, 0};
            int offset = 0;
            for (int remainingLen = len; remainingLen > 0; remainingLen -= responseDataLen) {
                int expectedLen = remainingLen < 196 ? remainingLen : 196;
                getCh[4] = (byte)expectedLen;
                ResponseAPDU response = this.sendCommand(getCh);
                responseDataLen = response.getData().length;
                byte[] responseData = response.getData();
                System.arraycopy(responseData, 0, data, offset, responseDataLen);
                offset += responseDataLen;
            }
        }
        return data;
    }

    @Override
    public void verify(byte[] pin, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] verifyCommandTemplate = new byte[]{0, 32, 0, pinNo};
        if (!isMF) {
            verifyCommandTemplate[3] = (byte)(verifyCommandTemplate[3] | 0x80);
        }
        if (pin == null) {
            throw new AkisCIFException("Invalid parameter");
        }
        byte[] verifyCommand = new byte[verifyCommandTemplate.length + pin.length + 1];
        System.arraycopy(verifyCommandTemplate, 0, verifyCommand, 0, verifyCommandTemplate.length);
        verifyCommand[4] = (byte)pin.length;
        System.arraycopy(pin, 0, verifyCommand, 5, pin.length);
        this.sendCommand(verifyCommand);
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] queryCounter;
        byte[] remainingTryCounter;
        byte[] verifyCommandTemplate = new byte[]{30, 0, -126, 0, 0, 16, 6, 2, 1, 4, 9, 0, 0, 0, 0, 5, 0, 0, 0, 0, 32, 0, pinNo, 0};
        if (!isMF) {
            verifyCommandTemplate[22] = (byte)(verifyCommandTemplate[22] | 0x80);
        }
        if ((remainingTryCounter = this.getDataSDO(queryCounter = new byte[]{77, 10, -65, -127, 1, 6, -96, 4, -101, -128, -99, -128}))[8] == 1) {
            verifyCommandTemplate[5] = 22;
            verifyCommandTemplate[6] = 12;
        }
        this.sendCommandWithControl(verifyCommandTemplate);
    }

    @Override
    public void logout() {
        throw new UnsupportedVersionException();
    }

    @Override
    @Deprecated
    public void changeDFPIN(byte[] fid, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeMFPIN(byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeDFPIN(byte pinNo, byte[] oldPIN, byte[] newPIN) throws AkisCardException, AkisSWException, AkisCIFException {
        this.changePIN(pinNo, oldPIN, newPIN, false);
    }

    @Override
    public void changeMFPIN(byte pinNo, byte[] oldPIN, byte[] newPIN) throws AkisCardException, AkisSWException, AkisCIFException {
        this.changePIN(pinNo, oldPIN, newPIN, true);
    }

    protected void changePIN(byte pinNo, byte[] oldPIN, byte[] newPIN, boolean isMF) throws AkisCardException, AkisSWException, AkisCIFException {
        LifeCycle lc = this.getLifeCycle();
        if (lc == LifeCycle.OPERATION) {
            if (oldPIN == null || newPIN == null) {
                throw new AkisCIFException("Invalid parameter");
            }
            byte[] changepin = new byte[5 + oldPIN.length + newPIN.length];
            byte[] changepinTemplate = new byte[]{0, 36, 0, pinNo, 0};
            if (!isMF) {
                changepinTemplate[3] = (byte)(changepinTemplate[3] | 0x80);
            }
            changepinTemplate[4] = (byte)(newPIN.length + oldPIN.length);
            int index = 0;
            System.arraycopy(changepinTemplate, 0, changepin, index, changepinTemplate.length);
            System.arraycopy(oldPIN, 0, changepin, index += changepinTemplate.length, oldPIN.length);
            System.arraycopy(newPIN, 0, changepin, index += oldPIN.length, newPIN.length);
            this.sendCommand(changepin);
        } else {
            if (newPIN == null) {
                throw new AkisCIFException("Invalid parameter");
            }
            byte pinRef = pinNo;
            if (!isMF) {
                pinRef = (byte)(pinNo | 0x80);
            }
            byte[] updatePin = PIN.UpdatePIN(pinRef, newPIN);
            this.putDataSDO(updatePin);
        }
    }

    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void unlockDFPIN(byte pukNo, byte[] PUK, byte pinNo, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.unlockPIN(pukNo, PUK, pinNo, newPIN, false);
    }

    @Override
    public void unlockMFPIN(byte pukNo, byte[] PUK, byte pinNo, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.unlockPIN(pukNo, PUK, pinNo, newPIN, true);
    }

    protected void unlockPIN(byte pukNo, byte[] PUK, byte pinNo, byte[] newPIN, boolean isMF) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] resetRetryTemplate = new byte[]{0, 44, 0, pinNo};
        byte[] resetRetry = null;
        if (PUK != null) {
            this.verify(pukNo, PUK, isMF);
        }
        if (!isMF) {
            resetRetryTemplate[3] = (byte)(resetRetryTemplate[3] | 0x80);
        }
        if (newPIN != null) {
            resetRetryTemplate[2] = 2;
            resetRetry = new byte[5 + newPIN.length];
            resetRetry[4] = (byte)newPIN.length;
            int index = 0;
            System.arraycopy(resetRetryTemplate, 0, resetRetry, index, resetRetryTemplate.length);
            System.arraycopy(newPIN, 0, resetRetry, index += resetRetryTemplate.length + 1, newPIN.length);
            this.sendCommand(resetRetry);
        } else {
            resetRetryTemplate[2] = 3;
            this.sendCommand(resetRetryTemplate);
        }
    }

    public byte[] mutualAuthenticate(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] mauth1 = new byte[]{0, -126, 0, 0, 40};
        byte[] mauth = new byte[46];
        mauth[45] = 40;
        System.arraycopy(mauth1, 0, mauth, 0, 5);
        System.arraycopy(data, 0, mauth, 5, data.length);
        return this.sendCommand(mauth).getData();
    }

    @Override
    public byte[] internalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] internalAuthTmpl = new byte[]{0, -120, 0, 0, 16};
        if (data.length != 16) {
            throw new AkisCIFException("Invalid length");
        }
        byte[] mseData = this.generateMseData(signAlg, hashAlg, publicKeyIFD, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_SM);
        this.mseSet((byte)65, (byte)-92, mseData);
        byte[] internalAuth = new byte[22];
        System.arraycopy(internalAuthTmpl, 0, internalAuth, 0, 5);
        System.arraycopy(data, 0, internalAuth, 5, 16);
        internalAuth[21] = 0;
        return this.sendCommand(internalAuth).getData();
    }

    @Override
    public byte[] internalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte privateKeyICC, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] internalAuthTmpl = new byte[]{0, -120, 0, 0, 16};
        if (data.length != 16) {
            throw new AkisCIFException("Invalid length");
        }
        byte[] mseData = this.generateMseData(signAlg, hashAlg, null, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_CDS);
        this.mseSet((byte)65, (byte)-92, mseData);
        byte[] internalAuth = new byte[22];
        System.arraycopy(internalAuthTmpl, 0, internalAuth, 0, 5);
        System.arraycopy(data, 0, internalAuth, 5, 16);
        internalAuth[21] = 0;
        return this.sendCommand(internalAuth).getData();
    }

    @Override
    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, publicKeyIFD, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_SM);
        this.mseSet((byte)-127, (byte)-92, mseData);
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                byte[] externalAuth = new byte[externalAuthTmpl.length + dataPartLen + 2];
                System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
                externalAuth[externalAuthTmpl.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, externalAuth, externalAuthTmpl.length + 1, dataPartLen);
                externalAuth[externalAuth.length - 1] = 0;
                if (remaining > 196) {
                    externalAuth[0] = (byte)(externalAuth[0] | 0x10);
                }
                this.sendCommand(externalAuth);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            byte[] externalAuth = new byte[externalAuthTmpl.length + data.length + 2];
            externalAuth[externalAuthTmpl.length] = (byte)data.length;
            System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
            System.arraycopy(data, 0, externalAuth, externalAuthTmpl.length + 1, data.length);
            externalAuth[externalAuth.length - 1] = 0;
            this.sendCommand(externalAuth);
        }
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                byte[] externalAuth = new byte[externalAuthTmpl.length + dataPartLen + 2];
                System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
                externalAuth[externalAuthTmpl.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, externalAuth, externalAuthTmpl.length + 1, dataPartLen);
                externalAuth[externalAuth.length - 1] = 0;
                if (remaining > 196) {
                    externalAuth[0] = (byte)(externalAuth[0] | 0x10);
                }
                this.sendCommand(externalAuth);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            byte[] externalAuth = new byte[externalAuthTmpl.length + data.length + 2];
            externalAuth[externalAuthTmpl.length] = (byte)data.length;
            System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
            System.arraycopy(data, 0, externalAuth, externalAuthTmpl.length + 1, data.length);
            externalAuth[externalAuth.length - 1] = 0;
            this.sendCommand(externalAuth);
        }
    }

    @Override
    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyRole, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, publicKeyRole, (byte)0, AuthenticationType.ROLE_AUTH_SM);
        this.mseSet((byte)-127, (byte)-92, mseData);
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                byte[] externalAuth = new byte[externalAuthTmpl.length + dataPartLen + 2];
                System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
                externalAuth[externalAuthTmpl.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, externalAuth, externalAuthTmpl.length + 1, dataPartLen);
                externalAuth[externalAuth.length - 1] = 0;
                if (remaining > 196) {
                    externalAuth[0] = (byte)(externalAuth[0] | 0x10);
                }
                this.sendCommand(externalAuth);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            byte[] externalAuth = new byte[externalAuthTmpl.length + data.length + 2];
            externalAuth[externalAuthTmpl.length] = (byte)data.length;
            System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
            System.arraycopy(data, 0, externalAuth, externalAuthTmpl.length + 1, data.length);
            externalAuth[externalAuth.length - 1] = 0;
            this.sendCommand(externalAuth);
        }
    }

    @Override
    public byte[] externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, null, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_SM_CDS);
        this.mseSet((byte)-127, (byte)-92, mseData);
        this.getChallenge(8);
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                byte[] externalAuth = new byte[externalAuthTmpl.length + dataPartLen + 2];
                System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
                externalAuth[externalAuthTmpl.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, externalAuth, externalAuthTmpl.length + 1, dataPartLen);
                externalAuth[externalAuth.length - 1] = 0;
                if (remaining > 196) {
                    externalAuth[0] = (byte)(externalAuth[0] | 0x10);
                }
                response = this.sendCommand(externalAuth);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            byte[] externalAuth = new byte[externalAuthTmpl.length + data.length + 2];
            externalAuth[externalAuthTmpl.length] = (byte)data.length;
            System.arraycopy(externalAuthTmpl, 0, externalAuth, 0, externalAuthTmpl.length);
            System.arraycopy(data, 0, externalAuth, externalAuthTmpl.length + 1, data.length);
            externalAuth[externalAuth.length - 1] = 0;
            response = this.sendCommand(externalAuth);
        }
        return response.getData();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) throws AkisCIFException {
        byte[] algorithm = new byte[]{-128, 1, 0};
        byte[] publicKey = new byte[]{-125, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] privateKey = new byte[]{-124, 1, 0};
        if (publicKeyIFD != null && publicKeyIFD.length != 12) {
            throw new AkisCIFException("Invalid length");
        }
        int algID = 0;
        if (signAlg == Algorithm.ISO_9796_2_S_1 && hashAlg == Algorithm.SHA_1) {
            algID = 9;
        } else if (signAlg == Algorithm.ISO_9796_2_S_1 && hashAlg == Algorithm.SHA_256) {
            algID = 10;
        } else if (signAlg == Algorithm.ISO_9796_2_S_2 && hashAlg == Algorithm.SHA_1) {
            algID = 13;
        } else if (signAlg == Algorithm.ISO_9796_2_S_2 && hashAlg == Algorithm.SHA_256) {
            algID = 14;
        } else {
            throw new AkisCIFException("Invalid parameter");
        }
        if (authType == AuthenticationType.ASYM_DEVICE_AUTH_SM) {
            algorithm[2] = (byte)(algID | 0xE0);
        } else if (authType == AuthenticationType.ROLE_AUTH_SM) {
            algorithm[2] = (byte)(algID | 0x60);
        } else if (authType == AuthenticationType.ASYM_DEVICE_AUTH_CDS) {
            algorithm[2] = (byte)(algID | 0xD0);
        } else if (authType == AuthenticationType.ASYM_DEVICE_AUTH_SM_CDS) {
            algorithm[2] = (byte)(algID | 0xF0);
        }
        byte[] mseTemp = new byte[20];
        System.arraycopy(algorithm, 0, mseTemp, 0, 3);
        int index = 3;
        if (privateKeyICC != 0) {
            privateKey[2] = privateKeyICC;
            System.arraycopy(privateKey, 0, mseTemp, 3, 3);
            index += 3;
        }
        if (publicKeyIFD != null) {
            System.arraycopy(publicKeyIFD, 0, publicKey, 2, 12);
            System.arraycopy(publicKey, 0, mseTemp, index, 14);
            index += 14;
        }
        byte[] mseData = new byte[index];
        System.arraycopy(mseTemp, 0, mseData, 0, index);
        return mseData;
    }

    @Override
    public void mse(byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void mseSet(byte P1, byte P2, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] mseTempl = new byte[]{0, 34, P1, P2, 0};
        byte[] mse = new byte[mseTempl.length + data.length];
        System.arraycopy(mseTempl, 0, mse, 0, mseTempl.length);
        mse[mseTempl.length - 1] = (byte)data.length;
        System.arraycopy(data, 0, mse, mseTempl.length, data.length);
        this.sendCommand(mse);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte[] psoTempl = new byte[]{0, 42, psoMode.getp1(), psoMode.getp2()};
        byte[] pso = null;
        if (data.length > 196) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 196 ? 196 : remaining;
                pso = new byte[psoTempl.length + dataPartLen + 2];
                System.arraycopy(psoTempl, 0, pso, 0, psoTempl.length);
                pso[psoTempl.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, pso, psoTempl.length + 1, dataPartLen);
                pso[pso.length - 1] = 0;
                if (remaining > 196) {
                    pso[0] = (byte)(pso[0] | 0x10);
                }
                response = this.sendCommand(pso);
                offset += dataPartLen;
            } while ((remaining -= 196) > 0);
        } else {
            pso = new byte[psoTempl.length + data.length + 2];
            pso[psoTempl.length] = (byte)data.length;
            System.arraycopy(psoTempl, 0, pso, 0, psoTempl.length);
            System.arraycopy(data, 0, pso, psoTempl.length + 1, data.length);
            pso[pso.length - 1] = 0;
            response = this.sendCommand(pso);
        }
        return response.getData();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] sign(Algorithm signAlg, Algorithm hashAlg, byte keyID, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] mseDataTempl = new byte[]{-128, 1, 0, -124, 1, 0};
        Object mseData = null;
        int algID = 0;
        if (signAlg == Algorithm.PKCS_1_5) {
            algID = -126;
        } else if (signAlg == Algorithm.PKCS_PSS) {
            algID = -127;
        } else {
            throw new AkisCIFException("Invalid parameter");
        }
        if (signAlg == Algorithm.PKCS_PSS) {
            if (hashAlg == Algorithm.SHA_1) {
                algID = (byte)(algID | 8);
            } else if (hashAlg == Algorithm.SHA_256) {
                algID = (byte)(algID | 0x10);
            } else {
                throw new AkisCIFException("Invalid parameter");
            }
        }
        mseDataTempl[2] = algID;
        mseDataTempl[5] = keyID;
        this.mseSet((byte)65, (byte)-74, mseDataTempl);
        return this.pso(this.pso_param.cds, data);
    }

    @Override
    public byte[] decrypt(Algorithm decAlg, Algorithm hashAlg, byte keyID, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] mseData = new byte[]{-128, 1, 0, -124, 1, keyID};
        int algID = 0;
        if (decAlg == Algorithm.OAEP) {
            algID = -64;
        } else if (decAlg == Algorithm.PKCS_1_5) {
            algID = -96;
        } else {
            throw new AkisCIFException("Invalid parameter");
        }
        if (decAlg == Algorithm.OAEP) {
            if (hashAlg == Algorithm.SHA_1) {
                algID = (byte)(algID | 4);
            } else if (hashAlg == Algorithm.SHA_256) {
                algID = (byte)(algID | 8);
            } else {
                throw new AkisCIFException("Invalid parameter");
            }
        }
        mseData[2] = algID;
        this.mseSet((byte)65, (byte)-72, mseData);
        return this.pso(this.pso_param.dec, data);
    }

    @Override
    public void verifyCertificate(Algorithm signAlg, Algorithm hashAlg, byte[] cvCert) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] key = new byte[]{1};
        this.VerifyCertificate(signAlg, hashAlg, key, cvCert);
    }

    @Override
    public void verifyCertificate(Algorithm signAlg, Algorithm hashAlg, byte[] keyref, byte[] cvCert) throws AkisCIFException, AkisSWException, AkisCardException {
        if (keyref.length != 12) {
            throw new AkisCIFException("Invalid length");
        }
        this.VerifyCertificate(signAlg, hashAlg, keyref, cvCert);
    }

    protected void VerifyCertificate(Algorithm signAlg, Algorithm hashAlg, byte[] key, byte[] cvCert) throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] data;
        byte[] dataTempl = new byte[]{-128, 1, 0, -125, 1, 0};
        int dataLen = 0;
        int algID = 0;
        if (signAlg == Algorithm.ISO_9796_2_S_1) {
            algID = (byte)(algID | 5);
        } else if (signAlg == Algorithm.ISO_9796_2_S_2) {
            algID = (byte)(algID | 6);
        } else {
            throw new AkisCIFException("Invalid parameter");
        }
        if (hashAlg == Algorithm.SHA_1) {
            algID = (byte)(algID | 8);
        } else if (hashAlg == Algorithm.SHA_256) {
            algID = (byte)(algID | 0x10);
        } else {
            throw new AkisCIFException("Invalid parameter");
        }
        dataTempl[2] = algID;
        if (key.length == 1) {
            dataTempl[5] = key[0];
            dataLen = 6;
            data = new byte[dataLen];
            System.arraycopy(dataTempl, 0, data, 0, dataLen);
        } else {
            dataTempl[4] = 12;
            dataLen = 17;
            data = new byte[dataLen];
            System.arraycopy(dataTempl, 0, data, 0, 5);
            System.arraycopy(key, 0, data, 5, 12);
        }
        this.mseSet((byte)-127, (byte)-74, data);
        this.pso(this.pso_param.cer, cvCert);
    }

    @Override
    public long[] getMechanisms() {
        long[] mechanisms = new long[]{13L, 1L, 9L, 544L, 592L};
        return mechanisms;
    }

    @Override
    public void activateSecureMsgingDeviceAuth(byte[] KICC, byte[] RICC, byte[] KIFD, byte[] RIFD) {
        this.generateSecureMessagingKey(KICC, RICC, KIFD, RIFD);
        this.isSecureMessagingActive = true;
    }

    @Override
    public void deactivateSecureMsging() {
        this.isSecureMessagingActive = false;
        int i = 0;
        for (i = 0; i < this.K_SM_ENC.length; ++i) {
            this.K_SM_ENC[i] = 0;
            this.K_SM_MAC[i] = 0;
        }
        for (i = 0; i < this.SSC.length; ++i) {
            this.SSC[i] = 0;
        }
    }

    protected void generateSecureMessagingKey(byte[] KICC, byte[] RICC, byte[] KIFD, byte[] RIFD) {
        byte[] K = new byte[32];
        for (int i = 0; i < 32; ++i) {
            K[i] = (byte)(KIFD[i] ^ KICC[i]);
        }
        byte[] c = new byte[]{0, 0, 0, 1};
        byte[] dataForHash = new byte[36];
        System.arraycopy(K, 0, dataForHash, 0, K.length);
        System.arraycopy(c, 0, dataForHash, K.length, c.length);
        this.K_SM_ENC = Crypto.computeHashValue(dataForHash, "SHA-256");
        c[3] = 2;
        System.arraycopy(K, 0, dataForHash, 0, K.length);
        System.arraycopy(c, 0, dataForHash, K.length, c.length);
        this.K_SM_MAC = Crypto.computeHashValue(dataForHash, "SHA-256");
        this.SSC = new byte[16];
        System.arraycopy(RICC, 0, this.SSC, 0, 8);
        System.arraycopy(RIFD, 0, this.SSC, 8, 8);
    }

    @Override
    protected void decideSecureMessageKeyGeneratingKey() {
    }

    @Override
    protected void generateSecureMessagingKey() {
        throw new UnsupportedVersionException();
    }

    @Override
    protected void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) {
        throw new UnsupportedVersionException();
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisSWException, AkisCardException, AkisCIFException {
        byte p2 = 0;
        return this.exchangeChallengeWithP2(encryptedRandomNumber, p2);
    }

    private byte[] exchangeChallengeWithP2(byte[] encryptedRandomNumber, byte p2) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte[] commandTemplate = new byte[]{-128, -122, 0, 0};
        commandTemplate[3] = p2;
        if (encryptedRandomNumber.length > 248) {
            int remaining = encryptedRandomNumber.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 248 ? 248 : remaining;
                byte[] command = new byte[commandTemplate.length + 1 + dataPartLen];
                System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
                command[commandTemplate.length] = (byte)dataPartLen;
                System.arraycopy(encryptedRandomNumber, offset, command, commandTemplate.length + 1, dataPartLen);
                if (remaining > 248) {
                    command[0] = (byte)(command[0] | 0x10);
                }
                response = this.sendCommand(command);
                offset += dataPartLen;
            } while ((remaining -= 248) > 0);
        } else {
            byte[] command = new byte[commandTemplate.length + 1 + encryptedRandomNumber.length];
            command[commandTemplate.length] = (byte)encryptedRandomNumber.length;
            System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
            System.arraycopy(encryptedRandomNumber, 0, command, commandTemplate.length + 1, encryptedRandomNumber.length);
            response = this.sendCommand(command);
        }
        return response.getData();
    }

    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisCIFException {
        int plainCommandLen = command.length;
        int dataBlock87Len = 0;
        int dataBlock97Len = 0;
        int dataBlock8ELen = 18;
        byte[] dataBlock87 = null;
        byte[] dataBlock97 = null;
        if (plainCommandLen > 5) {
            int dataLen = command[4] & 0xFF;
            int encdDataLen = 16 - dataLen % 16 + dataLen + 1;
            dataBlock87Len = encdDataLen >= 256 ? 16 - dataLen % 16 + dataLen + 5 : (encdDataLen >= 128 ? 16 - dataLen % 16 + dataLen + 4 : 16 - dataLen % 16 + dataLen + 3);
        }
        if (plainCommandLen >= 5 && (plainCommandLen == 5 || plainCommandLen == (command[4] & 0xFF) + 6)) {
            dataBlock97Len = 3;
        }
        int arrayIndex = 0;
        byte[] createdCommand = new byte[5 + dataBlock87Len + dataBlock97Len + dataBlock8ELen + 1];
        createdCommand[0] = (byte)(command[0] | 0xC);
        System.arraycopy(command, 1, createdCommand, ++arrayIndex, 3);
        arrayIndex += 3;
        createdCommand[arrayIndex++] = 0;
        this.incrementSSC();
        if (dataBlock87Len > 0) {
            dataBlock87 = this.createDataBlock87(command);
            System.arraycopy(dataBlock87, 0, createdCommand, arrayIndex, dataBlock87Len);
            arrayIndex += dataBlock87Len;
        }
        if (dataBlock97Len > 0) {
            dataBlock97 = this.createDataBlock97(command);
            System.arraycopy(dataBlock97, 0, createdCommand, arrayIndex, dataBlock97Len);
            arrayIndex += dataBlock97Len;
        }
        byte[] header = new byte[4];
        System.arraycopy(createdCommand, 0, header, 0, 4);
        byte[] paddedHeader = Crypto.padData(header, 16);
        if (dataBlock8ELen > 0) {
            byte[] dataBlock8E = this.createDataBlock8E(paddedHeader, dataBlock87, dataBlock97);
            System.arraycopy(dataBlock8E, 0, createdCommand, arrayIndex, dataBlock8ELen);
            arrayIndex += dataBlock8ELen;
        }
        int lc = dataBlock87Len + dataBlock97Len + dataBlock8ELen;
        createdCommand[4] = (byte)lc;
        createdCommand[createdCommand.length - 1] = 0;
        return createdCommand;
    }

    protected byte[] createDataBlock87(byte[] command) throws AkisCIFException {
        byte[] data = new byte[command[4] & 0xFF];
        System.arraycopy(command, 5, data, 0, data.length);
        byte[] paddeddata = Crypto.padData(data, 16);
        byte[] IV = Crypto.aes(this.K_SM_ENC, this.SSC, true);
        byte[] aesData = Crypto.aesCBC(this.K_SM_ENC, IV, paddeddata, true);
        int dataIndex = 0;
        int dataLen = aesData.length;
        dataIndex = dataLen >= 256 ? 5 : (dataLen >= 128 ? 4 : 3);
        byte[] DOB87 = new byte[aesData.length + dataIndex];
        System.arraycopy(aesData, 0, DOB87, dataIndex, aesData.length);
        DOB87[0] = -121;
        byte[] berLen = Conversions.GetBerLen(dataLen + 1);
        int berLenCount = berLen.length;
        System.arraycopy(berLen, 0, DOB87, 1, berLenCount);
        DOB87[berLenCount + 1] = 1;
        return DOB87;
    }

    protected byte[] createDataBlock97(byte[] command) {
        byte Le = command[command.length - 1];
        byte[] DOB97 = new byte[]{-105, 1, Le};
        return DOB97;
    }

    protected byte[] createDataBlock8E(byte[] paddedHeader, byte[] DOB87, byte[] DOB97) throws AkisCIFException {
        int inputLen = paddedHeader.length;
        if (DOB87 != null) {
            inputLen += DOB87.length;
        }
        if (DOB97 != null) {
            inputLen += DOB97.length;
        }
        byte[] checkSumInput = new byte[inputLen];
        int arrayIndex = 0;
        System.arraycopy(paddedHeader, 0, checkSumInput, arrayIndex, paddedHeader.length);
        arrayIndex += paddedHeader.length;
        if (DOB87 != null) {
            System.arraycopy(DOB87, 0, checkSumInput, arrayIndex, DOB87.length);
            arrayIndex += DOB87.length;
        }
        if (DOB97 != null) {
            System.arraycopy(DOB97, 0, checkSumInput, arrayIndex, DOB97.length);
            arrayIndex += DOB97.length;
        }
        byte[] datawithSSC = new byte[checkSumInput.length + this.SSC.length];
        System.arraycopy(this.SSC, 0, datawithSSC, 0, this.SSC.length);
        System.arraycopy(checkSumInput, 0, datawithSSC, this.SSC.length, checkSumInput.length);
        byte[] mac = Crypto.retailMacAes(datawithSSC, this.K_SM_MAC);
        byte[] block8E = new byte[mac.length + 2];
        block8E[0] = -114;
        block8E[1] = (byte)mac.length;
        System.arraycopy(mac, 0, block8E, 2, mac.length);
        return block8E;
    }

    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisCIFException {
        int responseLen = response.length;
        byte[] SW = new byte[2];
        byte[] CC = new byte[16];
        byte[] paddedOpenData = null;
        byte[] openData = null;
        int dataBlock99Len = 4;
        int dataBlock8ELen = 18;
        int dataBlock87Len = 0;
        int encryptedDataIndex = 0;
        int indexSW = 2;
        int indexCC = 6;
        this.incrementSSC();
        if (responseLen > 16 && response[0] == -121) {
            if (response[1] == -126) {
                dataBlock87Len = (response[2] & 0xFF) * 256 + (response[2] & 0xFF) + 3;
                encryptedDataIndex = 5;
            }
            if (response[1] == -127) {
                dataBlock87Len = (response[2] & 0xFF) + 3;
                encryptedDataIndex = 4;
            } else {
                dataBlock87Len = (response[1] & 0xFF) + 2;
                encryptedDataIndex = 3;
            }
            indexSW += dataBlock87Len;
            indexCC += dataBlock87Len;
            byte[] toBeDecryptedData = new byte[dataBlock87Len - encryptedDataIndex];
            System.arraycopy(response, encryptedDataIndex, toBeDecryptedData, 0, dataBlock87Len - encryptedDataIndex);
            byte[] IV = Crypto.aes(this.K_SM_ENC, this.SSC, true);
            paddedOpenData = Crypto.aesCBC(this.K_SM_ENC, IV, toBeDecryptedData, false);
            openData = Crypto.unPadData(paddedOpenData);
        }
        if (response[indexSW - 2] != -103) {
            throw new AkisCIFException("Status Word is not found.");
        }
        System.arraycopy(response, indexSW, SW, 0, 2);
        if (response[indexCC - 2] != -114) {
            throw new AkisCIFException("Checksum datablock is not found.");
        }
        System.arraycopy(response, indexCC, CC, 0, 16);
        byte[] toBeCC = new byte[16 + response.length - 20];
        System.arraycopy(this.SSC, 0, toBeCC, 0, 16);
        System.arraycopy(response, 0, toBeCC, 16, response.length - 20);
        byte[] CC_Expected = Crypto.retailMacAes(toBeCC, this.K_SM_MAC);
        for (int i = 0; i < 16; ++i) {
            if (CC_Expected[i] == CC[i]) continue;
            throw new AkisCIFException("Checksum is not valid.");
        }
        byte[] openResponse = null;
        if (openData != null) {
            openResponse = new byte[openData.length + 2];
            System.arraycopy(openData, 0, openResponse, 0, openData.length);
            System.arraycopy(SW, 0, openResponse, openData.length, 2);
        } else {
            openResponse = new byte[2];
            System.arraycopy(SW, 0, openResponse, 0, 2);
        }
        return openResponse;
    }

    protected void incrementSSC() {
        int len = this.SSC.length;
        for (int i = 0; i < len; ++i) {
            int n = len - 1 - i;
            this.SSC[n] = (byte)(this.SSC[n] + 1);
            if (this.SSC[len - 1 - i] != 0) break;
        }
    }
}

