/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import java.util.Arrays;

public class ARR {
    private byte tag = 0;
    private byte len = (byte)3;
    private byte[] fidCB;
    private byte[] fidCL;
    private byte recordNumberCB;
    private byte recordNumberCL;

    public ARR(byte tag, byte len, byte[] fidCB, byte[] fidCL, byte recordNumberCB, byte recordNumberCL) {
        this.tag = tag;
        this.len = len;
        if (fidCB != null) {
            this.fidCB = Arrays.copyOf(fidCB, fidCB.length);
        }
        if (fidCL != null) {
            this.fidCL = Arrays.copyOf(fidCL, fidCL.length);
        }
        this.recordNumberCB = recordNumberCB;
        this.recordNumberCL = recordNumberCL;
    }

    public ARR(byte[] arrData) {
        if (arrData.length == 5) {
            if (arrData[0] == -53) {
                this.tag = arrData[0];
                this.fidCB = new byte[2];
                this.fidCB[0] = arrData[2];
                this.fidCB[1] = arrData[3];
                this.recordNumberCB = arrData[4];
            } else if (arrData[0] == -52) {
                this.tag = arrData[0];
                this.fidCL = new byte[2];
                this.fidCL[0] = arrData[2];
                this.fidCL[1] = arrData[3];
                this.recordNumberCL = arrData[4];
            }
        } else if (arrData.length == 10) {
            if (arrData[0] == -53) {
                this.fidCB = new byte[2];
                this.fidCB[0] = arrData[2];
                this.fidCB[1] = arrData[3];
                this.recordNumberCB = arrData[4];
                this.fidCL = new byte[2];
                this.fidCL[0] = arrData[7];
                this.fidCL[1] = arrData[8];
                this.recordNumberCL = arrData[9];
            } else if (arrData[0] == -52) {
                this.fidCL = new byte[2];
                this.fidCL[0] = arrData[2];
                this.fidCL[1] = arrData[3];
                this.recordNumberCL = arrData[4];
                this.fidCB = new byte[2];
                this.fidCB[0] = arrData[7];
                this.fidCB[1] = arrData[8];
                this.recordNumberCB = arrData[9];
            }
        }
    }

    public ARR(boolean isContactless, byte[] fid, byte recordNumber) {
        if (isContactless) {
            this.fidCL = new byte[2];
            this.tag = (byte)-52;
            this.fidCL[0] = fid[0];
            this.fidCL[1] = fid[1];
            this.recordNumberCL = recordNumber;
        } else {
            this.fidCB = new byte[2];
            this.tag = (byte)-53;
            this.fidCB[0] = fid[0];
            this.fidCB[1] = fid[1];
            this.recordNumberCB = recordNumber;
        }
    }

    public ARR(byte[] fidCB, byte recordNumberCB, byte[] fidCL, byte recordNumberCL) {
        this.fidCB = new byte[2];
        this.fidCB[0] = fidCB[0];
        this.fidCB[1] = fidCB[1];
        this.recordNumberCB = recordNumberCB;
        this.fidCL = new byte[2];
        this.fidCL[0] = fidCL[0];
        this.fidCL[1] = fidCL[1];
        this.recordNumberCL = recordNumberCL;
    }

    public byte[] toByteArray() {
        byte[] arrData;
        if (this.tag < 0) {
            arrData = new byte[5];
            if (this.recordNumberCB > 0) {
                arrData[0] = this.tag;
                arrData[1] = this.len;
                arrData[2] = this.fidCB[0];
                arrData[3] = this.fidCB[1];
                arrData[4] = this.recordNumberCB;
            } else {
                arrData[0] = this.tag;
                arrData[1] = this.len;
                arrData[2] = this.fidCL[0];
                arrData[3] = this.fidCL[1];
                arrData[4] = this.recordNumberCL;
            }
        } else {
            arrData = new byte[]{-53, this.len, this.fidCB[0], this.fidCB[1], this.recordNumberCB, -52, this.len, this.fidCL[0], this.fidCL[1], this.recordNumberCL};
        }
        return arrData;
    }

    public byte getTag() {
        return this.tag;
    }

    public byte getLen() {
        return this.len;
    }

    public byte[] getFidCB() {
        return this.fidCB;
    }

    public byte[] getFidCL() {
        return this.fidCL;
    }

    public byte getRecordNumberCB() {
        return this.recordNumberCB;
    }

    public byte getRecordNumberCL() {
        return this.recordNumberCL;
    }
}

