/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeaderGezgin;
import tubitak.akis.cif.functions.Conversions;

public class DiffieHellmanKey {
    public SDOHeaderGezgin header;
    private final byte[] prv;
    private byte[] pub;
    private byte[] modulus;

    public DiffieHellmanKey() {
        this.header = new SDOHeaderGezgin();
        this.prv = null;
        this.pub = null;
        this.modulus = null;
    }

    public DiffieHellmanKey(SDOHeaderGezgin header, byte[] prv, byte[] pub, byte[] modulus) {
        this.header = header;
        if (prv.length % 2 != 0) {
            this.prv = new byte[prv.length + 1];
            this.prv[0] = 0;
            System.arraycopy(prv, 0, this.prv, 1, prv.length);
        } else {
            this.prv = prv;
        }
        if (pub != null) {
            if (pub.length % 2 != 0) {
                this.pub = new byte[pub.length + 1];
                this.pub[0] = 0;
                System.arraycopy(pub, 0, this.pub, 1, pub.length);
            } else {
                this.pub = pub;
            }
        } else {
            this.pub = null;
        }
        if (modulus.length % 2 != 0) {
            this.modulus = new byte[modulus.length + 1];
            this.modulus[0] = 0;
            System.arraycopy(modulus, 0, this.modulus, 1, modulus.length);
        } else {
            this.modulus = modulus;
        }
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i = 0;
        byte[] headerList = new byte[256];
        if (this.header.effectiveDate != null && this.header.effectiveDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.expirationDate != null && this.header.expirationDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (keyType != KeyType.PRIVATE_DH) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = -65;
        headerList[i++] = -110;
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        int index = i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (keyType == KeyType.PRIVATE_DH && !op) {
            if (this.prv == null || this.modulus == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i++] = 127;
            headerList[i++] = 72;
            index = i;
            headerList[i++] = 0;
            headerList[i++] = -123;
            byte[] temp = Conversions.GetBerLen(this.prv.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            if (this.pub != null) {
                headerList[i++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, headerList, i, temp.length);
                i += temp.length;
            }
            headerList[i++] = -127;
            temp = Conversions.GetBerLen(this.modulus.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            headerList[index] = (byte)((i += temp.length) - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] CreateSDOHeaderListv10(KeyType keyType, boolean op) {
        int i = 0;
        int index = 0;
        byte[] headerList = new byte[256];
        if (this.header.effectiveDate != null && this.header.effectiveDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.expirationDate != null && this.header.expirationDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (keyType != KeyType.PRIVATE_DH) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = -65;
        headerList[i++] = -110;
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (keyType == KeyType.PRIVATE_DH && !op) {
            if (this.prv == null || this.modulus == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i++] = 127;
            headerList[i++] = 72;
            index = i;
            headerList[i++] = 0;
            headerList[i++] = -123;
            byte[] temp = Conversions.GetBerLen(this.prv.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            if (this.pub != null) {
                headerList[i++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, headerList, i, temp.length);
                i += temp.length;
            }
            headerList[i++] = -127;
            temp = Conversions.GetBerLen(this.modulus.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -126;
            temp = new byte[]{1};
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -125;
            temp = new byte[]{1};
            System.arraycopy(temp, 0, headerList, i, temp.length);
            headerList[index] = (byte)((i += temp.length) - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(KeyType keyType, int tag) {
        byte[] temp;
        int i = 0;
        byte[] data = new byte[512];
        byte[] sdo = new byte[512];
        sdo[0] = -65;
        sdo[2] = this.header.keyID;
        if (keyType == KeyType.PRIVATE_DH) {
            sdo[1] = -110;
            data[i++] = 127;
            data[i++] = 72;
            if (tag == 132 && this.pub != null) {
                temp = Conversions.GetBerLen(this.pub.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.pub, 0, data, i += temp.length, this.pub.length);
                i += this.pub.length;
            } else if (tag == 133) {
                temp = Conversions.GetBerLen(this.prv.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -123;
                temp = Conversions.GetBerLen(this.prv.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.prv, 0, data, i += temp.length, this.prv.length);
                i += this.prv.length;
            } else if (tag == 129) {
                temp = Conversions.GetBerLen(this.modulus.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -127;
                temp = Conversions.GetBerLen(this.modulus.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.modulus, 0, data, i += temp.length, this.modulus.length);
                i += this.modulus.length;
            }
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int dataLen = i;
        temp = Conversions.GetBerLen(dataLen);
        System.arraycopy(temp, 0, sdo, 3, temp.length);
        i = temp.length + 3;
        System.arraycopy(data, 0, sdo, i, dataLen);
        byte[] resizedData = new byte[dataLen + i];
        System.arraycopy(sdo, 0, resizedData, 0, dataLen + i);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 && sdo[1] != -110 && sdo[1] != -94) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int len = sdo[3] < 0 ? (sdo[3] & 0x7F) + 1 : 1;
        int i = 3 + len;
        if (sdo[i] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i + 1] == 73) {
            int n = len = sdo[i + 2] < 0 ? (sdo[i + 2] & 0x7F) + 1 : 1;
            if (sdo[i += len + 2] == -124) {
                len = sdo[i + 1] < 0 ? (sdo[i + 1] & 0x7F) + 1 : 1;
                this.pub = new byte[sdo.length - (i += len + 1)];
                System.arraycopy(sdo, i, this.pub, 0, this.pub.length);
            } else if (sdo[i] == -127) {
                len = sdo[i + 1] < 0 ? (sdo[i + 1] & 0x7F) + 1 : 1;
                this.modulus = new byte[sdo.length - (i += len + 1)];
                System.arraycopy(sdo, i, this.modulus, 0, this.modulus.length);
            }
        }
    }
}

