/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.ARR;
import tubitak.akis.cif.dataStructures.FDB;
import tubitak.akis.cif.functions.TLVParser;

public class FCI {
    protected byte[] fileProperties;
    protected int fileLength = -1;
    protected byte[] FDB = null;
    protected byte[] FID = null;
    protected byte[] DFName = null;
    protected byte[] FCI_FID = null;
    public byte SFI = 0;
    protected ARR ARR = null;
    public static byte FCI_6F = (byte)111;
    public static byte FCP_62 = (byte)98;

    public FCI() {
        this.fileProperties = null;
    }

    public FCI(byte[] TLVData) {
        if (TLVData != null && TLVData.length > 0) {
            this.fileProperties = TLVParser.getTagData(TLVData, FCI_6F);
            if (this.fileProperties == null) {
                this.fileProperties = TLVParser.getTagData(TLVData, FCP_62);
            }
            if (this.fileProperties != null) {
                byte[] value = TLVParser.getTagData(this.fileProperties, (byte)-128);
                if (value != null) {
                    this.fileLength = ((value[0] & 0xFF) << 8) + (value[1] & 0xFF);
                }
                this.FDB = TLVParser.getTagData(this.fileProperties, (byte)-126);
                this.FID = TLVParser.getTagData(this.fileProperties, (byte)-125);
                this.DFName = TLVParser.getTagData(this.fileProperties, (byte)-124);
                this.FCI_FID = TLVParser.getTagData(this.fileProperties, (byte)-121);
                byte[] data = TLVParser.getTagData(this.fileProperties, (byte)-120);
                if (data != null) {
                    this.SFI = (byte)(data[0] >> 3 & 0x1F);
                }
                if ((data = TLVParser.getTagData(this.fileProperties, (byte)-95)) != null) {
                    this.ARR = new ARR(data);
                }
            }
        }
    }

    public FCI(int fileLen, FDB fdb, byte[] fid, byte[] dfName, byte[] fci_fid, byte sfi, ARR arr) {
        if (dfName == null && fid == null || sfi == 0 && fid == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (fileLen > 0) {
            this.fileLength = fileLen;
        }
        if (fdb.toByteArray() == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.FDB = fdb.toByteArray();
        if (fid != null) {
            this.FID = new byte[fid.length];
            System.arraycopy(fid, 0, this.FID, 0, fid.length);
        }
        if (dfName != null) {
            this.DFName = new byte[dfName.length];
            System.arraycopy(dfName, 0, this.DFName, 0, dfName.length);
        }
        if (fci_fid != null) {
            this.FCI_FID = new byte[fci_fid.length];
            System.arraycopy(fci_fid, 0, this.FCI_FID, 0, fci_fid.length);
        }
        if (sfi != 0) {
            this.SFI = (byte)(sfi << 3);
        }
        if (arr.toByteArray() == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.ARR = arr;
    }

    public void setFCI(byte[] TLVData) {
        if (TLVData != null && TLVData.length > 0) {
            this.fileProperties = TLVParser.getTagData(TLVData, FCI_6F);
            if (this.fileProperties == null) {
                this.fileProperties = TLVParser.getTagData(TLVData, FCP_62);
            }
            if (this.fileProperties != null) {
                byte[] value = TLVParser.getTagData(this.fileProperties, (byte)-128);
                if (value != null) {
                    this.fileLength = ((value[0] & 0xFF) << 8) + (value[1] & 0xFF);
                }
                this.FDB = TLVParser.getTagData(this.fileProperties, (byte)-126);
                this.FID = TLVParser.getTagData(this.fileProperties, (byte)-125);
                this.DFName = TLVParser.getTagData(this.fileProperties, (byte)-124);
                this.FCI_FID = TLVParser.getTagData(this.fileProperties, (byte)-121);
                byte[] data = TLVParser.getTagData(this.fileProperties, (byte)-120);
                if (data != null) {
                    this.SFI = (byte)(data[0] >> 3 & 0x1F);
                }
                if ((data = TLVParser.getTagData(this.fileProperties, (byte)-95)) != null) {
                    this.ARR = new ARR(data);
                }
            }
        }
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(int length) {
        this.fileLength = length;
    }

    public byte[] getFDB() {
        return this.FDB;
    }

    public void setFDB(FDB fdb) {
        this.FDB = fdb.toByteArray();
    }

    public byte[] getFID() {
        return this.FID;
    }

    public void setFID(byte[] fid) {
        this.FID = new byte[fid.length];
        System.arraycopy(fid, 0, this.FID, 0, fid.length);
    }

    public byte[] getDFName() {
        return this.DFName;
    }

    public void setDFName(byte[] name) {
        this.DFName = new byte[name.length];
        System.arraycopy(name, 0, this.DFName, 0, name.length);
    }

    public byte[] getFCI_FID() {
        return this.FCI_FID;
    }

    public void setFCI_FID(byte[] fci_fid) {
        this.FCI_FID = new byte[fci_fid.length];
        System.arraycopy(fci_fid, 0, this.FCI_FID, 0, fci_fid.length);
    }

    public byte getSFI() {
        return this.SFI;
    }

    public void setSFI(byte sfi) {
        this.SFI = (byte)(sfi << 3);
    }

    public ARR getARR() {
        return this.ARR;
    }

    public void setARR(ARR arr) {
        this.ARR = arr;
    }

    public byte[] getTagValue(byte tag) {
        return TLVParser.getTagData(this.fileProperties, tag);
    }

    public byte[] getTagValue(byte[] TLVData, byte tag) {
        return TLVParser.getTagData(TLVData, tag);
    }
}

