/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPSignatureChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class SigningCertificateChecker
extends OCSPResponseChecker {
    private static final Logger d;
    private static final String e;

    @Override
    protected PathValidationResult _check(EOCSPResponse aOCSPResponse, OCSPResponseStatusInfo aOCSPResponseInfo) throws ESYAException {
        if (this.mParentSystem == null) {
            return null;
        }
        ECertificate eCertificate = aOCSPResponse.getBasicOCSPResponse().getCertificate(0);
        if (!this.a(eCertificate)) {
            d.error(e);
            aOCSPResponseInfo.addDetail(this, OCSPSignatureChecker.OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, false);
            return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
        }
        IssuerCheckParameters issuerCheckParameters = this.mParentSystem.getCheckSystem().getConstraintCheckParam();
        long l = issuerCheckParameters.getCertificateOrder();
        issuerCheckParameters.setCertificateOrder(-1L);
        CertificateController certificateController = new CertificateController();
        CertificateStatusInfo certificateStatusInfo = certificateController.check(this.mParentSystem, eCertificate);
        aOCSPResponseInfo.setSigningCertficateInfo(certificateStatusInfo);
        issuerCheckParameters.setCertificateOrder(l);
        if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
            aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.VALID, true);
            return PathValidationResult.SUCCESS;
        }
        aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.INVALID, false);
        return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
    }

    private boolean a(ECertificate eCertificate) {
        EExtendedKeyUsage eExtendedKeyUsage = eCertificate.getExtensions().getExtendedKeyUsage();
        return eExtendedKeyUsage == null || eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING);
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSP_IMZALAYAN_SERTIFIKA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                char[] cArray3 = "\u0005K&wv-F%E56i)M8O:\u007fq-\u001f\u0003e\u000fF:%R6G0wc-\\\u017d\u0006\u00aal\u007f S%\u01395x\u007flL-N5f:(Z\u0153O0".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 76;
                            break;
                        }
                        case 1: {
                            n6 = 38;
                            break;
                        }
                        case 2: {
                            n6 = 92;
                            break;
                        }
                        case 3: {
                            n6 = 22;
                            break;
                        }
                        case 4: {
                            n6 = 26;
                            break;
                        }
                        case 5: {
                            n6 = 76;
                            break;
                        }
                        default: {
                            n6 = 63;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        e = new String(cArray).intern();
        d = LoggerFactory.getLogger(SigningCertificateChecker.class);
    }

    public static final class SigningCertificateCheckStatus
    extends Enum<SigningCertificateCheckStatus>
    implements CheckStatus {
        public static final /* enum */ SigningCertificateCheckStatus VALID;
        public static final /* enum */ SigningCertificateCheckStatus INVALID;
        private static final /* synthetic */ SigningCertificateCheckStatus[] a;

        public static SigningCertificateCheckStatus[] values() {
            return (SigningCertificateCheckStatus[])a.clone();
        }

        public static SigningCertificateCheckStatus valueOf(String name) {
            return Enum.valueOf(SigningCertificateCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case VALID: {
                    return CertI18n.message((String)CertI18n.IMZALAYAN_SERTIFIKA_GECERLI);
                }
                case INVALID: {
                    return CertI18n.message((String)CertI18n.IMZALAYAN_SERTIFIKA_GECERSIZ);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var6 = new String[2];
                var4_1 = 0;
                var3_2 = "r\r?\u00141y\t\u0005m\u0002%\u001c9";
                var5_3 = "r\r?\u00141y\t\u0005m\u0002%\u001c9".length();
                var2_4 = 7;
                var1_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var6[var4_1++] = new String(v0).intern();
                    if ((var1_5 += var2_4) < var5_3) {
                        var2_4 = var3_2.charAt(var1_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var1_5;
                v2 = var3_2.substring(v1, v1 + var2_4).toCharArray();
                var7_6 = 0;
                v3 = v2.length;
                v4 = v2;
                v5 = v3;
                if (v3 > 1) ** GOTO lbl59
                do {
                    v6 = v4;
                    v7 = v4;
                    v8 = var7_6;
                    while (true) {
                        v9 = v6[v8];
                        switch (var7_6 % 7) {
                            case 0: {
                                v10 = 59;
                                break;
                            }
                            case 1: {
                                v10 = 67;
                                break;
                            }
                            case 2: {
                                v10 = 105;
                                break;
                            }
                            case 3: {
                                v10 = 85;
                                break;
                            }
                            case 4: {
                                v10 = 125;
                                break;
                            }
                            case 5: {
                                v10 = 48;
                                break;
                            }
                            default: {
                                v10 = 77;
                            }
                        }
                        v6[v8] = (char)(v9 ^ v10);
                        ++var7_6;
                        v4 = v7;
                        v5 = v5;
                        if (v5 != 0) break;
                        v7 = v4;
                        v11 = v5;
                        v8 = v5;
                        v6 = v4;
                    }
lbl59:
                    // 2 sources

                    v0 = v4;
                    v11 = v5;
                } while (v5 > var7_6);
                ** while (true)
            }
            var0_7 = var6;
            SigningCertificateCheckStatus.VALID = new SigningCertificateCheckStatus();
            SigningCertificateCheckStatus.INVALID = new SigningCertificateCheckStatus();
            SigningCertificateCheckStatus.a = new SigningCertificateCheckStatus[]{SigningCertificateCheckStatus.VALID, SigningCertificateCheckStatus.INVALID};
        }
    }
}

