/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.FindSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationFromOCSPChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevocationCheckResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevokeCheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class RevocationFromInitialOCSPChecker
extends RevocationChecker {
    private static final Logger e;
    private static final String j;

    @Override
    protected RevokeCheckStatus _check(ECertificate aIssuerCertificate, CertificateStatusInfo aCertificateStatusInfo) throws ESYAException {
        block12: {
            ESingleResponse eSingleResponse;
            block13: {
                if (this.mParentSystem == null) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                ECertificate eCertificate = aCertificateStatusInfo.getCertificate();
                FindSystem findSystem = this.mParentSystem.getFindSystem();
                EOCSPResponse eOCSPResponse = findSystem.findOCSPResponseFromInitial(this.mParentSystem, aIssuerCertificate, aCertificateStatusInfo);
                if (eOCSPResponse == null) {
                    e.debug(j + eCertificate.getSubject().stringValue());
                    aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(this.getCheckText(), RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND.getText(), (CheckStatus)RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND, RevokeCheckStatus.CANT_CHECK));
                    return RevokeCheckStatus.CANT_CHECK;
                }
                OCSPResponseController oCSPResponseController = new OCSPResponseController();
                OCSPResponseStatusInfo oCSPResponseStatusInfo = oCSPResponseController.check(this.mParentSystem, eOCSPResponse);
                aCertificateStatusInfo.addOCSPResponseInfo(oCSPResponseStatusInfo);
                eSingleResponse = eOCSPResponse.getSingleResponse();
                eOCSPResponse = null;
                if (oCSPResponseStatusInfo.getOCSPResponseStatus() != OCSPResponseStatusInfo.OCSPResponseStatus.VALID) break block12;
                if (eSingleResponse.getCertificateStatus() != 1) break block13;
                aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED);
                return RevokeCheckStatus.NOT_REVOKED;
            }
            if (eSingleResponse.getCertificateStatus() == 2) {
                Calendar calendar = eSingleResponse.getRevocationTime();
                Calendar calendar2 = this.mParentSystem.getBaseValidationTime();
                if (calendar2.after(calendar)) {
                    RevocationStatusInfo revocationStatusInfo = new RevocationStatusInfo();
                    revocationStatusInfo.setRevocationDate(eSingleResponse.getRevocationTime().getTime());
                    revocationStatusInfo.setRevocationCause(eSingleResponse.getRevokationReason());
                    aCertificateStatusInfo.setRevocationInfo(revocationStatusInfo);
                    aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID, RevokeCheckStatus.REVOKED);
                    return RevokeCheckStatus.REVOKED;
                }
                aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED);
                return RevokeCheckStatus.NOT_REVOKED;
            }
        }
        aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPChecker.RevocationFromOCSPCheckStatus.INVALID_OCSP_RESPONSE, RevokeCheckStatus.CANT_CHECK);
        return RevokeCheckStatus.CANT_CHECK;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                char[] cArray3 = "\u0002,\t{fG;/)G@\u0005r\u0002a?\u0002|6N<2(Gi)Sr".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 65;
                            break;
                        }
                        case 1: {
                            n6 = 77;
                            break;
                        }
                        case 2: {
                            n6 = 103;
                            break;
                        }
                        case 3: {
                            n6 = 15;
                            break;
                        }
                        case 4: {
                            n6 = 70;
                            break;
                        }
                        case 5: {
                            n6 = 33;
                            break;
                        }
                        default: {
                            n6 = 82;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        j = new String(cArray).intern();
        e = LoggerFactory.getLogger(RevocationFromInitialOCSPChecker.class);
    }
}

