/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerMessageDumpHandler;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Asn1BerEncodeBuffer
extends Asn1EncodeBuffer {
    private static h a = h.a();

    public Asn1BerEncodeBuffer() {
        this.mByteIndex = this.mData.length - 1;
    }

    public Asn1BerEncodeBuffer(int n2) {
        super(n2);
        this.mByteIndex = n2 - 1;
    }

    protected void checkSize(int n2) {
        if (n2 > this.mByteIndex + 1) {
            int n3 = this.mData.length * 2;
            int n4 = this.mData.length - (this.mByteIndex + 1);
            int n5 = n2 + n4;
            if (n3 < n5) {
                n3 = n5;
            }
            byte[] byArray = new byte[n3];
            int n6 = n3 - n4;
            System.arraycopy(this.mData, this.mByteIndex + 1, byArray, n6, n4);
            this.mData = byArray;
            this.mByteIndex = n6 - 1;
        }
        a.lcheck(1);
    }

    public void copy(byte by) {
        if (this.mByteIndex < 0) {
            this.checkSize(1);
        }
        this.mData[this.mByteIndex--] = by;
    }

    public void copy(byte[] byArray) throws Asn1Exception {
        this.checkSize(byArray.length);
        this.mByteIndex -= byArray.length;
        System.arraycopy(byArray, 0, this.mData, this.mByteIndex + 1, byArray.length);
    }

    public void copy(byte[] byArray, int n2, int n3) throws Asn1Exception {
        this.checkSize(n3);
        this.mByteIndex -= n3;
        System.arraycopy(byArray, n2, this.mData, this.mByteIndex + 1, n3);
    }

    public void copy(String string) {
        int n2 = string.length();
        this.checkSize(n2);
        this.mByteIndex -= n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mData[this.mByteIndex + i2 + 1] = (byte)string.charAt(i2);
        }
    }

    public int encodeIdentifier(int n2) {
        boolean bl = true;
        int n3 = 0;
        int n4 = n2;
        do {
            if (this.mByteIndex < 0) {
                this.checkSize(1);
            }
            this.mData[this.mByteIndex] = (byte)(n4 % 128);
            if (!bl) {
                int n5 = this.mByteIndex;
                this.mData[n5] = (byte)(this.mData[n5] | 0x80);
            } else {
                bl = false;
            }
            --this.mByteIndex;
            ++n3;
        } while ((n4 /= 128) > 0);
        return n3;
    }

    public int encodeIntValue(long l2) {
        long l3;
        long l4 = l2;
        int n2 = 0;
        do {
            l3 = l4 % 256L;
            if ((l4 /= 256L) < 0L && l3 != 0L) {
                --l4;
            }
            this.copy((byte)l3);
            ++n2;
        } while (l4 != 0L && l4 != -1L);
        if (l2 > 0L && (l3 & 0x80L) == 128L) {
            this.copy((byte)0);
            ++n2;
        } else if (l2 < 0L && (l3 & 0x80L) == 0L) {
            this.copy((byte)-1);
            ++n2;
        }
        return n2;
    }

    public int encodeLength(int n2) {
        int n3 = 0;
        boolean bl = false;
        if (n2 >= 0) {
            bl = n2 > 127;
            int n4 = n2;
            do {
                if (this.mByteIndex < 0) {
                    this.checkSize(1);
                }
                this.mData[this.mByteIndex--] = (byte)(n4 % 256);
                ++n3;
            } while ((n4 /= 256) > 0);
        } else {
            boolean bl2 = bl = n2 == -9999;
        }
        if (bl) {
            if (this.mByteIndex < 0) {
                this.checkSize(1);
            }
            this.mData[this.mByteIndex--] = (byte)(n3 | 0x80);
            ++n3;
        }
        return n3;
    }

    public int encodeTag(Asn1Tag asn1Tag) {
        return this.encodeTag(asn1Tag.mClass, asn1Tag.mForm, asn1Tag.mIDCode);
    }

    public int encodeTag(short s2, short s3, int n2) {
        byte by = (byte)(s2 | s3);
        int n3 = 0;
        if (n2 < 31) {
            this.copy((byte)(by | n2));
            ++n3;
        } else {
            n3 += this.encodeIdentifier(n2);
            this.copy((byte)(by | 0x1F));
            ++n3;
        }
        a.lcheck(1);
        return n3;
    }

    public int encodeTagAndLength(Asn1Tag asn1Tag, int n2) {
        int n3 = this.encodeLength(n2);
        return n3 += this.encodeTag(asn1Tag);
    }

    public int encodeTagAndLength(short s2, short s3, int n2, int n3) {
        int n4 = this.encodeLength(n3);
        return n4 += this.encodeTag(s2, s3, n2);
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        int n2 = this.mByteIndex + 1;
        return new ByteArrayInputStream(this.mData, n2, this.mData.length - n2);
    }

    public InputStream getInputStream() {
        return this.getByteArrayInputStream();
    }

    public byte[] getMsgCopy() {
        int n2 = this.mByteIndex + 1;
        int n3 = this.mData.length - n2;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.mData, n2, byArray, 0, n3);
        return byArray;
    }

    public int getMsgLength() {
        int n2 = this.mByteIndex + 1;
        return this.mData.length - n2;
    }

    public void binDump(PrintStream printStream, String string) {
        Asn1BerDecodeBuffer asn1BerDecodeBuffer = new Asn1BerDecodeBuffer(this.getByteArrayInputStream());
        try {
            asn1BerDecodeBuffer.parse(new Asn1BerMessageDumpHandler(printStream));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void binDump() {
        super.binDump(null);
    }

    public void reset() {
        this.mByteIndex = this.mData.length - 1;
    }

    public String toString() {
        boolean bl = Asn1Exception.z;
        int n2 = this.mByteIndex + 1;
        int n3 = this.mData.length - n2;
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            Asn1Util.toHexString(this.mData[i2 + n2], stringBuffer);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        int n2 = this.mByteIndex + 1;
        outputStream.write(this.mData, n2, this.mData.length - n2);
    }

    public boolean isBER() {
        return true;
    }
}

