/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1MderDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1MderOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1Value;
import com.objsys.asn1j.runtime.Asn1ValueParseException;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.IntHolder;
import com.objsys.asn1j.runtime.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;

public class Asn1BitString
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 3);
    public static final short HEX = 0;
    public static final short BITS = 1;
    public static final short ASN1VALUE = 2;
    public static final short HEXBIN = 3;
    public static short mStringFormat = (short)3;
    public transient int numbits;
    public transient byte[] value;
    public boolean trimZeroBits;
    private static final long serialVersionUID = -8111143948369307678L;
    private static h d = h.a();

    public Asn1BitString() {
        this.numbits = 0;
        this.value = null;
        this.trimZeroBits = false;
    }

    public Asn1BitString(int n2, byte[] byArray) {
        this.numbits = n2;
        this.value = byArray;
        this.trimZeroBits = false;
    }

    public Asn1BitString(byte[] byArray) {
        this(byArray.length * 8, byArray);
    }

    public Asn1BitString(boolean[] blArray) {
        boolean bl = Asn1Exception.z;
        if (blArray == null) {
            throw new NullPointerException("Bit Values must not be null!");
        }
        this.a(blArray.length);
        int n2 = 0;
        int n3 = 128;
        int n4 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (blArray[i2]) {
                n4 |= n3;
            }
            if ((n3 >>= 1) != 0) continue;
            this.value[n2++] = (byte)n4;
            n3 = 128;
            n4 = 0;
            if (!bl) continue;
        }
        if (n3 != 128) {
            this.value[n2] = (byte)n4;
        }
    }

    public Asn1BitString(String string) throws Asn1ValueParseException {
        IntHolder intHolder = new IntHolder();
        this.value = Asn1Value.parseString(string, intHolder);
        this.numbits = intHolder.value;
        this.trimZeroBits = false;
    }

    public Asn1BitString(BitSet bitSet) {
        boolean bl = Asn1Exception.z;
        this.a(bitSet.length());
        int n2 = 0;
        int n3 = 128;
        int n4 = 0;
        for (int i2 = 0; i2 < bitSet.length(); ++i2) {
            if (bitSet.get(i2)) {
                n4 |= n3;
            }
            if ((n3 >>= 1) != 0) continue;
            this.value[n2++] = (byte)n4;
            n3 = 128;
            n4 = 0;
            if (!bl) continue;
        }
        if (n3 != 128) {
            this.value[n2] = (byte)n4;
        }
    }

    public void clear(int n2) {
        this.set(n2, false);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1BitString.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            int n7 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            while (!asn1BerDecodeContext.expired()) {
                int n8 = Asn1BitString.matchTag(asn1BerDecodeBuffer, TAG);
                if (n8 > 0) {
                    n4 += n8;
                    if (n5 == 0) {
                        this.a(n4 * 8);
                    } else {
                        this.b(n4 * 8);
                    }
                    n6 = n5;
                    asn1BerDecodeBuffer.read(this.value, n5, n8);
                    n5 = n4;
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n6 >= 0) {
                n7 = this.value[n6];
                if (n5 - n6 - 1 > 0) {
                    System.arraycopy(this.value, n6 + 1, this.value, n6, n5 - n6 - 1);
                }
                --n4;
            }
            if (n7 < 0 || n7 > 7) {
                throw new Asn1Exception("Invalid format of bit string: initial octet is invalid (" + n7 + ")");
            }
            this.b(n4 * 8 - n7);
            if (n3 == -9999) {
                Asn1BitString.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            if (n3 < 0) {
                throw new Asn1InvalidLengthException();
            }
            if (n3 != 0) {
                int n9 = n3 - 1;
                int n10 = asn1BerDecodeBuffer.read();
                if (n10 < 0) {
                    throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                }
                if (n10 < 0 || n10 > 7) {
                    throw new Asn1Exception("Invalid format of bit string: initial octet is invalid (" + n10 + ")");
                }
                if (n9 == 0 && n10 != 0) {
                    throw new Asn1InvalidLengthException();
                }
                this.numbits = n9 * 8 - n10;
                this.value = new byte[n9];
                asn1BerDecodeBuffer.read(this.value);
            } else {
                this.numbits = 0;
                this.value = null;
            }
        }
        asn1BerDecodeBuffer.setTypeCode((short)3);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        if (this.trimZeroBits) {
            this.numbits = asn1BerEncodeBuffer.trimBitString(this);
        }
        int n2 = (this.numbits + 7) / 8;
        int n3 = this.numbits % 8;
        if (n3 != 0) {
            n3 = 8 - n3;
            int n4 = n2 - 1;
            this.value[n4] = (byte)(this.value[n4] & ~((1 << n3) - 1));
        }
        if (n2 != 0) {
            asn1BerEncodeBuffer.copy(this.value, 0, n2);
        }
        asn1BerEncodeBuffer.copy((byte)n3);
        ++n2;
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        do {
            if ((n2 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            n3 += n2;
            asn1PerDecodeBuffer.byteAlign();
            if (n4 == 0) {
                this.a(n3);
            } else {
                this.b(n3);
            }
            asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, n4, n2);
            if (n2 < 16384) continue;
            n4 += n2 / 8;
        } while (n2 >= 16384);
        asn1PerDecodeBuffer.setTypeCode((short)3);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        if (l3 < 65536L) {
            this.numbits = (int)asn1PerDecodeBuffer.decodeLength(l2, l3);
            if (this.numbits > 0) {
                if (l2 != l3 || l3 > 16L) {
                    asn1PerDecodeBuffer.byteAlign();
                }
                this.a(this.numbits);
                asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, 0, this.numbits);
            }
        } else {
            Asn1BitString asn1BitString = new Asn1BitString();
            asn1BitString.decode(asn1PerDecodeBuffer);
            this.numbits = asn1BitString.numbits;
            this.value = asn1BitString.value;
        }
        asn1PerDecodeBuffer.setTypeCode((short)3);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, Object object) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.decode(asn1PerDecodeBuffer, l2, Long.MAX_VALUE);
        this.numbits = asn1BitString.numbits;
        this.value = asn1BitString.value;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Object object, long l2) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.decode(asn1PerDecodeBuffer, 0L, l2);
        this.numbits = asn1BitString.numbits;
        this.value = asn1BitString.value;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Object object, Object object2) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.decode(asn1PerDecodeBuffer);
        this.numbits = asn1BitString.numbits;
        this.value = asn1BitString.value;
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.trimZeroBits) {
            this.numbits = asn1PerEncodeBuffer.trimBitString(this);
        }
        int n2 = this.numbits;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = (int)asn1PerEncodeBuffer.encodeLength(n2)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeBits(this.value, n3, n4);
            }
            if ((n2 -= n4) <= 0) break;
            n3 += n4 / 8;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(this.numbits);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        if (this.trimZeroBits) {
            this.numbits = asn1PerEncodeBuffer.trimBitString(this);
            if ((long)this.numbits < l2) {
                this.numbits = (int)l2;
            }
        }
        if ((long)this.numbits >= l2 && (long)this.numbits <= l3) {
            if (l3 < 65536L) {
                asn1PerEncodeBuffer.encodeLength(this.numbits, l2, l3);
                if (this.numbits > 0) {
                    if (l2 != l3 || l3 > 16L) {
                        asn1PerEncodeBuffer.byteAlign();
                    }
                    asn1PerEncodeBuffer.encodeBits(this.value, 0, this.numbits);
                }
            } else {
                Asn1BitString asn1BitString = new Asn1BitString();
                asn1BitString.numbits = this.numbits;
                asn1BitString.value = this.value;
                asn1BitString.encode(asn1PerEncodeBuffer);
            }
        } else {
            throw new Asn1ConsVioException("Asn1BitString.length", this.numbits);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, Object object) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.numbits = this.numbits;
        asn1BitString.value = this.value;
        asn1BitString.encode(asn1PerEncodeBuffer, l2, Long.MAX_VALUE);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Object object, long l2) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.numbits = this.numbits;
        asn1BitString.value = this.value;
        asn1BitString.encode(asn1PerEncodeBuffer, 0L, l2);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Object object, Object object2) throws Asn1Exception, IOException {
        Asn1BitString asn1BitString = new Asn1BitString();
        asn1BitString.numbits = this.numbits;
        asn1BitString.value = this.value;
        asn1BitString.encode(asn1PerEncodeBuffer);
    }

    public void decode(Asn1MderDecodeBuffer asn1MderDecodeBuffer, int n2) throws Asn1Exception, IOException {
        int n3 = n2 / 8;
        this.a(n2);
        d.lcheck(1);
        asn1MderDecodeBuffer.read(this.value, 0, n3);
    }

    private void a(String string, int n2) {
        int n3;
        boolean bl = Asn1Exception.z;
        int n4 = 0;
        int n5 = string.length();
        for (n3 = 0; n3 < n5; ++n3) {
            if (Character.isSpaceChar(string.charAt(n3))) continue;
            ++n4;
            if (!bl) continue;
        }
        this.value = new byte[(n4 + 7) / 8];
        n3 = 0;
        int n6 = 128;
        for (int i2 = 0; i2 < n5; ++i2) {
            block7: {
                char c2;
                block6: {
                    c2 = string.charAt(i2);
                    if (Character.isSpaceChar(c2)) continue;
                    if (c2 != '1') break block6;
                    int n7 = n3;
                    this.value[n7] = (byte)(this.value[n7] | n6);
                    if (!bl) break block7;
                }
                if (c2 != '0') {
                    throw new Asn1Exception("Invalid format of bit string");
                }
            }
            if ((n6 >>= 1) != 0) continue;
            n6 = 128;
            ++n3;
            if (!bl) continue;
        }
        d.lcheck(n2);
        this.numbits = n4;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BIT_STRING";
        }
        if (this.numbits == 0) {
            asn1XerEncoder.indent();
            asn1XerEncoder.encodeEmptyElement(string);
        } else {
            asn1XerEncoder.encodeStartElement(string);
            asn1XerEncoder.encodeBinStrValue(this.value, this.numbits);
            asn1XerEncoder.encodeEndElement(string);
        }
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.a(string, 4);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2, String[] stringArray, int[] nArray) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BIT_STRING";
        }
        if (this.numbits == 0) {
            asn1XmlEncoder.indent();
            asn1XmlEncoder.encodeEmptyElement(string, string2);
        } else {
            boolean bl = false;
            asn1XmlEncoder.encodeStartElement(string, string2, true);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!this.isSet(nArray[i2])) continue;
                if (!bl) {
                    bl = true;
                } else {
                    asn1XmlEncoder.copy(" ");
                }
                asn1XmlEncoder.encodeNamedValueElement(stringArray[i2]);
            }
            if (!bl) {
                asn1XmlEncoder.encodeBinStrValue(this.value, this.numbits);
            }
            asn1XmlEncoder.encodeEndElement(string, string2);
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BIT_STRING";
        }
        if (this.numbits == 0) {
            asn1XmlEncoder.indent();
            asn1XmlEncoder.encodeEmptyElement(string, string2);
        } else {
            asn1XmlEncoder.encodeStartElement(string, string2, true);
            asn1XmlEncoder.encodeBinStrValue(this.value, this.numbits);
            asn1XmlEncoder.encodeEndElement(string, string2);
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public boolean isNamedBitStr(String string) {
        boolean bl = Asn1Exception.z;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return Character.isLetter(c2);
        }
        return false;
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        String string = asn1JsonDecodeBuffer.readString();
        this.a(string, 0);
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        int n2 = 128;
        asn1JsonOutputStream.write(34);
        for (int i2 = 0; i2 < this.numbits; ++i2) {
            int n3 = (this.value[i2 / 8] & n2) != 0 ? 49 : 48;
            asn1JsonOutputStream.write(n3);
            if (0 != (n2 >>>= 1)) continue;
            n2 = 128;
        }
        asn1JsonOutputStream.write(34);
    }

    public boolean equals(int n2, byte[] byArray) {
        boolean bl = Asn1Exception.z;
        if (this.value == null) {
            return byArray == null;
        }
        if (n2 == this.numbits) {
            int n3 = (n2 - 1) / 8 + 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (byArray[i2] == this.value[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Asn1BitString) {
            Asn1BitString asn1BitString = (Asn1BitString)object;
            return this.equals(asn1BitString.numbits, asn1BitString.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return 1;
        }
        if (this.value.length == 0) {
            return 1;
        }
        String string = new String(this.value);
        return string.hashCode() == 0 ? 1 : string.hashCode();
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.numbits;
    }

    public boolean isSet(int n2) {
        int n3 = n2 / 8;
        int n4 = 1 << 7 - n2 % 8;
        if (this.value != null && this.value.length > n3) {
            byte by = this.value[n3];
            return (by & n4) != 0;
        }
        return false;
    }

    public boolean[] toBoolArray() {
        boolean bl = Asn1Exception.z;
        boolean[] blArray = new boolean[this.numbits];
        int n2 = 0;
        int n3 = 128;
        int n4 = this.numbits;
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            byte by = this.value[i2];
            n3 = 128;
            int n5 = n4 < 8 ? n4 : 8;
            for (int i3 = 0; i3 < n5; ++i3) {
                blArray[n2++] = (by & n3) != 0;
                n3 >>= 1;
                if (!bl) continue;
            }
            n4 -= 8;
            if (!bl) continue;
        }
        return blArray;
    }

    public void set(int n2, boolean bl) {
        int n3;
        int n4;
        block6: {
            int n5;
            block5: {
                n4 = n2 / 8;
                n3 = 1 << 7 - n2 % 8;
                n5 = n4 + 1;
                if (this.value != null) break block5;
                this.value = new byte[n5];
                if (!Asn1Exception.z) break block6;
            }
            if (this.value.length < n5) {
                byte[] byArray = new byte[n5];
                System.arraycopy(this.value, 0, byArray, 0, this.value.length);
                this.value = byArray;
            }
        }
        int n6 = this.value[n4];
        n6 = bl ? n6 | n3 : n6 & ~n3;
        this.value[n4] = (byte)n6;
        if (n2 + 1 > this.numbits) {
            this.numbits = n2 + 1;
        }
    }

    public void set(int n2) {
        this.set(n2, true);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.value, 0, this.value.length);
    }

    public String toHexString() {
        boolean bl = Asn1Exception.z;
        String string = new String("");
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            string = string + Asn1Util.toHexString(this.value[i2]);
            if (!bl) continue;
        }
        return string;
    }

    public String toString() {
        String string;
        block22: {
            StringBuffer stringBuffer;
            block24: {
                int n2;
                int n3;
                int n4;
                boolean bl;
                block28: {
                    block27: {
                        block23: {
                            block21: {
                                bl = Asn1Exception.z;
                                string = null;
                                if (mStringFormat != 1 && (mStringFormat != 2 || this.numbits > 16)) break block21;
                                if (this.numbits != 0) {
                                    boolean[] blArray = this.toBoolArray();
                                    StringBuffer stringBuffer2 = new StringBuffer(blArray.length + 3);
                                    if (mStringFormat == 2) {
                                        stringBuffer2.append("'");
                                    }
                                    for (int i2 = 0; i2 < blArray.length; ++i2) {
                                        stringBuffer2.append(blArray[i2] ? "1" : "0");
                                        if (!bl) continue;
                                    }
                                    if (mStringFormat == 2) {
                                        stringBuffer2.append("'B");
                                    }
                                    string = stringBuffer2.toString();
                                }
                                break block22;
                            }
                            if (mStringFormat != 0 && (mStringFormat != 2 || this.numbits <= 16)) break block23;
                            int n5 = 4;
                            int n6 = (this.numbits + 3) / 4;
                            StringBuffer stringBuffer3 = new StringBuffer(n6 + 3);
                            if (mStringFormat == 2) {
                                stringBuffer3.append("'");
                            }
                            if (this.value != null) {
                                int n7 = 0;
                                for (int i3 = 0; i3 < n6; ++i3) {
                                    int n8;
                                    stringBuffer3.append((char)(n8 + ((n8 = this.value[n7] >> n5 & 0xF) >= 10 ? 87 : 48)));
                                    if ((n5 -= 4) >= 0) continue;
                                    n5 = 4;
                                    ++n7;
                                    if (!bl) continue;
                                }
                            }
                            if (mStringFormat == 2) {
                                stringBuffer3.append("'H");
                            }
                            string = stringBuffer3.toString();
                            break block22;
                        }
                        if (mStringFormat != 3) break block22;
                        n4 = this.numbits / 8;
                        stringBuffer = new StringBuffer(n4 * 5 + (n4 + 15) / 16 + 9);
                        if (this.value == null) break block24;
                        if (n4 > 8) {
                            stringBuffer.append('\n');
                        }
                        for (n3 = 0; n3 < n4; ++n3) {
                            block25: {
                                block26: {
                                    if (n3 == 0) break block25;
                                    if (n3 % 16 != 0) break block26;
                                    stringBuffer.append('\n');
                                    if (!bl) break block25;
                                }
                                stringBuffer.append(' ');
                            }
                            stringBuffer.append("0x");
                            n2 = this.value[n3] >> 4 & 0xF;
                            stringBuffer.append((char)(n2 + (n2 >= 10 ? 55 : 48)));
                            n2 = this.value[n3] & 0xF;
                            stringBuffer.append((char)(n2 + (n2 >= 10 ? 55 : 48)));
                            if (!bl) continue;
                        }
                        if (n3 * 8 == this.numbits) break block24;
                        n2 = this.value[n3];
                        n4 = this.numbits % 8;
                        if (n3 % 16 != 15) break block27;
                        stringBuffer.append('\n');
                        if (!bl) break block28;
                    }
                    if (n3 > 0) {
                        stringBuffer.append(' ');
                    }
                }
                n3 = 0;
                while (n3 < n4) {
                    stringBuffer.append((n2 & 0x80) != 0 ? (char)'1' : '0');
                    ++n3;
                    n2 = (byte)(n2 << 1);
                    if (!bl) continue;
                }
                while (n3 < 8) {
                    stringBuffer.append('x');
                    ++n3;
                    if (!bl) continue;
                }
            }
            string = stringBuffer.toString();
        }
        return string != null ? string : "";
    }

    private void a(int n2) {
        this.numbits = n2;
        int n3 = (this.numbits + 7) / 8;
        if (this.value == null || this.value.length < n3) {
            this.value = new byte[n3];
        }
    }

    private void b(int n2) {
        this.numbits = n2;
        int n3 = (this.numbits + 7) / 8;
        if (this.value.length == n3) {
            return;
        }
        byte[] byArray = this.value;
        this.value = new byte[n3];
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.value, 0, Math.min(byArray.length, n3));
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        asn1BerOutputStream.encodeBitString(this.value, this.numbits, bl, TAG);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, l2, l3);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1MderOutputStream asn1MderOutputStream, int n2) throws Asn1Exception, IOException {
        if (n2 != this.getLength()) {
            throw new Asn1ConsVioException("length", this.getLength());
        }
        int n3 = n2 / 8;
        asn1MderOutputStream.write(this.value, 0, n3);
        d.lcheck(1);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeInt(this.numbits);
        objectOutputStream.write(this.value, 0, (this.numbits + 7) / 8);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.numbits = objectInputStream.readInt();
        this.a(this.numbits);
        objectInputStream.readFully(this.value, 0, (this.numbits + 7) / 8);
    }
}

