/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidEnumException;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Asn1Enumerated
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 10);
    public static final int UNDEFINED = -999;
    protected transient int value;
    private static final long serialVersionUID = 6679322540041260007L;

    public Asn1Enumerated() {
        this.value = -999;
    }

    public Asn1Enumerated(int n2) {
        this.value = n2;
    }

    public int getValue() {
        return this.value;
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = asn1BerEncodeBuffer.encodeIntValue(this.value);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, long l3) throws Asn1Exception {
        block5: {
            block4: {
                if ((long)this.value < l2 || (long)this.value > l3) break block4;
                long l4 = (long)this.value - l2;
                long l5 = l3 - l2 + 1L;
                if (l2 != l3) {
                    asn1PerEncodeBuffer.encodeConsWholeNumber(l4, l5);
                }
                if (!Asn1Exception.z) break block5;
            }
            throw new Asn1ConsVioException("Asn1Enumerated.value", this.value);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        String string2;
        if (string == null) {
            string = "ENUMERATED";
        }
        if ((string2 = this.toString()).equals("UNDEFINED")) {
            throw new Asn1InvalidEnumException(this.value);
        }
        asn1XerEncoder.encodeNamedValue(string2, string);
    }

    public void encode(Asn1XerEncodeBuffer asn1XerEncodeBuffer) throws Asn1Exception {
        String string = this.toString();
        if (string.equals("UNDEFINED")) {
            throw new Asn1InvalidEnumException(this.value);
        }
        asn1XerEncodeBuffer.encodeNamedValueElement(string);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        String string3;
        if (string == null) {
            string = "ENUMERATED";
        }
        if ((string3 = this.toString()).equals("UNDEFINED")) {
            throw new Asn1InvalidEnumException(this.value);
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        asn1XmlEncoder.copy(string3);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2, boolean bl) throws IOException, Asn1Exception {
        block6: {
            String string3;
            block5: {
                if (string == null) {
                    string = "ENUMERATED";
                }
                if ((string3 = this.toString()).equals("UNDEFINED")) {
                    throw new Asn1InvalidEnumException(this.value);
                }
                asn1XmlEncoder.encodeStartElement(string, string2, true);
                if (!bl) break block5;
                asn1XmlEncoder.copy(string3);
                if (!Asn1Exception.z) break block6;
            }
            asn1XmlEncoder.encodeEmptyElement(string3, "");
        }
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        if (this.value == -999) {
            throw new Asn1InvalidEnumException(this.value);
        }
        asn1JsonOutputStream.write(Integer.toString(this.value));
    }

    public boolean equals(int n2) {
        return this.value == n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1Enumerated)) {
            return false;
        }
        return this.value == ((Asn1Enumerated)object).value;
    }

    public int hashCode() {
        return this.value;
    }

    public static int parseValue(String string) throws Asn1Exception {
        return -1;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeIntValue(this.value, true);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, l2, l3);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeInt(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readInt();
    }
}

