/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.math.BigInteger;

public class ASN1Integer
extends BaseASN1Object {
    private BigInteger value;
    private BigInteger defaultValue;

    public ASN1Integer() {
        super("");
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(2);
        this.setTagNumber(2);
    }

    public ASN1Integer(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(2);
        this.setTagNumber(2);
    }

    public ASN1Integer(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(2);
        this.setTagNumber(2);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof BigInteger) {
            this.value = (BigInteger)value;
        }
        if (value instanceof String) {
            this.value = new BigInteger((String)value);
        }
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return null;
    }

    public void setDefaultValue(Object value) {
        if (value instanceof BigInteger) {
            this.defaultValue = (BigInteger)value;
        }
        if (value instanceof String) {
            this.defaultValue = new BigInteger((String)value);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDefaultValue() {
        BigInteger x2;
        BigInteger x1;
        if (this.defaultValue == null) {
            return false;
        }
        if (this.value == null && this.defaultValue != null) {
            return true;
        }
        return this.value != null && this.defaultValue != null && (x1 = this.value).equals(x2 = this.defaultValue);
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        byte[] integerBytes = new byte[tagInfo.contentLength];
        System.arraycopy(data, tagInfo.contentIndex, integerBytes, 0, tagInfo.contentLength);
        this.value = new BigInteger(integerBytes);
    }

    protected byte[] getContentEncoding() {
        if (this.value == null) {
            return null;
        }
        return this.value.toByteArray();
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " value = " + this.value.toString());
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        int z;
        byte[] a = new byte[]{2, 1, 0};
        byte[] b = new byte[]{2, 1, 127};
        byte[] c = new byte[]{2, 1, -128};
        byte[] d = new byte[]{2, 2, 0, -128};
        byte[] e = new byte[]{-96, 3, 2, 1, 3};
        byte[] f = new byte[]{-63, 1, 3};
        ASN1Integer i = new ASN1Integer("TestInteger");
        i.decode(a);
        System.out.println(i.toString());
        i.decode(b);
        System.out.println(i.toString());
        i.decode(c);
        System.out.println(i.toString());
        i.decode(d);
        System.out.println(i.toString());
        i.decode(e);
        System.out.println(i.toString());
        e = i.getEncoded();
        for (z = 0; z < e.length; ++z) {
            System.out.println(Integer.toString(e[z] & 0xFF, 16));
        }
        i.decode(f);
        System.out.println(i.toString());
        f = i.getEncoded();
        for (z = 0; z < f.length; ++z) {
            System.out.println(Integer.toString(f[z] & 0xFF, 16));
        }
        if (args.length > 0) {
            BigInteger x = new BigInteger(args[0]);
            byte[] y = x.toByteArray();
            System.out.println(Integer.toString(y.length));
            for (int z2 = 0; z2 < y.length; ++z2) {
                System.out.println(Integer.toString(y[z2]));
            }
        }
    }
}

