/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class NumericString
extends BaseASN1Object {
    private String value;

    public NumericString(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(18);
        this.setTagNumber(18);
    }

    public NumericString(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(18);
        this.setTagNumber(18);
        this.setValue(value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value_par) {
        if (value_par instanceof String) {
            this.value = (String)value_par;
        }
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(18);
        try {
            this.value = new String(data, tagInfo.contentIndex, tagInfo.contentLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] getContentEncoding() {
        try {
            return this.value.getBytes();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return new String(super.toString());
    }
}

