/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.Choice;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.util.Vector;

public class Sequence
extends BaseASN1Object {
    private Vector components;
    private boolean emptyEncodingAllowed = true;

    public Sequence() {
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
    }

    public Sequence(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
    }

    public Sequence(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof Vector) {
            this.components = (Vector)value;
        }
    }

    public Object getValue() {
        return this.components;
    }

    public void addElement(ASN1Object element) {
        if (this.components == null) {
            this.components = new Vector();
        }
        this.components.addElement(element);
    }

    public ASN1Object getElement(String name) {
        if (this.components == null) {
            return null;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object element = (ASN1Object)this.components.elementAt(i);
            String elementName = element.getName();
            if (elementName == null || !elementName.equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public ASN1Object getElement(int index) {
        if (this.components == null) {
            return null;
        }
        if (index >= this.components.size()) {
            return null;
        }
        return (ASN1Object)this.components.elementAt(index);
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (tagInfo == null) {
            throw new DecodeException();
        }
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        Sequence.trace("Sequence." + this.getName() + ".decode: " + this.toString());
        Sequence.trace("Sequence." + this.getName() + ".decode: tagInfo =\n" + tagInfo.toString() + "\n");
        int startAtIdx = 0;
        int idx = tagInfo.contentIndex;
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        boolean tumElemanlarVar = false;
        int sonDekodlananElemanIndeksi = -1;
        while (idx < tagInfo.contentIndex + tagInfo.contentLength) {
            TagInfo x = this.getTagInfo(data, idx);
            if (x == null) {
                throw new DecodeException();
            }
            Sequence.trace("Sequence." + this.getName() + ".decode: " + " decoding component specified by:\n" + x.toString());
            for (int i = startAtIdx; i < this.components.size(); ++i) {
                ASN1Object comp = (ASN1Object)this.components.elementAt(i);
                Sequence.trace("Sequence." + this.getName() + ".decode: checking for match: " + comp.toString());
                if (x.getTagMethod() == 2 && comp.getForcedTagMethod() == 1) {
                    x = comp.getTagInfo(data, idx);
                }
                if (comp.getType() != 0 && !comp.isChoice()) {
                    byte b1 = comp.getTagClass();
                    Sequence.trace("Sequence." + this.getName() + ".decode: Comparing tag classes; component (" + b1 + ") == encoded (" + x.tagClass + ")?");
                    if (b1 != x.tagClass) {
                        Sequence.trace("tag classes are not equal");
                        if (comp.isOptional()) continue;
                        throw new DecodeException();
                    }
                    int i1 = comp.getTagNumber();
                    Sequence.trace("Sequence." + this.getName() + ".decode: Comparing tag numbers; component (" + i1 + ") == encoded (" + x.tagNumber + ")?");
                    if (i1 != x.tagNumber) {
                        Sequence.trace("tag numbers are not equal");
                        if (comp.isOptional()) continue;
                        throw new DecodeException();
                    }
                }
                if (comp.isChoice()) {
                    Vector compTagClasses = ((Choice)comp).getComponentTagClasses();
                    if (compTagClasses == null) {
                        Sequence.trace("choice has no defined components");
                        continue;
                    }
                    if ((comp.isImplicitlyTagged() || comp.isExplicityTagged()) && x.tagNumber != comp.getTagNumber()) {
                        Sequence.trace("tag numbers are not equal");
                        continue;
                    }
                }
                startAtIdx = i + 1;
                Sequence.trace("Sequence." + this.getName() + ".decode: setting the value of " + comp.getName() + "\n");
                int y = x.contentLength + (x.contentIndex - x.tagIndex);
                byte[] content = new byte[y];
                System.arraycopy(data, x.tagIndex, content, 0, y);
                if (comp.isExplicityTagged() && comp.getInternalTagMethod() == 1) {
                    TagInfo internalTagInfo = this.getTagInfo(content, 0);
                    int z = content.length - internalTagInfo.internalTagIndex;
                    byte[] internalContent = new byte[z];
                    System.arraycopy(content, internalTagInfo.internalTagIndex, internalContent, 0, z);
                    comp.setTaggingMethod(1);
                    comp.decode(internalContent);
                } else {
                    comp.decode(content);
                }
                if (i == this.components.size() - 1) {
                    tumElemanlarVar = true;
                }
                sonDekodlananElemanIndeksi = i;
                break;
            }
            idx = x.contentIndex + x.contentLength;
        }
    }

    public byte[] getContentEncoding() {
        byte[] contents;
        if (this.components == null) {
            return new byte[0];
        }
        Vector<byte[]> componentEncodings = new Vector<byte[]>(this.components.size());
        int len = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object object = (ASN1Object)this.components.elementAt(i);
            Sequence.trace("Sequence." + this.getName() + ".getContentEncoding: getting encoding for " + object.getName());
            if (object.isOptional() && object.isDefaultValue()) {
                Sequence.trace("Sequence." + this.getName() + ".getContentEncoding: " + object.getName() + " is optional and has default value, not included in the encoding");
                continue;
            }
            contents = object.getEncoded();
            if (contents == null && object.isOptional()) {
                Sequence.trace("Sequence." + this.getName() + ".getContentEncoding: " + object.getName() + " is optional and has no value, not included in the encoding");
                continue;
            }
            if (object.getType() == 16 && contents.length == 2 && contents[1] == 0 && !((Sequence)object).getEmptyEncodingAllowed()) continue;
            componentEncodings.addElement(contents);
            len += contents.length;
        }
        byte[] totalContents = new byte[len];
        len = 0;
        for (int i = 0; i < componentEncodings.size(); ++i) {
            contents = (byte[])componentEncodings.elementAt(i);
            System.arraycopy(contents, 0, totalContents, len, contents.length);
            len += contents.length;
        }
        return totalContents;
    }

    public String toString() {
        return new String(super.toString());
    }

    public void clearElements() {
        this.components.clear();
    }

    public void setEmptyEncodingAllowed(boolean allow) {
        this.emptyEncodingAllowed = allow;
    }

    public boolean getEmptyEncodingAllowed() {
        return this.emptyEncodingAllowed;
    }

    public static void main(String[] args) {
        Sequence seq = new Sequence("Sequence");
        ASN1Integer i1 = new ASN1Integer("PublicExponent");
        ASN1Integer i2 = new ASN1Integer("Modulus");
        seq.addElement(i1);
        seq.addElement(i2);
        byte[] contents = new byte[]{48, 8, 2, 1, 16, 2, 3, 1, 0, 1};
        try {
            seq.decode(contents);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        ASN1Object publicExponent = seq.getElement("PublicExponent");
        System.out.println("\nPublicExponent = " + publicExponent.getValue().toString());
        ASN1Object modulus = seq.getElement("modulus");
        System.out.println("\nModulus = " + modulus.getValue().toString());
        byte[] f = seq.getEncoded();
        for (int z = 0; z < f.length; ++z) {
            System.out.print(Integer.toString(f[z] & 0xFF, 16) + " ");
        }
        System.out.println("");
    }
}

